<?php
/*
 * Copyright (c) 2023 LatePoint LLC. All rights reserved.
 */

/**
 * @var $order OsOrderModel
 * @var $for string
 * @var $key string
 */
?>
<div class="manage-booking-wrapper" data-route-name="<?php echo OsRouterHelper::build_route_name('manage_order_by_key', 'show'); ?>" data-key="<?php echo $key; ?>">
	<div class="manage-booking-controls status-<?php echo $order->status; ?>">
		<?php if($for == 'agent'){
			echo '<div class="change-booking-status-trigger-wrapper" data-route-name="'.OsRouterHelper::build_route_name('manage_order_by_key', 'change_status').'">';
			echo OsFormHelper::select_field('booking[status]', __('Status:', 'latepoint'), OsBookingHelper::get_statuses_list(), $order->status, ['id' => 'booking_status_'.$order->id, 'class' => 'change-booking-status-trigger']);
			echo '</div>'; ?>
			<?php
		}else{ ?>
			<div class="manage-status-info">
				<span class="status-info-label"><?php _e('Status:', 'latepoint'); ?></span>
				<span class="status-info-value status-<?php echo $order->status; ?>"><?php echo $order->nice_status; ?></span>
			</div>
			<?php
		}?>
	</div>
	<div class="manage-booking-inner">
		<?php include(LATEPOINT_VIEWS_ABSPATH.'orders/_full_summary.php'); ?>
	</div>
</div>
