<?php
/**
 * Source file was changed on the Thu May 16 11:51:04 2024 +0200
 */

namespace WP_Rocket\Engine\CDN\RocketCDN;

use WP_Rocket\Dependencies\League\Container\ServiceProvider\AbstractServiceProvider;
use WP_Rocket\Engine\AccelerateWp\ApiSocket;

/**
 * Service provider for RocketCDN
 */
class ServiceProvider extends AbstractServiceProvider {
	/**
	 * Array of services provided by this service provider
	 *
	 * @var array
	 */
	protected $provides = [
		'rocketcdn_api_client',
		'rocketcdn_options_manager',
		'rocketcdn_data_manager_subscriber',
		'rocketcdn_rest_subscriber',
		'rocketcdn_admin_subscriber',
		'rocketcdn_notices_subscriber',
		'rocketcdn_api_client_subscriber',
		'awp_socket_client',
		'rocketcdn_mail_subscriber',
	];

	/**
	 * Check if the service provider provides a specific service.
	 *
	 * @param string $id The id of the service.
	 *
	 * @return bool
	 */
	public function provides( string $id ): bool {
		return in_array( $id, $this->provides, true );
	}

	/**
	 * Registers items with the container
	 *
	 * @note CL.
	 * @return void
	 */
	public function register(): void {
		$options = $this->getContainer()->get( 'options' );

		// CL. RocketCDN CDN options manager.
		$this->getContainer()->add( 'rocketcdn_options_manager', CDNOptionsManager::class )
			->addArgument( $this->getContainer()->get( 'options_api' ) )
			->addArgument( $options );

		// CL. AWP Socket.
		$this->getContainer()->add( 'awp_socket_client', ApiSocket::class );

		// CL. RocketCDN API Client.
		$this->getContainer()->add( 'rocketcdn_api_client', APIClient::class )
			->addArgument( $this->getContainer()->get( 'rocketcdn_options_manager' ) )
			->addArgument( $this->getContainer()->get( 'awp_socket_client' ) );

		// CL. RocketCDN Data manager subscriber.
		$this->getContainer()->addShared( 'rocketcdn_data_manager_subscriber', DataManagerSubscriber::class )
			->addArgument( $this->getContainer()->get( 'rocketcdn_api_client' ) )
			->addArgument( $this->getContainer()->get( 'rocketcdn_options_manager' ) )
			->addTag( 'admin_subscriber' );

		// CL. RocketCDN REST API Subscriber.
		$this->getContainer()->addShared( 'rocketcdn_rest_subscriber', RESTSubscriber::class )
			->addArgument( $this->getContainer()->get( 'rocketcdn_options_manager' ) )
			->addArgument( $options )
			->addArgument( $this->getContainer()->get( 'rocketcdn_api_client' ) )
			->addTag( 'common_subscriber' );

		// CL. RocketCDN Notices Subscriber.
		$this->getContainer()->addShared( 'rocketcdn_notices_subscriber', NoticesSubscriber::class )
			->addArgument( $this->getContainer()->get( 'rocketcdn_api_client' ) )
			->addArgument( $this->getContainer()->get( 'beacon' ) )
			->addArgument( __DIR__ . '/views' )
			->addTag( 'admin_subscriber' );

		// CL. RocketCDN settings page subscriber.
		$this->getContainer()->addShared( 'rocketcdn_admin_subscriber', AdminPageSubscriber::class )
			->addArgument( $this->getContainer()->get( 'rocketcdn_api_client' ) )
			->addArgument( $options )
			->addArgument( $this->getContainer()->get( 'beacon' ) )
			->addArgument( __DIR__ . '/views' )
			->addTag( 'admin_subscriber' );

		// CL. ApiClient subscriber.
		$this->getContainer()->addShared( 'rocketcdn_api_client_subscriber', ApiClientSubscriber::class )
			->addArgument( $this->getContainer()->get( 'rocketcdn_api_client' ) );

		// CL. CDN Mailer.
		$this->getContainer()->addShared( 'rocketcdn_mail_subscriber', MailSubscriber::class )
			->addArgument( __DIR__ . '/views' )
			->addTag( 'common_subscriber' );
	}
}
