/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-12-29 10:16:50 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wptr_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=37016 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=235 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=394 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_activities` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) DEFAULT NULL,
  `booking_id` int(11) DEFAULT NULL,
  `service_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `order_item_id` int(11) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `initiated_by` varchar(100) DEFAULT NULL,
  `initiated_by_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_agent_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_agents` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `avatar_image_id` int(11) DEFAULT NULL,
  `bio_image_id` int(11) DEFAULT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `bio` text DEFAULT NULL,
  `features` text DEFAULT NULL,
  `email` varchar(110) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `custom_hours` tinyint(1) DEFAULT NULL,
  `wp_user_id` int(11) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `extra_emails` text DEFAULT NULL,
  `extra_phones` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_agents_services` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `is_custom_hours` tinyint(1) DEFAULT NULL,
  `is_custom_price` tinyint(1) DEFAULT NULL,
  `is_custom_duration` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_booking_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_code` varchar(10) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `start_time` mediumint(9) DEFAULT NULL,
  `end_time` mediumint(9) DEFAULT NULL,
  `start_datetime_utc` datetime DEFAULT NULL,
  `end_datetime_utc` datetime DEFAULT NULL,
  `buffer_before` mediumint(9) NOT NULL,
  `buffer_after` mediumint(9) NOT NULL,
  `duration` mediumint(9) DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'pending',
  `customer_id` mediumint(9) NOT NULL,
  `service_id` mediumint(9) NOT NULL,
  `agent_id` mediumint(9) NOT NULL,
  `location_id` mediumint(9) DEFAULT NULL,
  `order_item_id` mediumint(9) DEFAULT NULL,
  `total_attendees` mediumint(4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `status_index` (`status`),
  KEY `customer_id_index` (`customer_id`),
  KEY `service_id_index` (`service_id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_bundles` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_description` text DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `visibility` varchar(20) NOT NULL,
  `order_number` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `status_index` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_bundles_services` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `bundle_id` mediumint(9) DEFAULT NULL,
  `service_id` mediumint(9) DEFAULT NULL,
  `total_attendees` mediumint(4) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `quantity` mediumint(4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bundle_id_index` (`bundle_id`),
  KEY `service_id_index` (`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_cart_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` int(11) NOT NULL,
  `variant` varchar(55) DEFAULT NULL,
  `item_data` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_id_index` (`cart_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_cart_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `order_intent_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uuid_index` (`uuid`),
  KEY `order_id_index` (`order_id`),
  KEY `order_intent_id_index` (`order_intent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_custom_prices` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `is_price_variable` tinyint(1) DEFAULT NULL,
  `price_min` decimal(20,4) DEFAULT NULL,
  `price_max` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `is_deposit_required` tinyint(1) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_customer_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_customers` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `email` varchar(110) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `avatar_image_id` int(11) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `activation_key` varchar(255) DEFAULT NULL,
  `account_nonse` varchar(255) DEFAULT NULL,
  `google_user_id` varchar(255) DEFAULT NULL,
  `facebook_user_id` varchar(255) DEFAULT NULL,
  `wordpress_user_id` int(11) DEFAULT NULL,
  `is_guest` tinyint(1) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `admin_notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`),
  KEY `status_index` (`status`),
  KEY `wordpress_user_id_index` (`wordpress_user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_location_categories` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `short_description` text DEFAULT NULL,
  `parent_id` mediumint(9) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `parent_id_index` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_locations` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `full_address` text DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status_index` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_order_intents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `intent_key` varchar(55) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `cart_items_data` text DEFAULT NULL,
  `restrictions_data` text DEFAULT NULL,
  `presets_data` text DEFAULT NULL,
  `payment_data` text DEFAULT NULL,
  `other_data` text DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `booking_form_page_url` text DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `specs_charge_amount` varchar(55) DEFAULT NULL,
  `price_breakdown` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'new',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `intent_key_index` (`intent_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_order_invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `invoice_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'not_paid',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id_index` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `variant` varchar(55) DEFAULT NULL,
  `item_data` text DEFAULT NULL,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id_index` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_order_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'open',
  `fulfillment_status` varchar(30) NOT NULL DEFAULT 'not_fulfilled',
  `payment_status` varchar(30) NOT NULL DEFAULT 'not_paid',
  `source_id` varchar(100) DEFAULT NULL,
  `source_url` text DEFAULT NULL,
  `ip_address` varchar(55) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `customer_comment` text DEFAULT NULL,
  `confirmation_code` varchar(10) DEFAULT NULL,
  `price_breakdown` text DEFAULT NULL,
  `coupon_code` varchar(100) DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id_index` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_process_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(11) NOT NULL,
  `object_id` int(11) NOT NULL,
  `object_model_type` varchar(55) DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `to_run_after_utc` datetime DEFAULT NULL,
  `status` varchar(30) DEFAULT 'scheduled',
  `run_result` text DEFAULT NULL,
  `process_info` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_processes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(110) NOT NULL,
  `event_type` varchar(110) NOT NULL,
  `actions_json` text DEFAULT NULL,
  `status` varchar(30) DEFAULT 'active',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_service_categories` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `short_description` text DEFAULT NULL,
  `parent_id` mediumint(9) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `parent_id_index` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_service_meta` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(9) NOT NULL,
  `meta_key` varchar(110) NOT NULL,
  `meta_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_services` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_description` text DEFAULT NULL,
  `is_price_variable` tinyint(1) DEFAULT NULL,
  `price_min` decimal(20,4) DEFAULT NULL,
  `price_max` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `is_deposit_required` tinyint(1) DEFAULT NULL,
  `duration_name` varchar(255) DEFAULT NULL,
  `override_default_booking_status` varchar(255) DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `buffer_before` int(11) DEFAULT NULL,
  `buffer_after` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `selection_image_id` int(11) DEFAULT NULL,
  `description_image_id` int(11) DEFAULT NULL,
  `bg_color` varchar(20) DEFAULT NULL,
  `timeblock_interval` int(11) DEFAULT NULL,
  `capacity_min` int(4) DEFAULT NULL,
  `capacity_max` int(4) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `visibility` varchar(20) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id_index` (`category_id`),
  KEY `order_number_index` (`order_number`),
  KEY `status_index` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` varchar(55) NOT NULL,
  `session_value` longtext NOT NULL,
  `expiration` bigint(20) unsigned NOT NULL,
  `hash` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_settings` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(110) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name_index` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_step_settings` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `label` varchar(50) NOT NULL,
  `value` text DEFAULT NULL,
  `step` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `step_index` (`step`),
  KEY `label_index` (`label`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_steps` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` text DEFAULT NULL,
  `before_content` text DEFAULT NULL,
  `after_content` text DEFAULT NULL,
  `side_title` text DEFAULT NULL,
  `side_description` text DEFAULT NULL,
  `use_custom_image` tinyint(1) DEFAULT NULL,
  `custom_image_id` int(11) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `parent_step_id` smallint(6) DEFAULT NULL,
  `position` smallint(6) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_transactions` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `token` text DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `processor` varchar(100) DEFAULT NULL,
  `payment_method` varchar(55) DEFAULT NULL,
  `payment_portion` varchar(55) DEFAULT NULL,
  `kind` varchar(40) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_latepoint_work_periods` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `agent_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `start_time` smallint(6) NOT NULL,
  `end_time` smallint(6) NOT NULL,
  `week_day` tinyint(3) NOT NULL,
  `custom_date` date DEFAULT NULL,
  `chain_id` varchar(20) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`),
  KEY `week_day_index` (`week_day`),
  KEY `custom_date_index` (`custom_date`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_mwai_filemeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_mwai_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `refId` varchar(64) NOT NULL,
  `envId` varchar(128) DEFAULT NULL,
  `userId` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `purpose` varchar(32) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `expires` datetime DEFAULT NULL,
  `path` text DEFAULT NULL,
  `url` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_file_id` (`refId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_mwai_logmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_mwai_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userId` bigint(20) DEFAULT NULL,
  `ip` varchar(64) DEFAULT NULL,
  `session` varchar(64) DEFAULT NULL,
  `model` varchar(64) DEFAULT NULL,
  `feature` varchar(64) DEFAULT NULL,
  `units` int(11) NOT NULL DEFAULT 0,
  `type` varchar(64) DEFAULT NULL,
  `price` float NOT NULL DEFAULT 0,
  `scope` varchar(64) DEFAULT NULL,
  `envId` varchar(128) DEFAULT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_mwai_vectors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `behavior` varchar(32) NOT NULL DEFAULT 'context',
  `status` varchar(32) DEFAULT NULL,
  `envId` varchar(64) DEFAULT NULL,
  `model` varchar(64) DEFAULT NULL,
  `dimensions` smallint(6) DEFAULT NULL,
  `dbId` varchar(64) DEFAULT NULL,
  `refId` bigint(20) DEFAULT NULL,
  `refChecksum` varchar(64) DEFAULT NULL,
  `error` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=1691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=308804 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=37156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_sbi_feed_caches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(255) NOT NULL DEFAULT '',
  `cache_key` varchar(255) NOT NULL DEFAULT '',
  `cache_value` longtext NOT NULL DEFAULT '',
  `cron_update` varchar(20) NOT NULL DEFAULT 'yes',
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`(191))
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_sbi_feeds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_name` text NOT NULL DEFAULT '',
  `feed_title` text NOT NULL DEFAULT '',
  `settings` longtext NOT NULL DEFAULT '',
  `author` bigint(20) unsigned NOT NULL DEFAULT 1,
  `status` varchar(255) NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `author` (`author`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_sbi_instagram_feed_locator` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) NOT NULL DEFAULT '',
  `post_id` bigint(20) unsigned NOT NULL,
  `html_location` varchar(50) NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wptr_sbi_instagram_feeds_posts` (
  `record_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(11) unsigned NOT NULL,
  `instagram_id` varchar(1000) NOT NULL DEFAULT '',
  `feed_id` varchar(1000) NOT NULL DEFAULT '',
  `hashtag` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `hashtag` (`hashtag`(191)),
  KEY `feed_id` (`feed_id`(191))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_sbi_instagram_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `instagram_id` varchar(1000) NOT NULL DEFAULT '',
  `time_stamp` datetime DEFAULT NULL,
  `top_time_stamp` datetime DEFAULT NULL,
  `json_data` longtext NOT NULL DEFAULT '',
  `media_id` varchar(1000) NOT NULL DEFAULT '',
  `sizes` varchar(1000) NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT 0.00,
  `images_done` tinyint(1) NOT NULL DEFAULT 0,
  `last_requested` date DEFAULT NULL,
  `mime_type` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_sbi_sources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) NOT NULL DEFAULT '',
  `account_type` varchar(255) NOT NULL DEFAULT '',
  `privilege` varchar(255) NOT NULL DEFAULT '',
  `access_token` varchar(1000) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `info` text NOT NULL DEFAULT '',
  `error` text NOT NULL DEFAULT '',
  `expires` datetime NOT NULL,
  `last_updated` datetime NOT NULL,
  `author` bigint(20) unsigned NOT NULL DEFAULT 1,
  `connect_type` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account_type` (`account_type`(191)),
  KEY `author` (`author`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1524 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text DEFAULT NULL,
  `backup_date` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT '',
  `viewport` longtext DEFAULT '',
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wpr_image_optimization` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `format` varchar(32) NOT NULL DEFAULT '',
  `status` varchar(32) NOT NULL DEFAULT '',
  `secret` varchar(32) DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `job_id` varchar(255) DEFAULT NULL,
  `priority` tinyint(1) NOT NULL DEFAULT 0,
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `postponed_until` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status_index` (`status`),
  KEY `format_index` (`format`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wptr_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wptr_actionscheduler_actions */
INSERT INTO `wptr_actionscheduler_actions` VALUES("36883", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-12-26 12:29:24", "2024-12-26 12:29:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735216164;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735216164;}", "1", "1", "2024-12-26 12:30:29", "2024-12-26 12:30:29", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36884", "action_scheduler/migration_hook", "complete", "2024-12-26 12:30:25", "2024-12-26 12:30:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735216225;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735216225;}", "2", "1", "2024-12-26 12:30:29", "2024-12-26 12:30:29", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36885", "woocommerce_cleanup_draft_orders", "complete", "2024-12-26 12:29:30", "2024-12-26 12:29:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735216170;s:18:\"\0*\0first_timestamp\";i:1735216170;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735216170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2024-12-26 12:30:29", "2024-12-26 12:30:29", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36887", "action_scheduler/migration_hook", "failed", "2024-12-26 12:31:30", "2024-12-26 12:31:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735216290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735216290;}", "2", "1", "2024-12-26 12:31:37", "2024-12-26 12:31:37", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36886", "woocommerce_cleanup_draft_orders", "complete", "2024-12-27 12:30:29", "2024-12-27 12:30:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735302629;s:18:\"\0*\0first_timestamp\";i:1735216170;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735302629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2024-12-27 14:58:06", "2024-12-27 14:58:06", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36888", "woocommerce_install_assembler_fonts", "complete", "2024-12-26 12:43:31", "2024-12-26 12:43:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735217011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735217011;}", "3", "1", "2024-12-26 12:45:28", "2024-12-26 12:45:28", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36889", "fetch_patterns", "complete", "2024-12-26 12:43:31", "2024-12-26 12:43:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735217011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735217011;}", "3", "1", "2024-12-26 12:45:36", "2024-12-26 12:45:36", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36890", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-12-26 12:43:36", "2024-12-26 12:43:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735217016;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735217016;}", "1", "1", "2024-12-26 12:45:37", "2024-12-26 12:45:37", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36891", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-12-26 12:43:35", "2024-12-26 12:43:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735217015;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735217015;}", "4", "1", "2024-12-26 12:45:36", "2024-12-26 12:45:36", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36892", "fetch_patterns", "complete", "2024-12-26 15:55:42", "2024-12-26 15:55:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735228542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735228542;}", "3", "1", "2024-12-26 15:57:20", "2024-12-26 15:57:20", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36893", "action_scheduler/migration_hook", "complete", "2024-12-26 15:56:42", "2024-12-26 15:56:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735228602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735228602;}", "2", "1", "2024-12-26 15:57:20", "2024-12-26 15:57:20", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36894", "rocket_preload_job_load_initial_sitemap", "failed", "2024-12-26 19:09:15", "2024-12-26 19:09:15", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2024-12-26 19:09:37", "2024-12-26 19:09:37", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36895", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:12:02", "2024-12-26 19:12:02", "10", "[1735240262]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735240322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735240322;}", "5", "1", "2024-12-26 19:39:23", "2024-12-26 19:39:23", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36896", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:40:23", "2024-12-26 19:40:23", "10", "[1735241963]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242023;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242023;}", "5", "1", "2024-12-26 19:41:02", "2024-12-26 19:41:02", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36897", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:42:02", "2024-12-26 19:42:02", "10", "[1735242062]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242122;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242122;}", "5", "1", "2024-12-26 19:42:07", "2024-12-26 19:42:07", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36898", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:43:07", "2024-12-26 19:43:07", "10", "[1735242127]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242187;}", "5", "1", "2024-12-26 19:43:12", "2024-12-26 19:43:12", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36899", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:44:12", "2024-12-26 19:44:12", "10", "[1735242192]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242252;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242252;}", "5", "1", "2024-12-26 19:44:26", "2024-12-26 19:44:26", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36900", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:45:26", "2024-12-26 19:45:26", "10", "[1735242266]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242326;}", "5", "1", "2024-12-26 19:45:30", "2024-12-26 19:45:30", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36901", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:46:30", "2024-12-26 19:46:30", "10", "[1735242330]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242390;}", "5", "1", "2024-12-26 19:46:49", "2024-12-26 19:46:49", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36902", "rocket_preload_job_check_finished", "complete", "2024-12-26 19:47:49", "2024-12-26 19:47:49", "10", "[1735242409]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735242469;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735242469;}", "5", "1", "2024-12-26 20:44:11", "2024-12-26 20:44:11", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36903", "rocket_preload_job_check_finished", "complete", "2024-12-26 20:45:11", "2024-12-26 20:45:11", "10", "[1735245851]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735245911;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735245911;}", "5", "1", "2024-12-26 23:27:57", "2024-12-26 23:27:57", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36904", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:28:57", "2024-12-26 23:28:57", "10", "[1735255677]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735255737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735255737;}", "5", "1", "2024-12-26 23:29:15", "2024-12-26 23:29:15", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36905", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:30:15", "2024-12-26 23:30:15", "10", "[1735255755]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735255815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735255815;}", "5", "1", "2024-12-26 23:30:29", "2024-12-26 23:30:29", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36906", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:31:29", "2024-12-26 23:31:29", "10", "[1735255829]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735255889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735255889;}", "5", "1", "2024-12-26 23:32:31", "2024-12-26 23:32:31", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36907", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:33:31", "2024-12-26 23:33:31", "10", "[1735255951]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256011;}", "5", "1", "2024-12-26 23:33:55", "2024-12-26 23:33:55", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36908", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:34:55", "2024-12-26 23:34:55", "10", "[1735256035]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256095;}", "5", "1", "2024-12-26 23:35:23", "2024-12-26 23:35:23", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36909", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:36:23", "2024-12-26 23:36:23", "10", "[1735256123]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256183;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256183;}", "5", "1", "2024-12-26 23:37:26", "2024-12-26 23:37:26", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36910", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:38:26", "2024-12-26 23:38:26", "10", "[1735256246]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256306;}", "5", "1", "2024-12-26 23:38:37", "2024-12-26 23:38:37", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36911", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:39:37", "2024-12-26 23:39:37", "10", "[1735256317]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256377;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256377;}", "5", "1", "2024-12-26 23:39:40", "2024-12-26 23:39:40", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36912", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:40:40", "2024-12-26 23:40:40", "10", "[1735256380]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256440;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256440;}", "5", "1", "2024-12-26 23:41:42", "2024-12-26 23:41:42", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36913", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:42:42", "2024-12-26 23:42:42", "10", "[1735256502]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256562;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256562;}", "5", "1", "2024-12-26 23:42:44", "2024-12-26 23:42:44", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36914", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:43:44", "2024-12-26 23:43:44", "10", "[1735256564]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256624;}", "5", "1", "2024-12-26 23:43:55", "2024-12-26 23:43:55", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36915", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:44:55", "2024-12-26 23:44:55", "10", "[1735256635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256695;}", "5", "1", "2024-12-26 23:45:59", "2024-12-26 23:45:59", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36916", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:46:59", "2024-12-26 23:46:59", "10", "[1735256759]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256819;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256819;}", "5", "1", "2024-12-26 23:47:03", "2024-12-26 23:47:03", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36917", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:48:03", "2024-12-26 23:48:03", "10", "[1735256823]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735256883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735256883;}", "5", "1", "2024-12-26 23:49:50", "2024-12-26 23:49:50", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36918", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:50:50", "2024-12-26 23:50:50", "10", "[1735256990]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257050;}", "5", "1", "2024-12-26 23:50:53", "2024-12-26 23:50:53", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36919", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:51:53", "2024-12-26 23:51:53", "10", "[1735257053]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257113;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257113;}", "5", "1", "2024-12-26 23:52:50", "2024-12-26 23:52:50", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36920", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:53:50", "2024-12-26 23:53:50", "10", "[1735257170]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257230;}", "5", "1", "2024-12-26 23:53:52", "2024-12-26 23:53:52", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36921", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:54:52", "2024-12-26 23:54:52", "10", "[1735257232]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257292;}", "5", "1", "2024-12-26 23:54:54", "2024-12-26 23:54:54", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36922", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:55:54", "2024-12-26 23:55:54", "10", "[1735257294]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257354;}", "5", "1", "2024-12-26 23:56:08", "2024-12-26 23:56:08", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36923", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:57:08", "2024-12-26 23:57:08", "10", "[1735257368]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257428;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257428;}", "5", "1", "2024-12-26 23:58:13", "2024-12-26 23:58:13", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36924", "rocket_preload_job_check_finished", "complete", "2024-12-26 23:59:13", "2024-12-26 23:59:13", "10", "[1735257493]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257553;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257553;}", "5", "1", "2024-12-26 23:59:21", "2024-12-26 23:59:21", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36925", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:00:21", "2024-12-27 00:00:21", "10", "[1735257561]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257621;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257621;}", "5", "1", "2024-12-27 00:01:27", "2024-12-27 00:01:27", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36926", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:02:27", "2024-12-27 00:02:27", "10", "[1735257687]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257747;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257747;}", "5", "1", "2024-12-27 00:02:49", "2024-12-27 00:02:49", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36927", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:03:49", "2024-12-27 00:03:49", "10", "[1735257769]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257829;}", "5", "1", "2024-12-27 00:04:41", "2024-12-27 00:04:41", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36928", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:05:41", "2024-12-27 00:05:41", "10", "[1735257881]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735257941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735257941;}", "5", "1", "2024-12-27 00:05:55", "2024-12-27 00:05:55", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36929", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:06:55", "2024-12-27 00:06:55", "10", "[1735257955]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735258015;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735258015;}", "5", "1", "2024-12-27 00:23:38", "2024-12-27 00:23:38", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36930", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:24:38", "2024-12-27 00:24:38", "10", "[1735259018]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735259078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735259078;}", "5", "1", "2024-12-27 00:38:40", "2024-12-27 00:38:40", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36931", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:39:40", "2024-12-27 00:39:40", "10", "[1735259920]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735259980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735259980;}", "5", "1", "2024-12-27 00:39:41", "2024-12-27 00:39:41", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36932", "fetch_patterns", "complete", "2024-12-27 00:39:37", "2024-12-27 00:39:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735259977;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735259977;}", "3", "1", "2024-12-27 00:39:41", "2024-12-27 00:39:41", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36933", "action_scheduler/migration_hook", "complete", "2024-12-27 00:40:37", "2024-12-27 00:40:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735260037;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735260037;}", "2", "1", "2024-12-27 09:36:28", "2024-12-27 09:36:28", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36934", "rocket_preload_job_check_finished", "complete", "2024-12-27 00:40:41", "2024-12-27 00:40:41", "10", "[1735259981]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735260041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735260041;}", "5", "1", "2024-12-27 09:36:28", "2024-12-27 09:36:28", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36935", "rocket_preload_job_check_finished", "complete", "2024-12-27 09:37:28", "2024-12-27 09:37:28", "10", "[1735292188]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735292248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735292248;}", "5", "1", "2024-12-27 11:00:38", "2024-12-27 11:00:38", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36936", "rocket_preload_job_check_finished", "complete", "2024-12-27 11:01:38", "2024-12-27 11:01:38", "10", "[1735297238]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735297298;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735297298;}", "5", "1", "2024-12-27 11:07:47", "2024-12-27 11:07:47", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36937", "rocket_preload_job_check_finished", "complete", "2024-12-27 11:08:47", "2024-12-27 11:08:47", "10", "[1735297667]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735297727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735297727;}", "5", "1", "2024-12-27 11:09:09", "2024-12-27 11:09:09", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36938", "rocket_preload_job_check_finished", "complete", "2024-12-27 11:10:09", "2024-12-27 11:10:09", "10", "[1735297749]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735297809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735297809;}", "5", "1", "2024-12-27 11:47:13", "2024-12-27 11:47:13", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36939", "fetch_patterns", "complete", "2024-12-27 11:40:42", "2024-12-27 11:40:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735299642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735299642;}", "3", "1", "2024-12-27 11:47:14", "2024-12-27 11:47:14", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36940", "action_scheduler/migration_hook", "complete", "2024-12-27 11:41:42", "2024-12-27 11:41:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735299702;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735299702;}", "2", "1", "2024-12-27 11:47:14", "2024-12-27 11:47:14", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36941", "rocket_preload_job_check_finished", "complete", "2024-12-27 11:48:13", "2024-12-27 11:48:13", "10", "[1735300033]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735300093;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735300093;}", "5", "1", "2024-12-27 14:58:06", "2024-12-27 14:58:06", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36942", "action_scheduler/migration_hook", "failed", "2024-12-27 11:48:14", "2024-12-27 11:48:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735300094;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735300094;}", "2", "1", "2024-12-27 14:58:06", "2024-12-27 14:58:06", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36945", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:00:10", "2024-12-27 15:00:10", "10", "[1735311550]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735311610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735311610;}", "5", "1", "2024-12-27 15:20:45", "2024-12-27 15:20:45", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36943", "rocket_preload_job_check_finished", "complete", "2024-12-27 14:59:06", "2024-12-27 14:59:06", "10", "[1735311486]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735311546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735311546;}", "5", "1", "2024-12-27 14:59:10", "2024-12-27 14:59:10", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36944", "woocommerce_cleanup_draft_orders", "pending", "2024-12-28 14:58:06", "2024-12-28 14:58:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735397886;s:18:\"\0*\0first_timestamp\";i:1735216170;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735397886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36946", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:21:45", "2024-12-27 15:21:45", "10", "[1735312845]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735312905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735312905;}", "5", "1", "2024-12-27 15:22:45", "2024-12-27 15:22:45", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36947", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:23:45", "2024-12-27 15:23:45", "10", "[1735312965]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313025;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313025;}", "5", "1", "2024-12-27 15:24:45", "2024-12-27 15:24:45", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36948", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:25:45", "2024-12-27 15:25:45", "10", "[1735313085]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313145;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313145;}", "5", "1", "2024-12-27 15:26:15", "2024-12-27 15:26:15", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36949", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:27:15", "2024-12-27 15:27:15", "10", "[1735313175]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313235;}", "5", "1", "2024-12-27 15:27:19", "2024-12-27 15:27:19", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36950", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:28:19", "2024-12-27 15:28:19", "10", "[1735313239]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313299;}", "5", "1", "2024-12-27 15:28:40", "2024-12-27 15:28:40", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36951", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:29:40", "2024-12-27 15:29:40", "10", "[1735313320]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313380;}", "5", "1", "2024-12-27 15:30:05", "2024-12-27 15:30:05", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36952", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:31:05", "2024-12-27 15:31:05", "10", "[1735313405]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313465;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313465;}", "5", "1", "2024-12-27 15:31:32", "2024-12-27 15:31:32", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36953", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:32:32", "2024-12-27 15:32:32", "10", "[1735313492]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313552;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313552;}", "5", "1", "2024-12-27 15:32:45", "2024-12-27 15:32:45", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36954", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:33:45", "2024-12-27 15:33:45", "10", "[1735313565]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313625;}", "5", "1", "2024-12-27 15:34:45", "2024-12-27 15:34:45", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36955", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:35:45", "2024-12-27 15:35:45", "10", "[1735313685]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313745;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313745;}", "5", "1", "2024-12-27 15:36:44", "2024-12-27 15:36:44", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36956", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:37:44", "2024-12-27 15:37:44", "10", "[1735313804]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313864;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313864;}", "5", "1", "2024-12-27 15:37:46", "2024-12-27 15:37:46", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36957", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:38:46", "2024-12-27 15:38:46", "10", "[1735313866]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735313926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735313926;}", "5", "1", "2024-12-27 15:39:35", "2024-12-27 15:39:35", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36958", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:40:35", "2024-12-27 15:40:35", "10", "[1735313975]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314035;}", "5", "1", "2024-12-27 15:40:37", "2024-12-27 15:40:37", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36959", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:41:37", "2024-12-27 15:41:37", "10", "[1735314037]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314097;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314097;}", "5", "1", "2024-12-27 15:43:06", "2024-12-27 15:43:06", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36960", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:44:06", "2024-12-27 15:44:06", "10", "[1735314186]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314246;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314246;}", "5", "1", "2024-12-27 15:44:38", "2024-12-27 15:44:38", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36961", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:45:38", "2024-12-27 15:45:38", "10", "[1735314278]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314338;}", "5", "1", "2024-12-27 15:46:40", "2024-12-27 15:46:40", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36962", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:47:40", "2024-12-27 15:47:40", "10", "[1735314400]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314460;}", "5", "1", "2024-12-27 15:48:23", "2024-12-27 15:48:23", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36963", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:49:23", "2024-12-27 15:49:23", "10", "[1735314503]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314563;}", "5", "1", "2024-12-27 15:49:40", "2024-12-27 15:49:40", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36964", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:50:40", "2024-12-27 15:50:40", "10", "[1735314580]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314640;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314640;}", "5", "1", "2024-12-27 15:51:04", "2024-12-27 15:51:04", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36965", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:52:04", "2024-12-27 15:52:04", "10", "[1735314664]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314724;}", "5", "1", "2024-12-27 15:52:17", "2024-12-27 15:52:17", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36966", "rocket_preload_job_check_finished", "complete", "2024-12-27 15:53:17", "2024-12-27 15:53:17", "10", "[1735314737]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735314797;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735314797;}", "5", "1", "2024-12-27 16:50:28", "2024-12-27 16:50:28", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36967", "rocket_preload_job_check_finished", "complete", "2024-12-27 16:51:28", "2024-12-27 16:51:28", "10", "[1735318228]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735318288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735318288;}", "5", "1", "2024-12-27 16:51:40", "2024-12-27 16:51:40", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36968", "rocket_preload_job_check_finished", "complete", "2024-12-27 16:52:40", "2024-12-27 16:52:40", "10", "[1735318300]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735318360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735318360;}", "5", "1", "2024-12-27 16:56:41", "2024-12-27 16:56:41", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36969", "rocket_preload_job_check_finished", "complete", "2024-12-27 16:57:41", "2024-12-27 16:57:41", "10", "[1735318601]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735318661;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735318661;}", "5", "1", "2024-12-27 16:58:50", "2024-12-27 16:58:50", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36970", "rocket_preload_job_check_finished", "complete", "2024-12-27 16:59:50", "2024-12-27 16:59:50", "10", "[1735318730]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735318790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735318790;}", "5", "1", "2024-12-27 17:00:50", "2024-12-27 17:00:50", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36971", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:01:50", "2024-12-27 17:01:50", "10", "[1735318850]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735318910;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735318910;}", "5", "1", "2024-12-27 17:02:52", "2024-12-27 17:02:52", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36972", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:03:52", "2024-12-27 17:03:52", "10", "[1735318972]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735319032;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735319032;}", "5", "1", "2024-12-27 17:04:53", "2024-12-27 17:04:53", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36973", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:05:53", "2024-12-27 17:05:53", "10", "[1735319093]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735319153;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735319153;}", "5", "1", "2024-12-27 17:06:54", "2024-12-27 17:06:54", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36974", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:07:54", "2024-12-27 17:07:54", "10", "[1735319214]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735319274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735319274;}", "5", "1", "2024-12-27 17:08:55", "2024-12-27 17:08:55", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36975", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:09:55", "2024-12-27 17:09:55", "10", "[1735319335]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735319395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735319395;}", "5", "1", "2024-12-27 17:10:56", "2024-12-27 17:10:56", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36976", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:11:56", "2024-12-27 17:11:56", "10", "[1735319456]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735319516;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735319516;}", "5", "1", "2024-12-27 17:39:14", "2024-12-27 17:39:14", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36977", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:40:14", "2024-12-27 17:40:14", "10", "[1735321154]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735321214;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735321214;}", "5", "1", "2024-12-27 17:41:14", "2024-12-27 17:41:14", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36978", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:42:14", "2024-12-27 17:42:14", "10", "[1735321274]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735321334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735321334;}", "5", "1", "2024-12-27 17:43:15", "2024-12-27 17:43:15", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36979", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:44:15", "2024-12-27 17:44:15", "10", "[1735321395]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735321455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735321455;}", "5", "1", "2024-12-27 17:45:16", "2024-12-27 17:45:16", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36980", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:46:16", "2024-12-27 17:46:16", "10", "[1735321516]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735321576;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735321576;}", "5", "1", "2024-12-27 17:47:17", "2024-12-27 17:47:17", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36981", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:48:17", "2024-12-27 17:48:17", "10", "[1735321637]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735321697;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735321697;}", "5", "1", "2024-12-27 17:49:18", "2024-12-27 17:49:18", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36982", "rocket_preload_job_check_finished", "complete", "2024-12-27 17:50:18", "2024-12-27 17:50:18", "10", "[1735321758]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735321818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735321818;}", "5", "1", "2024-12-27 23:19:02", "2024-12-27 23:19:02", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36983", "rocket_preload_job_check_finished", "complete", "2024-12-27 23:20:02", "2024-12-27 23:20:02", "10", "[1735341542]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735341602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735341602;}", "5", "1", "2024-12-28 01:54:25", "2024-12-28 01:54:25", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36984", "rocket_preload_job_check_finished", "complete", "2024-12-28 01:55:25", "2024-12-28 01:55:25", "10", "[1735350865]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735350925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735350925;}", "5", "1", "2024-12-28 01:56:07", "2024-12-28 01:56:07", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36985", "rocket_preload_job_check_finished", "complete", "2024-12-28 01:57:07", "2024-12-28 01:57:07", "10", "[1735350967]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735351027;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735351027;}", "5", "1", "2024-12-28 01:57:25", "2024-12-28 01:57:25", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36986", "rocket_preload_job_check_finished", "complete", "2024-12-28 01:58:25", "2024-12-28 01:58:25", "10", "[1735351045]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735351105;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735351105;}", "5", "1", "2024-12-28 08:13:34", "2024-12-28 08:13:34", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36987", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:14:34", "2024-12-28 08:14:34", "10", "[1735373614]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735373674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735373674;}", "5", "1", "2024-12-28 08:15:14", "2024-12-28 08:15:14", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36988", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:16:14", "2024-12-28 08:16:14", "10", "[1735373714]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735373774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735373774;}", "5", "1", "2024-12-28 08:16:22", "2024-12-28 08:16:22", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36989", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:17:22", "2024-12-28 08:17:22", "10", "[1735373782]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735373842;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735373842;}", "5", "1", "2024-12-28 08:17:26", "2024-12-28 08:17:26", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36990", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:18:26", "2024-12-28 08:18:26", "10", "[1735373846]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735373906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735373906;}", "5", "1", "2024-12-28 08:18:31", "2024-12-28 08:18:31", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36991", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:19:31", "2024-12-28 08:19:31", "10", "[1735373911]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735373971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735373971;}", "5", "1", "2024-12-28 08:19:38", "2024-12-28 08:19:38", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36992", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:20:38", "2024-12-28 08:20:38", "10", "[1735373978]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374038;}", "5", "1", "2024-12-28 08:20:45", "2024-12-28 08:20:45", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36993", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:21:45", "2024-12-28 08:21:45", "10", "[1735374045]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374105;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374105;}", "5", "1", "2024-12-28 08:22:35", "2024-12-28 08:22:35", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36994", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:23:35", "2024-12-28 08:23:35", "10", "[1735374155]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374215;}", "5", "1", "2024-12-28 08:23:39", "2024-12-28 08:23:39", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36995", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:24:39", "2024-12-28 08:24:39", "10", "[1735374219]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374279;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374279;}", "5", "1", "2024-12-28 08:24:48", "2024-12-28 08:24:48", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36996", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:25:48", "2024-12-28 08:25:48", "10", "[1735374288]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374348;}", "5", "1", "2024-12-28 08:25:57", "2024-12-28 08:25:57", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36997", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:26:57", "2024-12-28 08:26:57", "10", "[1735374357]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374417;}", "5", "1", "2024-12-28 08:27:00", "2024-12-28 08:27:00", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36998", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:28:00", "2024-12-28 08:28:00", "10", "[1735374420]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374480;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374480;}", "5", "1", "2024-12-28 08:28:13", "2024-12-28 08:28:13", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("36999", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:29:13", "2024-12-28 08:29:13", "10", "[1735374493]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374553;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374553;}", "5", "1", "2024-12-28 08:29:18", "2024-12-28 08:29:18", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37000", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:30:18", "2024-12-28 08:30:18", "10", "[1735374558]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374618;}", "5", "1", "2024-12-28 08:30:35", "2024-12-28 08:30:35", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37001", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:31:35", "2024-12-28 08:31:35", "10", "[1735374635]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374695;}", "5", "1", "2024-12-28 08:31:54", "2024-12-28 08:31:54", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37002", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:32:54", "2024-12-28 08:32:54", "10", "[1735374714]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374774;}", "5", "1", "2024-12-28 08:33:19", "2024-12-28 08:33:19", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37003", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:34:19", "2024-12-28 08:34:19", "10", "[1735374799]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374859;}", "5", "1", "2024-12-28 08:34:26", "2024-12-28 08:34:26", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37004", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:35:26", "2024-12-28 08:35:26", "10", "[1735374866]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374926;}", "5", "1", "2024-12-28 08:35:34", "2024-12-28 08:35:34", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37005", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:36:34", "2024-12-28 08:36:34", "10", "[1735374934]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735374994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735374994;}", "5", "1", "2024-12-28 08:37:47", "2024-12-28 08:37:47", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37006", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:38:47", "2024-12-28 08:38:47", "10", "[1735375067]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375127;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375127;}", "5", "1", "2024-12-28 08:39:48", "2024-12-28 08:39:48", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37007", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:40:48", "2024-12-28 08:40:48", "10", "[1735375188]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375248;}", "5", "1", "2024-12-28 08:41:16", "2024-12-28 08:41:16", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37008", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:42:16", "2024-12-28 08:42:16", "10", "[1735375276]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375336;}", "5", "1", "2024-12-28 08:42:24", "2024-12-28 08:42:24", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37009", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:43:24", "2024-12-28 08:43:24", "10", "[1735375344]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375404;}", "5", "1", "2024-12-28 08:44:25", "2024-12-28 08:44:25", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37010", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:45:25", "2024-12-28 08:45:25", "10", "[1735375465]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375525;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375525;}", "5", "1", "2024-12-28 08:46:26", "2024-12-28 08:46:26", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37011", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:47:26", "2024-12-28 08:47:26", "10", "[1735375586]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375646;}", "5", "1", "2024-12-28 08:48:12", "2024-12-28 08:48:12", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37012", "rocket_preload_job_check_finished", "complete", "2024-12-28 08:49:12", "2024-12-28 08:49:12", "10", "[1735375692]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375752;}", "5", "1", "2024-12-28 08:49:25", "2024-12-28 08:49:25", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37013", "fetch_patterns", "complete", "2024-12-28 08:48:55", "2024-12-28 08:48:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375735;}", "3", "1", "2024-12-28 08:49:25", "2024-12-28 08:49:25", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37014", "action_scheduler/migration_hook", "pending", "2024-12-28 08:49:55", "2024-12-28 08:49:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375795;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wptr_actionscheduler_actions` VALUES("37015", "rocket_preload_job_check_finished", "pending", "2024-12-28 08:50:25", "2024-12-28 08:50:25", "10", "[1735375765]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735375825;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735375825;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wptr_actionscheduler_groups */
INSERT INTO `wptr_actionscheduler_groups` VALUES("1", "woocommerce-db-updates");
INSERT INTO `wptr_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wptr_actionscheduler_groups` VALUES("3", "");
INSERT INTO `wptr_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wptr_actionscheduler_groups` VALUES("5", "rocket-preload");

/* INSERT TABLE DATA: wptr_actionscheduler_logs */
INSERT INTO `wptr_actionscheduler_logs` VALUES("1", "36883", "action created", "2024-12-26 12:29:23", "2024-12-26 12:29:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("2", "36884", "action created", "2024-12-26 12:29:25", "2024-12-26 12:29:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("3", "36885", "action created", "2024-12-26 12:29:30", "2024-12-26 12:29:30");
INSERT INTO `wptr_actionscheduler_logs` VALUES("4", "36883", "action started via Async Request", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("5", "36883", "action complete via Async Request", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("6", "36885", "action started via Async Request", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("7", "36885", "action complete via Async Request", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("8", "36886", "action created", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("9", "36884", "action started via Async Request", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("10", "36884", "action complete via Async Request", "2024-12-26 12:30:29", "2024-12-26 12:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("11", "36887", "action created", "2024-12-26 12:30:30", "2024-12-26 12:30:30");
INSERT INTO `wptr_actionscheduler_logs` VALUES("12", "36887", "action started via Async Request", "2024-12-26 12:31:37", "2024-12-26 12:31:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("13", "36887", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-12-26 12:31:37", "2024-12-26 12:31:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("14", "36888", "action created", "2024-12-26 12:43:31", "2024-12-26 12:43:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("15", "36889", "action created", "2024-12-26 12:43:31", "2024-12-26 12:43:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("16", "36890", "action created", "2024-12-26 12:43:35", "2024-12-26 12:43:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("17", "36891", "action created", "2024-12-26 12:43:35", "2024-12-26 12:43:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("18", "36888", "action started via Async Request", "2024-12-26 12:45:12", "2024-12-26 12:45:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("19", "36888", "action complete via Async Request", "2024-12-26 12:45:28", "2024-12-26 12:45:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("20", "36889", "action started via Async Request", "2024-12-26 12:45:35", "2024-12-26 12:45:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("21", "36889", "action complete via Async Request", "2024-12-26 12:45:36", "2024-12-26 12:45:36");
INSERT INTO `wptr_actionscheduler_logs` VALUES("22", "36891", "action started via Async Request", "2024-12-26 12:45:36", "2024-12-26 12:45:36");
INSERT INTO `wptr_actionscheduler_logs` VALUES("23", "36891", "action complete via Async Request", "2024-12-26 12:45:36", "2024-12-26 12:45:36");
INSERT INTO `wptr_actionscheduler_logs` VALUES("24", "36890", "action started via Async Request", "2024-12-26 12:45:36", "2024-12-26 12:45:36");
INSERT INTO `wptr_actionscheduler_logs` VALUES("25", "36890", "action complete via Async Request", "2024-12-26 12:45:37", "2024-12-26 12:45:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("26", "36892", "action created", "2024-12-26 15:55:42", "2024-12-26 15:55:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("27", "36893", "action created", "2024-12-26 15:55:42", "2024-12-26 15:55:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("28", "36892", "action started via Async Request", "2024-12-26 15:57:19", "2024-12-26 15:57:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("29", "36892", "action complete via Async Request", "2024-12-26 15:57:20", "2024-12-26 15:57:20");
INSERT INTO `wptr_actionscheduler_logs` VALUES("30", "36893", "action started via Async Request", "2024-12-26 15:57:20", "2024-12-26 15:57:20");
INSERT INTO `wptr_actionscheduler_logs` VALUES("31", "36893", "action complete via Async Request", "2024-12-26 15:57:20", "2024-12-26 15:57:20");
INSERT INTO `wptr_actionscheduler_logs` VALUES("32", "36894", "action created", "2024-12-26 19:09:15", "2024-12-26 19:09:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("33", "36894", "action started via WP Cron", "2024-12-26 19:09:37", "2024-12-26 19:09:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("34", "36894", "action failed via WP Cron: Scheduled action for rocket_preload_job_load_initial_sitemap will not be executed as no callbacks are registered.", "2024-12-26 19:09:37", "2024-12-26 19:09:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("35", "36895", "action created", "2024-12-26 19:11:02", "2024-12-26 19:11:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("36", "36895", "action started via Async Request", "2024-12-26 19:39:23", "2024-12-26 19:39:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("37", "36896", "action created", "2024-12-26 19:39:23", "2024-12-26 19:39:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("38", "36895", "action complete via Async Request", "2024-12-26 19:39:23", "2024-12-26 19:39:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("39", "36896", "action started via Async Request", "2024-12-26 19:41:02", "2024-12-26 19:41:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("40", "36897", "action created", "2024-12-26 19:41:02", "2024-12-26 19:41:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("41", "36896", "action complete via Async Request", "2024-12-26 19:41:02", "2024-12-26 19:41:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("42", "36897", "action started via Async Request", "2024-12-26 19:42:07", "2024-12-26 19:42:07");
INSERT INTO `wptr_actionscheduler_logs` VALUES("43", "36898", "action created", "2024-12-26 19:42:07", "2024-12-26 19:42:07");
INSERT INTO `wptr_actionscheduler_logs` VALUES("44", "36897", "action complete via Async Request", "2024-12-26 19:42:07", "2024-12-26 19:42:07");
INSERT INTO `wptr_actionscheduler_logs` VALUES("45", "36898", "action started via Async Request", "2024-12-26 19:43:12", "2024-12-26 19:43:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("46", "36899", "action created", "2024-12-26 19:43:12", "2024-12-26 19:43:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("47", "36898", "action complete via Async Request", "2024-12-26 19:43:12", "2024-12-26 19:43:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("48", "36899", "action started via Async Request", "2024-12-26 19:44:26", "2024-12-26 19:44:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("49", "36900", "action created", "2024-12-26 19:44:26", "2024-12-26 19:44:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("50", "36899", "action complete via Async Request", "2024-12-26 19:44:26", "2024-12-26 19:44:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("51", "36900", "action started via Async Request", "2024-12-26 19:45:30", "2024-12-26 19:45:30");
INSERT INTO `wptr_actionscheduler_logs` VALUES("52", "36901", "action created", "2024-12-26 19:45:30", "2024-12-26 19:45:30");
INSERT INTO `wptr_actionscheduler_logs` VALUES("53", "36900", "action complete via Async Request", "2024-12-26 19:45:30", "2024-12-26 19:45:30");
INSERT INTO `wptr_actionscheduler_logs` VALUES("54", "36901", "action started via Async Request", "2024-12-26 19:46:49", "2024-12-26 19:46:49");
INSERT INTO `wptr_actionscheduler_logs` VALUES("55", "36902", "action created", "2024-12-26 19:46:49", "2024-12-26 19:46:49");
INSERT INTO `wptr_actionscheduler_logs` VALUES("56", "36901", "action complete via Async Request", "2024-12-26 19:46:49", "2024-12-26 19:46:49");
INSERT INTO `wptr_actionscheduler_logs` VALUES("57", "36902", "action started via Async Request", "2024-12-26 20:44:11", "2024-12-26 20:44:11");
INSERT INTO `wptr_actionscheduler_logs` VALUES("58", "36903", "action created", "2024-12-26 20:44:11", "2024-12-26 20:44:11");
INSERT INTO `wptr_actionscheduler_logs` VALUES("59", "36902", "action complete via Async Request", "2024-12-26 20:44:11", "2024-12-26 20:44:11");
INSERT INTO `wptr_actionscheduler_logs` VALUES("60", "36903", "action started via Async Request", "2024-12-26 23:27:57", "2024-12-26 23:27:57");
INSERT INTO `wptr_actionscheduler_logs` VALUES("61", "36904", "action created", "2024-12-26 23:27:57", "2024-12-26 23:27:57");
INSERT INTO `wptr_actionscheduler_logs` VALUES("62", "36903", "action complete via Async Request", "2024-12-26 23:27:57", "2024-12-26 23:27:57");
INSERT INTO `wptr_actionscheduler_logs` VALUES("63", "36904", "action started via Async Request", "2024-12-26 23:29:15", "2024-12-26 23:29:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("64", "36905", "action created", "2024-12-26 23:29:15", "2024-12-26 23:29:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("65", "36904", "action complete via Async Request", "2024-12-26 23:29:15", "2024-12-26 23:29:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("66", "36905", "action started via Async Request", "2024-12-26 23:30:29", "2024-12-26 23:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("67", "36906", "action created", "2024-12-26 23:30:29", "2024-12-26 23:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("68", "36905", "action complete via Async Request", "2024-12-26 23:30:29", "2024-12-26 23:30:29");
INSERT INTO `wptr_actionscheduler_logs` VALUES("69", "36906", "action started via Async Request", "2024-12-26 23:32:31", "2024-12-26 23:32:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("70", "36907", "action created", "2024-12-26 23:32:31", "2024-12-26 23:32:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("71", "36906", "action complete via Async Request", "2024-12-26 23:32:31", "2024-12-26 23:32:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("72", "36907", "action started via Async Request", "2024-12-26 23:33:55", "2024-12-26 23:33:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("73", "36908", "action created", "2024-12-26 23:33:55", "2024-12-26 23:33:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("74", "36907", "action complete via Async Request", "2024-12-26 23:33:55", "2024-12-26 23:33:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("75", "36908", "action started via Async Request", "2024-12-26 23:35:23", "2024-12-26 23:35:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("76", "36909", "action created", "2024-12-26 23:35:23", "2024-12-26 23:35:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("77", "36908", "action complete via Async Request", "2024-12-26 23:35:23", "2024-12-26 23:35:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("78", "36909", "action started via Async Request", "2024-12-26 23:37:26", "2024-12-26 23:37:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("79", "36910", "action created", "2024-12-26 23:37:26", "2024-12-26 23:37:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("80", "36909", "action complete via Async Request", "2024-12-26 23:37:26", "2024-12-26 23:37:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("81", "36910", "action started via Async Request", "2024-12-26 23:38:37", "2024-12-26 23:38:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("82", "36911", "action created", "2024-12-26 23:38:37", "2024-12-26 23:38:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("83", "36910", "action complete via Async Request", "2024-12-26 23:38:37", "2024-12-26 23:38:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("84", "36911", "action started via Async Request", "2024-12-26 23:39:40", "2024-12-26 23:39:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("85", "36912", "action created", "2024-12-26 23:39:40", "2024-12-26 23:39:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("86", "36911", "action complete via Async Request", "2024-12-26 23:39:40", "2024-12-26 23:39:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("87", "36912", "action started via Async Request", "2024-12-26 23:41:42", "2024-12-26 23:41:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("88", "36913", "action created", "2024-12-26 23:41:42", "2024-12-26 23:41:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("89", "36912", "action complete via Async Request", "2024-12-26 23:41:42", "2024-12-26 23:41:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("90", "36913", "action started via Async Request", "2024-12-26 23:42:44", "2024-12-26 23:42:44");
INSERT INTO `wptr_actionscheduler_logs` VALUES("91", "36914", "action created", "2024-12-26 23:42:44", "2024-12-26 23:42:44");
INSERT INTO `wptr_actionscheduler_logs` VALUES("92", "36913", "action complete via Async Request", "2024-12-26 23:42:44", "2024-12-26 23:42:44");
INSERT INTO `wptr_actionscheduler_logs` VALUES("93", "36914", "action started via Async Request", "2024-12-26 23:43:55", "2024-12-26 23:43:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("94", "36915", "action created", "2024-12-26 23:43:55", "2024-12-26 23:43:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("95", "36914", "action complete via Async Request", "2024-12-26 23:43:55", "2024-12-26 23:43:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("96", "36915", "action started via Async Request", "2024-12-26 23:45:59", "2024-12-26 23:45:59");
INSERT INTO `wptr_actionscheduler_logs` VALUES("97", "36916", "action created", "2024-12-26 23:45:59", "2024-12-26 23:45:59");
INSERT INTO `wptr_actionscheduler_logs` VALUES("98", "36915", "action complete via Async Request", "2024-12-26 23:45:59", "2024-12-26 23:45:59");
INSERT INTO `wptr_actionscheduler_logs` VALUES("99", "36916", "action started via Async Request", "2024-12-26 23:47:03", "2024-12-26 23:47:03");
INSERT INTO `wptr_actionscheduler_logs` VALUES("100", "36917", "action created", "2024-12-26 23:47:03", "2024-12-26 23:47:03");
INSERT INTO `wptr_actionscheduler_logs` VALUES("101", "36916", "action complete via Async Request", "2024-12-26 23:47:03", "2024-12-26 23:47:03");
INSERT INTO `wptr_actionscheduler_logs` VALUES("102", "36917", "action started via Async Request", "2024-12-26 23:49:50", "2024-12-26 23:49:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("103", "36918", "action created", "2024-12-26 23:49:50", "2024-12-26 23:49:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("104", "36917", "action complete via Async Request", "2024-12-26 23:49:50", "2024-12-26 23:49:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("105", "36918", "action started via Async Request", "2024-12-26 23:50:53", "2024-12-26 23:50:53");
INSERT INTO `wptr_actionscheduler_logs` VALUES("106", "36919", "action created", "2024-12-26 23:50:53", "2024-12-26 23:50:53");
INSERT INTO `wptr_actionscheduler_logs` VALUES("107", "36918", "action complete via Async Request", "2024-12-26 23:50:53", "2024-12-26 23:50:53");
INSERT INTO `wptr_actionscheduler_logs` VALUES("108", "36919", "action started via Async Request", "2024-12-26 23:52:50", "2024-12-26 23:52:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("109", "36920", "action created", "2024-12-26 23:52:50", "2024-12-26 23:52:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("110", "36919", "action complete via Async Request", "2024-12-26 23:52:50", "2024-12-26 23:52:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("111", "36920", "action started via Async Request", "2024-12-26 23:53:52", "2024-12-26 23:53:52");
INSERT INTO `wptr_actionscheduler_logs` VALUES("112", "36921", "action created", "2024-12-26 23:53:52", "2024-12-26 23:53:52");
INSERT INTO `wptr_actionscheduler_logs` VALUES("113", "36920", "action complete via Async Request", "2024-12-26 23:53:52", "2024-12-26 23:53:52");
INSERT INTO `wptr_actionscheduler_logs` VALUES("114", "36921", "action started via Async Request", "2024-12-26 23:54:54", "2024-12-26 23:54:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("115", "36922", "action created", "2024-12-26 23:54:54", "2024-12-26 23:54:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("116", "36921", "action complete via Async Request", "2024-12-26 23:54:54", "2024-12-26 23:54:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("117", "36922", "action started via Async Request", "2024-12-26 23:56:08", "2024-12-26 23:56:08");
INSERT INTO `wptr_actionscheduler_logs` VALUES("118", "36923", "action created", "2024-12-26 23:56:08", "2024-12-26 23:56:08");
INSERT INTO `wptr_actionscheduler_logs` VALUES("119", "36922", "action complete via Async Request", "2024-12-26 23:56:08", "2024-12-26 23:56:08");
INSERT INTO `wptr_actionscheduler_logs` VALUES("120", "36923", "action started via Async Request", "2024-12-26 23:58:13", "2024-12-26 23:58:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("121", "36924", "action created", "2024-12-26 23:58:13", "2024-12-26 23:58:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("122", "36923", "action complete via Async Request", "2024-12-26 23:58:13", "2024-12-26 23:58:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("123", "36924", "action started via Async Request", "2024-12-26 23:59:21", "2024-12-26 23:59:21");
INSERT INTO `wptr_actionscheduler_logs` VALUES("124", "36925", "action created", "2024-12-26 23:59:21", "2024-12-26 23:59:21");
INSERT INTO `wptr_actionscheduler_logs` VALUES("125", "36924", "action complete via Async Request", "2024-12-26 23:59:21", "2024-12-26 23:59:21");
INSERT INTO `wptr_actionscheduler_logs` VALUES("126", "36925", "action started via Async Request", "2024-12-27 00:01:27", "2024-12-27 00:01:27");
INSERT INTO `wptr_actionscheduler_logs` VALUES("127", "36926", "action created", "2024-12-27 00:01:27", "2024-12-27 00:01:27");
INSERT INTO `wptr_actionscheduler_logs` VALUES("128", "36925", "action complete via Async Request", "2024-12-27 00:01:27", "2024-12-27 00:01:27");
INSERT INTO `wptr_actionscheduler_logs` VALUES("129", "36926", "action started via Async Request", "2024-12-27 00:02:49", "2024-12-27 00:02:49");
INSERT INTO `wptr_actionscheduler_logs` VALUES("130", "36927", "action created", "2024-12-27 00:02:49", "2024-12-27 00:02:49");
INSERT INTO `wptr_actionscheduler_logs` VALUES("131", "36926", "action complete via Async Request", "2024-12-27 00:02:49", "2024-12-27 00:02:49");
INSERT INTO `wptr_actionscheduler_logs` VALUES("132", "36927", "action started via Async Request", "2024-12-27 00:04:41", "2024-12-27 00:04:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("133", "36928", "action created", "2024-12-27 00:04:41", "2024-12-27 00:04:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("134", "36927", "action complete via Async Request", "2024-12-27 00:04:41", "2024-12-27 00:04:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("135", "36928", "action started via Async Request", "2024-12-27 00:05:55", "2024-12-27 00:05:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("136", "36929", "action created", "2024-12-27 00:05:55", "2024-12-27 00:05:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("137", "36928", "action complete via Async Request", "2024-12-27 00:05:55", "2024-12-27 00:05:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("138", "36929", "action started via Async Request", "2024-12-27 00:23:38", "2024-12-27 00:23:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("139", "36930", "action created", "2024-12-27 00:23:38", "2024-12-27 00:23:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("140", "36929", "action complete via Async Request", "2024-12-27 00:23:38", "2024-12-27 00:23:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("141", "36930", "action started via Async Request", "2024-12-27 00:38:40", "2024-12-27 00:38:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("142", "36931", "action created", "2024-12-27 00:38:40", "2024-12-27 00:38:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("143", "36930", "action complete via Async Request", "2024-12-27 00:38:40", "2024-12-27 00:38:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("144", "36932", "action created", "2024-12-27 00:39:37", "2024-12-27 00:39:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("145", "36933", "action created", "2024-12-27 00:39:37", "2024-12-27 00:39:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("146", "36932", "action started via Async Request", "2024-12-27 00:39:40", "2024-12-27 00:39:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("147", "36932", "action complete via Async Request", "2024-12-27 00:39:41", "2024-12-27 00:39:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("148", "36931", "action started via Async Request", "2024-12-27 00:39:41", "2024-12-27 00:39:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("149", "36934", "action created", "2024-12-27 00:39:41", "2024-12-27 00:39:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("150", "36931", "action complete via Async Request", "2024-12-27 00:39:41", "2024-12-27 00:39:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("151", "36933", "action started via Async Request", "2024-12-27 09:36:28", "2024-12-27 09:36:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("152", "36933", "action complete via Async Request", "2024-12-27 09:36:28", "2024-12-27 09:36:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("153", "36934", "action started via Async Request", "2024-12-27 09:36:28", "2024-12-27 09:36:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("154", "36935", "action created", "2024-12-27 09:36:28", "2024-12-27 09:36:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("155", "36934", "action complete via Async Request", "2024-12-27 09:36:28", "2024-12-27 09:36:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("156", "36935", "action started via Async Request", "2024-12-27 11:00:38", "2024-12-27 11:00:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("157", "36936", "action created", "2024-12-27 11:00:38", "2024-12-27 11:00:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("158", "36935", "action complete via Async Request", "2024-12-27 11:00:38", "2024-12-27 11:00:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("159", "36936", "action started via Async Request", "2024-12-27 11:07:47", "2024-12-27 11:07:47");
INSERT INTO `wptr_actionscheduler_logs` VALUES("160", "36937", "action created", "2024-12-27 11:07:47", "2024-12-27 11:07:47");
INSERT INTO `wptr_actionscheduler_logs` VALUES("161", "36936", "action complete via Async Request", "2024-12-27 11:07:47", "2024-12-27 11:07:47");
INSERT INTO `wptr_actionscheduler_logs` VALUES("162", "36937", "action started via Async Request", "2024-12-27 11:09:09", "2024-12-27 11:09:09");
INSERT INTO `wptr_actionscheduler_logs` VALUES("163", "36938", "action created", "2024-12-27 11:09:09", "2024-12-27 11:09:09");
INSERT INTO `wptr_actionscheduler_logs` VALUES("164", "36937", "action complete via Async Request", "2024-12-27 11:09:09", "2024-12-27 11:09:09");
INSERT INTO `wptr_actionscheduler_logs` VALUES("165", "36939", "action created", "2024-12-27 11:40:42", "2024-12-27 11:40:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("166", "36940", "action created", "2024-12-27 11:40:42", "2024-12-27 11:40:42");
INSERT INTO `wptr_actionscheduler_logs` VALUES("167", "36938", "action started via Async Request", "2024-12-27 11:47:13", "2024-12-27 11:47:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("168", "36941", "action created", "2024-12-27 11:47:13", "2024-12-27 11:47:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("169", "36938", "action complete via Async Request", "2024-12-27 11:47:13", "2024-12-27 11:47:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("170", "36939", "action started via Async Request", "2024-12-27 11:47:13", "2024-12-27 11:47:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("171", "36939", "action complete via Async Request", "2024-12-27 11:47:14", "2024-12-27 11:47:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("172", "36940", "action started via Async Request", "2024-12-27 11:47:14", "2024-12-27 11:47:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("173", "36940", "action complete via Async Request", "2024-12-27 11:47:14", "2024-12-27 11:47:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("174", "36942", "action created", "2024-12-27 11:47:14", "2024-12-27 11:47:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("175", "36941", "action started via Async Request", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("176", "36943", "action created", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("177", "36941", "action complete via Async Request", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("178", "36942", "action started via Async Request", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("179", "36942", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("180", "36886", "action started via Async Request", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("181", "36886", "action complete via Async Request", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("182", "36944", "action created", "2024-12-27 14:58:06", "2024-12-27 14:58:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("183", "36943", "action started via Async Request", "2024-12-27 14:59:10", "2024-12-27 14:59:10");
INSERT INTO `wptr_actionscheduler_logs` VALUES("184", "36945", "action created", "2024-12-27 14:59:10", "2024-12-27 14:59:10");
INSERT INTO `wptr_actionscheduler_logs` VALUES("185", "36943", "action complete via Async Request", "2024-12-27 14:59:10", "2024-12-27 14:59:10");
INSERT INTO `wptr_actionscheduler_logs` VALUES("186", "36945", "action started via Async Request", "2024-12-27 15:20:45", "2024-12-27 15:20:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("187", "36946", "action created", "2024-12-27 15:20:45", "2024-12-27 15:20:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("188", "36945", "action complete via Async Request", "2024-12-27 15:20:45", "2024-12-27 15:20:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("189", "36946", "action started via Async Request", "2024-12-27 15:22:45", "2024-12-27 15:22:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("190", "36947", "action created", "2024-12-27 15:22:45", "2024-12-27 15:22:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("191", "36946", "action complete via Async Request", "2024-12-27 15:22:45", "2024-12-27 15:22:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("192", "36947", "action started via Async Request", "2024-12-27 15:24:45", "2024-12-27 15:24:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("193", "36948", "action created", "2024-12-27 15:24:45", "2024-12-27 15:24:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("194", "36947", "action complete via Async Request", "2024-12-27 15:24:45", "2024-12-27 15:24:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("195", "36948", "action started via Async Request", "2024-12-27 15:26:15", "2024-12-27 15:26:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("196", "36949", "action created", "2024-12-27 15:26:15", "2024-12-27 15:26:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("197", "36948", "action complete via Async Request", "2024-12-27 15:26:15", "2024-12-27 15:26:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("198", "36949", "action started via Async Request", "2024-12-27 15:27:19", "2024-12-27 15:27:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("199", "36950", "action created", "2024-12-27 15:27:19", "2024-12-27 15:27:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("200", "36949", "action complete via Async Request", "2024-12-27 15:27:19", "2024-12-27 15:27:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("201", "36950", "action started via Async Request", "2024-12-27 15:28:40", "2024-12-27 15:28:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("202", "36951", "action created", "2024-12-27 15:28:40", "2024-12-27 15:28:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("203", "36950", "action complete via Async Request", "2024-12-27 15:28:40", "2024-12-27 15:28:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("204", "36951", "action started via Async Request", "2024-12-27 15:30:05", "2024-12-27 15:30:05");
INSERT INTO `wptr_actionscheduler_logs` VALUES("205", "36952", "action created", "2024-12-27 15:30:05", "2024-12-27 15:30:05");
INSERT INTO `wptr_actionscheduler_logs` VALUES("206", "36951", "action complete via Async Request", "2024-12-27 15:30:05", "2024-12-27 15:30:05");
INSERT INTO `wptr_actionscheduler_logs` VALUES("207", "36952", "action started via Async Request", "2024-12-27 15:31:32", "2024-12-27 15:31:32");
INSERT INTO `wptr_actionscheduler_logs` VALUES("208", "36953", "action created", "2024-12-27 15:31:32", "2024-12-27 15:31:32");
INSERT INTO `wptr_actionscheduler_logs` VALUES("209", "36952", "action complete via Async Request", "2024-12-27 15:31:32", "2024-12-27 15:31:32");
INSERT INTO `wptr_actionscheduler_logs` VALUES("210", "36953", "action started via Async Request", "2024-12-27 15:32:45", "2024-12-27 15:32:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("211", "36954", "action created", "2024-12-27 15:32:45", "2024-12-27 15:32:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("212", "36953", "action complete via Async Request", "2024-12-27 15:32:45", "2024-12-27 15:32:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("213", "36954", "action started via Async Request", "2024-12-27 15:34:45", "2024-12-27 15:34:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("214", "36955", "action created", "2024-12-27 15:34:45", "2024-12-27 15:34:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("215", "36954", "action complete via Async Request", "2024-12-27 15:34:45", "2024-12-27 15:34:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("216", "36955", "action started via Async Request", "2024-12-27 15:36:44", "2024-12-27 15:36:44");
INSERT INTO `wptr_actionscheduler_logs` VALUES("217", "36956", "action created", "2024-12-27 15:36:44", "2024-12-27 15:36:44");
INSERT INTO `wptr_actionscheduler_logs` VALUES("218", "36955", "action complete via Async Request", "2024-12-27 15:36:44", "2024-12-27 15:36:44");
INSERT INTO `wptr_actionscheduler_logs` VALUES("219", "36956", "action started via Async Request", "2024-12-27 15:37:46", "2024-12-27 15:37:46");
INSERT INTO `wptr_actionscheduler_logs` VALUES("220", "36957", "action created", "2024-12-27 15:37:46", "2024-12-27 15:37:46");
INSERT INTO `wptr_actionscheduler_logs` VALUES("221", "36956", "action complete via Async Request", "2024-12-27 15:37:46", "2024-12-27 15:37:46");
INSERT INTO `wptr_actionscheduler_logs` VALUES("222", "36957", "action started via Async Request", "2024-12-27 15:39:35", "2024-12-27 15:39:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("223", "36958", "action created", "2024-12-27 15:39:35", "2024-12-27 15:39:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("224", "36957", "action complete via Async Request", "2024-12-27 15:39:35", "2024-12-27 15:39:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("225", "36958", "action started via Async Request", "2024-12-27 15:40:37", "2024-12-27 15:40:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("226", "36959", "action created", "2024-12-27 15:40:37", "2024-12-27 15:40:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("227", "36958", "action complete via Async Request", "2024-12-27 15:40:37", "2024-12-27 15:40:37");
INSERT INTO `wptr_actionscheduler_logs` VALUES("228", "36959", "action started via Async Request", "2024-12-27 15:43:06", "2024-12-27 15:43:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("229", "36960", "action created", "2024-12-27 15:43:06", "2024-12-27 15:43:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("230", "36959", "action complete via Async Request", "2024-12-27 15:43:06", "2024-12-27 15:43:06");
INSERT INTO `wptr_actionscheduler_logs` VALUES("231", "36960", "action started via Async Request", "2024-12-27 15:44:38", "2024-12-27 15:44:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("232", "36961", "action created", "2024-12-27 15:44:38", "2024-12-27 15:44:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("233", "36960", "action complete via Async Request", "2024-12-27 15:44:38", "2024-12-27 15:44:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("234", "36961", "action started via Async Request", "2024-12-27 15:46:40", "2024-12-27 15:46:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("235", "36962", "action created", "2024-12-27 15:46:40", "2024-12-27 15:46:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("236", "36961", "action complete via Async Request", "2024-12-27 15:46:40", "2024-12-27 15:46:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("237", "36962", "action started via Async Request", "2024-12-27 15:48:23", "2024-12-27 15:48:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("238", "36963", "action created", "2024-12-27 15:48:23", "2024-12-27 15:48:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("239", "36962", "action complete via Async Request", "2024-12-27 15:48:23", "2024-12-27 15:48:23");
INSERT INTO `wptr_actionscheduler_logs` VALUES("240", "36963", "action started via Async Request", "2024-12-27 15:49:40", "2024-12-27 15:49:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("241", "36964", "action created", "2024-12-27 15:49:40", "2024-12-27 15:49:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("242", "36963", "action complete via Async Request", "2024-12-27 15:49:40", "2024-12-27 15:49:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("243", "36964", "action started via Async Request", "2024-12-27 15:51:04", "2024-12-27 15:51:04");
INSERT INTO `wptr_actionscheduler_logs` VALUES("244", "36965", "action created", "2024-12-27 15:51:04", "2024-12-27 15:51:04");
INSERT INTO `wptr_actionscheduler_logs` VALUES("245", "36964", "action complete via Async Request", "2024-12-27 15:51:04", "2024-12-27 15:51:04");
INSERT INTO `wptr_actionscheduler_logs` VALUES("246", "36965", "action started via Async Request", "2024-12-27 15:52:17", "2024-12-27 15:52:17");
INSERT INTO `wptr_actionscheduler_logs` VALUES("247", "36966", "action created", "2024-12-27 15:52:17", "2024-12-27 15:52:17");
INSERT INTO `wptr_actionscheduler_logs` VALUES("248", "36965", "action complete via Async Request", "2024-12-27 15:52:17", "2024-12-27 15:52:17");
INSERT INTO `wptr_actionscheduler_logs` VALUES("249", "36966", "action started via Async Request", "2024-12-27 16:50:28", "2024-12-27 16:50:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("250", "36967", "action created", "2024-12-27 16:50:28", "2024-12-27 16:50:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("251", "36966", "action complete via Async Request", "2024-12-27 16:50:28", "2024-12-27 16:50:28");
INSERT INTO `wptr_actionscheduler_logs` VALUES("252", "36967", "action started via Async Request", "2024-12-27 16:51:40", "2024-12-27 16:51:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("253", "36968", "action created", "2024-12-27 16:51:40", "2024-12-27 16:51:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("254", "36967", "action complete via Async Request", "2024-12-27 16:51:40", "2024-12-27 16:51:40");
INSERT INTO `wptr_actionscheduler_logs` VALUES("255", "36968", "action started via Async Request", "2024-12-27 16:56:41", "2024-12-27 16:56:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("256", "36969", "action created", "2024-12-27 16:56:41", "2024-12-27 16:56:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("257", "36968", "action complete via Async Request", "2024-12-27 16:56:41", "2024-12-27 16:56:41");
INSERT INTO `wptr_actionscheduler_logs` VALUES("258", "36969", "action started via Async Request", "2024-12-27 16:58:50", "2024-12-27 16:58:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("259", "36970", "action created", "2024-12-27 16:58:50", "2024-12-27 16:58:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("260", "36969", "action complete via Async Request", "2024-12-27 16:58:50", "2024-12-27 16:58:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("261", "36970", "action started via Async Request", "2024-12-27 17:00:50", "2024-12-27 17:00:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("262", "36971", "action created", "2024-12-27 17:00:50", "2024-12-27 17:00:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("263", "36970", "action complete via Async Request", "2024-12-27 17:00:50", "2024-12-27 17:00:50");
INSERT INTO `wptr_actionscheduler_logs` VALUES("264", "36971", "action started via Async Request", "2024-12-27 17:02:52", "2024-12-27 17:02:52");
INSERT INTO `wptr_actionscheduler_logs` VALUES("265", "36972", "action created", "2024-12-27 17:02:52", "2024-12-27 17:02:52");
INSERT INTO `wptr_actionscheduler_logs` VALUES("266", "36971", "action complete via Async Request", "2024-12-27 17:02:52", "2024-12-27 17:02:52");
INSERT INTO `wptr_actionscheduler_logs` VALUES("267", "36972", "action started via Async Request", "2024-12-27 17:04:53", "2024-12-27 17:04:53");
INSERT INTO `wptr_actionscheduler_logs` VALUES("268", "36973", "action created", "2024-12-27 17:04:53", "2024-12-27 17:04:53");
INSERT INTO `wptr_actionscheduler_logs` VALUES("269", "36972", "action complete via Async Request", "2024-12-27 17:04:53", "2024-12-27 17:04:53");
INSERT INTO `wptr_actionscheduler_logs` VALUES("270", "36973", "action started via Async Request", "2024-12-27 17:06:54", "2024-12-27 17:06:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("271", "36974", "action created", "2024-12-27 17:06:54", "2024-12-27 17:06:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("272", "36973", "action complete via Async Request", "2024-12-27 17:06:54", "2024-12-27 17:06:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("273", "36974", "action started via Async Request", "2024-12-27 17:08:55", "2024-12-27 17:08:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("274", "36975", "action created", "2024-12-27 17:08:55", "2024-12-27 17:08:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("275", "36974", "action complete via Async Request", "2024-12-27 17:08:55", "2024-12-27 17:08:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("276", "36975", "action started via Async Request", "2024-12-27 17:10:56", "2024-12-27 17:10:56");
INSERT INTO `wptr_actionscheduler_logs` VALUES("277", "36976", "action created", "2024-12-27 17:10:56", "2024-12-27 17:10:56");
INSERT INTO `wptr_actionscheduler_logs` VALUES("278", "36975", "action complete via Async Request", "2024-12-27 17:10:56", "2024-12-27 17:10:56");
INSERT INTO `wptr_actionscheduler_logs` VALUES("279", "36976", "action started via Async Request", "2024-12-27 17:39:14", "2024-12-27 17:39:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("280", "36977", "action created", "2024-12-27 17:39:14", "2024-12-27 17:39:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("281", "36976", "action complete via Async Request", "2024-12-27 17:39:14", "2024-12-27 17:39:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("282", "36977", "action started via Async Request", "2024-12-27 17:41:14", "2024-12-27 17:41:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("283", "36978", "action created", "2024-12-27 17:41:14", "2024-12-27 17:41:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("284", "36977", "action complete via Async Request", "2024-12-27 17:41:14", "2024-12-27 17:41:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("285", "36978", "action started via Async Request", "2024-12-27 17:43:15", "2024-12-27 17:43:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("286", "36979", "action created", "2024-12-27 17:43:15", "2024-12-27 17:43:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("287", "36978", "action complete via Async Request", "2024-12-27 17:43:15", "2024-12-27 17:43:15");
INSERT INTO `wptr_actionscheduler_logs` VALUES("288", "36979", "action started via Async Request", "2024-12-27 17:45:16", "2024-12-27 17:45:16");
INSERT INTO `wptr_actionscheduler_logs` VALUES("289", "36980", "action created", "2024-12-27 17:45:16", "2024-12-27 17:45:16");
INSERT INTO `wptr_actionscheduler_logs` VALUES("290", "36979", "action complete via Async Request", "2024-12-27 17:45:16", "2024-12-27 17:45:16");
INSERT INTO `wptr_actionscheduler_logs` VALUES("291", "36980", "action started via Async Request", "2024-12-27 17:47:17", "2024-12-27 17:47:17");
INSERT INTO `wptr_actionscheduler_logs` VALUES("292", "36981", "action created", "2024-12-27 17:47:17", "2024-12-27 17:47:17");
INSERT INTO `wptr_actionscheduler_logs` VALUES("293", "36980", "action complete via Async Request", "2024-12-27 17:47:17", "2024-12-27 17:47:17");
INSERT INTO `wptr_actionscheduler_logs` VALUES("294", "36981", "action started via Async Request", "2024-12-27 17:49:18", "2024-12-27 17:49:18");
INSERT INTO `wptr_actionscheduler_logs` VALUES("295", "36982", "action created", "2024-12-27 17:49:18", "2024-12-27 17:49:18");
INSERT INTO `wptr_actionscheduler_logs` VALUES("296", "36981", "action complete via Async Request", "2024-12-27 17:49:18", "2024-12-27 17:49:18");
INSERT INTO `wptr_actionscheduler_logs` VALUES("297", "36982", "action started via Async Request", "2024-12-27 23:19:02", "2024-12-27 23:19:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("298", "36983", "action created", "2024-12-27 23:19:02", "2024-12-27 23:19:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("299", "36982", "action complete via Async Request", "2024-12-27 23:19:02", "2024-12-27 23:19:02");
INSERT INTO `wptr_actionscheduler_logs` VALUES("300", "36983", "action started via Async Request", "2024-12-28 01:54:25", "2024-12-28 01:54:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("301", "36984", "action created", "2024-12-28 01:54:25", "2024-12-28 01:54:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("302", "36983", "action complete via Async Request", "2024-12-28 01:54:25", "2024-12-28 01:54:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("303", "36984", "action started via Async Request", "2024-12-28 01:56:07", "2024-12-28 01:56:07");
INSERT INTO `wptr_actionscheduler_logs` VALUES("304", "36985", "action created", "2024-12-28 01:56:07", "2024-12-28 01:56:07");
INSERT INTO `wptr_actionscheduler_logs` VALUES("305", "36984", "action complete via Async Request", "2024-12-28 01:56:07", "2024-12-28 01:56:07");
INSERT INTO `wptr_actionscheduler_logs` VALUES("306", "36985", "action started via Async Request", "2024-12-28 01:57:25", "2024-12-28 01:57:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("307", "36986", "action created", "2024-12-28 01:57:25", "2024-12-28 01:57:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("308", "36985", "action complete via Async Request", "2024-12-28 01:57:25", "2024-12-28 01:57:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("309", "36986", "action started via Async Request", "2024-12-28 08:13:34", "2024-12-28 08:13:34");
INSERT INTO `wptr_actionscheduler_logs` VALUES("310", "36987", "action created", "2024-12-28 08:13:34", "2024-12-28 08:13:34");
INSERT INTO `wptr_actionscheduler_logs` VALUES("311", "36986", "action complete via Async Request", "2024-12-28 08:13:34", "2024-12-28 08:13:34");
INSERT INTO `wptr_actionscheduler_logs` VALUES("312", "36987", "action started via Async Request", "2024-12-28 08:15:14", "2024-12-28 08:15:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("313", "36988", "action created", "2024-12-28 08:15:14", "2024-12-28 08:15:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("314", "36987", "action complete via Async Request", "2024-12-28 08:15:14", "2024-12-28 08:15:14");
INSERT INTO `wptr_actionscheduler_logs` VALUES("315", "36988", "action started via Async Request", "2024-12-28 08:16:22", "2024-12-28 08:16:22");
INSERT INTO `wptr_actionscheduler_logs` VALUES("316", "36989", "action created", "2024-12-28 08:16:22", "2024-12-28 08:16:22");
INSERT INTO `wptr_actionscheduler_logs` VALUES("317", "36988", "action complete via Async Request", "2024-12-28 08:16:22", "2024-12-28 08:16:22");
INSERT INTO `wptr_actionscheduler_logs` VALUES("318", "36989", "action started via Async Request", "2024-12-28 08:17:26", "2024-12-28 08:17:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("319", "36990", "action created", "2024-12-28 08:17:26", "2024-12-28 08:17:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("320", "36989", "action complete via Async Request", "2024-12-28 08:17:26", "2024-12-28 08:17:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("321", "36990", "action started via Async Request", "2024-12-28 08:18:31", "2024-12-28 08:18:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("322", "36991", "action created", "2024-12-28 08:18:31", "2024-12-28 08:18:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("323", "36990", "action complete via Async Request", "2024-12-28 08:18:31", "2024-12-28 08:18:31");
INSERT INTO `wptr_actionscheduler_logs` VALUES("324", "36991", "action started via Async Request", "2024-12-28 08:19:38", "2024-12-28 08:19:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("325", "36992", "action created", "2024-12-28 08:19:38", "2024-12-28 08:19:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("326", "36991", "action complete via Async Request", "2024-12-28 08:19:38", "2024-12-28 08:19:38");
INSERT INTO `wptr_actionscheduler_logs` VALUES("327", "36992", "action started via Async Request", "2024-12-28 08:20:45", "2024-12-28 08:20:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("328", "36993", "action created", "2024-12-28 08:20:45", "2024-12-28 08:20:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("329", "36992", "action complete via Async Request", "2024-12-28 08:20:45", "2024-12-28 08:20:45");
INSERT INTO `wptr_actionscheduler_logs` VALUES("330", "36993", "action started via Async Request", "2024-12-28 08:22:35", "2024-12-28 08:22:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("331", "36994", "action created", "2024-12-28 08:22:35", "2024-12-28 08:22:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("332", "36993", "action complete via Async Request", "2024-12-28 08:22:35", "2024-12-28 08:22:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("333", "36994", "action started via Async Request", "2024-12-28 08:23:39", "2024-12-28 08:23:39");
INSERT INTO `wptr_actionscheduler_logs` VALUES("334", "36995", "action created", "2024-12-28 08:23:39", "2024-12-28 08:23:39");
INSERT INTO `wptr_actionscheduler_logs` VALUES("335", "36994", "action complete via Async Request", "2024-12-28 08:23:39", "2024-12-28 08:23:39");
INSERT INTO `wptr_actionscheduler_logs` VALUES("336", "36995", "action started via Async Request", "2024-12-28 08:24:48", "2024-12-28 08:24:48");
INSERT INTO `wptr_actionscheduler_logs` VALUES("337", "36996", "action created", "2024-12-28 08:24:48", "2024-12-28 08:24:48");
INSERT INTO `wptr_actionscheduler_logs` VALUES("338", "36995", "action complete via Async Request", "2024-12-28 08:24:48", "2024-12-28 08:24:48");
INSERT INTO `wptr_actionscheduler_logs` VALUES("339", "36996", "action started via Async Request", "2024-12-28 08:25:57", "2024-12-28 08:25:57");
INSERT INTO `wptr_actionscheduler_logs` VALUES("340", "36997", "action created", "2024-12-28 08:25:57", "2024-12-28 08:25:57");
INSERT INTO `wptr_actionscheduler_logs` VALUES("341", "36996", "action complete via Async Request", "2024-12-28 08:25:57", "2024-12-28 08:25:57");
INSERT INTO `wptr_actionscheduler_logs` VALUES("342", "36997", "action started via Async Request", "2024-12-28 08:27:00", "2024-12-28 08:27:00");
INSERT INTO `wptr_actionscheduler_logs` VALUES("343", "36998", "action created", "2024-12-28 08:27:00", "2024-12-28 08:27:00");
INSERT INTO `wptr_actionscheduler_logs` VALUES("344", "36997", "action complete via Async Request", "2024-12-28 08:27:00", "2024-12-28 08:27:00");
INSERT INTO `wptr_actionscheduler_logs` VALUES("345", "36998", "action started via Async Request", "2024-12-28 08:28:13", "2024-12-28 08:28:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("346", "36999", "action created", "2024-12-28 08:28:13", "2024-12-28 08:28:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("347", "36998", "action complete via Async Request", "2024-12-28 08:28:13", "2024-12-28 08:28:13");
INSERT INTO `wptr_actionscheduler_logs` VALUES("348", "36999", "action started via Async Request", "2024-12-28 08:29:18", "2024-12-28 08:29:18");
INSERT INTO `wptr_actionscheduler_logs` VALUES("349", "37000", "action created", "2024-12-28 08:29:18", "2024-12-28 08:29:18");
INSERT INTO `wptr_actionscheduler_logs` VALUES("350", "36999", "action complete via Async Request", "2024-12-28 08:29:18", "2024-12-28 08:29:18");
INSERT INTO `wptr_actionscheduler_logs` VALUES("351", "37000", "action started via Async Request", "2024-12-28 08:30:35", "2024-12-28 08:30:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("352", "37001", "action created", "2024-12-28 08:30:35", "2024-12-28 08:30:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("353", "37000", "action complete via Async Request", "2024-12-28 08:30:35", "2024-12-28 08:30:35");
INSERT INTO `wptr_actionscheduler_logs` VALUES("354", "37001", "action started via Async Request", "2024-12-28 08:31:54", "2024-12-28 08:31:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("355", "37002", "action created", "2024-12-28 08:31:54", "2024-12-28 08:31:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("356", "37001", "action complete via Async Request", "2024-12-28 08:31:54", "2024-12-28 08:31:54");
INSERT INTO `wptr_actionscheduler_logs` VALUES("357", "37002", "action started via Async Request", "2024-12-28 08:33:19", "2024-12-28 08:33:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("358", "37003", "action created", "2024-12-28 08:33:19", "2024-12-28 08:33:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("359", "37002", "action complete via Async Request", "2024-12-28 08:33:19", "2024-12-28 08:33:19");
INSERT INTO `wptr_actionscheduler_logs` VALUES("360", "37003", "action started via Async Request", "2024-12-28 08:34:26", "2024-12-28 08:34:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("361", "37004", "action created", "2024-12-28 08:34:26", "2024-12-28 08:34:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("362", "37003", "action complete via Async Request", "2024-12-28 08:34:26", "2024-12-28 08:34:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("363", "37004", "action started via Async Request", "2024-12-28 08:35:34", "2024-12-28 08:35:34");
INSERT INTO `wptr_actionscheduler_logs` VALUES("364", "37005", "action created", "2024-12-28 08:35:34", "2024-12-28 08:35:34");
INSERT INTO `wptr_actionscheduler_logs` VALUES("365", "37004", "action complete via Async Request", "2024-12-28 08:35:34", "2024-12-28 08:35:34");
INSERT INTO `wptr_actionscheduler_logs` VALUES("366", "37005", "action started via Async Request", "2024-12-28 08:37:47", "2024-12-28 08:37:47");
INSERT INTO `wptr_actionscheduler_logs` VALUES("367", "37006", "action created", "2024-12-28 08:37:47", "2024-12-28 08:37:47");
INSERT INTO `wptr_actionscheduler_logs` VALUES("368", "37005", "action complete via Async Request", "2024-12-28 08:37:47", "2024-12-28 08:37:47");
INSERT INTO `wptr_actionscheduler_logs` VALUES("369", "37006", "action started via Async Request", "2024-12-28 08:39:48", "2024-12-28 08:39:48");
INSERT INTO `wptr_actionscheduler_logs` VALUES("370", "37007", "action created", "2024-12-28 08:39:48", "2024-12-28 08:39:48");
INSERT INTO `wptr_actionscheduler_logs` VALUES("371", "37006", "action complete via Async Request", "2024-12-28 08:39:48", "2024-12-28 08:39:48");
INSERT INTO `wptr_actionscheduler_logs` VALUES("372", "37007", "action started via Async Request", "2024-12-28 08:41:16", "2024-12-28 08:41:16");
INSERT INTO `wptr_actionscheduler_logs` VALUES("373", "37008", "action created", "2024-12-28 08:41:16", "2024-12-28 08:41:16");
INSERT INTO `wptr_actionscheduler_logs` VALUES("374", "37007", "action complete via Async Request", "2024-12-28 08:41:16", "2024-12-28 08:41:16");
INSERT INTO `wptr_actionscheduler_logs` VALUES("375", "37008", "action started via Async Request", "2024-12-28 08:42:24", "2024-12-28 08:42:24");
INSERT INTO `wptr_actionscheduler_logs` VALUES("376", "37009", "action created", "2024-12-28 08:42:24", "2024-12-28 08:42:24");
INSERT INTO `wptr_actionscheduler_logs` VALUES("377", "37008", "action complete via Async Request", "2024-12-28 08:42:24", "2024-12-28 08:42:24");
INSERT INTO `wptr_actionscheduler_logs` VALUES("378", "37009", "action started via Async Request", "2024-12-28 08:44:25", "2024-12-28 08:44:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("379", "37010", "action created", "2024-12-28 08:44:25", "2024-12-28 08:44:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("380", "37009", "action complete via Async Request", "2024-12-28 08:44:25", "2024-12-28 08:44:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("381", "37010", "action started via Async Request", "2024-12-28 08:46:26", "2024-12-28 08:46:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("382", "37011", "action created", "2024-12-28 08:46:26", "2024-12-28 08:46:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("383", "37010", "action complete via Async Request", "2024-12-28 08:46:26", "2024-12-28 08:46:26");
INSERT INTO `wptr_actionscheduler_logs` VALUES("384", "37011", "action started via Async Request", "2024-12-28 08:48:12", "2024-12-28 08:48:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("385", "37012", "action created", "2024-12-28 08:48:12", "2024-12-28 08:48:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("386", "37011", "action complete via Async Request", "2024-12-28 08:48:12", "2024-12-28 08:48:12");
INSERT INTO `wptr_actionscheduler_logs` VALUES("387", "37013", "action created", "2024-12-28 08:48:55", "2024-12-28 08:48:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("388", "37014", "action created", "2024-12-28 08:48:55", "2024-12-28 08:48:55");
INSERT INTO `wptr_actionscheduler_logs` VALUES("389", "37013", "action started via Async Request", "2024-12-28 08:49:25", "2024-12-28 08:49:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("390", "37013", "action complete via Async Request", "2024-12-28 08:49:25", "2024-12-28 08:49:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("391", "37012", "action started via Async Request", "2024-12-28 08:49:25", "2024-12-28 08:49:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("392", "37015", "action created", "2024-12-28 08:49:25", "2024-12-28 08:49:25");
INSERT INTO `wptr_actionscheduler_logs` VALUES("393", "37012", "action complete via Async Request", "2024-12-28 08:49:25", "2024-12-28 08:49:25");

/* INSERT TABLE DATA: wptr_commentmeta */
INSERT INTO `wptr_commentmeta` VALUES("18", "6", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("19", "6", "_wpgdprc", "1591168835");
INSERT INTO `wptr_commentmeta` VALUES("20", "7", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("21", "7", "_wpgdprc", "1591168880");
INSERT INTO `wptr_commentmeta` VALUES("22", "8", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("23", "8", "_wpgdprc", "1591168916");
INSERT INTO `wptr_commentmeta` VALUES("24", "9", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("139", "47", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("140", "47", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("141", "47", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("142", "47", "_wpgdprc", "1662448595");
INSERT INTO `wptr_commentmeta` VALUES("143", "48", "rating", "5");
INSERT INTO `wptr_commentmeta` VALUES("144", "48", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("145", "48", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("146", "48", "_wpgdprc", "1662448822");
INSERT INTO `wptr_commentmeta` VALUES("147", "49", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("148", "49", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("149", "49", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("150", "49", "_wpgdprc", "1662448922");
INSERT INTO `wptr_commentmeta` VALUES("151", "50", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("152", "50", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("153", "50", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("154", "50", "_wpgdprc", "1662449005");
INSERT INTO `wptr_commentmeta` VALUES("155", "51", "rating", "5");
INSERT INTO `wptr_commentmeta` VALUES("156", "51", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("157", "51", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("158", "51", "_wpgdprc", "1662449421");
INSERT INTO `wptr_commentmeta` VALUES("159", "52", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("160", "52", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("161", "52", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("162", "52", "_wpgdprc", "1662449736");
INSERT INTO `wptr_commentmeta` VALUES("163", "53", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("164", "53", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("165", "53", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("166", "53", "_wpgdprc", "1662452846");
INSERT INTO `wptr_commentmeta` VALUES("167", "54", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("168", "54", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("169", "54", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("170", "54", "_wpgdprc", "1662452977");
INSERT INTO `wptr_commentmeta` VALUES("171", "55", "rating", "5");
INSERT INTO `wptr_commentmeta` VALUES("172", "55", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("173", "55", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("174", "55", "_wpgdprc", "1662453014");
INSERT INTO `wptr_commentmeta` VALUES("175", "56", "rating", "5");
INSERT INTO `wptr_commentmeta` VALUES("176", "56", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("177", "56", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("178", "56", "_wpgdprc", "1662453555");
INSERT INTO `wptr_commentmeta` VALUES("179", "57", "rating", "5");
INSERT INTO `wptr_commentmeta` VALUES("180", "57", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("181", "57", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("182", "57", "_wpgdprc", "1662453647");
INSERT INTO `wptr_commentmeta` VALUES("183", "58", "rating", "4");
INSERT INTO `wptr_commentmeta` VALUES("184", "58", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("185", "58", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("186", "58", "_wpgdprc", "1662453743");
INSERT INTO `wptr_commentmeta` VALUES("189", "59", "rating", "5");
INSERT INTO `wptr_commentmeta` VALUES("190", "59", "trx_addons_comment_likes_count", "0");
INSERT INTO `wptr_commentmeta` VALUES("191", "59", "verified", "0");
INSERT INTO `wptr_commentmeta` VALUES("192", "59", "_wpgdprc", "1662550912");

/* INSERT TABLE DATA: wptr_comments */
INSERT INTO `wptr_comments` VALUES("6", "426", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2020-06-03 07:20:34", "2020-06-03 07:20:34", "Sed eleifend ultricies risus, vel rutrum erat commodo ut. Praesent finibus congue euismod. Nullam scelerisque massa vel augue placerat, a tempor sem egestas. Curabitur placerat finibus lacus.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:76.0) Gecko/20100101 Firefox/76.0", "comment", "0", "1");
INSERT INTO `wptr_comments` VALUES("7", "426", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2020-06-03 07:21:19", "2020-06-03 07:21:19", "Praesent finibus congue euismod. Nullam scelerisque massa vel augue placerat, a tempor sem egestas. Curabitur placerat finibus lacus.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:76.0) Gecko/20100101 Firefox/76.0", "comment", "6", "1");
INSERT INTO `wptr_comments` VALUES("8", "426", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2020-06-03 07:21:55", "2020-06-03 07:21:55", "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:76.0) Gecko/20100101 Firefox/76.0", "comment", "0", "1");
INSERT INTO `wptr_comments` VALUES("9", "288", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2020-06-04 11:09:32", "2020-06-04 11:09:32", "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore tefe.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:76.0) Gecko/20100101 Firefox/76.0", "comment", "0", "1");
INSERT INTO `wptr_comments` VALUES("47", "19251", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 07:16:35", "2022-09-06 07:16:35", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("48", "19250", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 07:20:22", "2022-09-06 07:20:22", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("49", "19249", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 07:22:02", "2022-09-06 07:22:02", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("50", "19248", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 07:23:25", "2022-09-06 07:23:25", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("51", "19247", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 07:30:20", "2022-09-06 07:30:20", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("52", "19246", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 07:35:36", "2022-09-06 07:35:36", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("53", "19245", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 08:27:25", "2022-09-06 08:27:25", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("54", "19244", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 08:29:37", "2022-09-06 08:29:37", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("55", "19243", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 08:30:14", "2022-09-06 08:30:14", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("56", "19242", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 08:39:15", "2022-09-06 08:39:15", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("57", "19241", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 08:40:47", "2022-09-06 08:40:47", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("58", "19253", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-06 08:42:23", "2022-09-06 08:42:23", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");
INSERT INTO `wptr_comments` VALUES("59", "19252", "Ashton Porter", "ashton.porter@bigmir.net", "", "127.0.0.1", "2022-09-07 11:41:52", "2022-09-07 11:41:52", "Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0", "review", "0", "1");

/* INSERT TABLE DATA: wptr_duplicator_packages */
INSERT INTO `wptr_duplicator_packages` VALUES("1", "20241229_dashcloud", "486a5191c2c7529d6647_20241229101612", "21", "2024-12-29 10:16:50", "dashcloud_admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-29 10:16:12\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.18\";s:10:\"VersionPHP\";s:5:\"8.3.9\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:18:\"20241229_dashcloud\";s:4:\"Hash\";s:35:\"486a5191c2c7529d6647_20241229101612\";s:8:\"NameHash\";s:54:\"20241229_dashcloud_486a5191c2c7529d6647_20241229101612\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20241229_dashcloud_486a5191c2c7529d6647_20241229101612_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.5\";s:6:\"WPUser\";s:15:\"dashcloud_admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:66:\"20241229_dashcloud_486a5191c2c7529d6647_20241229101612_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/dashclou/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:4786;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:35122;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-29 10:16:12\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.18\";s:10:\"VersionPHP\";s:5:\"8.3.9\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20241229_dashcloud\";s:4:\"Hash\";s:35:\"486a5191c2c7529d6647_20241229101612\";s:8:\"NameHash\";s:54:\"20241229_dashcloud_486a5191c2c7529d6647_20241229101612\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:72:\"20241229_dashcloud_486a5191c2c7529d6647_20241229101612_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/dashclou/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:67:\"20241229_dashcloud_486a5191c2c7529d6647_20241229101612_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:126:\"/home/dashclou/public_html/wp-content/backups-dup-lite/tmp/20241229_dashcloud_486a5191c2c7529d6647_20241229101612_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/dashclou/public_html/wp-admin\";i:1;s:38:\"/home/dashclou/public_html/wp-includes\";i:2;s:47:\"/home/dashclou/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/dashclou/public_html\";i:1;s:26:\"/home/dashclou/public_html\";i:2;s:37:\"/home/dashclou/public_html/wp-content\";i:3;s:45:\"/home/dashclou/public_html/wp-content/uploads\";i:4;s:45:\"/home/dashclou/public_html/wp-content/plugins\";i:5;s:48:\"/home/dashclou/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/dashclou/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/dashclou/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wptr_e_notes */
INSERT INTO `wptr_e_notes` VALUES("1", "/?p=5002", "Home page", "5002", "5002", "1992493c", "0", "1", NULL, "publish", "{\"x\":18.872466216216218,\"y\":33.41041007975083}", "@emre burda eskisi gibi flipchartlari y&uuml;kleyebiliriz.", "0", "1", "2024-12-28 09:51:10", "2024-12-28 09:51:10", "2024-12-28 09:51:10");
INSERT INTO `wptr_e_notes` VALUES("2", "/?p=5002", "Home page", "5002", "5002", "1992493c", "0", "1", NULL, "publish", "{\"x\":18.872466216216218,\"y\":33.41041007975083}", "@emre burda eskisi gibi flipchartlari y&uuml;kleyebiliriz.", "0", "1", "2024-12-28 09:51:12", "2024-12-28 09:51:12", "2024-12-28 09:51:12");
INSERT INTO `wptr_e_notes` VALUES("3", "/?p=5002", "Home page", "5002", "5002", "1992493c", "0", "1", NULL, "publish", "{\"x\":18.872466216216218,\"y\":33.41041007975083}", "@emre burda eskisi gibi flipchartlari y&uuml;kleyebiliriz.", "0", "1", "2024-12-28 09:51:16", "2024-12-28 09:51:16", "2024-12-28 09:51:16");
INSERT INTO `wptr_e_notes` VALUES("4", "/?p=5002", "Home page", "5002", "5002", "1992493c", "0", "1", NULL, "publish", "{\"x\":18.872466216216218,\"y\":33.41041007975083}", "@emre burda eskisi gibi flipchartlari y&uuml;kleyebiliriz.", "0", "1", "2024-12-28 09:51:18", "2024-12-28 09:51:18", "2024-12-28 09:51:18");
INSERT INTO `wptr_e_notes` VALUES("5", "/?p=5002", "Home page", "5002", "5002", "1992493c", "0", "1", NULL, "publish", "{\"x\":18.872466216216218,\"y\":33.41041007975083}", "@emre burda eskisi gibi flipchartlari y&uuml;kleyebiliriz.", "0", "1", "2024-12-28 09:51:20", "2024-12-28 09:51:20", "2024-12-28 09:51:20");
INSERT INTO `wptr_e_notes` VALUES("6", "/?p=5002", "Home page", "5002", "5002", "1992493c", "0", "1", NULL, "publish", "{\"x\":18.872466216216218,\"y\":33.41041007975083}", "@emre burda eskisi gibi flipchartlari y&uuml;kleyebiliriz.", "0", "1", "2024-12-28 09:51:23", "2024-12-28 09:51:23", "2024-12-28 09:51:23");

/* INSERT TABLE DATA: wptr_e_notes_users_relations */
INSERT INTO `wptr_e_notes_users_relations` VALUES("1", "mention", "1", "2", "2024-12-28 09:51:10", "2024-12-28 09:51:10");
INSERT INTO `wptr_e_notes_users_relations` VALUES("2", "read", "1", "1", "2024-12-28 09:51:10", "2024-12-28 09:51:10");
INSERT INTO `wptr_e_notes_users_relations` VALUES("3", "mention", "2", "2", "2024-12-28 09:51:12", "2024-12-28 09:51:12");
INSERT INTO `wptr_e_notes_users_relations` VALUES("4", "read", "2", "1", "2024-12-28 09:51:12", "2024-12-28 09:51:12");
INSERT INTO `wptr_e_notes_users_relations` VALUES("5", "mention", "3", "2", "2024-12-28 09:51:16", "2024-12-28 09:51:16");
INSERT INTO `wptr_e_notes_users_relations` VALUES("6", "read", "3", "1", "2024-12-28 09:51:16", "2024-12-28 09:51:16");
INSERT INTO `wptr_e_notes_users_relations` VALUES("7", "mention", "4", "2", "2024-12-28 09:51:18", "2024-12-28 09:51:18");
INSERT INTO `wptr_e_notes_users_relations` VALUES("8", "read", "4", "1", "2024-12-28 09:51:18", "2024-12-28 09:51:18");
INSERT INTO `wptr_e_notes_users_relations` VALUES("9", "mention", "5", "2", "2024-12-28 09:51:20", "2024-12-28 09:51:20");
INSERT INTO `wptr_e_notes_users_relations` VALUES("10", "read", "5", "1", "2024-12-28 09:51:20", "2024-12-28 09:51:20");
INSERT INTO `wptr_e_notes_users_relations` VALUES("11", "mention", "6", "2", "2024-12-28 09:51:23", "2024-12-28 09:51:23");
INSERT INTO `wptr_e_notes_users_relations` VALUES("12", "read", "6", "1", "2024-12-28 09:51:23", "2024-12-28 09:51:23");

/* INSERT TABLE DATA: wptr_latepoint_agents */
INSERT INTO `wptr_latepoint_agents` VALUES("1", "3240", "2407", "Michael", "Green", "Michael", "Michael Green", "Dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia.", "[{\"value\":\"9\",\"label\":\"Experience Years\"},{\"value\":\"1,400+\",\"label\":\"Served Customers\"},{\"value\":\"5\",\"label\":\"Certifications\"}]", "info@test.com", "+1 840 841 25 69", "$P$B9PtGmaXLrEv0TPNRz8BU8LaYwnOoj/", NULL, "0", "active", "info@test.com", "+1 840 841 25 69", "2020-07-21 09:54:36", "2020-07-22 06:48:27");
INSERT INTO `wptr_latepoint_agents` VALUES("13", "1144", "4604", "Ashton", "Porter", "Ashton", "Ashton Porter", "Dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia.", "[{\"value\":\"8\",\"label\":\"Experience Years\"},{\"value\":\"1,200+\",\"label\":\"Served Customers\"},{\"value\":\"7\",\"label\":\"Certifications\"}]", "info@test.com", "+1 840 841 25 69", "$P$BUIiwS0/tVEO.qfqL51qISYC.TKFyh/", NULL, "0", "active", "", "", "2020-07-22 06:11:48", "2020-07-22 06:50:15");

/* INSERT TABLE DATA: wptr_latepoint_agents_services */
INSERT INTO `wptr_latepoint_agents_services` VALUES("2", "1", "2", "1", "0", "0", "0", "2020-07-22 06:08:37", "2020-07-22 06:08:37");
INSERT INTO `wptr_latepoint_agents_services` VALUES("4", "13", "2", "1", "0", "0", "0", "2020-07-22 06:11:48", "2020-07-22 06:11:48");
INSERT INTO `wptr_latepoint_agents_services` VALUES("5", "1", "3", "1", "0", "0", "0", "2020-07-22 06:14:47", "2020-07-22 06:14:47");
INSERT INTO `wptr_latepoint_agents_services` VALUES("6", "13", "3", "1", "0", "0", "0", "2020-07-22 06:14:47", "2020-07-22 06:14:47");
INSERT INTO `wptr_latepoint_agents_services` VALUES("7", "1", "4", "1", "0", "0", "0", "2020-07-22 06:16:55", "2020-07-22 06:16:55");
INSERT INTO `wptr_latepoint_agents_services` VALUES("8", "13", "4", "1", "0", "0", "0", "2020-07-22 06:16:55", "2020-07-22 06:16:55");
INSERT INTO `wptr_latepoint_agents_services` VALUES("9", "1", "1", "1", "0", "0", "0", "2020-07-22 07:51:11", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_agents_services` VALUES("10", "13", "1", "1", "0", "0", "0", "2020-07-22 07:51:11", "2020-07-22 07:51:11");

/* INSERT TABLE DATA: wptr_latepoint_customer_meta */
INSERT INTO `wptr_latepoint_customer_meta` VALUES("1", "1", "timezone_name", "+00:00", "2020-10-08 11:40:34", "2020-10-08 11:40:34");

/* INSERT TABLE DATA: wptr_latepoint_customers */
INSERT INTO `wptr_latepoint_customers` VALUES("1", "gg", "fff", "dfgfg@sdfs.fgh", "6545756854", NULL, "pending_verification", "$2y$10$k1K0wzNEhM891YznindI4e56I3c.4RI9OuToA3zf9.BwLS0HGgoXK", "1ab784472dcb5ec39518b046568f2675521dde88", "a737fb4d72b474f55189233bb417d087fbc5ca98", NULL, NULL, NULL, "0", "ghfnhnh", "", "2020-10-08 11:40:34", "2020-10-08 12:06:24");

/* INSERT TABLE DATA: wptr_latepoint_locations */
INSERT INTO `wptr_latepoint_locations` VALUES("1", "Main Location", NULL, "active", NULL, NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");

/* INSERT TABLE DATA: wptr_latepoint_processes */
INSERT INTO `wptr_latepoint_processes` VALUES("1", "New Booking Notification", "booking_created", "[{\"type\":\"group\",\"trigger_condition\":false,\"items\":[{\"type\":\"action\",\"id\":\"pa_nX5no3\",\"settings\":{\"status\":\"active\",\"type\":\"send_email\",\"settings\":{\"to_email\":\"{{agent_full_name}} <{{agent_email}}>\",\"subject\":\"New Appointment Received\",\"content\":\"<div style=\\\"padding: 20px; background-color: #f0f0f0; font-family: -apple-system, system-ui, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\\"Helvetica Neue\\\", Arial, sans-serif;\\\">\\n\\t<div style=\\\"background-color: #fff; padding: 30px; margin: 0px auto; max-width: 450px; box-shadow: 0px 2px 6px -1px rgba(0,0,0,0.2); border-radius: 6px;\\\">\\n\\t\\t<div style=\\\"margin: 0px auto 30px auto; border-bottom: 1px solid #eee; padding-bottom: 20px;\\\">\\n\\t\\t\\t<table style=\\\"width: 100%;\\\">\\n\\t\\t\\t\\t<tr>\\n\\t\\t\\t\\t\\t<td>{{business_logo_image}}<\\/td>\\n\\t\\t\\t\\t\\t<td style=\\\"text-align: right;\\\"><span style=\\\"color: #7b7b7b;\\\">Questions?<\\/span><br\\/><strong>{{business_phone}}<\\/strong><\\/td>\\n\\t\\t\\t\\t<\\/tr>\\n\\t\\t\\t<\\/table>\\n\\t\\t<\\/div>\\n\\t\\t<div style=\\\"font-size: 16px; line-height: 1.5;\\\">\\n\\t\\t\\t<div style=\\\"font-size: 16px; margin-bottom: 20px; line-height: 1.6;\\\">\\n\\tHi {{agent_full_name}},\\n\\t<br\\/><br\\/>\\n\\tYou have received a new appointment request from {{customer_full_name}}\\n<\\/div>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Customer Information<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Full Name:<\\/span> <strong>{{customer_full_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Email Address:<\\/span> <strong>{{customer_email}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Phone:<\\/span> <strong>{{customer_phone}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Comments:<\\/span> <strong>{{customer_notes}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Appointment Information<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Service:<\\/span> <strong>{{service_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Date, Time:<\\/span> <strong>{{start_date}}, {{start_time}} - {{end_time}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Order Summary<\\/h4>\\n<div style=\\\"margin-bottom: 20px;\\\">{{order_summary_breakdown}}<\\/div>\\n<div style=\\\"margin-top: 25px;\\\">\\n\\t<a href=\\\"{{manage_booking_url_agent}}\\\" style=\\\"display: block; text-decoration: none; padding: 10px; border-radius: 6px; text-align: center; font-size: 18px; color: #fff; background-color: #1e7bff; font-weight: 700;\\\">Manage This Appointment<\\/a>\\n<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t<div style=\\\"max-width: 450px; margin: 10px auto; text-align: center;\\\">{{business_address}}<\\/div>\\n<\\/div>\"}}},{\"type\":\"action\",\"id\":\"pa_rRSp5K\",\"settings\":{\"status\":\"active\",\"type\":\"send_email\",\"settings\":{\"to_email\":\"{{customer_full_name}} <{{customer_email}}>\",\"subject\":\"Appointment Confirmation\",\"content\":\"<div style=\\\"padding: 20px; background-color: #f0f0f0; font-family: -apple-system, system-ui, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\\"Helvetica Neue\\\", Arial, sans-serif;\\\">\\n\\t<div style=\\\"background-color: #fff; padding: 30px; margin: 0px auto; max-width: 450px; box-shadow: 0px 2px 6px -1px rgba(0,0,0,0.2); border-radius: 6px;\\\">\\n\\t\\t<div style=\\\"margin: 0px auto 30px auto; border-bottom: 1px solid #eee; padding-bottom: 20px;\\\">\\n\\t\\t\\t<table style=\\\"width: 100%;\\\">\\n\\t\\t\\t\\t<tr>\\n\\t\\t\\t\\t\\t<td>{{business_logo_image}}<\\/td>\\n\\t\\t\\t\\t\\t<td style=\\\"text-align: right;\\\"><span style=\\\"color: #7b7b7b;\\\">Questions?<\\/span><br\\/><strong>{{business_phone}}<\\/strong><\\/td>\\n\\t\\t\\t\\t<\\/tr>\\n\\t\\t\\t<\\/table>\\n\\t\\t<\\/div>\\n\\t\\t<div style=\\\"font-size: 16px; line-height: 1.5;\\\">\\n\\t\\t\\t<div style=\\\"font-size: 16px; margin-bottom: 20px; line-height: 1.6;\\\">\\n\\tHi {{customer_full_name}},\\n\\t<br>\\n\\t<br>\\n\\tYour {{service_name}} appointment with <strong>{{agent_full_name}}<\\/strong> is <strong>{{booking_status}}<\\/strong>.\\n<\\/div>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Appointment Details:<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Agent:<\\/span> <strong>{{agent_full_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Service:<\\/span> <strong>{{service_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Date, Time:<\\/span> <strong>{{start_date}}, {{start_time}} - {{end_time}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Order Summary<\\/h4>\\n<div style=\\\"margin-bottom: 20px;\\\">{{order_summary_breakdown}}<\\/div>\\n<div style=\\\"margin-top: 25px;\\\">\\n\\t<a href=\\\"{{manage_booking_url_customer}}\\\" style=\\\"display: block; text-decoration: none; padding: 10px; border-radius: 6px; text-align: center; font-size: 18px; color: #fff; background-color: #1e7bff; font-weight: 700;\\\">Manage This Appointment<\\/a>\\n<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t<div style=\\\"max-width: 450px; margin: 10px auto; text-align: center;\\\">{{business_address}}<\\/div>\\n<\\/div>\"}}}],\"time_offset\":[]}]", "active", "2024-12-26 12:29:17", "2024-12-26 12:29:17");

/* INSERT TABLE DATA: wptr_latepoint_service_categories */
INSERT INTO `wptr_latepoint_service_categories` VALUES("1", "Massage and Recovery", "Adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.", NULL, "3795", "3", NULL, NULL);
INSERT INTO `wptr_latepoint_service_categories` VALUES("2", "Development", "Ut enim ad minim veniam, quis nostrud exercitation ullamco.", NULL, "1856", "2", NULL, NULL);
INSERT INTO `wptr_latepoint_service_categories` VALUES("3", "Art & Design", "Consectetur adipiscing elit, sed do eiusm od tempor incididunt ut labore. ", NULL, "3513", "1", NULL, NULL);

/* INSERT TABLE DATA: wptr_latepoint_service_meta */
INSERT INTO `wptr_latepoint_service_meta` VALUES("1", "1", "durations", "[]", "2020-07-21 10:59:23", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_service_meta` VALUES("2", "2", "durations", "[]", "2020-07-22 06:08:37", "2020-07-22 06:08:37");
INSERT INTO `wptr_latepoint_service_meta` VALUES("3", "3", "durations", "[]", "2020-07-22 06:14:47", "2020-07-22 06:14:47");
INSERT INTO `wptr_latepoint_service_meta` VALUES("4", "4", "durations", "[]", "2020-07-22 06:16:55", "2020-07-22 06:16:55");

/* INSERT TABLE DATA: wptr_latepoint_services */
INSERT INTO `wptr_latepoint_services` VALUES("1", "Branding", "Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", NULL, "10.0000", "60.0000", "50.0000", "30.0000", NULL, "", NULL, "60", "30", "15", "3", "1", "6405", "0", "#2752E4", "5", "1", "1", "active", "visible", "2020-07-21 10:59:23", "2023-04-12 14:08:26");
INSERT INTO `wptr_latepoint_services` VALUES("2", "Multiple Options", "", NULL, "15.0000", "0.0000", "30.0000", "20.0000", NULL, "", NULL, "45", "15", "30", "2", "1", "1853", "0", "#C066F1", "5", "1", "1", "active", "visible", "2020-07-22 06:08:37", "2020-07-22 07:55:28");
INSERT INTO `wptr_latepoint_services` VALUES("3", "Modern Interface", "", NULL, "10.0000", "15.0000", "40.0000", "30.0000", NULL, "", NULL, "60", "30", "30", "3", "2", "4644", "0", "#26B7DD", "10", "1", "1", "active", "visible", "2020-07-22 06:14:47", "2020-07-22 07:55:28");
INSERT INTO `wptr_latepoint_services` VALUES("4", "App Development", "", NULL, "3.0000", "6.0000", "20.0000", "5.0000", NULL, "", NULL, "60", "10", "50", "2", "2", "133", "0", "#E8C634", "20", "1", "1", "active", "visible", "2020-07-22 06:16:55", "2020-07-22 07:55:29");

/* INSERT TABLE DATA: wptr_latepoint_settings */
INSERT INTO `wptr_latepoint_settings` VALUES("1", "steps_show_service_categories", "on", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("2", "steps_show_agent_bio", "on", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("3", "steps_require_setting_password", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("4", "steps_hide_registration_prompt", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("5", "steps_hide_login_register_tabs", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("6", "steps_hide_agent_info", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("7", "manual_next_step", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("8", "steps_skip_verify_step", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("9", "steps_always_show_agent_step", "off", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("10", "allow_any_agent", "on", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("11", "any_agent_order", "random", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("12", "steps_support_text", "<h5>Questions?</h5>\nCall (858) 939-3746 for help", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("13", "confirmation_step_tracking_code", "", "2020-07-21 11:01:51", "2020-07-22 06:47:44");
INSERT INTO `wptr_latepoint_settings` VALUES("14", "default_booking_status", "approved", "2020-07-22 06:34:43", "2020-07-22 08:21:45");
INSERT INTO `wptr_latepoint_settings` VALUES("15", "time_system", "12", "2020-07-22 06:34:43", "2020-07-22 08:21:45");
INSERT INTO `wptr_latepoint_settings` VALUES("16", "date_format", "m/d/Y", "2020-07-22 06:34:43", "2020-07-22 08:21:45");
INSERT INTO `wptr_latepoint_settings` VALUES("17", "timeblock_interval", "15", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("18", "show_booking_end_time", "off", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("19", "disable_verbose_date_output", "off", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("20", "earliest_possible_booking", "", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("21", "latest_possible_booking", "", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("22", "max_future_bookings_per_customer", "", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("23", "one_location_at_time", "off", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("24", "currency_symbol_before", "$", "2020-07-22 06:34:43", "2020-07-22 08:21:46");
INSERT INTO `wptr_latepoint_settings` VALUES("25", "currency_symbol_after", "", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("26", "phone_format", "(999) 999-9999", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("27", "disable_phone_formatting", "off", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("28", "country_phone_code", "+1", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("29", "color_scheme_for_booking_form", "black", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("30", "border_radius", "flat", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("31", "enable_google_login", "off", "2020-07-22 06:34:43", "2020-07-22 08:21:47");
INSERT INTO `wptr_latepoint_settings` VALUES("32", "google_client_id", "", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("33", "google_client_secret", "YA0evA25mqKF5/AKZMTcJg==", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("34", "enable_facebook_login", "off", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("35", "facebook_app_id", "", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("36", "facebook_app_secret", "YA0evA25mqKF5/AKZMTcJg==", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("37", "page_url_customer_dashboard", "/customer-dashboard", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("38", "page_url_customer_login", "/customer-login", "2020-07-22 06:34:43", "2020-07-22 08:21:48");
INSERT INTO `wptr_latepoint_settings` VALUES("39", "day_calendar_min_height", "700", "2020-07-22 06:34:43", "2020-07-22 08:21:49");
INSERT INTO `wptr_latepoint_settings` VALUES("40", "customer_dashboard_book_shortcode", "[latepoint_book_button]", "2020-07-22 06:34:43", "2020-07-22 08:21:49");
INSERT INTO `wptr_latepoint_settings` VALUES("41", "step_codes_in_order", "booking__services,booking__agents,booking__datepicker,customer,verify,payment__times,payment__portions,payment__methods,payment__processors,payment__pay,confirmation", "2024-12-26 12:47:02", "2024-12-26 12:47:02");
INSERT INTO `wptr_latepoint_settings` VALUES("42", "steps_settings", "a:12:{s:6:\"shared\";a:1:{s:18:\"steps_support_text\";s:54:\"<h5>Questions?</h5><p>Call (858) 939-3746 for help</p>\";}s:17:\"booking__services\";a:3:{s:18:\"side_panel_heading\";s:17:\"Service Selection\";s:22:\"side_panel_description\";s:69:\"Please select a service for which you want to schedule an appointment\";s:18:\"main_panel_heading\";s:18:\"Available Services\";}s:15:\"booking__agents\";a:3:{s:18:\"side_panel_heading\";s:15:\"Agent Selection\";s:22:\"side_panel_description\";s:59:\"Please select an agent that will be providing you a service\";s:18:\"main_panel_heading\";s:16:\"Available Agents\";}s:19:\"booking__datepicker\";a:3:{s:18:\"side_panel_heading\";s:18:\"Select Date & Time\";s:22:\"side_panel_description\";s:48:\"Please select date and time for your appointment\";s:18:\"main_panel_heading\";s:21:\"Date & Time Selection\";}s:8:\"customer\";a:3:{s:18:\"side_panel_heading\";s:22:\"Enter Your Information\";s:22:\"side_panel_description\";s:37:\"Please enter your contact information\";s:18:\"main_panel_heading\";s:20:\"Customer Information\";}s:6:\"verify\";a:3:{s:18:\"side_panel_heading\";s:20:\"Verify Order Details\";s:22:\"side_panel_description\";s:86:\"Double check your reservation details and click submit button if everything is correct\";s:18:\"main_panel_heading\";s:20:\"Verify Order Details\";}s:14:\"payment__times\";a:3:{s:18:\"side_panel_heading\";s:22:\"Payment Time Selection\";s:22:\"side_panel_description\";s:61:\"Please choose when you would like to pay for your appointment\";s:18:\"main_panel_heading\";s:27:\"When would you like to pay?\";}s:17:\"payment__portions\";a:3:{s:18:\"side_panel_heading\";s:25:\"Payment Portion Selection\";s:22:\"side_panel_description\";s:48:\"Please select how much you would like to pay now\";s:18:\"main_panel_heading\";s:35:\"How much would you like to pay now?\";}s:16:\"payment__methods\";a:3:{s:18:\"side_panel_heading\";s:24:\"Payment Method Selection\";s:22:\"side_panel_description\";s:68:\"Please select a payment method you would like to make a payment with\";s:18:\"main_panel_heading\";s:21:\"Select payment method\";}s:19:\"payment__processors\";a:3:{s:18:\"side_panel_heading\";s:27:\"Payment Processor Selection\";s:22:\"side_panel_description\";s:70:\"Please select a payment processor you want to process the payment with\";s:18:\"main_panel_heading\";s:24:\"Select payment processor\";}s:12:\"payment__pay\";a:3:{s:18:\"side_panel_heading\";s:14:\"Make a Payment\";s:22:\"side_panel_description\";s:67:\"Please enter your payment information so we can process the payment\";s:18:\"main_panel_heading\";s:30:\"Enter your payment information\";}s:12:\"confirmation\";a:3:{s:18:\"side_panel_heading\";s:12:\"Confirmation\";s:22:\"side_panel_description\";s:76:\"Your order has been placed. Please retain this confirmation for your record.\";s:18:\"main_panel_heading\";s:18:\"Order Confirmation\";}}", "2024-12-26 12:47:02", "2024-12-26 12:47:02");

/* INSERT TABLE DATA: wptr_latepoint_work_periods */
INSERT INTO `wptr_latepoint_work_periods` VALUES("1", "0", "0", "0", "480", "1020", "1", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("2", "0", "0", "0", "480", "1020", "2", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("3", "0", "0", "0", "480", "1020", "3", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("4", "0", "0", "0", "480", "1020", "4", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("5", "0", "0", "0", "480", "1020", "5", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("6", "0", "0", "0", "480", "1020", "6", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("7", "0", "0", "0", "480", "1020", "7", NULL, NULL, "2020-07-21 10:02:48", "2020-07-21 10:02:48");
INSERT INTO `wptr_latepoint_work_periods` VALUES("8", "0", "1", "0", "480", "1020", "1", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_work_periods` VALUES("9", "0", "1", "0", "480", "1020", "2", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_work_periods` VALUES("10", "0", "1", "0", "480", "1020", "3", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_work_periods` VALUES("11", "0", "1", "0", "480", "1020", "4", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_work_periods` VALUES("12", "0", "1", "0", "480", "1020", "5", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_work_periods` VALUES("13", "0", "1", "0", "480", "1020", "6", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");
INSERT INTO `wptr_latepoint_work_periods` VALUES("14", "0", "1", "0", "0", "0", "7", NULL, NULL, "2020-07-22 06:32:19", "2020-07-22 07:51:11");

/* INSERT TABLE DATA: wptr_mwai_logs */
INSERT INTO `wptr_mwai_logs` VALUES("1", "1", "88.130.144.34", "676d7cb08b5bb", "o1-mini", "completion", "4141", "tokens", "0.033537", "advisor", "b17eihml", "2024-12-26 16:56:17");

/* INSERT TABLE DATA: wptr_options */
INSERT INTO `wptr_options` VALUES("1", "cron", "a:38:{i:1735217025;a:1:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735217075;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1735220615;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1735221202;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"0130b445f2a3da777482c02317e1901a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:81;}}}}i:1735221424;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"6392c3b0cd930fb020f301c8a7fc1e72\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:82;}}}}i:1735227815;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735235632;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c798afee6284d26afc3e1594986910ed\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:37020;}}}}i:1735238615;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735240181;a:1:{s:18:\"rocket_atf_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735240221;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1735240241;a:2:{s:30:\"rocket_preload_process_pending\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:30:\"rocket_preload_process_pending\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:37:\"rocket_preload_revert_old_failed_rows\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:29:\"rocket_revert_old_failed_rows\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735240412;a:2:{s:26:\"booked_send_user_reminders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"booked_everyfive\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:27:\"booked_send_admin_reminders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"booked_everyfive\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1735240456;a:1:{s:23:\"mwai_tasks_internal_run\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:8:\"mwai_5mn\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1735240781;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735241356;a:1:{s:18:\"mwai_files_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735241367;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735241377;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735242913;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735243781;a:1:{s:23:\"rocket_purge_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:34:\"rocket_expired_cache_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735250185;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735255512;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735257312;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735257600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735275960;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735293313;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735293385;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735293386;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735302556;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735302561;a:2:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"tribe_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735302562;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735302567;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735303425;a:1:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735567200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735605183;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735706138;a:1:{s:23:\"sbi_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735811723;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1736361380;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wptr_options` VALUES("2", "siteurl", "https://dashcloud.com.tr", "on");
INSERT INTO `wptr_options` VALUES("3", "home", "https://dashcloud.com.tr", "on");
INSERT INTO `wptr_options` VALUES("4", "blogname", "DASHCLOUD", "on");
INSERT INTO `wptr_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wptr_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wptr_options` VALUES("7", "admin_email", "admin@dashcloud.com.tr", "on");
INSERT INTO `wptr_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wptr_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wptr_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wptr_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wptr_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wptr_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wptr_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wptr_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wptr_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wptr_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wptr_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wptr_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wptr_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wptr_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wptr_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wptr_options` VALUES("23", "posts_per_page", "12", "on");
INSERT INTO `wptr_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wptr_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wptr_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wptr_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wptr_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wptr_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wptr_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wptr_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wptr_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wptr_options` VALUES("34", "active_plugins", "a:15:{i:0;s:35:\"advanced-popups/advanced-popups.php\";i:1;s:31:\"ai-engine-pro/ai-engine-pro.php\";i:2;s:15:\"clsop/clsop.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:43:\"devvn-image-hotspot/devvn-image-hotspot.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:31:\"elementor-pro/elementor-pro.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:37:\"elementskit-lite/elementskit-lite.php\";i:9;s:27:\"elementskit/elementskit.php\";i:10;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:11;s:23:\"revslider/revslider.php\";i:12;s:25:\"trx_addons/trx_addons.php\";i:13;s:27:\"trx_updater/trx_updater.php\";i:14;s:39:\"wp-file-manager/file_folder_manager.php\";}", "on");
INSERT INTO `wptr_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wptr_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wptr_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wptr_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wptr_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wptr_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wptr_options` VALUES("41", "template", "qwery", "on");
INSERT INTO `wptr_options` VALUES("42", "stylesheet", "qwery-child", "on");
INSERT INTO `wptr_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wptr_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wptr_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wptr_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wptr_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wptr_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wptr_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wptr_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `wptr_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wptr_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wptr_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wptr_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wptr_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wptr_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wptr_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wptr_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wptr_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wptr_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wptr_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wptr_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wptr_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wptr_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wptr_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wptr_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wptr_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wptr_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wptr_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wptr_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wptr_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wptr_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wptr_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wptr_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wptr_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wptr_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wptr_options` VALUES("77", "widget_categories", "a:2:{i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wptr_options` VALUES("78", "widget_text", "a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:12:\"Get in Touch\";s:4:\"text\";s:57:\"[contact-form-7 id=\"6501\" title=\"Contact Form (Style 8)\"]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wptr_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wptr_options` VALUES("80", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:33:\"instagram-feed/instagram-feed.php\";s:22:\"sb_instagram_uninstall\";}", "off");
INSERT INTO `wptr_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wptr_options` VALUES("82", "page_for_posts", "372", "on");
INSERT INTO `wptr_options` VALUES("83", "page_on_front", "5002", "on");
INSERT INTO `wptr_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wptr_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wptr_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wptr_options` VALUES("87", "site_icon", "12776", "on");
INSERT INTO `wptr_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wptr_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wptr_options` VALUES("90", "wp_page_for_privacy_policy", "0", "on");
INSERT INTO `wptr_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wptr_options` VALUES("92", "admin_email_lifespan", "1750758912", "on");
INSERT INTO `wptr_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wptr_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wptr_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wptr_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wptr_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wptr_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wptr_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wptr_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wptr_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wptr_options` VALUES("102", "wptr_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:145:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:29:\"manage_instagram_feed_options\";b:1;s:24:\"edit_booked_appointments\";b:1;s:21:\"manage_booked_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:25:\"rocket_image_optimization\";b:1;s:24:\"rocket_remove_unused_css\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:15:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:15:\"latepoint_agent\";a:2:{s:4:\"name\";s:15:\"LatePoint Agent\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:13:\"edit_bookings\";b:1;}}s:20:\"booked_booking_agent\";a:2:{s:4:\"name\";s:13:\"Booking Agent\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:24:\"edit_booked_appointments\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "on");
INSERT INTO `wptr_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wptr_options` VALUES("104", "user_count", "2", "off");
INSERT INTO `wptr_options` VALUES("105", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("312", "widget_booked_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("313", "widget_instagram-feed-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("314", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("106", "sidebars_widgets", "a:19:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:12:\"categories-3\";}s:15:\"sidebar_widgets\";a:3:{i:0;s:8:\"search-2\";i:1;s:32:\"trx_addons_widget_recent_posts-2\";i:2;s:26:\"trx_addons_widget_banner-2\";}s:14:\"header_widgets\";a:0:{}s:18:\"above_page_widgets\";a:0:{}s:21:\"above_content_widgets\";a:0:{}s:21:\"below_content_widgets\";a:0:{}s:18:\"below_page_widgets\";a:0:{}s:14:\"footer_widgets\";a:0:{}s:19:\"woocommerce_widgets\";a:5:{i:0;s:25:\"woocommerce_widget_cart-2\";i:1;s:28:\"woocommerce_product_search-2\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:26:\"woocommerce_price_filter-2\";i:4;s:31:\"woocommerce_product_tag_cloud-2\";}s:20:\"tribe_events_widgets\";a:0:{}s:27:\"front_page_features_widgets\";a:0:{}s:23:\"front_page_team_widgets\";a:0:{}s:31:\"front_page_testimonials_widgets\";a:0:{}s:23:\"front_page_blog_widgets\";a:0:{}s:28:\"front_page_googlemap_widgets\";a:0:{}s:16:\"custom_widgets_1\";a:1:{i:0;s:13:\"custom_html-2\";}s:16:\"custom_widgets_2\";a:2:{i:0;s:6:\"text-2\";i:1;s:28:\"trx_addons_widget_contacts-2\";}s:28:\"trx_addons_woocommerce_tools\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wptr_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("115", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:6:\"Search\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("120", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:366:\"<div class=\"extra_item\">\n<h6>Have a Project?</h6>\n<a href=\"mailto:info@website.com\">info@website.com</a>\n</div>\n\n<div class=\"extra_item\">\n<h6>Want to Work with Me?</h6>\n<a href=\"https://dashcloud.com.tr/about-personal/\">Send Brief</a>\n</div>\n\n<div class=\"extra_item\">\n<h6>Want to Buy Illustrations?</h6>\n<a href=\"https://dashcloud.com.tr/shop/\">Go to Shop</a>\n</div>\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wptr_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wptr_options` VALUES("179", "qwery_action", "", "auto");
INSERT INTO `wptr_options` VALUES("180", "qwery_about_page", "0", "auto");
INSERT INTO `wptr_options` VALUES("181", "qwery_theme_version", "3.4.1", "auto");
INSERT INTO `wptr_options` VALUES("258", "auto_update_plugins", "a:25:{i:0;s:35:\"advanced-popups/advanced-popups.php\";i:1;s:23:\"ai-engine/ai-engine.php\";i:2;s:19:\"akismet/akismet.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:31:\"elementor-pro/elementor-pro.php\";i:6;s:27:\"elementskit/elementskit.php\";i:7;s:9:\"hello.php\";i:8;s:43:\"devvn-image-hotspot/devvn-image-hotspot.php\";i:9;s:23:\"latepoint/latepoint.php\";i:10;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:11;s:21:\"quickcal/quickcal.php\";i:12;s:23:\"revslider/revslider.php\";i:13;s:33:\"instagram-feed/instagram-feed.php\";i:14;s:43:\"the-events-calendar/the-events-calendar.php\";i:15;s:25:\"trx_addons/trx_addons.php\";i:16;s:27:\"trx_updater/trx_updater.php\";i:17;s:20:\"twenty20/ttwenty.php\";i:18;s:15:\"clsop/clsop.php\";i:19;s:31:\"ai-engine-pro/ai-engine-pro.php\";i:20;s:37:\"elementskit-lite/elementskit-lite.php\";i:21;s:51:\"ti-woocommerce-wishlist/ti-woocommerce-wishlist.php\";i:22;s:27:\"woocommerce/woocommerce.php\";i:23;s:45:\"woo-smart-quick-view/wpc-smart-quick-view.php\";i:24;s:39:\"wp-file-manager/file_folder_manager.php\";}", "off");
INSERT INTO `wptr_options` VALUES("184", "trx_addons_just_activated", "no", "auto");
INSERT INTO `wptr_options` VALUES("185", "trx_addons_action", "", "auto");
INSERT INTO `wptr_options` VALUES("191", "trx_addons_db_update_state", "a:6:{s:32:\"elm_convert_params_with_term_ids\";i:0;s:8:\"_expired\";i:1735218144;s:28:\"elm_add_spacer_default_value\";i:0;s:27:\"elm_convert_params_parallax\";i:0;s:34:\"cpt_layouts_submenu_convert_params\";i:0;s:36:\"cpt_layouts_submenu_convert_params_2\";i:0;}", "auto");
INSERT INTO `wptr_options` VALUES("125", "nonce_key", "Bj:~~*6$[;;67|RtAK].hqzE7`lBt2=S~k2bTMD,C|BUY^j[vNU -fq!H2pai!Ca", "off");
INSERT INTO `wptr_options` VALUES("126", "nonce_salt", "9gr~Gc5m@cs=t9$[_w5Q_>El>b|GdeSHQ2q:yRUM>pf[ab6o0/Ph=xr{#_^-;U~&", "off");
INSERT INTO `wptr_options` VALUES("127", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1735207745;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wptr_options` VALUES("128", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"617691ea7f8bd7eb8fb96a2379647f58\";s:6:\"blocks\";a:7:{s:11:\"core/button\";s:354:\":root :where(.wp-block-button .wp-block-button__link){background-color: var(--theme-color-text_link);border-radius: 0;color: var(--theme-color-inverse_link);font-family: var(--theme-font-button_font-family);font-size: var(--theme-font-button_font-size);font-weight: var(--theme-font-button_font-weight);line-height: var(--theme-font-button_line-height);}\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:141:\":root :where(.wp-block-pullquote){border-width: 1px 0;font-size: clamp(0.984em, 0.984rem + ((1vw - 0.2em) * 0.878), 1.5em);line-height: 1.6;}\";s:18:\"core/post-comments\";s:86:\":root :where(.wp-block-post-comments){padding-top: var(--wp--custom--spacing--small);}\";s:10:\"core/quote\";s:49:\":root :where(.wp-block-quote){border-width: 1px;}\";}}", "on");
INSERT INTO `wptr_options` VALUES("1663", "_site_transient_timeout_wp_plugin_dependencies_plugin_timeout_woocommerce", "1735510438", "off");
INSERT INTO `wptr_options` VALUES("1664", "_site_transient_wp_plugin_dependencies_plugin_timeout_woocommerce", "1", "off");
INSERT INTO `wptr_options` VALUES("242", "_site_transient_wp_plugin_dependencies_plugin_data", "a:1:{s:11:\"woocommerce\";a:35:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"9.5.1\";s:6:\"author\";s:48:\"<a href=\"https://woocommerce.com\">Automattic</a>\";s:14:\"author_profile\";s:41:\"https://profiles.wordpress.org/woothemes/\";s:12:\"contributors\";a:49:{s:10:\"automattic\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/automattic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73edc627541112a447e978843cf72f516bdbf6350e7cbac10016c71ab1b8c8a1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"Automattic\";}s:11:\"woocommerce\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/woocommerce/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7781a3c13bcc86b57064b9539ec22da52fd5ef1902fbc020d0a4a8595b14ea0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"WooCommerce\";}s:10:\"mikejolley\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mikejolley/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8295774fc174b6a5b9bd960709949f4de88cd0b8708d711dc5b6676693d41432?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:18:\"Mike Jolley (a11n)\";}s:11:\"jameskoster\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/jameskoster/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/94b5473c03a46cb204f0a868dfe65f8199ef483242814ec1bcaf6770ba90d203?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"James Koster\";}s:14:\"claudiosanches\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/claudiosanches/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ac91c7d73bb4501567ab3790755bf001d53dac8d1f4311a2480a5fb62dfb180c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Claudio Sanches\";}s:13:\"rodrigosprimo\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/rodrigosprimo/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1dc85457417601db220b14e7fa96c842700fbd1cceecd21d65306c26fffb92cc?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Rodrigo Primo\";}s:15:\"peterfabian1000\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/peterfabian1000/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c25372df076206b9fe44dddd7ec6af6ba427d3fe2a457fa301fcb9cf90b23ddd?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Peter Fabian\";}s:7:\"vedjain\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/vedjain/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/eb19da24784b2f86d310a213b60c903b0a5464a6c725cf5fcabfd274383337c4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Vedanshu - a11n\";}s:8:\"jamosova\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/jamosova/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/5822965b924eb5a03e31a6280844976334cc16e7917e9c41e1ce5b6aed5054a8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Julia Amosova\";}s:16:\"obliviousharmony\";a:3:{s:7:\"profile\";s:48:\"https://profiles.wordpress.org/obliviousharmony/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/67851e0deeb2c6a7a4c238cf45c0e9694a919e2c5e02706c5852e67c4ad279c9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"obliviousharmony\";}s:9:\"konamiman\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/konamiman/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ee97f225bf5be24cd3c3b04990b9fc3dfc67a2c9aaea418ec2bdd32e164ed9b1?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:23:\"Néstor Soriano Vilchez\";}s:8:\"sadowski\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/sadowski/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/cee318a6ec06e747df7f70f274da4e0cf4adba60c59e12d660d0f5a6ba78658a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:8:\"sadowski\";}s:8:\"wpmuguru\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/wpmuguru/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23afb25faac780cb6ec9533b2ac9e5daedf7a1faf444b41db471b9529701f87e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Ron Rennick\";}s:5:\"royho\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/royho/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1beda14f19fa93030ba2c66359dc270286820af6c667cdfeb4e87833c747f3a0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"royho\";}s:13:\"barryhughes-1\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/barryhughes-1/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6ce0f4afb77f8d32da9c43e9a39c84fcfb3ed0e9cac24f440c46a151946cdec8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"Barry\";}s:12:\"claudiulodro\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/claudiulodro/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/34a74527d3859bd9fb0b477cd80c9f78b3610259a251c32a31023ead285ac124?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Claudiu Lodromanean\";}s:12:\"tiagonoronha\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tiagonoronha/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0352cd451932c8a2ab15b8457933e6d90cc919bbf23db63e3bc35ee41d56577e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Tiago Noronha\";}s:6:\"ryelle\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/ryelle/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ec41e096f07d542f72beed65211b2d0611eb3d11f623195d7a38df7ba8be5c0b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Kelly Choyce-Dwan\";}s:10:\"levinmedia\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/levinmedia/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/657d301b3683f02c75e4b2363681518e94485770056cc51526f19818884ba6aa?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:10:\"levinmedia\";}s:7:\"aljullu\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/aljullu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/784f29a6d06799d1d40adc32b115da932cd1ee2b22d91cd8597e9fe6e4ee1420?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:21:\"Albert Juhé Lluveras\";}s:6:\"nerrad\";a:3:{s:7:\"profile\";s:38:\"https://profiles.wordpress.org/nerrad/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1bd692736861bd20949789e4a3d922736480efcacb0e44041616c5a79eaa54c0?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:22:\"Darren Ethier (nerrad)\";}s:10:\"joshuawold\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/joshuawold/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f98224d78e12fcc0e9686dbf15f8c37b1967835212f25a92fceb6caafdc5b08d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Joshua Wold\";}s:13:\"assassinateur\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/assassinateur/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/9da547cf74479facffd2e3845e8b74ccc69334648c7d9a89f290ee39c84aae36?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Nadir Seghir a11n\";}s:7:\"haszari\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/haszari/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/5478c55437f47714a4dae1016cf521e803dfc4633ce5781b2f24d749d1623f69?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Rua Haszard\";}s:10:\"mppfeiffer\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/mppfeiffer/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0fe64f1ef1e4abe1825653bcb17113a4a14c755f5b6f77d2f27494fe349d7081?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"Michael P. Pfeiffer\";}s:10:\"nielslange\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/nielslange/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0894ec0d7e5d70306a16431b36249b1928cad88a572de9b5211a54d75ad5d77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Niels Lange\";}s:9:\"ralucastn\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/ralucastn/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e65d79886499f47ee368495f5016117deef427d5abca9d3ed76c4bfaa42e7c0a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:6:\"Raluca\";}s:11:\"tjcafferkey\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/tjcafferkey/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/23d134901eef453e721759c9d84810f5748a84fc8681ed230c7d78e53583c77a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"tjcafferkey\";}s:13:\"danielwrobert\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/danielwrobert/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/2be0e3c5a2629fae2858cc91764d680e9de5f70cf713d1e0cf30acfa32f7b53d?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"danielwrobert\";}s:19:\"patriciahillebrandt\";a:3:{s:7:\"profile\";s:51:\"https://profiles.wordpress.org/patriciahillebrandt/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/13f5707fad9a68e5cf9c3c0ebb9c7179c862dcb279c761d20c9b40bd2fff9f4a?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:19:\"patriciahillebrandt\";}s:7:\"albarin\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/albarin/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/0dd150b60949026a3c34f49d40089e3a8cf97dc331e2f5b27e805ffd34648e22?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"albarin\";}s:10:\"dinhtungdu\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/dinhtungdu/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/07e79c32b1abba868f8c5e3ee0c85b9150c74e2c2a946088a268e6be486d9114?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Tung Du\";}s:10:\"imanish003\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/imanish003/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/fa10e8238e7f033a1cad1f8fcabf76e70ac1e2637067c6d58e9a6d2b9f2d7093?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Manish Menaria\";}s:12:\"karolmanijak\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/karolmanijak/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/42305d7047ca11d494b1912d687266a50edd05954fdec22e61ab1fe63cf2df6b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Karol Manijak\";}s:13:\"sunyatasattva\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/sunyatasattva/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/73ce316f9775441698b601e6902728a80837f7fd6df0846e3c5a82448dce447c?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:20:\"sunyatasattva (a11n)\";}s:13:\"alexandrelara\";a:3:{s:7:\"profile\";s:45:\"https://profiles.wordpress.org/alexandrelara/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/1c0c71a072f798066e4661395461e73e0fb6692eaddcced2a0e457ef01a458e8?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:14:\"Alexandre Lara\";}s:7:\"gigitux\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/gigitux/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/2dcd003f15403180364c56b093b48e6edca9a88c8f1470b965b87fc230c66d7f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Luigi Teschio\";}s:12:\"danieldudzic\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/danieldudzic/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b689767c4b308b8f5910cef3a2f44c2acdadcb3b63326b0d5c865d2c208c668e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"danieldudzic\";}s:11:\"samueljseay\";a:3:{s:7:\"profile\";s:43:\"https://profiles.wordpress.org/samueljseay/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/4c4a5e8fd5b99749ed9ac735c31d0370254356e40feea46bcf51b2b607f8ab0e?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:3:\"Sam\";}s:12:\"alexflorisca\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/alexflorisca/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/b68615471f527e6224909ce0726dda68b074e6cbcf89e0d4b5ecc483a96557ca?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Alex Florisca\";}s:5:\"opr18\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/opr18/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/e083a0759b8ea01b11c1f154a3087ddfaf65a93011cf97a85fdbfc0cda709538?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:5:\"opr18\";}s:12:\"tarunvijwani\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/tarunvijwani/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/fa4a4b2688afb8d238bb035f31fda4d07dabd67ccf41576276e5eb084463d617?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"tarunvijwani\";}s:12:\"pauloarromba\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/pauloarromba/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/ab6034aa12c0e53f21978df9e470f161f06810d814082cbe3ab74450f0618818?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Paulo Arromba\";}s:9:\"saadtarhi\";a:3:{s:7:\"profile\";s:41:\"https://profiles.wordpress.org/saadtarhi/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/f4fd0df69b8c7bf3a3e6526df3b42c3854de544904ef825bfd549afc9829f645?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:7:\"Saad T.\";}s:4:\"bor0\";a:3:{s:7:\"profile\";s:36:\"https://profiles.wordpress.org/bor0/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/787d8ea71701ced680cd80411d656c20e0e600be5d34f6ce3478143d43dc9fd9?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Boro Sitnikovski\";}s:5:\"kloon\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/kloon/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/c7c708f5b0957714ab48e00220b0f74acccb43b70fa0d4b5ee091d59951ae751?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:17:\"Gerhard Potgieter\";}s:12:\"coreymckrill\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/coreymckrill/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/6ebeb5dc233dbb09a7dd347f6979cac86baed30a31158051a4bf6110074002cb?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:18:\"Corey McKrill a11n\";}s:12:\"jorgeatorres\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/jorgeatorres/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/33d6a063c7411775135383c5bae6cd4e45d094b72ec062c96ceafca5e2a4956f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:15:\"Jorge A. Torres\";}s:10:\"leifsinger\";a:3:{s:7:\"profile\";s:42:\"https://profiles.wordpress.org/leifsinger/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/8107603a6bbc5ff73e07e2450f260335af41a5adb2cccd80cba20cdd28b96651?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Leif Singer\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3653;i:4;i:181;i:3;i:98;i:2;i:105;i:1;i:395;}s:11:\"num_ratings\";i:4432;s:11:\"support_url\";s:49:\"https://wordpress.org/support/plugin/woocommerce/\";s:15:\"support_threads\";i:1252;s:24:\"support_threads_resolved\";i:683;s:15:\"active_installs\";i:8000000;s:12:\"last_updated\";s:22:\"2024-12-17 11:36am GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:8:\"sections\";a:6:{s:11:\"description\";s:12533:\"<p><a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a> is the open-source eCommerce platform for WordPress.</p>\n<p>Our core platform is free, flexible, and amplified by a global community. The freedom of open source means you retain full ownership of your store’s content and data forever.</p>\n<p>Whether you’re launching a business, taking brick-and-mortar retail online, or developing sites for clients, use WooCommerce for a store that powerfully blends content and commerce.</p>\n<ul>\n<li><strong>Create beautiful, enticing storefronts</strong> with <a href=\"https://woocommerce.com/product-category/themes/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">themes</a> suited to your brand and industry.</li>\n<li><strong>Increase revenue</strong> with an optimised <a href=\"https://woocommerce.com/checkout-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">shopping basket experience</a> that converts.</li>\n<li><strong>Customise product pages in minutes</strong> using modular <a href=\"https://woocommerce.com/document/woocommerce-blocks/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">product blocks</a>.</li>\n<li>Showcase physical and digital goods, product variations, custom configurations, instant downloads, and affiliate items.</li>\n<li>Sell <a href=\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">subscriptions</a>, <a href=\"https://woocommerce.com/products/woocommerce-bookings/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">bookings</a>, or <a href=\"https://woocommerce.com/products/woocommerce-memberships/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">memberships</a>, with our developer-vetted extensions.</li>\n<li><strong>Rise to the top of search results</strong> by leveraging <a href=\"https://www.searchenginejournal.com/wordpress-best-cms-seo/\" rel=\"nofollow ugc\">WordPress’ SEO advantage</a>.</li>\n<li><strong>Build on a platform that scales.</strong> Get flexible eCommerce for <a href=\"https://woocommerce.com/high-volume-stores/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">high-volume stores</a>.</li>\n</ul>\n<h4>ALL THE TOOLS YOU NEED TO SELL</h4>\n<p>Built-in tools and popular integrations help you efficiently manage your business operations. Many services are free to add with a single click via the optional <a href=\"https://woocommerce.com/document/woocommerce-setup-wizard/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Setup Wizard</a>.</p>\n<ul>\n<li><strong>Choose how you want to get paid</strong>. Conveniently manage payments from the comfort of your store with <a href=\"https://woocommerce.com/payments/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooPayments</a> (Available in the US, UK, Ireland, Australia, New Zealand, Canada, Spain, France, Germany, and Italy). Securely accept credit cards, mobile wallets, bank transfers, and cash thanks to <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">100+ payment gateways</a> – including <a href=\"https://woocommerce.com/products/stripe/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Stripe</a>, <a href=\"https://woocommerce.com/products/woocommerce-gateway-paypal-checkout/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">PayPal</a>, and <a href=\"https://woocommerce.com/products/square/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Square</a>.</li>\n<li><strong>Configure your shipping options</strong>. Print USPS labels right from your dashboard and even schedule a pickup with <a href=\"https://woocommerce.com/products/shipping/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Shipping</a> (US only). Connect with <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">well-known carriers</a> such as UPS and FedEx – plus a wide variety of delivery, inventory, and fulfilment solutions for your locale.</li>\n<li><strong>Simplify sales tax</strong>. Add <a href=\"https://woocommerce.com/products/tax/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Tax</a> or <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/tax?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">similar integrated services</a> to make automated calculations a reality.</li>\n</ul>\n<h4>Grow your business, add features, and monitor your store on the go</h4>\n<p>WooCommerce means business. Keep tabs on the performance metrics most important to you with <a href=\"https://wordpress.org/plugins/woocommerce-admin/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">WooCommerce Admin</a> – a powerful, customisable central dashboard for your store.</p>\n<p>Expand your audience across marketing and social channels with <a href=\"https://woocommerce.com/products/google-ads/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Google Ads</a>, <a href=\"https://woocommerce.com/products/hubspot-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">HubSpot</a>, <a href=\"https://woocommerce.com/products/mailchimp-for-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Mailchimp</a>, and <a href=\"https://woocommerce.com/products/facebook/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Facebook</a> integrations. You can always check out the in-dashboard <a href=\"https://woocommerce.com/document/marketing-hub/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Marketing Hub</a> for fresh ideas and tips to help you succeed.</p>\n<p>Enhance store functionality with hundreds of free and paid extensions from the <a href=\"https://woocommerce.com/products/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">official WooCommerce Marketplace</a>. Our developers <a href=\"https://woocommerce.com/document/marketplace-overview/#section-6?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">vet each new extension</a> and regularly review existing extensions to maintain Marketplace quality standards. We are actively <a href=\"https://woocommerce.com/document/marketplace-overview/#section-2?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">looking for products that help store builders create successful stores</a>.</p>\n<p>Manage your store from anywhere with the free WooCommerce <a href=\"https://woocommerce.com/mobile/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">mobile app</a> (Android and iOS). Spoiler alert: keep an ear out for the slightly addictive &#8220;cha-ching&#8221; notification sound each time you make a new sale!</p>\n<h4>Own and control your store data – forever</h4>\n<p>With <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a>, your data belongs to you. Always.</p>\n<p>If you opt to share <a href=\"https://woocommerce.com/usage-tracking/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">usage data</a> with us, you can feel confident knowing that it’s anonymised and kept secure. Choose to opt out at any time without impacting your store.</p>\n<p>Unlike hosted eCommerce solutions, WooCommerce store data is future-proof; you’re free to export all your content and take your site to any platform you choose. No restrictions.</p>\n<h4>Why developers choose (and love) WooCommerce</h4>\n<p>Developers can use <a href=\"https://woocommerce.com/woocommerce/\" rel=\"nofollow ugc\">WooCommerce</a> to create, customise, and scale a store to meet a client’s exact specifications, making enhancements through extensions or custom solutions.</p>\n<ul>\n<li>Leverage <a href=\"https://woocommerce.com/document/introduction-to-hooks-actions-and-filters/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">hooks and filters</a> to modify or create functionality.</li>\n<li>Integrate virtually any service using a robust <a href=\"https://developer.woocommerce.com/docs/getting-started-with-the-woocommerce-rest-api/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">REST API</a> and webhooks.</li>\n<li>Design and build custom content blocks with React.</li>\n<li><a href=\"https://developer.woocommerce.com/docs/category/extension-development/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Inspect and modify</a> any aspect of the core plugin code.</li>\n<li>Speed up development with a lightning-fast <a href=\"https://developer.woocommerce.com/docs/category/wc-cli/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">CLI</a>.</li>\n</ul>\n<p>The core platform is tested rigorously and often, supported by a dedicated development team working across time zones. Comprehensive documentation is updated with each release, empowering you to build exactly the store required.</p>\n<h4>Be part of our growing international community</h4>\n<p>WooCommerce has a large, passionate community dedicated to helping merchants succeed – and it’s growing fast.</p>\n<p>There are <a href=\"https://woocommerce.com/meetups/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Meetups</a> in locations around the world that you can attend for free and even get involved in running. These events are a great way to learn from others, share your expertise, and connect with like-minded folks.</p>\n<p>WooCommerce also has a regular presence at WordCamps across the globe – we’d love to meet you.</p>\n<h4>Contribute and translate</h4>\n<p>WooCommerce is developed and supported by Automattic, the creators of WordPress.com and Jetpack. We also have hundreds of independent contributors, and there’s always room for more. Head to the <a href=\"https://github.com/woocommerce/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce GitHub Repository</a> to find out how you can pitch in.</p>\n<p>WooCommerce is translated into multiple languages, including Danish, Ukrainian, and Persian. Help localise WooCommerce even further by adding your locale – visit <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">translate.wordpress.org</a>.</p>\n<h4>Connection to WooCommerce.com</h4>\n<p>You can connect your store to <a href=\"https://woocommerce.com/\" rel=\"nofollow ugc\">WooCommerce.com</a> to manage your subscriptions on WooCommerce Marketplace and receive product updates without leaving WordPress admin. Connection also enables installation of purchased products right from WooCommerce.com and streamlines access to technical support. If you’d like to learn about what data is gathered and how it is used, please refer to our <a href=\"https://automattic.com/privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</p>\n\";s:12:\"installation\";s:2398:\"<h4>Minimum requirements</h4>\n<ul>\n<li>PHP 7.4 or greater is required (PHP 8.0 or greater is recommended)</li>\n<li>MySQL 5.6 or greater, OR MariaDB version 10.1 or greater, is required</li>\n</ul>\n<p>Visit the <a href=\"https://woocommerce.com/document/server-requirements/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option &#8212; WordPress will handle the file transfer, and you won’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu, and click “Add New.”</p>\n<p>In the search field type “WooCommerce,” then click “Search Plugins.” Once you’ve found us,  you can view details about it such as the point release, rating, and description. Most importantly of course, you can install it by! Click “Install Now,” and WordPress will take it from there.</p>\n<h4>Manual installation</h4>\n<p>Manual installation method requires downloading the WooCommerce plugin and uploading it to your web server via your favourite FTP application. The WordPress codex contains <a href=\"https://wordpress.org/support/article/managing-plugins/#manual-plugin-installation\" rel=\"ugc\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work smoothly, but we still recommend you back up your site.</p>\n<p>If you encounter issues with the shop/category pages after an update, flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting “Save.” That should return things to normal.</p>\n<h4>Sample data</h4>\n<p>WooCommerce comes with some sample data you can use to see how products look; import sample_products.xml via the <a href=\"https://en-gb.wordpress.org/plugins/wordpress-importer/\" rel=\"nofollow ugc\">WordPress importer</a>. You can also use the core <a href=\"https://woocommerce.com/document/product-csv-importer-exporter/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">CSV importer</a> or our <a href=\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=wp%20org%20repo%20listing&amp;utm_content=3.6\" rel=\"nofollow ugc\">CSV Import Suite extension</a> to import sample_products.csv</p>\n\";s:3:\"faq\";s:7807:\"\n<dt id=\'where%20can%20i%20find%20woocommerce%20documentation%20and%20user%20guides%3F\'>\nWhere can I find WooCommerce documentation and user guides?\n</h4>\n<p>\n<p>For help setting up and configuring WooCommerce, please refer to <a href=\"https://woocommerce.com/documentation/plugins/woocommerce/getting-started/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Getting Started</a> and the <a href=\"https://woocommerce.com/guides/new-store/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">New WooCommerce Store Owner Guide</a>.</p>\n<p>For extending or theming WooCommerce, see our <a href=\"https://github.com/woocommerce/woocommerce/tree/trunk/docs\" rel=\"nofollow ugc\">documentation</a>, as well as the <a href=\"https://github.com/woocommerce/woocommerce/blob/trunk/docs/extension-development/extension-development-best-practices.md\" rel=\"nofollow ugc\">Plugin Developer Best Practices</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20or%20talk%20to%20other%20users%20about%20woocommerce%20core%3F\'>\nWhere can I get help or talk to other users about WooCommerce Core?\n</h4>\n<p>\n<p>If you get stuck, you can ask for help in the <a href=\"https://wordpress.org/support/plugin/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">WooCommerce Support Forum</a> by following <a href=\"https://wordpress.org/support/topic/guide-to-the-woocommerce-forum/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"ugc\">these guidelines</a>, reach out via the <a href=\"https://woocommerce.com/community-slack/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Community Slack</a>, or post in the <a href=\"https://www.facebook.com/groups/advanced.woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce Community group</a> on Facebook.</p>\n</p>\n<dt id=\'where%20can%20i%20get%20help%20for%20extensions%20i%20have%20purchased%20from%20the%20woocommerce%20marketplace%3F\'>\nWhere can I get help for extensions I have purchased from the WooCommerce Marketplace?\n</h4>\n<p>\n<p>For assistance with paid extensions from the WooCommerce Marketplace: first, review our <a href=\"https://woocommerce.com/document/woocommerce-self-service-guide/\" rel=\"nofollow ugc\">self-service troubleshooting guide</a>. If the problem persists, kindly log a support ticket via <a href=\"https://woocommerce.com/my-account/create-a-ticket/\" rel=\"nofollow ugc\">our helpdesk</a>. Our dedicated Happiness Engineers aim to respond within 24 hours.</p>\n</p>\n<dt id=\'i%E2%80%99m%20having%20trouble%20logging%20in%20to%20woocommerce.com%20%E2%80%93%20what%20now%3F\'>\nI’m having trouble logging in to WooCommerce.com – what now?\n</h4>\n<p>\n<p>First, troubleshoot common login issues using this helpful <a href=\"https://woocommerce.com/document/log-into-woocommerce-com-with-wordpress-com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">step-by-step guide</a>. Still not working? <a href=\"https://woocommerce.com/contact-us/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Get in touch with us</a>.</p>\n</p>\n<dt id=\'will%20woocommerce%20work%20with%20my%20theme%3F\'>\nWill WooCommerce work with my theme?\n</h4>\n<p>\n<p>Yes! WooCommerce will work with any theme but may require some additional styling. If you’re looking for a theme featuring deep WooCommerce integration, we recommend <a href=\"https://woocommerce.com/storefront/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Storefront</a>.</p>\n</p>\n<dt id=\'how%20do%20i%20update%20woocommerce%3F\'>\nHow do I update WooCommerce?\n</h4>\n<p>\n<p>We have a detailed guide on <a href=\"https://woocommerce.com/document/how-to-update-woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">How To Update WooCommerce</a>.</p>\n</p>\n<dt id=\'my%20site%20broke%20%E2%80%93%20what%20do%20i%20do%3F\'>\nMy site broke – what do I do?\n</h4>\n<p>\n<p>Start by diagnosing the issue using our helpful <a href=\"https://woocommerce.com/documentation/get-help/troubleshooting-get-help/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">troubleshooting guide</a>.</p>\n<p>If you noticed the error after updating a theme or plugin, there might be compatibility issues between it and WooCommerce. If the issue appeared after updating WooCommerce, there could be a conflict between WooCommerce and an outdated theme or plugin.</p>\n<p>In both instances, we recommend running a conflict test using <a href=\"https://woocommerce.com/document/troubleshooting-using-health-check/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Health Check</a> (which allows you to disable themes and plugins without affecting your visitors) or troubleshooting the issue using a <a href=\"https://woocommerce.com/document/how-to-test-for-conflicts/#section-3?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">staging site</a>.</p>\n</p>\n<dt id=\'where%20can%20i%20report%20bugs%3F\'>\nWhere can I report bugs?\n</h4>\n<p>\n<p>Report bugs on the <a href=\"https://github.com/woocommerce/woocommerce/issues?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce GitHub repository</a>. You can also notify us via our support forum – be sure to search the forums to confirm that the error has not already been reported.</p>\n</p>\n<dt id=\'where%20can%20i%20request%20new%20features%2C%20themes%2C%20and%20extensions%3F\'>\nWhere can I request new features, themes, and extensions?\n</h4>\n<p>\n<p>Request new features and extensions and vote on existing suggestions on our official <a href=\"https://woocommerce.com/feature-requests/woocommerce?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">feature request board</a>. Our Product teams regularly review requests and consider them valuable for product planning.</p>\n</p>\n<dt id=\'woocommerce%20is%20awesome%21%20can%20i%20contribute%3F\'>\nWooCommerce is awesome! Can I contribute?\n</h4>\n<p>\n<p>Yes, you can! Join in on our <a href=\"https://github.com/woocommerce/woocommerce/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">GitHub repository</a> and follow the <a href=\"https://woocommerce.wordpress.com/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">development blog</a> to stay up-to-date with everything happening in the project.</p>\n</p>\n<dt id=\'where%20can%20i%20find%20rest%20api%20documentation%3F\'>\nWhere can I find the REST API documentation?\n</h4>\n<p>\n<p>Extensive <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">WooCommerce REST API Documentation</a> is available on GitHub.</p>\n</p>\n<dt id=\'my%20question%20is%20not%20listed%20here.%20where%20can%20i%20find%20more%20answers%3F\'>\nMy question is not listed here. Where can I find more answers?\n</h4>\n<p>\n<p>Check out <a href=\"https://woocommerce.com/document/frequently-asked-questions/?utm_medium=referral&amp;utm_source=wordpress.org&amp;utm_campaign=wp_org_repo_listing\" rel=\"nofollow ugc\">Frequently Asked Questions</a> for more.</p>\n</p>\n\n\";s:9:\"changelog\";s:377:\"<h4>9.5.1 2024-12-17</h4>\n<p><strong>WooCommerce</strong></p>\n<ul>\n<li>Fix &#8211; Product Gallery: fix PHP fatal error. <a href=\"https://github.com/woocommerce/woocommerce/pull/53762\" rel=\"nofollow ugc\">#53762</a></li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/changelog.txt\" rel=\"nofollow ugc\">See change log for all versions</a>.</p>\n\";s:11:\"screenshots\";s:1035:\"<ol><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\" alt=\"\"></a></li><li><a href=\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\"><img src=\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\" alt=\"\"></a></li></ol>\";s:7:\"reviews\";s:18754:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Easy for a Newbie in SEO</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/erin1979/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/98d8de49eb41866514b0402c18511d3b2488f30553e2729e330a0a3a823ab997?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/98d8de49eb41866514b0402c18511d3b2488f30553e2729e330a0a3a823ab997?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/erin1979/\" class=\"reviewer-name\">erin1979</a> on <span class=\"review-date\">December 16, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I am new to SEO and am updating our company\'s website. AIOSEO thru WordPress is a game changer. It is easy to install &amp; use. I like the recommendations they provide, to make our website better.  Don\'t be afraid to try it out. When I had an issue/question, Jeff Burns in Technical Support answered quickly &amp; clearly.  THANKS! -SEO Newbie</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">How to edit check out fields</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/eldokkan/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/80b2b7e0b6be916de58a2ae9a48dc1b056126ce9c65b803a4356d87bce125609?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/80b2b7e0b6be916de58a2ae9a48dc1b056126ce9c65b803a4356d87bce125609?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/eldokkan/\" class=\"reviewer-name\">eldokkan</a> on <span class=\"review-date\">December 15, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>How to remove Zip/postal code and make phone number required </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">VERY versatile E-Commerce Solution</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/andreaslorenzi/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d6742536200172eaa7285e6d08abdada0ba86b1d1c7f5c00ca8ca00bf4b37cc0?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d6742536200172eaa7285e6d08abdada0ba86b1d1c7f5c00ca8ca00bf4b37cc0?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/andreaslorenzi/\" class=\"reviewer-name\">andreaslorenzi</a> on <span class=\"review-date\">December 4, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Five years ago, I was told that using Woo for a larger scale online shop is not the way to do it. <br />Gladly, I didn\'t listen.<br /><br />Four years into my own E-Commerce Project, I can reassure that Woo easily handles our 5k (and growing) products. We run retail, wholesale, pre-loved (differential taxation) of physical products as well as the selling of in person classes all out of one installation (yes, we use quite many plugins and about 500 lines of custom PHP-Code) - works like a charm.<br /><br />I am very happy with Woo! Great job, folks - thanks a million!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Powerful WooCommerce Plugin</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/devvlop/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/2215b0511ba6405217d239660189697de8144cbf354706e795e8a4fa8a4e1db1?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/2215b0511ba6405217d239660189697de8144cbf354706e795e8a4fa8a4e1db1?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/devvlop/\" class=\"reviewer-name\">devvlop</a> on <span class=\"review-date\">December 4, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>An excellent WooCommerce plugin! It’s user-friendly, highly customizable, and integrates seamlessly with my store. Support is responsive and helpful. Highly recommend it!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Support is incompetent</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/downhouse00/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/10c971a1192f264c1274285b5d9922b5f4f45ea18073f8b14737fad8def46003?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/10c971a1192f264c1274285b5d9922b5f4f45ea18073f8b14737fad8def46003?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/downhouse00/\" class=\"reviewer-name\">DH <small>(DownHouse00)</small></a> on <span class=\"review-date\">December 3, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>On more than 20 sites, language of woocommerce has changed to English.<br />Support is incompetent and cannot help.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Feels like running a shop from the 2000s</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/regedy1/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d94be630b1ac7275eb33842183531eb5eb760349c6974310b879ae049ad220cb?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d94be630b1ac7275eb33842183531eb5eb760349c6974310b879ae049ad220cb?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/regedy1/\" class=\"reviewer-name\">regedy1</a> on <span class=\"review-date\">December 2, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>There is a reason why shopify has taken so much market share. Woo just feels so clunky in every aspect. even basic things to run an ecommerce store in 2024 need extra plugins (e.g new account email validation, default tax rates, order email designer, a decent product bulk edit, checkout customizer, order bump, filters &amp; sorting, bulk discounts...)<br />Development for woo feels so stagnant and there hasn\'t been any innovative features in a looong time. <br />The fact that I don\'t even have a dashboard where I can see the conversion rate and all important metrics for my store is just mind blowing. the current analytics is a bit of a joke. </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Error with Free Shipping set-up</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/apositivetwist/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/5dbe5652f486983c9461c3f92227f4d6e79a7f1d3fc3e7d2ab0c5a6f95cfe9a6?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/5dbe5652f486983c9461c3f92227f4d6e79a7f1d3fc3e7d2ab0c5a6f95cfe9a6?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/apositivetwist/\" class=\"reviewer-name\">apositivetwist</a> on <span class=\"review-date\">November 29, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Took a few rounds but in the end my problem was solved. Thanks!</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Theme debugging</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/seasonalsports/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/e865e849e721bbf838234075d171ef3804635838eb2a3d78b85ef176939f1977?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/e865e849e721bbf838234075d171ef3804635838eb2a3d78b85ef176939f1977?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/seasonalsports/\" class=\"reviewer-name\">seasonalsports</a> on <span class=\"review-date\">November 21, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Pretty quick response . Great with knowing the problems and what to do . I have very little web building knowledge, so having them walk me through it is a plus ! </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Frustrating to See Where the Plugin Is</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"4 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"4\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/thekendog/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/31ae14b3e1aa905fd2f9afc345987f542f155df837f5c7f7d6091feddef1adef?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/31ae14b3e1aa905fd2f9afc345987f542f155df837f5c7f7d6091feddef1adef?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/thekendog/\" class=\"reviewer-name\">thekendog</a> on <span class=\"review-date\">November 21, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I\'ve been using WooCommerce for 10+ years now and it\'s very frustrating to see where it\'s currently at.  I\'m still giving it 4 stars because it\'s incredibly flexible and you can do all kinds of crazy stuff with it, but I would really like to see the UI improved greatly.  Right now, it\'s a mix mash of different interfaces.  Half of the admin UI is React based and the other half is legacy.  There\'s no continuity.  For instance, the latest update made the customers list in the admin React based.  You would think they would do the same with the orders table right?  Wrong.  It\'s the legacy table class look.  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>WooCommerce is owned by the same company who pretty much owns WordPress (it\'s not community owned, don\'t kid yourself).  That company is all about blocks, blocks, and more blocks.  Yet, here we are stuck with the classic editor for editing products.  Blocks are supposed to be great (they\'re okay) and we\'re told that we should start using them because they are core and the future.  Six years in though and a flagship plugin is still using classic editor.  So my clients have multiple interfaces to learn now instead of having one.  Again, no continuity.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Continuing with the lack of continuity is the cart and checkout blocks. Again, we edit products with the classic editor but BY DEFAULT the plugin uses blocks for the cart and checkout pages. These blocks are incompatible with certain action hooks and filters that have been around forever. Very frustrating. All the React things in general are a PITA and make things much, much harder to accomplish.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>They are also starting to cram more and more stuff into the admin section. The site visibility badge was annoying AF but at least they allow us to remove it now with a setting, although it\'s turned on by default. The latest update added a new payments admin menu item which has to be removed with code. It was broke and it\'s fixed now, although I suspect it will be displaying an advertisement for WooPayments in the future.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>My suggestion is to look at the other big e-commerce plugin (initials are SC) which is being adopted by a lot of folks.  It admittedly lacks a bunch of features that Woo has, but the interface is gorgeous and consistent.  </p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Still the same crappy format</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/kismett/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/0a4ee17eca07ae4ad9995a80c7efbaaac5dcaceb4367413513daecb62a26fc65?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/0a4ee17eca07ae4ad9995a80c7efbaaac5dcaceb4367413513daecb62a26fc65?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/kismett/\" class=\"reviewer-name\">kismett</a> on <span class=\"review-date\">November 21, 2024</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>It\'s honestly such a crappy, outdated and clonky plugin and they\'ve done absolutely NOTHING in all these years to try and simplify it and make it more user friendly. They\'ve had more than enough time on them to figure out to do a much better plugin.</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:146:\"Everything you need to launch an online store in days and keep it growing for years. From your first sale to millions in revenue, Woo is with you.\";s:13:\"download_link\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:9:\"ecommerce\";s:9:\"ecommerce\";s:12:\"online-store\";s:12:\"online store\";s:11:\"sell-online\";s:11:\"sell online\";s:4:\"shop\";s:4:\"shop\";s:13:\"shopping-cart\";s:13:\"shopping cart\";}s:8:\"versions\";a:466:{s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:6:\"3.5.10\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.10.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.6.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.7.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.3.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.3.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"3.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.5.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.4.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.4.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.5.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.6.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.4.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.5.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.5.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.7.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.4.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.3.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"4.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.5.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.3.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.3.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.5.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.3.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.4.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.4.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.2.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.2.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:5:\"5.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.1.zip\";s:5:\"5.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"5.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.1.zip\";s:5:\"6.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0.zip\";s:12:\"6.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-beta.1.zip\";s:10:\"6.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-rc.1.zip\";s:5:\"6.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.1.zip\";s:5:\"6.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0.zip\";s:12:\"6.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-beta.1.zip\";s:10:\"6.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.1.zip\";s:10:\"6.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.2.zip\";s:5:\"6.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.1.zip\";s:5:\"6.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.2.zip\";s:5:\"6.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0.zip\";s:12:\"6.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-beta.1.zip\";s:10:\"6.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.1.zip\";s:10:\"6.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.2.zip\";s:5:\"6.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.1.zip\";s:5:\"6.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.2.zip\";s:5:\"6.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0.zip\";s:12:\"6.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-beta.1.zip\";s:10:\"6.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.1.zip\";s:10:\"6.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.2.zip\";s:5:\"6.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.1.zip\";s:5:\"6.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0.zip\";s:12:\"6.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-beta.1.zip\";s:10:\"6.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-rc.1.zip\";s:5:\"6.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.1.zip\";s:5:\"6.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0.zip\";s:12:\"6.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-beta.1.zip\";s:10:\"6.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.1.zip\";s:10:\"6.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.2.zip\";s:5:\"6.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.1.zip\";s:5:\"6.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0.zip\";s:12:\"6.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-beta.1.zip\";s:10:\"6.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.1.zip\";s:10:\"6.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.2.zip\";s:5:\"6.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.1.zip\";s:5:\"6.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0.zip\";s:12:\"6.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.1.zip\";s:12:\"6.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.2.zip\";s:10:\"6.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-rc.1.zip\";s:5:\"6.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0.zip\";s:12:\"6.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.1.zip\";s:12:\"6.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.2.zip\";s:10:\"6.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-rc.1.zip\";s:5:\"6.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.1.zip\";s:5:\"6.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.2.zip\";s:5:\"6.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0.zip\";s:12:\"6.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.1.zip\";s:12:\"6.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.2.zip\";s:10:\"6.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-rc.1.zip\";s:5:\"6.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.1.zip\";s:5:\"6.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.2.zip\";s:5:\"6.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.3.zip\";s:5:\"6.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.4.zip\";s:5:\"7.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0.zip\";s:12:\"7.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.1.zip\";s:12:\"7.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.2.zip\";s:12:\"7.0.0-beta.3\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.3.zip\";s:10:\"7.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.1.zip\";s:10:\"7.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.2.zip\";s:5:\"7.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.1.zip\";s:5:\"7.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0.zip\";s:12:\"7.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.1.zip\";s:12:\"7.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.2.zip\";s:10:\"7.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.1.zip\";s:10:\"7.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.2.zip\";s:5:\"7.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.1.zip\";s:5:\"7.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0.zip\";s:12:\"7.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.1.zip\";s:12:\"7.2.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.2.zip\";s:10:\"7.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.1.zip\";s:10:\"7.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.2.zip\";s:5:\"7.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.1.zip\";s:5:\"7.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.2.zip\";s:5:\"7.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.3.zip\";s:5:\"7.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0.zip\";s:12:\"7.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.1.zip\";s:12:\"7.3.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.2.zip\";s:10:\"7.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.1.zip\";s:10:\"7.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.2.zip\";s:5:\"7.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0.zip\";s:12:\"7.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.1.zip\";s:12:\"7.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.2.zip\";s:10:\"7.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.1.zip\";s:10:\"7.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.2.zip\";s:5:\"7.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.1.zip\";s:5:\"7.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0.zip\";s:12:\"7.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.1.zip\";s:12:\"7.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.2.zip\";s:10:\"7.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-rc.1.zip\";s:5:\"7.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.1.zip\";s:5:\"7.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0.zip\";s:12:\"7.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.1.zip\";s:12:\"7.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.2.zip\";s:10:\"7.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.1.zip\";s:10:\"7.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.2.zip\";s:10:\"7.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.3.zip\";s:5:\"7.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.1.zip\";s:5:\"7.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0.zip\";s:12:\"7.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.1.zip\";s:12:\"7.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.2.zip\";s:10:\"7.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-rc.1.zip\";s:5:\"7.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.1.zip\";s:5:\"7.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.2.zip\";s:5:\"7.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0.zip\";s:12:\"7.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.1.zip\";s:12:\"7.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.2.zip\";s:10:\"7.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.1.zip\";s:10:\"7.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.2.zip\";s:5:\"7.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.1.zip\";s:5:\"7.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.2.zip\";s:5:\"7.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.3.zip\";s:5:\"7.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0.zip\";s:12:\"7.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.1.zip\";s:12:\"7.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.2.zip\";s:10:\"7.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.2.zip\";s:10:\"7.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.3.zip\";s:5:\"7.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.1.zip\";s:5:\"8.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0.zip\";s:12:\"8.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.1.zip\";s:12:\"8.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.2.zip\";s:10:\"8.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.1.zip\";s:10:\"8.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.2.zip\";s:5:\"8.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.1.zip\";s:5:\"8.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.2.zip\";s:5:\"8.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.3.zip\";s:5:\"8.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.4.zip\";s:5:\"8.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0.zip\";s:12:\"8.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-beta.1.zip\";s:10:\"8.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.1.zip\";s:10:\"8.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.2.zip\";s:5:\"8.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:5:\"8.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.2.zip\";s:5:\"8.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0.zip\";s:12:\"8.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-beta.1.zip\";s:10:\"8.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.1.zip\";s:10:\"8.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.2.zip\";s:5:\"8.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.1.zip\";s:5:\"8.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.2.zip\";s:5:\"8.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.3.zip\";s:5:\"8.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0.zip\";s:12:\"8.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-beta.1.zip\";s:10:\"8.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.1.zip\";s:10:\"8.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.2.zip\";s:5:\"8.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.1.zip\";s:5:\"8.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.2.zip\";s:5:\"8.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0.zip\";s:12:\"8.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-beta.1.zip\";s:10:\"8.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-rc.1.zip\";s:5:\"8.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.1.zip\";s:5:\"8.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0.zip\";s:12:\"8.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-beta.1.zip\";s:10:\"8.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-rc.1.zip\";s:5:\"8.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.1.zip\";s:5:\"8.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.2.zip\";s:5:\"8.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.3.zip\";s:5:\"8.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0.zip\";s:12:\"8.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-beta.1.zip\";s:10:\"8.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-rc.1.zip\";s:5:\"8.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.1.zip\";s:5:\"8.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.2.zip\";s:5:\"8.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0.zip\";s:12:\"8.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.1.zip\";s:12:\"8.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.2.zip\";s:10:\"8.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-rc.1.zip\";s:5:\"8.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.1.zip\";s:5:\"8.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0.zip\";s:12:\"8.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-beta.1.zip\";s:10:\"8.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-rc.1.zip\";s:5:\"8.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.1.zip\";s:5:\"8.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.2.zip\";s:5:\"8.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.3.zip\";s:5:\"8.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.4.zip\";s:5:\"8.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.5.zip\";s:5:\"8.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0.zip\";s:12:\"8.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-beta.1.zip\";s:10:\"8.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-rc.1.zip\";s:5:\"8.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.1.zip\";s:5:\"8.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.2.zip\";s:5:\"8.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.3.zip\";s:5:\"9.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0.zip\";s:12:\"9.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.1.zip\";s:12:\"9.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.2.zip\";s:10:\"9.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-rc.1.zip\";s:5:\"9.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.1.zip\";s:5:\"9.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.2.zip\";s:5:\"9.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0.zip\";s:12:\"9.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-beta.1.zip\";s:10:\"9.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-rc.1.zip\";s:5:\"9.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.1.zip\";s:5:\"9.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.2.zip\";s:5:\"9.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.3.zip\";s:5:\"9.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.4.zip\";s:5:\"9.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0.zip\";s:12:\"9.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-beta.1.zip\";s:10:\"9.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-rc.1.zip\";s:5:\"9.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.1.zip\";s:5:\"9.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.2.zip\";s:5:\"9.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.3.zip\";s:5:\"9.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0.zip\";s:12:\"9.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-beta.1.zip\";s:10:\"9.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-rc.1.zip\";s:5:\"9.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.1.zip\";s:5:\"9.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.2.zip\";s:5:\"9.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.3.zip\";s:5:\"9.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.4.zip\";s:5:\"9.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0.zip\";s:12:\"9.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.1.zip\";s:12:\"9.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.2.zip\";s:10:\"9.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.1.zip\";s:10:\"9.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.2.zip\";s:10:\"9.4.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.3.zip\";s:10:\"9.4.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.4.zip\";s:5:\"9.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.1.zip\";s:5:\"9.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.2.zip\";s:5:\"9.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.3.zip\";s:5:\"9.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0.zip\";s:12:\"9.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.1.zip\";s:12:\"9.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.2.zip\";s:10:\"9.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-rc.1.zip\";s:5:\"9.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:12:\"9.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.1.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3000842\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3000842\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-128x128.gif?rev=2869506\";s:2:\"2x\";s:64:\"https://ps.w.org/woocommerce/assets/icon-256x256.gif?rev=2869506\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:11:\"WooCommerce\";}}", "off");
INSERT INTO `wptr_options` VALUES("129", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wptr_options` VALUES("555", "woocommerce_inbox_variant_assignment", "6", "auto");
INSERT INTO `wptr_options` VALUES("556", "woocommerce_remote_variant_assignment", "60", "auto");
INSERT INTO `wptr_options` VALUES("170", "current_theme", "Qwery Child Theme", "auto");
INSERT INTO `wptr_options` VALUES("171", "theme_mods_qwery-child", "a:160:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"menu_main\";i:118;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1589275532;s:4:\"data\";a:18:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_widgets\";a:5:{i:0;s:8:\"search-2\";i:1;s:12:\"categories-2\";i:2;s:32:\"trx_addons_widget_recent_posts-2\";i:3;s:26:\"trx_addons_widget_banner-2\";i:4;s:11:\"tag_cloud-2\";}s:14:\"header_widgets\";a:0:{}s:18:\"above_page_widgets\";a:0:{}s:21:\"above_content_widgets\";a:0:{}s:21:\"below_content_widgets\";a:0:{}s:18:\"below_page_widgets\";a:0:{}s:14:\"footer_widgets\";a:0:{}s:27:\"front_page_features_widgets\";a:0:{}s:23:\"front_page_team_widgets\";a:0:{}s:31:\"front_page_testimonials_widgets\";a:0:{}s:23:\"front_page_blog_widgets\";a:0:{}s:28:\"front_page_googlemap_widgets\";a:0:{}s:19:\"woocommerce_widgets\";a:0:{}s:11:\"edd_widgets\";a:0:{}s:15:\"bbpress_widgets\";a:0:{}s:18:\"learnpress_widgets\";a:0:{}s:20:\"tribe_events_widgets\";a:0:{}}}s:19:\"logo_retina_enabled\";i:1;s:11:\"custom_logo\";s:5:\"36948\";s:11:\"logo_retina\";s:60:\"https://dashcloud.com.tr/wp-content/uploads/2024/12/Logo.png\";s:11:\"header_type\";s:6:\"custom\";s:12:\"header_style\";s:18:\"header-custom-4614\";s:18:\"header_type_single\";s:6:\"custom\";s:19:\"header_style_single\";s:18:\"header-custom-4696\";s:21:\"expand_content_single\";s:6:\"narrow\";s:12:\"single_style\";s:7:\"style-1\";s:11:\"logo_mobile\";s:66:\"https://dashcloud.com.tr/wp-content/uploads/2020/05/logo-white.png\";s:18:\"logo_mobile_retina\";s:68:\"https://dashcloud.com.tr/wp-content/uploads/2020/05/logo-white2x.png\";s:41:\"widgets_additional_menu_mobile_fullscreen\";s:16:\"custom_widgets_1\";s:19:\"expand_content_team\";s:6:\"expand\";s:26:\"expand_content_single_team\";s:6:\"expand\";s:23:\"show_related_posts_team\";i:0;s:23:\"header_type_team_single\";s:6:\"custom\";s:24:\"header_style_team_single\";s:18:\"header-custom-4120\";s:23:\"header_type_single_team\";s:6:\"custom\";s:24:\"header_style_single_team\";s:18:\"header-custom-4696\";s:24:\"sidebar_widgets_services\";s:15:\"sidebar_widgets\";s:32:\"sidebar_position_single_services\";s:5:\"right\";s:31:\"sidebar_widgets_single_services\";s:16:\"custom_widgets_2\";s:27:\"show_related_posts_services\";i:0;s:22:\"related_posts_services\";i:2;s:24:\"related_columns_services\";i:2;s:27:\"header_type_single_services\";s:6:\"custom\";s:28:\"header_style_single_services\";s:18:\"header-custom-6425\";s:28:\"header_type_single_portfolio\";s:6:\"custom\";s:29:\"header_style_single_portfolio\";s:18:\"header-custom-6705\";s:29:\"color_scheme_single_portfolio\";s:5:\"light\";s:23:\"related_posts_portfolio\";i:4;s:26:\"posts_navigation_portfolio\";i:1;s:24:\"cpt_navigation_portfolio\";i:1;s:16:\"header_style_404\";s:18:\"header-custom-6817\";s:15:\"header_type_404\";s:6:\"custom\";s:21:\"header_type_portfolio\";s:6:\"custom\";s:22:\"header_style_portfolio\";s:18:\"header-custom-6425\";s:29:\"scroll_to_top_scheme_watchers\";s:0:\"\";s:14:\"sticky_socials\";i:0;s:30:\"sticky_socials_scheme_watchers\";i:0;s:11:\"footer_type\";s:6:\"custom\";s:12:\"footer_style\";s:18:\"footer-custom-4105\";s:19:\"color_scheme_events\";s:5:\"light\";s:18:\"header_type_events\";s:6:\"custom\";s:19:\"header_style_events\";s:18:\"header-custom-9941\";s:23:\"header_type_single_shop\";s:6:\"custom\";s:24:\"header_style_single_shop\";s:19:\"header-custom-10078\";s:17:\"meta_parts_single\";s:90:\"categories=1|author=1|date=1|modified=0|views=0|likes=1|share=1|comments=1|edit=0|rating=0\";s:13:\"footer_scheme\";s:7:\"inherit\";s:22:\"color_scheme_portfolio\";s:5:\"light\";s:17:\"blog_style_search\";s:9:\"classic_3\";s:17:\"meta_parts_search\";s:90:\"categories=1|date=1|modified=0|views=0|likes=0|comments=0|author=0|share=0|edit=0|rating=0\";s:23:\"sidebar_position_search\";s:4:\"hide\";s:17:\"blog_style_author\";s:9:\"classic_3\";s:17:\"meta_parts_author\";s:90:\"categories=1|date=1|modified=0|views=0|likes=0|comments=0|author=0|share=0|edit=0|rating=0\";s:23:\"sidebar_position_author\";s:4:\"hide\";s:14:\"blog_style_tag\";s:9:\"classic_3\";s:14:\"meta_parts_tag\";s:90:\"categories=1|date=1|modified=0|views=0|likes=0|comments=0|author=0|share=0|edit=0|rating=0\";s:20:\"sidebar_position_tag\";s:4:\"hide\";s:19:\"blog_style_category\";s:9:\"classic_3\";s:19:\"meta_parts_category\";s:90:\"categories=1|date=1|modified=0|views=0|likes=0|comments=0|author=0|share=0|edit=0|rating=0\";s:25:\"sidebar_position_category\";s:4:\"hide\";s:32:\"sidebar_widgets_single_portfolio\";s:7:\"inherit\";s:26:\"sidebar_position_portfolio\";s:4:\"hide\";s:33:\"sidebar_position_single_portfolio\";s:4:\"hide\";s:27:\"sidebar_widgets_single_team\";s:7:\"inherit\";s:28:\"sidebar_position_single_team\";s:4:\"hide\";s:20:\"sidebar_widgets_team\";s:15:\"sidebar_widgets\";s:16:\"posts_navigation\";s:5:\"links\";s:15:\"shop_pagination\";s:4:\"more\";s:13:\"reset_options\";i:0;s:9:\"team_form\";s:4:\"5597\";s:28:\"show_related_posts_portfolio\";i:0;s:19:\"scroll_to_top_style\";s:7:\"default\";s:17:\"header_fullheight\";s:0:\"\";s:11:\"header_wide\";s:1:\"1\";s:15:\"header_position\";s:7:\"default\";s:10:\"meta_parts\";s:90:\"categories=0|date=1|modified=0|views=0|likes=0|comments=1|author=0|share=0|edit=0|rating=0\";s:21:\"sidebar_position_team\";s:4:\"hide\";s:21:\"footer_widgets_mobile\";s:7:\"inherit\";s:18:\"sidebar_style_blog\";s:7:\"inherit\";s:20:\"sidebar_widgets_blog\";s:7:\"inherit\";s:22:\"sidebar_style_category\";s:7:\"inherit\";s:17:\"sidebar_style_tag\";s:7:\"inherit\";s:20:\"sidebar_style_author\";s:7:\"inherit\";s:20:\"sidebar_style_search\";s:7:\"inherit\";s:20:\"sidebar_style_single\";s:7:\"inherit\";s:18:\"sidebar_style_shop\";s:20:\"sidebar-custom-19012\";s:25:\"sidebar_style_single_shop\";s:7:\"inherit\";s:19:\"footer_widgets_shop\";s:7:\"inherit\";s:19:\"load_fonts-4-family\";s:7:\"inherit\";s:19:\"load_fonts-5-family\";s:7:\"inherit\";s:13:\"p_font-family\";s:17:\"europa,sans-serif\";s:16:\"post_font-family\";s:7:\"inherit\";s:16:\"post_font-weight\";s:7:\"inherit\";s:15:\"post_font-style\";s:7:\"inherit\";s:20:\"post_text-decoration\";s:7:\"inherit\";s:19:\"post_text-transform\";s:7:\"inherit\";s:14:\"h1_font-family\";s:20:\"sofia-pro,sans-serif\";s:14:\"h2_font-family\";s:20:\"sofia-pro,sans-serif\";s:14:\"h3_font-family\";s:20:\"sofia-pro,sans-serif\";s:14:\"h4_font-family\";s:20:\"sofia-pro,sans-serif\";s:14:\"h5_font-family\";s:20:\"sofia-pro,sans-serif\";s:14:\"h6_font-family\";s:20:\"sofia-pro,sans-serif\";s:16:\"logo_font-family\";s:20:\"sofia-pro,sans-serif\";s:18:\"button_font-family\";s:20:\"sofia-pro,sans-serif\";s:16:\"menu_font-family\";s:20:\"sofia-pro,sans-serif\";s:19:\"submenu_font-family\";s:17:\"europa,sans-serif\";s:23:\"sidebar_style_portfolio\";s:7:\"inherit\";s:30:\"sidebar_style_single_portfolio\";s:7:\"inherit\";s:24:\"footer_widgets_portfolio\";s:7:\"inherit\";s:22:\"sidebar_style_services\";s:7:\"inherit\";s:29:\"sidebar_style_single_services\";s:7:\"inherit\";s:23:\"footer_widgets_services\";s:7:\"inherit\";s:18:\"sidebar_style_team\";s:7:\"inherit\";s:25:\"sidebar_style_single_team\";s:7:\"inherit\";s:19:\"footer_widgets_team\";s:7:\"inherit\";s:20:\"sidebar_style_events\";s:7:\"inherit\";s:27:\"sidebar_style_single_events\";s:7:\"inherit\";s:21:\"footer_widgets_events\";s:7:\"inherit\";s:26:\"footer_widgets_single_shop\";s:7:\"inherit\";s:16:\"header_type_team\";s:6:\"custom\";s:17:\"header_style_team\";s:18:\"header-custom-6817\";s:10:\"team_style\";s:9:\"default_3\";s:13:\"sidebar_style\";s:20:\"sidebar-custom-19012\";s:31:\"add_attributes_to_products_list\";s:45:\"pa_color=1|pa_brand=0|pa_size=0|pa_material=0\";s:23:\"swap_on_attribute_hover\";i:1;s:25:\"action_on_attribute_click\";s:4:\"link\";s:15:\"brand_attribute\";s:8:\"pa_brand\";s:13:\"product_style\";s:8:\"creative\";s:18:\"sidebar_width_shop\";s:3:\"270\";s:16:\"sidebar_gap_shop\";s:2:\"40\";s:25:\"sidebar_proportional_shop\";i:0;s:21:\"sidebar_position_shop\";s:4:\"left\";s:19:\"header_widgets_shop\";s:7:\"inherit\";s:20:\"sidebar_widgets_shop\";s:28:\"trx_addons_woocommerce_tools\";s:17:\"sidebar_type_shop\";s:6:\"custom\";s:20:\"sidebar_filters_shop\";i:1;s:20:\"body_style_shop_list\";s:8:\"fullwide\";s:15:\"body_style_shop\";s:8:\"fullwide\";s:22:\"body_style_single_shop\";s:4:\"wide\";s:31:\"single_product_text_after_price\";s:154:\"<p style=\"font-size: 16px;\">or 4 interest-free installments by Afterpay. <a style=\"text-decoration: underline; color: inherit;\" href=\"#\">More Info</a></p>\";s:37:\"single_product_text_after_add_to_cart\";s:1170:\"<div class=\"single_product_custom_text_style\">\n<p>Guaranteed safe checkout</p>\n<div class=\"custom_icons_1\"><img class=\"alignnone size-full wp-image-19233\" src=\"https://dashcloud.com.tr/wp-content/uploads/2022/09/p_s_1-copyright.png\" alt=\"payment\" width=\"106\" height=\"76\" /> <img class=\"alignnone size-medium wp-image-19234\" src=\"https://dashcloud.com.tr/wp-content/uploads/2022/09/p_s_2-copyright.png\" alt=\"payment\" width=\"106\" height=\"76\" /> <img class=\"alignnone size-medium wp-image-19235\" src=\"https://dashcloud.com.tr/wp-content/uploads/2022/09/p_s_3-copyright.png\" alt=\"payment\" width=\"106\" height=\"76\" /> <img class=\"alignnone size-medium wp-image-19236\" src=\"https://dashcloud.com.tr/wp-content/uploads/2022/09/p_s_4-copyright.png\" alt=\"payment\" width=\"106\" height=\"76\" /></div>\n<div class=\"custom_icons_2\"><span class=\"icon-truck-1\">Free Delivery</span> <span class=\"icon-contract\">30 Day Trial</span> <span class=\"icon-bag\">Free Returns</span></div>\n<div class=\"custom_icons_3\"><span class=\"icon-support-style\"> </span>\n<div class=\"r-info\">Need Help? Call Us <a href=\"tel:12558545526\">+1 255 854 55 26</a><br />Monday - Friday 9:00 - 17:00</div>\n</div>\n</div>\";s:26:\"single_product_custom_tabs\";a:4:{i:0;a:5:{s:8:\"tab_show\";s:1:\"1\";s:9:\"tab_title\";s:11:\"Description\";s:8:\"tab_slug\";s:11:\"description\";s:8:\"tab_icon\";s:0:\"\";s:11:\"tab_content\";s:0:\"\";}i:1;a:5:{s:8:\"tab_show\";s:1:\"1\";s:9:\"tab_title\";s:13:\"Delivery Info\";s:8:\"tab_slug\";s:0:\"\";s:8:\"tab_icon\";s:0:\"\";s:11:\"tab_content\";s:345:\"<ul class=\"trx_addons_list_dot\">\n<li>Standard and Express delivery services are available for all items.</li>\n<li>Shipping costs are calculated at the checkout page (after delivery option & destination confirmation).</li>\n<li>Tracking is available for all delivery options.</li>\n<li>Items are delivered during standard business hours.</li>\n</ul>\";}i:2;a:5:{s:8:\"tab_show\";s:1:\"1\";s:9:\"tab_title\";s:12:\"Reviews (%d)\";s:8:\"tab_slug\";s:7:\"reviews\";s:8:\"tab_icon\";s:0:\"\";s:11:\"tab_content\";s:0:\"\";}i:3;a:5:{s:8:\"tab_show\";s:1:\"0\";s:9:\"tab_title\";s:22:\"Additional information\";s:8:\"tab_slug\";s:22:\"additional_information\";s:8:\"tab_icon\";s:0:\"\";s:11:\"tab_content\";s:0:\"\";}}s:28:\"single_product_details_style\";s:9:\"accordion\";s:27:\"sidebar_widgets_single_shop\";s:7:\"inherit\";s:28:\"sidebar_position_single_shop\";s:4:\"hide\";s:31:\"sidebar_position_ss_single_shop\";s:7:\"inherit\";s:24:\"sidebar_type_single_shop\";s:7:\"inherit\";s:13:\"services_form\";s:4:\"none\";s:27:\"single_product_gallery_zoom\";i:0;s:19:\"single_product_meta\";i:0;s:12:\"privacy_text\";s:92:\"I agree that my submitted data is being <a href=\"/privacy-policy/\">collected and stored</a>.\";s:9:\"logo_zoom\";s:1:\"1\";s:14:\"scheme_storage\";s:5399:\"a:3:{s:7:\"default\";a:3:{s:5:\"title\";s:7:\"Default\";s:8:\"internal\";b:1;s:6:\"colors\";a:51:{s:8:\"bg_color\";s:7:\"#F6F6F6\";s:8:\"bd_color\";s:7:\"#E2E2E2\";s:4:\"text\";s:7:\"#7A7E83\";s:10:\"text_light\";s:7:\"#A5A6AA\";s:9:\"text_dark\";s:7:\"#222733\";s:9:\"text_link\";s:7:\"#ff822e\";s:10:\"text_hover\";s:7:\"#FD4431\";s:10:\"text_link2\";s:7:\"#2F39D3\";s:11:\"text_hover2\";s:7:\"#222BB7\";s:10:\"text_link3\";s:7:\"#C5A48E\";s:11:\"text_hover3\";s:7:\"#AB8E7A\";s:14:\"alter_bg_color\";s:7:\"#ffffff\";s:14:\"alter_bg_hover\";s:7:\"#F9F9F9\";s:14:\"alter_bd_color\";s:7:\"#E2E2E2\";s:14:\"alter_bd_hover\";s:7:\"#DCDCDC\";s:10:\"alter_text\";s:7:\"#797C7F\";s:11:\"alter_light\";s:7:\"#A5A6AA\";s:10:\"alter_dark\";s:7:\"#222733\";s:10:\"alter_link\";s:7:\"#FF5B4A\";s:11:\"alter_hover\";s:7:\"#FD4431\";s:11:\"alter_link2\";s:7:\"#2F39D3\";s:12:\"alter_hover2\";s:7:\"#222BB7\";s:11:\"alter_link3\";s:7:\"#C5A48E\";s:12:\"alter_hover3\";s:7:\"#AB8E7A\";s:14:\"extra_bg_color\";s:7:\"#222733\";s:14:\"extra_bg_hover\";s:7:\"#3f3d47\";s:14:\"extra_bd_color\";s:7:\"#323641\";s:14:\"extra_bd_hover\";s:7:\"#575757\";s:10:\"extra_text\";s:7:\"#96999F\";s:11:\"extra_light\";s:7:\"#afafaf\";s:10:\"extra_dark\";s:7:\"#ffffff\";s:10:\"extra_link\";s:7:\"#FF5B4A\";s:11:\"extra_hover\";s:7:\"#ffffff\";s:11:\"extra_link2\";s:7:\"#80d572\";s:12:\"extra_hover2\";s:7:\"#8be77c\";s:11:\"extra_link3\";s:7:\"#ddb837\";s:12:\"extra_hover3\";s:7:\"#eec432\";s:14:\"input_bg_color\";s:11:\"transparent\";s:14:\"input_bg_hover\";s:11:\"transparent\";s:14:\"input_bd_color\";s:7:\"#E2E2E2\";s:14:\"input_bd_hover\";s:7:\"#222733\";s:10:\"input_text\";s:7:\"#A5A6AA\";s:11:\"input_light\";s:7:\"#A5A6AA\";s:10:\"input_dark\";s:7:\"#222733\";s:16:\"inverse_bd_color\";s:7:\"#67bcc1\";s:16:\"inverse_bd_hover\";s:7:\"#5aa4a9\";s:12:\"inverse_text\";s:7:\"#1d1d1d\";s:13:\"inverse_light\";s:7:\"#333333\";s:12:\"inverse_dark\";s:7:\"#222733\";s:12:\"inverse_link\";s:7:\"#ffffff\";s:13:\"inverse_hover\";s:7:\"#ffffff\";}}s:4:\"dark\";a:3:{s:5:\"title\";s:4:\"Dark\";s:8:\"internal\";b:1;s:6:\"colors\";a:51:{s:8:\"bg_color\";s:7:\"#2C313D\";s:8:\"bd_color\";s:7:\"#474B55\";s:4:\"text\";s:7:\"#D2D3D5\";s:10:\"text_light\";s:7:\"#96999F\";s:9:\"text_dark\";s:7:\"#F9F9F9\";s:9:\"text_link\";s:7:\"#FF5B4A\";s:10:\"text_hover\";s:7:\"#FD4431\";s:10:\"text_link2\";s:7:\"#2F39D3\";s:11:\"text_hover2\";s:7:\"#222BB7\";s:10:\"text_link3\";s:7:\"#C5A48E\";s:11:\"text_hover3\";s:7:\"#AB8E7A\";s:14:\"alter_bg_color\";s:7:\"#222733\";s:14:\"alter_bg_hover\";s:7:\"#2C313D\";s:14:\"alter_bd_color\";s:7:\"#474B55\";s:14:\"alter_bd_hover\";s:7:\"#53535C\";s:10:\"alter_text\";s:7:\"#D2D3D5\";s:11:\"alter_light\";s:7:\"#96999F\";s:10:\"alter_dark\";s:7:\"#F9F9F9\";s:10:\"alter_link\";s:7:\"#FF5B4A\";s:11:\"alter_hover\";s:7:\"#FD4431\";s:11:\"alter_link2\";s:7:\"#2F39D3\";s:12:\"alter_hover2\";s:7:\"#222BB7\";s:11:\"alter_link3\";s:7:\"#C5A48E\";s:12:\"alter_hover3\";s:7:\"#AB8E7A\";s:14:\"extra_bg_color\";s:7:\"#222733\";s:14:\"extra_bg_hover\";s:7:\"#3f3d47\";s:14:\"extra_bd_color\";s:7:\"#323641\";s:14:\"extra_bd_hover\";s:7:\"#575757\";s:10:\"extra_text\";s:7:\"#96999F\";s:11:\"extra_light\";s:7:\"#afafaf\";s:10:\"extra_dark\";s:7:\"#ffffff\";s:10:\"extra_link\";s:7:\"#FF5B4A\";s:11:\"extra_hover\";s:7:\"#ffffff\";s:11:\"extra_link2\";s:7:\"#80d572\";s:12:\"extra_hover2\";s:7:\"#8be77c\";s:11:\"extra_link3\";s:7:\"#ddb837\";s:12:\"extra_hover3\";s:7:\"#eec432\";s:14:\"input_bg_color\";s:11:\"transparent\";s:14:\"input_bg_hover\";s:11:\"transparent\";s:14:\"input_bd_color\";s:7:\"#474B55\";s:14:\"input_bd_hover\";s:7:\"#474B55\";s:10:\"input_text\";s:7:\"#D2D3D5\";s:11:\"input_light\";s:7:\"#D2D3D5\";s:10:\"input_dark\";s:7:\"#ffffff\";s:16:\"inverse_bd_color\";s:7:\"#e36650\";s:16:\"inverse_bd_hover\";s:7:\"#cb5b47\";s:12:\"inverse_text\";s:7:\"#F9F9F9\";s:13:\"inverse_light\";s:7:\"#6f6f6f\";s:12:\"inverse_dark\";s:7:\"#222733\";s:12:\"inverse_link\";s:7:\"#ffffff\";s:13:\"inverse_hover\";s:7:\"#222733\";}}s:5:\"light\";a:3:{s:5:\"title\";s:5:\"Light\";s:8:\"internal\";b:1;s:6:\"colors\";a:51:{s:8:\"bg_color\";s:7:\"#ffffff\";s:8:\"bd_color\";s:7:\"#E2E2E2\";s:4:\"text\";s:7:\"#7A7E83\";s:10:\"text_light\";s:7:\"#A5A6AA\";s:9:\"text_dark\";s:7:\"#222733\";s:9:\"text_link\";s:7:\"#FF5B4A\";s:10:\"text_hover\";s:7:\"#FD4431\";s:10:\"text_link2\";s:7:\"#2F39D3\";s:11:\"text_hover2\";s:7:\"#222BB7\";s:10:\"text_link3\";s:7:\"#C5A48E\";s:11:\"text_hover3\";s:7:\"#AB8E7A\";s:14:\"alter_bg_color\";s:7:\"#F6F6F6\";s:14:\"alter_bg_hover\";s:7:\"#ffffff\";s:14:\"alter_bd_color\";s:7:\"#E2E2E2\";s:14:\"alter_bd_hover\";s:7:\"#DCDCDC\";s:10:\"alter_text\";s:7:\"#797C7F\";s:11:\"alter_light\";s:7:\"#A5A6AA\";s:10:\"alter_dark\";s:7:\"#222733\";s:10:\"alter_link\";s:7:\"#FF5B4A\";s:11:\"alter_hover\";s:7:\"#FD4431\";s:11:\"alter_link2\";s:7:\"#2F39D3\";s:12:\"alter_hover2\";s:7:\"#222BB7\";s:11:\"alter_link3\";s:7:\"#C5A48E\";s:12:\"alter_hover3\";s:7:\"#AB8E7A\";s:14:\"extra_bg_color\";s:7:\"#222733\";s:14:\"extra_bg_hover\";s:7:\"#3f3d47\";s:14:\"extra_bd_color\";s:7:\"#323641\";s:14:\"extra_bd_hover\";s:7:\"#575757\";s:10:\"extra_text\";s:7:\"#96999F\";s:11:\"extra_light\";s:7:\"#afafaf\";s:10:\"extra_dark\";s:7:\"#ffffff\";s:10:\"extra_link\";s:7:\"#FF5B4A\";s:11:\"extra_hover\";s:7:\"#ffffff\";s:11:\"extra_link2\";s:7:\"#80d572\";s:12:\"extra_hover2\";s:7:\"#8be77c\";s:11:\"extra_link3\";s:7:\"#ddb837\";s:12:\"extra_hover3\";s:7:\"#eec432\";s:14:\"input_bg_color\";s:11:\"transparent\";s:14:\"input_bg_hover\";s:11:\"transparent\";s:14:\"input_bd_color\";s:7:\"#E2E2E2\";s:14:\"input_bd_hover\";s:7:\"#222733\";s:10:\"input_text\";s:7:\"#A5A6AA\";s:11:\"input_light\";s:7:\"#A5A6AA\";s:10:\"input_dark\";s:7:\"#222733\";s:16:\"inverse_bd_color\";s:7:\"#67bcc1\";s:16:\"inverse_bd_hover\";s:7:\"#5aa4a9\";s:12:\"inverse_text\";s:7:\"#1d1d1d\";s:13:\"inverse_light\";s:7:\"#333333\";s:12:\"inverse_dark\";s:7:\"#222733\";s:12:\"inverse_link\";s:7:\"#ffffff\";s:13:\"inverse_hover\";s:7:\"#ffffff\";}}}\";s:10:\"page_width\";i:1260;}", "on");
INSERT INTO `wptr_options` VALUES("172", "theme_switched", "", "auto");
INSERT INTO `wptr_options` VALUES("1517", "_transient_timeout_qwery_list_skins", "1735555242", "off");
INSERT INTO `wptr_options` VALUES("1518", "_transient_qwery_list_skins", "a:104:{s:7:\"default\";a:7:{s:5:\"title\";s:7:\"Default\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"3.4\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:25:\"//qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-12-06\";s:7:\"checked\";s:19:\"2024-12-28 09:27:41\";}s:7:\"florist\";a:7:{s:5:\"title\";s:7:\"Florist\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:30:\"business,creative,online store\";s:8:\"demo_url\";s:33:\"//florist.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:51:33\";s:7:\"updated\";s:10:\"2024-12-23\";}s:6:\"lawyer\";a:7:{s:5:\"title\";s:6:\"Lawyer\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:32:\"//lawyer.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:51:50\";s:7:\"updated\";s:10:\"2024-10-31\";}s:6:\"luxury\";a:7:{s:5:\"title\";s:6:\"Luxury\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:21:\"online store,creative\";s:8:\"demo_url\";s:32:\"//luxury.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:51:56\";s:7:\"updated\";s:10:\"2024-10-18\";}s:4:\"yoga\";a:8:{s:5:\"title\";s:4:\"Yoga\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:33:\"business,health,blog,online store\";s:8:\"demo_url\";s:29:\"//yoga.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:03:55\";s:7:\"updated\";s:10:\"2024-05-03\";s:14:\"update_started\";i:1714746274;}s:11:\"engineering\";a:7:{s:5:\"title\";s:11:\"Engineering\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:13:\"business,blog\";s:8:\"demo_url\";s:37:\"//engineering.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:09:49\";s:7:\"updated\";s:10:\"2024-08-07\";}s:7:\"dentist\";a:7:{s:5:\"title\";s:7:\"Dentist\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:37:\"business,services,health,online store\";s:8:\"demo_url\";s:32:\"//dentist.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:10:43\";s:7:\"updated\";s:10:\"2024-04-23\";}s:9:\"lifecoach\";a:7:{s:5:\"title\";s:9:\"Lifecoach\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:35:\"//lifecoach.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:11:12\";s:7:\"updated\";s:10:\"2024-12-02\";}s:11:\"hairdresser\";a:7:{s:5:\"title\";s:11:\"Hairdresser\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:39:\"business,services,creative,online store\";s:8:\"demo_url\";s:37:\"//hairdresser.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:11:12\";s:7:\"updated\";s:10:\"2024-08-21\";}s:10:\"barbershop\";a:8:{s:5:\"title\";s:10:\"Barbershop\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.3\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:36:\"//barbershop.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:19:41\";s:7:\"updated\";s:10:\"2024-08-06\";s:14:\"update_started\";i:1718098333;}s:7:\"roofing\";a:7:{s:5:\"title\";s:7:\"Roofing\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:32:\"//roofing.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:20:06\";s:7:\"updated\";s:10:\"2024-05-22\";}s:8:\"flooring\";a:7:{s:5:\"title\";s:8:\"Flooring\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.3\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:34:\"//flooring.qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-11-21\";s:7:\"checked\";s:19:\"2024-12-28 09:25:56\";}s:9:\"dietitian\";a:7:{s:5:\"title\";s:9:\"Dietitian\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:20:\"health,services,blog\";s:8:\"demo_url\";s:34:\"//dietitian.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:35:50\";s:7:\"updated\";s:10:\"2024-04-25\";}s:7:\"massage\";a:7:{s:5:\"title\";s:7:\"Massage\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.1\";s:8:\"category\";s:37:\"business,services,online store,health\";s:8:\"demo_url\";s:33:\"//massage.qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-10-17\";s:7:\"checked\";s:19:\"2024-12-28 09:51:56\";}s:5:\"music\";a:7:{s:5:\"title\";s:5:\"music\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:26:\"creative,online store,blog\";s:8:\"demo_url\";s:30:\"//music.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:51:56\";s:7:\"updated\";s:10:\"2024-12-17\";}s:6:\"church\";a:8:{s:5:\"title\";s:6:\"Church\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:22:\"creative,services,blog\";s:8:\"demo_url\";s:32:\"//church.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:51:56\";s:7:\"updated\";s:10:\"2024-05-31\";s:14:\"update_started\";i:1717152304;}s:6:\"tailor\";a:7:{s:5:\"title\";s:6:\"Tailor\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:39:\"business,services,online store,creative\";s:8:\"demo_url\";s:31:\"//tailor.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:27:42\";s:7:\"updated\";s:10:\"2024-05-07\";}s:7:\"fitness\";a:7:{s:5:\"title\";s:7:\"Fitness\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:20:\"health,services,blog\";s:8:\"demo_url\";s:32:\"//fitness.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:51:56\";s:7:\"updated\";s:10:\"2024-09-10\";}s:5:\"nails\";a:7:{s:5:\"title\";s:5:\"Nails\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:31:\"//nails.qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-10-09\";s:7:\"checked\";s:19:\"2024-12-28 09:51:56\";}s:7:\"medical\";a:8:{s:5:\"title\";s:7:\"Medical\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.1\";s:8:\"category\";s:20:\"health,services,blog\";s:8:\"demo_url\";s:33:\"//medical.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:51:57\";s:7:\"updated\";s:10:\"2024-10-03\";s:14:\"update_started\";i:1727967150;}s:7:\"speaker\";a:7:{s:5:\"title\";s:7:\"Speaker\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:26:\"business,blog,online store\";s:8:\"demo_url\";s:32:\"//speaker.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:08\";s:7:\"updated\";s:10:\"2024-09-12\";}s:9:\"architect\";a:7:{s:5:\"title\";s:9:\"Architect\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:39:\"business,services,online store,creative\";s:8:\"demo_url\";s:34:\"//architect.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:08\";s:7:\"updated\";s:10:\"2024-09-30\";}s:10:\"restaurant\";a:7:{s:5:\"title\";s:10:\"Restaurant\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.1\";s:8:\"category\";s:8:\"business\";s:8:\"demo_url\";s:35:\"//restaurant.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:08\";s:7:\"updated\";s:10:\"2024-09-16\";}s:8:\"catering\";a:7:{s:5:\"title\";s:8:\"Catering\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:33:\"//catering.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:08\";s:7:\"updated\";s:10:\"2024-04-15\";}s:9:\"corporate\";a:7:{s:5:\"title\";s:9:\"Corporate\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.8\";s:8:\"category\";s:22:\"creative,business,blog\";s:8:\"demo_url\";s:35:\"//corporate.qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-04-24\";s:7:\"checked\";s:19:\"2024-12-28 09:52:08\";}s:9:\"elearning\";a:7:{s:5:\"title\";s:9:\"ELearning\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.3\";s:8:\"category\";s:30:\"business,online store,creative\";s:8:\"demo_url\";s:35:\"//elearning.qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-12-27\";s:7:\"checked\";s:19:\"2024-12-28 09:52:18\";}s:5:\"hotel\";a:7:{s:5:\"title\";s:5:\"Hotel\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.1\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:30:\"//hotel.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:40\";s:7:\"updated\";s:10:\"2024-10-02\";}s:7:\"fashion\";a:7:{s:5:\"title\";s:7:\"Fashion\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:30:\"business,creative,online store\";s:8:\"demo_url\";s:32:\"//fashion.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:41\";s:7:\"updated\";s:10:\"2024-08-30\";}s:9:\"education\";a:7:{s:5:\"title\";s:9:\"Education\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:13:\"services,blog\";s:8:\"demo_url\";s:35:\"//education.qwery.ancorathemes.com/\";s:7:\"updated\";s:10:\"2024-04-01\";s:7:\"checked\";s:19:\"2024-12-28 09:52:41\";}s:8:\"personal\";a:7:{s:5:\"title\";s:8:\"Personal\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:22:\"creative,services,blog\";s:8:\"demo_url\";s:33:\"//personal.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:55:50\";s:7:\"updated\";s:10:\"2024-10-28\";}s:11:\"agriculture\";a:7:{s:5:\"title\";s:11:\"Agriculture\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.8\";s:8:\"category\";s:26:\"business,online store,blog\";s:8:\"demo_url\";s:36:\"//agriculture.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:55:50\";s:7:\"updated\";s:10:\"2024-09-12\";}s:12:\"photographer\";a:7:{s:5:\"title\";s:12:\"Photographer\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:26:\"services,creative,business\";s:8:\"demo_url\";s:37:\"//photographer.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:55:57\";s:7:\"updated\";s:10:\"2024-07-24\";}s:9:\"craftsman\";a:7:{s:5:\"title\";s:9:\"Craftsman\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.8\";s:8:\"category\";s:21:\"creative,online store\";s:8:\"demo_url\";s:34:\"//craftsman.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:55:57\";s:7:\"updated\";s:10:\"2024-09-25\";}s:8:\"designer\";a:7:{s:5:\"title\";s:8:\"Designer\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:22:\"creative,services,blog\";s:8:\"demo_url\";s:33:\"//designer.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:55:57\";s:7:\"updated\";s:10:\"2024-03-22\";}s:12:\"pet-grooming\";a:7:{s:5:\"title\";s:12:\"Pet Grooming\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:37:\"//pet-grooming.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 08:57:51\";s:7:\"updated\";s:10:\"2024-04-18\";}s:6:\"travel\";a:7:{s:5:\"title\";s:6:\"Travel\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:26:\"creative,online store,blog\";s:8:\"demo_url\";s:31:\"//travel.qwery.ancorathemes.com\";s:7:\"updated\";s:10:\"2024-06-06\";s:7:\"checked\";s:19:\"2024-12-28 09:00:50\";}s:9:\"logistics\";a:7:{s:5:\"title\";s:9:\"Logistics\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:8:\"business\";s:8:\"demo_url\";s:34:\"//logistics.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:02:09\";s:7:\"updated\";s:10:\"2024-10-29\";}s:11:\"dermatology\";a:7:{s:5:\"title\";s:11:\"Dermatology\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:33:\"health,services,blog,online store\";s:8:\"demo_url\";s:37:\"//dermatology.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:27:42\";s:7:\"updated\";s:10:\"2024-10-21\";}s:15:\"creative-agency\";a:7:{s:5:\"title\";s:15:\"Creative Agency\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:31:\"creative,business,services,blog\";s:8:\"demo_url\";s:40:\"//creative-agency.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:32:09\";s:7:\"updated\";s:10:\"2024-10-11\";}s:12:\"psychologist\";a:7:{s:5:\"title\";s:12:\"Psychologist\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:20:\"health,services,blog\";s:8:\"demo_url\";s:37:\"//psychologist.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:32:22\";s:7:\"updated\";s:10:\"2024-05-01\";}s:7:\"charity\";a:7:{s:5:\"title\";s:7:\"Charity\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:24:\"health,blog,online store\";s:8:\"demo_url\";s:33:\"//charity.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:02:09\";s:7:\"updated\";s:10:\"2024-11-26\";}s:6:\"winery\";a:8:{s:5:\"title\";s:6:\"Winery\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:26:\"creative,online store,blog\";s:8:\"demo_url\";s:31:\"//winery.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:03:55\";s:7:\"updated\";s:10:\"2024-09-16\";s:14:\"update_started\";i:1724339153;}s:3:\"seo\";a:7:{s:5:\"title\";s:3:\"Seo\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:26:\"business,services,creative\";s:8:\"demo_url\";s:28:\"//seo.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:03:56\";s:7:\"updated\";s:10:\"2024-12-25\";}s:10:\"elder-care\";a:7:{s:5:\"title\";s:10:\"Elder Care\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:15:\"health,services\";s:8:\"demo_url\";s:36:\"//elder-care.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:33:24\";s:7:\"updated\";s:10:\"2024-11-01\";}s:8:\"mechanic\";a:7:{s:5:\"title\";s:8:\"Mechanic\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:33:\"//mechanic.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:41\";s:7:\"updated\";s:10:\"2024-06-19\";}s:20:\"portfolio-fullscreen\";a:7:{s:5:\"title\";s:20:\"Portfolio Fullscreen\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:22:\"creative,services,blog\";s:8:\"demo_url\";s:45:\"//portfolio-fullscreen.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:41\";s:7:\"updated\";s:10:\"2024-07-09\";}s:14:\"cryptocurrency\";a:7:{s:5:\"title\";s:14:\"Cryptocurrency\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:31:\"business,services,creative,blog\";s:8:\"demo_url\";s:40:\"//cryptocurrency.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:52:44\";s:7:\"updated\";s:10:\"2024-07-12\";}s:11:\"woodworking\";a:7:{s:5:\"title\";s:11:\"Woodworking\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.8\";s:8:\"category\";s:22:\"business,services,blog\";s:8:\"demo_url\";s:36:\"//woodworking.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:44\";s:7:\"updated\";s:10:\"2024-11-05\";}s:12:\"phone-repair\";a:7:{s:5:\"title\";s:12:\"Phone Repair\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:37:\"//phone-repair.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:44\";s:7:\"updated\";s:10:\"2024-07-29\";}s:15:\"plastic-surgeon\";a:7:{s:5:\"title\";s:15:\"Plastic Surgeon\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:24:\"business,services,health\";s:8:\"demo_url\";s:41:\"//plastic-surgeon.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:52:44\";s:7:\"updated\";s:10:\"2024-11-08\";}s:8:\"military\";a:7:{s:5:\"title\";s:8:\"Military\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:26:\"services,online store,blog\";s:8:\"demo_url\";s:34:\"//military.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:52:44\";s:7:\"updated\";s:10:\"2024-12-04\";}s:6:\"yachts\";a:7:{s:5:\"title\";s:6:\"Yachts\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.8\";s:8:\"category\";s:35:\"business,services,online store,blog\";s:8:\"demo_url\";s:32:\"//yachts.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:12:03\";s:7:\"updated\";s:10:\"2024-04-26\";}s:12:\"pet-supplies\";a:7:{s:5:\"title\";s:12:\"Pet Supplies\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:26:\"business,online store,blog\";s:8:\"demo_url\";s:37:\"//pet-supplies.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:13:09\";s:7:\"updated\";s:10:\"2024-11-25\";}s:7:\"glasses\";a:7:{s:5:\"title\";s:7:\"Glasses\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:30:\"business,creative,online store\";s:8:\"demo_url\";s:32:\"//glasses.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:15:26\";s:7:\"updated\";s:10:\"2024-12-24\";}s:12:\"pest-control\";a:8:{s:5:\"title\";s:12:\"Pest Control\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:30:\"business,online store,services\";s:8:\"demo_url\";s:37:\"//pest-control.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-07-23\";s:7:\"checked\";s:19:\"2024-12-28 09:20:06\";s:7:\"updated\";s:10:\"2024-07-19\";}s:17:\"portfolio-stacked\";a:8:{s:5:\"title\";s:17:\"Portfolio Stacked\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:22:\"creative,services,blog\";s:8:\"demo_url\";s:42:\"//portfolio-stacked.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-07-30\";s:7:\"checked\";s:19:\"2024-12-28 09:27:57\";s:7:\"updated\";s:10:\"2024-06-17\";}s:16:\"personal-stylist\";a:8:{s:5:\"title\";s:16:\"Personal Stylist\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:26:\"services,online store,blog\";s:8:\"demo_url\";s:41:\"//personal-stylist.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-08-05\";s:7:\"checked\";s:19:\"2024-12-28 09:52:52\";s:7:\"updated\";s:10:\"2024-06-03\";}s:11:\"bike-repair\";a:9:{s:5:\"title\";s:11:\"Bike Repair\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.1\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:36:\"//bike-repair.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-08-12\";s:7:\"checked\";s:19:\"2024-12-28 09:52:52\";s:7:\"updated\";s:10:\"2024-08-02\";s:14:\"update_started\";i:1722596180;}s:10:\"accountant\";a:7:{s:5:\"title\";s:10:\"Accountant\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:35:\"//accountant.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:54\";s:7:\"updated\";s:10:\"2024-10-23\";}s:7:\"ecology\";a:7:{s:5:\"title\";s:7:\"Ecology\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"2.2\";s:8:\"category\";s:24:\"health,blog,online store\";s:8:\"demo_url\";s:33:\"//ecology.qwery.ancorathemes.com/\";s:7:\"checked\";s:19:\"2024-12-28 09:52:54\";s:7:\"updated\";s:10:\"2024-08-01\";}s:16:\"air-conditioning\";a:7:{s:5:\"title\";s:16:\"Air Conditioning\";s:11:\"description\";s:0:\"\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:41:\"//air-conditioning.qwery.ancorathemes.com\";s:7:\"checked\";s:19:\"2024-12-28 09:52:54\";s:7:\"updated\";s:10:\"2024-09-05\";}s:15:\"product-landing\";a:7:{s:5:\"title\";s:15:\"Product Landing\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:31:\"business,online store, services\";s:8:\"demo_url\";s:40:\"//product-landing.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-09-10\";s:7:\"updated\";s:10:\"2024-10-04\";s:7:\"checked\";s:19:\"2024-12-28 09:52:54\";}s:6:\"bakery\";a:7:{s:5:\"title\";s:6:\"Bakery\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:39:\"business,services,online store,creative\";s:8:\"demo_url\";s:31:\"//bakery.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-09-17\";s:7:\"updated\";s:10:\"2024-06-21\";s:7:\"checked\";s:19:\"2024-12-28 09:53:07\";}s:4:\"saas\";a:8:{s:5:\"title\";s:4:\"SaaS\";s:7:\"version\";s:3:\"2.4\";s:8:\"category\";s:31:\"business,services,blog,creative\";s:8:\"demo_url\";s:30:\"//saas.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-09-30\";s:7:\"updated\";s:10:\"2024-08-15\";s:7:\"checked\";s:19:\"2024-12-28 09:53:07\";s:14:\"update_started\";i:1723746687;}s:11:\"electrician\";a:7:{s:5:\"title\";s:11:\"Electrician\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:37:\"//electrician.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-10-01\";s:7:\"updated\";s:10:\"2024-07-03\";s:7:\"checked\";s:19:\"2024-12-28 09:53:07\";}s:14:\"portfolio-dark\";a:7:{s:5:\"title\";s:14:\"Portfolio Dark\";s:7:\"version\";s:3:\"2.1\";s:8:\"category\";s:22:\"services,creative,blog\";s:8:\"demo_url\";s:40:\"//portfolio-dark.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-10-14\";s:7:\"updated\";s:10:\"2024-08-28\";s:7:\"checked\";s:19:\"2024-12-28 09:53:07\";}s:9:\"cosmetics\";a:7:{s:5:\"title\";s:9:\"Cosmetics\";s:7:\"version\";s:3:\"2.0\";s:8:\"category\";s:29:\"business,services,health,blog\";s:8:\"demo_url\";s:35:\"//cosmetics.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-10-27\";s:7:\"updated\";s:10:\"2024-10-07\";s:7:\"checked\";s:19:\"2024-12-28 09:53:32\";}s:18:\"italian-restaurant\";a:7:{s:5:\"title\";s:12:\"Restaurant 2\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:8:\"business\";s:8:\"demo_url\";s:43:\"//italian-restaurant.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-10-28\";s:7:\"updated\";s:10:\"2024-06-26\";s:7:\"checked\";s:19:\"2024-12-28 09:53:32\";}s:5:\"solar\";a:7:{s:5:\"title\";s:5:\"Solar\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:30:\"//solar.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-11-05\";s:7:\"updated\";s:10:\"2024-10-23\";s:7:\"checked\";s:19:\"2024-12-28 09:54:17\";}s:11:\"sports-shop\";a:7:{s:5:\"title\";s:11:\"Sports Shop\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:36:\"//sports-shop.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2021-11-09\";s:7:\"updated\";s:10:\"2024-05-24\";s:7:\"checked\";s:19:\"2024-12-28 09:54:17\";}s:9:\"gardening\";a:7:{s:5:\"title\";s:9:\"gardening\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:35:\"//gardening.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-11-19\";s:7:\"updated\";s:10:\"2024-12-18\";s:7:\"checked\";s:19:\"2024-12-28 09:54:18\";}s:8:\"creative\";a:7:{s:5:\"title\";s:8:\"Creative\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:26:\"creative,online store,blog\";s:8:\"demo_url\";s:34:\"//creative.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-11-23\";s:7:\"updated\";s:10:\"2024-08-28\";s:7:\"checked\";s:19:\"2024-12-28 09:54:18\";}s:8:\"pet-shop\";a:7:{s:5:\"title\";s:8:\"Pet Shop\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:35:\"blog,business,services,online store\";s:8:\"demo_url\";s:34:\"//pet-shop.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-12-06\";s:7:\"updated\";s:10:\"2024-07-26\";s:7:\"checked\";s:19:\"2024-12-28 09:54:18\";}s:9:\"portfolio\";a:7:{s:5:\"title\";s:9:\"Portfolio\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:22:\"creative,services,blog\";s:8:\"demo_url\";s:35:\"//portfolio.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-12-08\";s:7:\"updated\";s:10:\"2024-09-27\";s:7:\"checked\";s:19:\"2024-12-28 09:54:31\";}s:18:\"advertising-agency\";a:7:{s:5:\"title\";s:18:\"Advertising Agency\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:26:\"business,services,creative\";s:8:\"demo_url\";s:44:\"//advertising-agency.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2021-12-16\";s:7:\"updated\";s:10:\"2024-11-27\";s:7:\"checked\";s:19:\"2024-12-28 09:54:31\";}s:10:\"freelancer\";a:7:{s:5:\"title\";s:10:\"Freelancer\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:26:\"creative,services,business\";s:8:\"demo_url\";s:36:\"//freelancer.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-01-21\";s:7:\"updated\";s:10:\"2024-09-25\";s:7:\"checked\";s:19:\"2024-12-28 09:54:31\";}s:18:\"creative-portfolio\";a:7:{s:5:\"title\";s:18:\"Creative Portfolio\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:26:\"business,services,creative\";s:8:\"demo_url\";s:44:\"//creative-portfolio.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-01-28\";s:7:\"updated\";s:10:\"2024-09-09\";s:7:\"checked\";s:19:\"2024-12-28 09:54:31\";}s:16:\"concerts-tickets\";a:7:{s:5:\"title\";s:18:\"Concerts & Tickets\";s:7:\"version\";s:3:\"1.3\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:42:\"//concerts-tickets.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-02-11\";s:7:\"updated\";s:10:\"2024-07-17\";s:7:\"checked\";s:19:\"2024-12-28 09:54:32\";}s:7:\"courses\";a:7:{s:5:\"title\";s:7:\"Courses\";s:7:\"version\";s:3:\"1.9\";s:8:\"category\";s:30:\"services,online store,business\";s:8:\"demo_url\";s:33:\"//courses.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-02-23\";s:7:\"updated\";s:10:\"2024-12-02\";s:7:\"checked\";s:19:\"2024-12-28 09:54:40\";}s:14:\"transportation\";a:7:{s:5:\"title\";s:14:\"Transportation\";s:7:\"version\";s:3:\"1.3\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:40:\"//transportation.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-03-28\";s:7:\"updated\";s:10:\"2024-07-31\";s:7:\"checked\";s:19:\"2024-12-28 09:54:41\";}s:3:\"nft\";a:7:{s:5:\"title\";s:3:\"NFT\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:26:\"business,online store,blog\";s:8:\"demo_url\";s:29:\"//nft.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-04-05\";s:7:\"updated\";s:10:\"2024-09-06\";s:7:\"checked\";s:19:\"2024-12-28 09:54:41\";}s:13:\"blog-creative\";a:7:{s:5:\"title\";s:13:\"Blog Creative\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:13:\"blog,creative\";s:8:\"demo_url\";s:38:\"//blog-creative.qwery.ancorathemes.com\";s:8:\"uploaded\";s:10:\"2022-05-05\";s:7:\"updated\";s:10:\"2024-08-19\";s:7:\"checked\";s:19:\"2024-12-28 09:54:43\";}s:8:\"cleaning\";a:7:{s:5:\"title\";s:8:\"Cleaning\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:34:\"//cleaning.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-05-17\";s:7:\"updated\";s:10:\"2024-08-20\";s:7:\"checked\";s:19:\"2024-12-28 09:55:21\";}s:15:\"interior-design\";a:7:{s:5:\"title\";s:15:\"Interior Design\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:35:\"creative,blog,online store,services\";s:8:\"demo_url\";s:41:\"//interior-design.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-05-25\";s:7:\"updated\";s:10:\"2024-07-05\";s:7:\"checked\";s:19:\"2024-12-28 09:55:22\";}s:18:\"vaccination-center\";a:7:{s:5:\"title\";s:18:\"Vaccination Center\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:15:\"business,health\";s:8:\"demo_url\";s:44:\"//vaccination-center.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-06-03\";s:7:\"updated\";s:10:\"2024-09-13\";s:7:\"checked\";s:19:\"2024-12-28 09:55:58\";}s:12:\"construction\";a:7:{s:5:\"title\";s:12:\"Construction\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:22:\"business,services,blog\";s:8:\"demo_url\";s:38:\"//construction.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-06-14\";s:7:\"updated\";s:10:\"2024-08-15\";s:7:\"checked\";s:19:\"2024-12-28 09:55:58\";}s:14:\"blog-fullwidth\";a:7:{s:5:\"title\";s:14:\"Blog Fullwidth\";s:7:\"version\";s:3:\"1.3\";s:8:\"category\";s:13:\"blog,creative\";s:8:\"demo_url\";s:40:\"//blog-fullwidth.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-06-24\";s:7:\"updated\";s:10:\"2024-07-30\";s:7:\"checked\";s:19:\"2024-12-28 09:56:48\";}s:14:\"driving-school\";a:7:{s:5:\"title\";s:14:\"Driving School\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:13:\"services,blog\";s:8:\"demo_url\";s:40:\"//driving-school.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-06-28\";s:7:\"updated\";s:10:\"2024-09-02\";s:7:\"checked\";s:19:\"2024-12-28 09:57:33\";}s:17:\"insurance-company\";a:7:{s:5:\"title\";s:17:\"Insurance Company\";s:7:\"version\";s:3:\"1.6\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:43:\"//insurance-company.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-07-12\";s:7:\"updated\";s:10:\"2024-08-26\";s:7:\"checked\";s:19:\"2024-12-28 09:57:33\";}s:5:\"lgbtq\";a:7:{s:5:\"title\";s:5:\"lgbtq\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:26:\"blog,online store,creative\";s:8:\"demo_url\";s:31:\"//lgbtq.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-07-22\";s:7:\"updated\";s:10:\"2024-12-20\";s:7:\"checked\";s:19:\"2024-12-28 09:57:33\";}s:8:\"pharmacy\";a:7:{s:5:\"title\";s:8:\"Pharmacy\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:28:\"business,health,online store\";s:8:\"demo_url\";s:34:\"//pharmacy.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-07-29\";s:7:\"updated\";s:10:\"2024-08-14\";s:7:\"checked\";s:19:\"2024-12-28 09:57:50\";}s:7:\"laundry\";a:7:{s:5:\"title\";s:7:\"Laundry\";s:7:\"version\";s:3:\"1.3\";s:8:\"category\";s:17:\"business,services\";s:8:\"demo_url\";s:33:\"//laundry.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-08-05\";s:7:\"updated\";s:10:\"2024-09-20\";s:7:\"checked\";s:19:\"2024-12-28 09:57:50\";}s:8:\"festival\";a:7:{s:5:\"title\";s:8:\"Festival\";s:7:\"version\";s:3:\"1.5\";s:8:\"category\";s:39:\"business,services,creative,online store\";s:8:\"demo_url\";s:34:\"//festival.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-08-12\";s:7:\"updated\";s:10:\"2024-10-01\";s:7:\"checked\";s:19:\"2024-12-28 09:57:50\";}s:10:\"laboratory\";a:7:{s:5:\"title\";s:10:\"Laboratory\";s:7:\"version\";s:3:\"1.4\";s:8:\"category\";s:37:\"business,services,online store,health\";s:8:\"demo_url\";s:36:\"//laboratory.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-08-18\";s:7:\"updated\";s:10:\"2024-09-24\";s:7:\"checked\";s:19:\"2024-12-28 09:58:17\";}s:14:\"retreat-center\";a:7:{s:5:\"title\";s:14:\"Retreat Center\";s:7:\"version\";s:3:\"1.2\";s:8:\"category\";s:24:\"creative,services,health\";s:8:\"demo_url\";s:40:\"//retreat-center.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-08-26\";s:7:\"updated\";s:10:\"2024-05-09\";s:7:\"checked\";s:19:\"2024-12-28 09:58:40\";}s:17:\"nature-protection\";a:7:{s:5:\"title\";s:17:\"Nature Protection\";s:7:\"version\";s:3:\"1.2\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:43:\"//nature-protection.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-09-06\";s:7:\"updated\";s:10:\"2024-05-17\";s:7:\"checked\";s:19:\"2024-12-28 09:58:41\";}s:7:\"finance\";a:7:{s:5:\"title\";s:7:\"Finance\";s:7:\"version\";s:3:\"1.7\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:33:\"//finance.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-09-16\";s:7:\"updated\";s:10:\"2024-07-23\";s:7:\"checked\";s:19:\"2024-12-28 09:58:41\";}s:15:\"astrology-tarot\";a:7:{s:5:\"title\";s:17:\"Astrology & Tarot\";s:7:\"version\";s:3:\"1.2\";s:8:\"category\";s:30:\"creative,services,online store\";s:8:\"demo_url\";s:41:\"//astrology-tarot.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-10-03\";s:7:\"updated\";s:10:\"2024-05-21\";s:7:\"checked\";s:19:\"2024-12-28 09:58:41\";}s:6:\"museum\";a:7:{s:5:\"title\";s:6:\"Museum\";s:7:\"version\";s:3:\"1.2\";s:8:\"category\";s:35:\"creative,online store,business,blog\";s:8:\"demo_url\";s:32:\"//museum.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-10-21\";s:7:\"updated\";s:10:\"2024-04-10\";s:7:\"checked\";s:19:\"2024-12-28 09:58:41\";}s:10:\"conference\";a:7:{s:5:\"title\";s:10:\"Conference\";s:7:\"version\";s:3:\"1.3\";s:8:\"category\";s:22:\"creative,blog,business\";s:8:\"demo_url\";s:36:\"//conference.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2022-11-02\";s:7:\"updated\";s:10:\"2024-10-24\";s:7:\"checked\";s:19:\"2024-12-28 09:58:44\";}s:23:\"artificial-intelligence\";a:7:{s:5:\"title\";s:23:\"artificial-intelligence\";s:7:\"version\";s:3:\"2.5\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:49:\"//artificial-intelligence.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2023-01-27\";s:7:\"updated\";s:10:\"2024-12-19\";s:7:\"checked\";s:19:\"2024-12-28 08:57:51\";}s:6:\"sports\";a:8:{s:5:\"title\";s:6:\"Sports\";s:7:\"version\";s:3:\"1.2\";s:8:\"category\";s:42:\"business,blog,creative,health,online store\";s:8:\"demo_url\";s:32:\"//sports.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2024-01-22\";s:7:\"updated\";s:10:\"2024-08-16\";s:7:\"checked\";s:19:\"2024-12-28 08:57:55\";s:14:\"update_started\";i:1723800139;}s:4:\"cars\";a:7:{s:5:\"title\";s:4:\"Cars\";s:7:\"version\";s:3:\"1.1\";s:8:\"category\";s:30:\"business,services,online store\";s:8:\"demo_url\";s:30:\"//cars.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2024-06-25\";s:7:\"updated\";s:10:\"2024-06-27\";s:7:\"checked\";s:19:\"2024-12-28 08:57:55\";}s:20:\"kindergarten-daycare\";a:7:{s:5:\"title\";s:22:\"Kindergarten & Daycare\";s:7:\"version\";s:3:\"1.0\";s:8:\"category\";s:33:\"blog,health,online store,services\";s:8:\"demo_url\";s:46:\"//kindergarten-daycare.qwery.ancorathemes.com/\";s:8:\"uploaded\";s:10:\"2024-07-23\";s:7:\"updated\";s:10:\"2024-07-23\";s:7:\"checked\";s:19:\"2024-12-28 08:57:55\";}}", "off");
INSERT INTO `wptr_options` VALUES("135", "WPLANG", "en_GB", "auto");
INSERT INTO `wptr_options` VALUES("137", "_site_transient_timeout_browser_0845b309c7b9b957afd9ecf775a4c21f", "1735811785", "off");
INSERT INTO `wptr_options` VALUES("138", "_site_transient_browser_0845b309c7b9b957afd9ecf775a4c21f", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"131.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wptr_options` VALUES("139", "_site_transient_timeout_php_check_b8fa35562cc6ad42f9f2aa9b9acff9e3", "1735811786", "off");
INSERT INTO `wptr_options` VALUES("140", "_site_transient_php_check_b8fa35562cc6ad42f9f2aa9b9acff9e3", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wptr_options` VALUES("1434", "_transient_timeout_wc_report_orders_stats_81e602669187e0d5fe1528df45f9418a", "1735955663", "off");
INSERT INTO `wptr_options` VALUES("1435", "_transient_wc_report_orders_stats_81e602669187e0d5fe1528df45f9418a", "a:2:{s:7:\"version\";s:10:\"1735216731\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:5:{i:0;a:6:{s:8:\"interval\";s:7:\"2024-52\";s:10:\"date_start\";s:19:\"2024-12-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2024-12-23 00:00:00\";s:8:\"date_end\";s:19:\"2024-12-28 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2024-12-28 23:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:7:\"2024-51\";s:10:\"date_start\";s:19:\"2024-12-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2024-12-16 00:00:00\";s:8:\"date_end\";s:19:\"2024-12-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2024-12-22 23:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:7:\"2024-50\";s:10:\"date_start\";s:19:\"2024-12-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2024-12-09 00:00:00\";s:8:\"date_end\";s:19:\"2024-12-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2024-12-15 23:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:7:\"2024-49\";s:10:\"date_start\";s:19:\"2024-12-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2024-12-02 00:00:00\";s:8:\"date_end\";s:19:\"2024-12-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2024-12-08 23:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:7:\"2024-48\";s:10:\"date_start\";s:19:\"2024-12-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2024-12-01 00:00:00\";s:8:\"date_end\";s:19:\"2024-12-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2024-12-01 23:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:5;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "off");
INSERT INTO `wptr_options` VALUES("1659", "_site_transient_timeout_community-events-b6a445c22f0fe864d31e5d5ece3bc54e", "1735510002", "off");
INSERT INTO `wptr_options` VALUES("1660", "_site_transient_community-events-b6a445c22f0fe864d31e5d5ece3bc54e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"88.130.144.0\";}s:6:\"events\";a:5:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:47:\"#wpbn No. 87 - Google Seach Console & WordPress\";s:3:\"url\";s:66:\"https://www.meetup.com/wordpress-meetup-bonn-wpbn/events/304434267\";s:6:\"meetup\";s:27:\"WordPress Meetup Bonn #wpbn\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/wordpress-meetup-bonn-wpbn/\";s:4:\"date\";s:19:\"2025-01-08 19:00:00\";s:8:\"end_date\";s:19:\"2025-01-08 21:00:00\";s:20:\"start_unix_timestamp\";i:1736359200;s:18:\"end_unix_timestamp\";i:1736366400;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"DE\";s:8:\"latitude\";d:50.73;s:9:\"longitude\";d:7.1;}}i:1;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:33:\"WPDUS #85 – WooCommerce E-Mails\";s:3:\"url\";s:67:\"https://www.meetup.com/dusseldorf-wordpress-meetup/events/304783065\";s:6:\"meetup\";s:28:\"Düsseldorf WordPress Meetup\";s:10:\"meetup_url\";s:51:\"https://www.meetup.com/dusseldorf-wordpress-meetup/\";s:4:\"date\";s:19:\"2025-01-14 18:30:00\";s:8:\"end_date\";s:19:\"2025-01-14 20:30:00\";s:20:\"start_unix_timestamp\";i:1736875800;s:18:\"end_unix_timestamp\";i:1736883000;s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Düsseldorf, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:51.22214;s:9:\"longitude\";d:6.792968;}}i:2;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:75:\"WordPress Meetup Südsauerland #14: Tipps zu Themes und Plugins - Werkstatt\";s:3:\"url\";s:75:\"https://www.meetup.com/sudsauerland-wordpress-meetup-group/events/305147263\";s:6:\"meetup\";s:30:\"WordPress Meetup Südsauerland\";s:10:\"meetup_url\";s:59:\"https://www.meetup.com/sudsauerland-wordpress-meetup-group/\";s:4:\"date\";s:19:\"2025-01-20 19:00:00\";s:8:\"end_date\";s:19:\"2025-01-20 21:00:00\";s:20:\"start_unix_timestamp\";i:1737396000;s:18:\"end_unix_timestamp\";i:1737403200;s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Attendorn, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:51.125156;s:9:\"longitude\";d:7.900452;}}i:3;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:62:\"Was sind Block Themes? Eine Einführung – WP Meetup Dortmund\";s:3:\"url\";s:65:\"https://www.meetup.com/wordpress-meetup-dortmund/events/304166182\";s:6:\"meetup\";s:25:\"WordPress Meetup Dortmund\";s:10:\"meetup_url\";s:49:\"https://www.meetup.com/WordPress-Meetup-Dortmund/\";s:4:\"date\";s:19:\"2025-01-22 19:00:00\";s:8:\"end_date\";s:19:\"2025-01-22 21:00:00\";s:20:\"start_unix_timestamp\";i:1737568800;s:18:\"end_unix_timestamp\";i:1737576000;s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Dortmund, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:51.48584;s:9:\"longitude\";d:7.475832;}}i:4;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:72:\"WPDUS #86 – WordPress Meetup Düsseldorf – Merke dir den Termin vor!\";s:3:\"url\";s:67:\"https://www.meetup.com/dusseldorf-wordpress-meetup/events/304783067\";s:6:\"meetup\";s:28:\"Düsseldorf WordPress Meetup\";s:10:\"meetup_url\";s:51:\"https://www.meetup.com/dusseldorf-wordpress-meetup/\";s:4:\"date\";s:19:\"2025-02-11 18:30:00\";s:8:\"end_date\";s:19:\"2025-02-11 20:30:00\";s:20:\"start_unix_timestamp\";i:1739295000;s:18:\"end_unix_timestamp\";i:1739302200;s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Düsseldorf, Germany\";s:7:\"country\";s:2:\"de\";s:8:\"latitude\";d:51.22214;s:9:\"longitude\";d:6.792968;}}}}", "off");
INSERT INTO `wptr_options` VALUES("1647", "_site_transient_timeout_community-events-fb1f769fa12e11a29e212b43fe13cf65", "1735508768", "off");
INSERT INTO `wptr_options` VALUES("1648", "_site_transient_community-events-fb1f769fa12e11a29e212b43fe13cf65", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"94.55.236.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wptr_options` VALUES("1649", "_transient_timeout_feed_94d0b45cbbe5640144493b43a9e8f566", "1735508768", "off");
INSERT INTO `wptr_options` VALUES("1650", "_transient_feed_94d0b45cbbe5640144493b43a9e8f566", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Blog – WordPress.org English (UK)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://en-gb.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Sep 2024 20:43:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-GB\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Blog – WordPress.org English (UK)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://en-gb.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.6.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/09/10/wordpress-6-6-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/09/10/wordpress-6-6-2-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Sep 2024 20:43:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1777\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"WordPress 6.6.2 is now available! This minor release includes&#160;15 bug fixes in Core&#160;and&#160;11 in the Block Editor, addressing issues like unexpected CSS specificity changes in certain themes. For a full summary of the maintenance updates, you can refer to the&#160;Release Candidate announcement. WordPress 6.6.2 is a short-cycle release. The next major release will be version 6.7 planned [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8189:\"\n<h2 class=\"wp-block-heading\">WordPress 6.6.2 is now available!</h2>\n\n\n\n<p>This minor release includes&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!61982&amp;milestone=6.6.2&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=id\">15 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/61982#comment:5\">11 in the Block Editor</a>, addressing issues like unexpected CSS specificity changes in certain themes. For a full summary of the maintenance updates, you can refer to the&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/04/wordpress-6-6-2-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.6.2 is a short-cycle release. The next major release will be <a href=\"https://make.wordpress.org/core/6-7/\">version 6.7</a> planned for 12 November 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.6.2.zip\">download WordPress 6.6.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-6-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a> and <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>, with <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> mentoring us.</p>\n\n\n\n<p>WordPress 6.6.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aaronrobertshaw\">Aaron Robertshaw</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/atachibana\">Akira Tachibana</a>,&nbsp;<a href=\"https://profiles.wordpress.org/akshat2802\">Akshat Kakkad</a>,&nbsp;<a href=\"https://profiles.wordpress.org/harlet7\">Alexandru Horeanu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/amitraj2203\">Amit Raj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andreiglingeanu\">andreiglingeanu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/the-ank\">Ankur Vishwakarma</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/apmeyer\">apmeyer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aristath\">Ari Stathopoulos</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rainbowgeek\">Benjamin Denis</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/freibergergarcia\">Bruno Freiberger Garcia</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dballari\">David Ballarin Prunera</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dsas\">Dean Sas</a>,&nbsp;<a href=\"https://profiles.wordpress.org/debarghyabanerjee\">DEBARGHYA BANERJEE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jamesros161\">James Rosado</a>,&nbsp;<a href=\"https://profiles.wordpress.org/madtownlems\">Jason LeMahieu (MadtownLems)</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josklever\">Jos Klever</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karan4word\">karan4official</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ryelle\">Kelly Choyce-Dwan</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kowsar89\">Kowsar Hossain</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kracked888\">kracked888</a>,&nbsp;<a href=\"https://profiles.wordpress.org/luisherranz\">luisherranz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marius84\">mariushosting</a>,&nbsp;<a href=\"https://profiles.wordpress.org/markhowellsmead\">Mark Howells-Mead</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mattraines\">mattraines</a>,&nbsp;<a href=\"https://profiles.wordpress.org/michaelwp85\">michaelwp85</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/munyagu\">munyagu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nithi22\">Nithin John</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nithins53\">Nithin SreeRaj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/alshakero\">Omar Alshaker</a>,&nbsp;<a href=\"https://profiles.wordpress.org/paaljoachim\">Paal Joachim Romdahl</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pamprn\">Pamela Ribeiro</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/presstoke\">presstoke</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/shailu25\">Shail Mehta</a>,&nbsp;<a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales\">Vicente Canales</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wongjn\">wongjn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ytfeldrawkcab\">ytfeLdrawkcaB</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C07BTF54N68\">#6-7-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>As a reminder, please see&nbsp;<a href=\"https://wordpress.org/https://make.wordpress.org/plugins/2024/09/04/upcoming-security-changes-for-plugin-and-theme-authors-on-wordpress-org/\">this post for the upcoming security changes for plugin and theme authors on WordPress.org</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/09/10/wordpress-6-6-2-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1777\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.6.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/07/23/wordpress-6-6-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/07/23/wordpress-6-6-1-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Jul 2024 16:10:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1771\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"WordPress 6.6.1 is now available! This minor release features&#160;7 bug fixes in Core&#160;and&#160;9 bug fixes for the Block Editor. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement. WordPress 6.6.1 is a short-cycle release. The next major release will be version 6.7 planned for November 2024. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6032:\"\n<p><strong>WordPress 6.6.1 is now available!</strong></p>\n\n\n\n<p>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!61692&amp;milestone=6.6.1&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">7 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/61692#comment:4\">9 bug fixes for the Block Editor</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/18/wordpress-6-6-1-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.6.1 is a short-cycle release. The next major release will be <a href=\"https://make.wordpress.org/core/6-7/\">version 6.7</a> planned for November 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.6.1.zip\">download WordPress 6.6.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-6-1\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a>.</p>\n\n\n\n<p>WordPress 6.6.1 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin%22\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aaronrobertshaw\">Aaron Robertshaw</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/amitraj2203\">Amit Raj</a>,&nbsp;<a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ambrosiawt\">Art Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bgardner\">Brian Gardner</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/cbirdsong\">cbirdsong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/butterflymedia\">Ciprian</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clarktbt\">Clark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/courane01\">Courtney Robertson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annubis\">Eric-Oliver Mächler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jsnajdr\">Jarda Snajdr</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joen\">Joen A.</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a><a>,&nbsp;</a><a href=\"https://profiles.wordpress.org/mciampini\">Marco Ciampini</a>,&nbsp;<a href=\"https://profiles.wordpress.org/santosguillamot\">Mario Santos</a>,&nbsp;<a href=\"https://profiles.wordpress.org/markhowellsmead\">Mark Howells-Mead</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27%20\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/neotrope\">neotrope</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/raquelandefeld\">Raquel</a>,&nbsp;<a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/richtabor\">Rich Tabor</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sourav08\">Sourav Pahwa</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sunil25393\">SunilPrajapati</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/up1512001\">up1512001</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C07BTF54N68\">#6-7-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/07/23/wordpress-6-6-1-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1771\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.6 “Dorsey”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://en-gb.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://en-gb.wordpress.org/2024/07/16/wordpress-6-6-dorsey/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:07:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1768\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"Say hello to WordPress 6.6 “Dorsey,” named after the legendary American Big Band leader, Tommy Dorsey. Renowned for his smooth-toned trombone and compositions, Dorsey’s music captivated audiences with its emotional depth and vibrant energy. Let your heart swing, sing, and sway to the deep brass notes of&#160;Dorsey’s Big Band sound&#160;as you explore the new features [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:63148:\"\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/07/Release-Edition-Inline-Image-1.png?resize=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-17529\" /></figure>\n\n\n\n<p>Say hello to WordPress 6.6 “Dorsey,” named after the legendary American Big Band leader, Tommy Dorsey. Renowned for his smooth-toned trombone and compositions, Dorsey’s music captivated audiences with its emotional depth and vibrant energy.</p>\n\n\n\n<p>Let your heart swing, sing, and sway to the deep brass notes of&nbsp;<a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\">Dorsey’s Big Band sound</a>&nbsp;as you explore the new features and enhancements of WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Hello, 6.6!</h2>\n\n\n\n<p>WordPress 6.6 delivers on the promise of a better web by bringing style, finesse, and a suite of creative possibilities to your site-building experience. This version helps you do more with ease, putting enhanced tools at your fingertips and giving you unprecedented power behind the scenes. You will find more ways to create beautiful, coherent design elements across your site, a new layout for quick page previews in the Site Editor, and the safety of automatic rollbacks for failed plugin auto-updates – among many other highlights.</p>\n\n\n\n<p>In addition to the new features, “Dorsey” continues to deliver the performance and accessibility gains you can expect from every WordPress release. Explore what WordPress 6.6 has to offer and get ready to let its features take your sites to new heights.</p>\n\n\n\n<p><a href=\"https://wordpress.org/wordpress-6.6.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Download WordPress 6.6 “Dorsey”</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s inside</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add more design options to block themes</h3>\n\n\n\n<p>Create colour or font sets to multiply design combinations across one theme. These sets offer more contained design possibilities, allowing visual variety within the site’s broader styling guidelines.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXc7Mg7QzTwFiR7NDQLj6p5m4eddq6MtscZYzTh5QeGqB2sLP3T_t2Io2cqA5QuSixyze9ZVWqsDF9ZD7VscWn0TWA6lCG0OgZ4o5Ar_8MgQta8B3vu3VzJQHYREY9NxUb9J8e3BFESmcnbRwg7g6GuFfguU?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Simplify your workflow with a new layout for pages in the Site Editor</h3>\n\n\n\n<p>See all of your pages and a preview of any selected page with the new side-by-side layout in the Site Editor.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXfdAh-2XaS_6bdw8YcDZMRpkT0O6oWezPzZT3FzKjoWcxhM4ofivJli8eDRs1pO60wJ7F6YjQblSDop_O8MXQKwRlb_-g8CsFPPVb7hY3vEgIBPLb3tDyrvZZhSZL6Zp-ntXQdB2-ixFVoWaY-Empv3hZQ-?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Auto-update your plugins with peace of mind</h3>\n\n\n\n<p>Enjoy the convenience of plugin auto-updates with the safety of rollbacks if anything goes wrong – offering your site a new level of security, enhanced functionality as it becomes available, and almost no time or bandwidth from you to make it happen.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXc3cOWzosH9yiEDJrkmndXXX4QShj-vVMJJslAlgxCT74ugbYJuRPszdUi2rrCt8fnmZm1fTdJ3DTkKxYh5ImN4b6lvyBI3bsf5nvzWSBtexeldhPGyjYZM4Me1eUzfq9bAzlzlwxVqI5Hf_i9y1NGvKEdc?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Customise content in synced patterns</h3>\n\n\n\n<p>Make content changes in each instance of a synced pattern while maintaining a consistent style across them. Set these overrides for Heading, Paragraph, Button, and Image blocks when placed in a synced pattern.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://lh7-us.googleusercontent.com/docsz/AD_4nXdH_at4lSW3-Slznfn7HTOEp11xKp889JaLIj-JY5zATJbqZhNPM5MIVZzhn7J2gGhqRbkIzjGMhkFzfQFXfLpxoXu2MXDcPMCXaACaucFHph4dMrd8jHCqFckpk0HtJhEI_cWHTRDR0343_Ut06sgNgaOw?key=EV-htfbHG-kjLl6r6s-uKA\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.6 features important updates like removing redundant WP_Theme_JSON calls, disabling autoload for large options, and eliminating unnecessary polyfill dependencies. Other highlights include lazy-loading post embeds, a new&nbsp;<code>data-wp-on-async</code>&nbsp;directive, and templates in the editor that load approximately 35% faster overall.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility</h3>\n\n\n\n<p>This release includes 58 accessibility fixes and enhancements. These focus on foundational aspects of the WordPress experience, particularly the data views component powering the new site editing experience and areas like the Inserter, which provide a key way of interacting with blocks and patterns.</p>\n\n\n\n<h3 class=\"wp-block-heading\">And much more</h3>\n\n\n\n<p>Visit the&nbsp;<a href=\"https://wordpress.org/download/releases/6-6/\">feature showcase</a>&nbsp;for a full overview of all the new features and enhancements in WordPress 6.6.</p>\n\n\n\n<p><a href=\"https://wordpress.org/download/releases/6-6/\">Check out what’s new</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.6</h2>\n\n\n\n<p>Explore<a href=\"https://learn.wordpress.org/\">&nbsp;Learn WordPress</a>&nbsp;for quick how-to videos,<a href=\"https://learn.wordpress.org/social-learning/\">&nbsp;online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>The&nbsp;<a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\">WordPress 6.6 Field Guide</a>&nbsp;contains detailed technical information and&nbsp;<a href=\"https://make.wordpress.org/core/tag/dev-notes-6-6/\">developer notes</a>&nbsp;to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the&nbsp;<a href=\"https://developer.wordpress.org/news/\">Developer Blog</a>&nbsp;for updates, tutorials, and other helpful WordPress content for developers.</p>\n\n\n\n<p>For information about installation, file changes, fixes, and other updates, read the 6.6 release notes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.6 release squad</h2>\n\n\n\n<p>Every release comes to you from a dedicated team of enthusiastic contributors who help keep things on track and moving smoothly. The team that has led 6.6 is a cross-functional group of contributors who are always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinator: <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Core Tech Lead: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> </li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Marketing &amp; Communications Lead: <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Test Lead: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>The mission of WordPress is to <a href=\"https://wordpress.org/about/\">democratise publishing</a> and embody the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. A global and diverse community of people collaborating to strengthen the software supports this effort.</p>\n\n\n\n<p>WordPress 6.6 reflects the tireless efforts and passion of more than 630 contributors in at least 51 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 1,900 enhancements and fixes, ensuring a stable release for all – a testament to the power and capability of the WordPress open source community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abditsori/\">abditsori</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abhijitrakas/\">Abhijit Rakas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/abitofmind/\">abitofmind</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aezazshekh/\">Aezaz Shekh</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ajfleming/\">ajfleming</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alesflex/\">alesflex</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cawa-93/\">Alex Kozack</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alexminza/\">alexminza</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amanias1977/\">amanias1977</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amisiewicz/\">amisiewicz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/anamarijapapic/\">Anamarija Papić</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andr3ribeiro/\">Andre Ribeiro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>·&nbsp;<a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/angelasjin/\">Angela Jin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/anilvaza/\">Anil Vaza</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/asheshmagar/\">Ashesh Magar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/imasikur22/\">Asiqur Rahman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alisongodar/\">asmittle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/balub/\">Balu B</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benjaminpick/\">Benjamin Pick</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/benjpw/\">benjpw</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bissy/\">bissy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/oldrup/\">Bjarne Oldrup</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/blackbam/\">Blackbam</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/blockify/\">Blockify</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bnewboldbsky/\">bnewboldbsky</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bridgetwillard/\">Bridget Willard</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stringpiggy/\">Candy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/caercam/\">Charlie Merland</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colind/\">ColinD</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colle/\">colle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/comecaramelos/\">comecaramelos</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cotobago/\">Constantine Vasilyev</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/craigfrancis/\">Craig Francis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/crazytonyli/\">crazytonyli</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/curdin/\">Curdin Krummenacher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cyrus11/\">cyrus11</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/daledupreez/\">Dale du Preez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colorful%20tones/\">Damon Cook</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dav4/\">dav4</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/diggeddy/\">David</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidakennedy/\">David A. Kennedy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dkjensen/\">David Jensen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/davideferre/\">davideferre</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rxnlabs/\">De’Yonté W.</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhruvang21/\">dhruvang21</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dhruvkb/\">dhruvkb</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/diedeexterkate/\">DiedeExterkate</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/itsjustdj/\">DJ</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/djzone/\">DjZoNe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/drrxbracho/\">drrxbracho</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/garridinsi/\">Eneko Garrido</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/enodekciw/\">enodekciw</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/enricosorcinelli/\">Enrico Sorcinelli</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/flabernardez/\">Flavia Bernárdez Rodríguez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/f-j-kaiser/\">Franz Josef Kaiser</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lunule/\">Gabor Lippert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/blepoxp/\">Glenn Ansley</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hakre/\">hakre</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/heinperu/\">heinvv</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hinnerk/\">Hinnerk Altenburg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/humanify/\">humanify</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/huubl/\">huubl</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/inwerpsel/\">inwerpsel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ivanottinger/\">ivanottinger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/weijland/\">Jaap Weijland</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jaclync/\">jaclync</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/xhemals/\">Jamie Speller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/janboddez/\">Jan Boddez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jtolleouw/\">Jansen Tolle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/szopserwis/\">Jarek Mazurczak</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jpolakovic/\">Jaroslav “Dero” Polakovic</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jayanthparthsarathy/\">jayanthparthsarathy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jdekhtiar/\">jdekhtiar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/onmauitime/\">Jess</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jhned/\">jhned</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jivedig/\">JiveDig</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bitmachina/\">John Hooks</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jon092/\">jon092</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jaruzek/\">Jonathan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jules/\">jules</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/justnorris/\">justnorris</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jyolsna/\">Jyolsna J E</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kamran8176/\">kamran8176</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/killua99/\">killua99</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ixkaito/\">Kite</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kmvan/\">kmvan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kovshenin/\">Konstantin Kovshenin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kristenfisher427/\">kristenfisher427</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kyleak/\">kyleak</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lanresmith/\">Lanre Smith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lgersman/\">Lars Gersmann</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/peexy/\">Laurent Naudier</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/gigitux/\">Luigi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lardsax/\">Luis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/interdevel/\">Luis Molina (interdevel)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lyonmuller/\">Lyon Müller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pagelab/\">Márcio Duarte</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mai21/\">Mai</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/makdiahussain/\">Makdia Hussain</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/marherumr/\">marherumr</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/markjszymanski/\">Mark Szymanski</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mattmm/\">Matt Medeiros</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tofajjal02/\">Md Tofajjal Hossen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mdnesarmridha/\">MD.NESAR MRIDHA</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/meetmehta1205/\">Meet Mehta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/misulicus/\">Mihai Joldis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mikehend/\">Mike Henderson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/presents111/\">miya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/musannifzahir/\">musannifzahir</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/myhro/\">myhro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mykolashlyakhtun/\">mykolashlyakhtun</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nsinelnikov/\">Mykyta Synelnikov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nicmare/\">nicmare</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nico23/\">Nico</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/niktat/\">Nicolas Tatarchenko</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nicomollet/\">nicomollet</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a>·&nbsp;<a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nkeller15/\">nkeller15</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ohia/\">Ohia ᚛ᚈᚐᚂᚐᚋᚆ᚜</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/okat/\">okat</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/dargus/\">Old account</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webgarten/\">Oliver Schmid</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/peiche/\">peiche</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pers/\">Per Søderlind</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a>·&nbsp;<a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wppinar/\">Pinar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pkuliga/\">pkuliga</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/povilasstaskus/\">povilasstaskus</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/printsachen1/\">printsachen1</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/priyanshii5/\">Priyanshii Vijayvargiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/prottoysarkar/\">Prottoy Sarkar Argho</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/quietnoise/\">QuietNoise</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Galani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rafaucau/\">Rafał Całka</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/lamarajan/\">Rajan Lama</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ravipatel/\">Ravikumar Patel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ravinderk/\">Ravinder Kumar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/defries/\">Remkus de Vries</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/richardevs/\">richardevs</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rodionov201/\">rodionov201</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rogermedia/\">Roger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/s0what/\">s0what</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sahilthakur02/\">sahilthakur02</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/samanthaxmunoz/\">Sam Brockway</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sarkarripon/\">Sarkar Ripon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/smetzdev/\">Sascha Metz</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/scribu/\">scribu</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/script2see/\">script2see</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/flexseth/\">Seth Miller</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shivapoudel/\">Shiva Poudel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shivashankerbhatta/\">Shiva Shanker Bhatta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shuvomohajan/\">Shuvo Mohajan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sirzooro/\">sirzooro</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sjnbham/\">SJNBham</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stephenbrook/\">Stephen Brook</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stephenmiracle/\">stephenmiracle</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/steveblum/\">steveblum</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/strangehill/\">strangehill</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/suascat_wp/\">Suwash</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/edent/\">Terence Eden</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/teresagobble/\">Teresa Gobble</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thijso/\">Thijs</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/thirumani02/\">Thirumani Guhan</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timnicholson/\">Tim Nicholson</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomepajk/\">tomepajk</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/tybor/\">tybor</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vinita29/\">Vinita Tandulkar</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/ashokrane/\">Vishal Kothari</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/websitegenii/\">websitegenii</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wesatintellitonic/\">wesatintellitonic</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/whaze/\">whaze</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/wojtekn/\">Wojtek Naruniec</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yankiara/\">yankiara</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/collet/\">Yann</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zafarkamal/\">Zafar Kamal</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zkarj/\">zkarj</a>&nbsp;·&nbsp;<a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<p>More than&nbsp;<a href=\"https://translate.wordpress.org/stats/\">60 locales have translated 90 percent</a>&nbsp;or more of WordPress 6.6 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the&nbsp;<a href=\"https://wordpress.org/support/\">support forums</a>&nbsp;by answering questions from WordPress users worldwide.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved</h2>\n\n\n\n<p>Participation in WordPress goes far beyond coding, and learning more and getting involved is easy. Discover the teams that come together to&nbsp;<a href=\"https://make.wordpress.org/\">Make WordPress</a>&nbsp;and use&nbsp;<a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a>&nbsp;to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">6.6 haiku</h2>\n\n\n\n<p>Six-point-six is here.<br>Make it all gorgeous; keep it<br>On brand, and relax.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://en-gb.wordpress.org/2024/07/16/wordpress-6-6-dorsey/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1768\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"WordPress 6.5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://en-gb.wordpress.org/2024/06/24/wordpress-6-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://en-gb.wordpress.org/2024/06/24/wordpress-6-5-5/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Jun 2024 20:00:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1761\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:413:\"WordPress 6.5.5 is now available! This release features three security fixes. Because this is a security release, it is recommended that you update your sites immediately. This minor release also includes three bug fixes in Core. You can&#160;download WordPress 6.5.5 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4414:\"\n<h2 class=\"wp-block-heading\">WordPress 6.5.5 is now available!</h2>\n\n\n\n<p>This release features three security fixes. Because this is a security release, <strong>it is recommended that you update your sites immediately. </strong>This minor release also includes <a href=\"https://core.trac.wordpress.org/query?component=!Build%2FTest+Tools&amp;milestone=6.5.5&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;col=component&amp;order=priority\">three bug fixes</a> in Core.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.5.zip\">download WordPress 6.5.5 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>WordPress 6.5.5 is a short-cycle release. The next major release will be version 6.6 which is scheduled for 16 July 2024.</p>\n\n\n\n<p>For more information on WordPress 6.5.5, please visit the&nbsp;<a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5-5/\">HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for&nbsp;<a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A cross-site scripting (XSS) vulnerability affecting the HTML API reported by Dennis Snell of the WordPress Core Team, along with Alex Concha and Grzegorz (Greg) Ziółkowski of the WordPress security team.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability affecting the Template Part block reported independently by Rafie Muhammad of Patchstack and during a third party security audit.</li>\n\n\n\n<li>A path traversal issue affecting sites hosted on Windows reported independently by Rafie M &amp; Edouard L of Patchstack, David Fifield,&nbsp;<a href=\"https://hackerone.com/x89\">x89</a>,&nbsp;<a href=\"https://hackerone.com/apple502j\">apple502j</a>, and&nbsp;<a href=\"https://hackerone.com/mishre\">mishre</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.5.5 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance and security fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin\">Grant M. Kinney</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/matveb\">Matias Ventura</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rajinsharwar\">Rajin Sharwar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;Slack channel. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://en-gb.wordpress.org/2024/06/24/wordpress-6-5-5/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1761\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.5.4 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/06/05/wordpress-6-5-4-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/06/05/wordpress-6-5-4-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Jun 2024 16:45:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1757\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"WordPress 6.5.4 is now available!This minor release features&#160;5 bug fixes in Core. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement. WordPress 6.5.4 is a short-cycle release. The next major release will be&#160;version 6.6&#160;planned for July 2024. If you have sites that support automatic background updates, the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4531:\"\n<p><strong>WordPress 6.5.4 is now available!</strong><br>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5.4&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">5 bug fixes in Core</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2024/05/30/wordpress-6-5-4-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.5.4 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-6/\">version 6.6</a>&nbsp;planned for July 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.4.zip\">download WordPress 6.5.4 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-5-4\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.5.4 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin%22\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adrianduffell\">adrianduffell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>,&nbsp;<a href=\"https://profiles.wordpress.org/beaulebens\">Beau Lebens</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nerrad\">Darren Ethier (nerrad)</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lopo\">Enrico Battocchi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevinwhoffman\">Kevin Hoffman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/louiswol94\">Louis Wolmarans</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hmbashar\">Md Abul Bashar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/illuminea\">Miriam Schwab</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pooja1210\">Pooja N Muchandikar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mikachan\">Sarah Norris</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/smub\">Syed Balkhi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C06U06K50Q5\">#6-6-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/06/05/wordpress-6-5-4-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1757\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.5.3 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://en-gb.wordpress.org/2024/05/07/wordpress-6-5-3-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://en-gb.wordpress.org/2024/05/07/wordpress-6-5-3-maintenance-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 May 2024 17:52:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1752\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:395:\"WordPress 6.5.3 is now available! This minor release features&#160;12 bug fixes in Core&#160;and&#160;9 bug fixes for the block editor. You can review a summary of the maintenance updates in this release by reading the&#160;Release Candidate announcement. WordPress 6.5.3 is a short-cycle release. The next major release will be&#160;version 6.6&#160;planned for July 2024. If you have [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7608:\"\n<h2 class=\"wp-block-heading\">WordPress 6.5.3 is now available!</h2>\n\n\n\n<p>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5.3&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">12 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/61299\">9 bug fixes for the block editor</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2024/05/02/wordpress-6-5-3-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.5.3 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-6/\">version 6.6</a>&nbsp;planned for July 2024.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.3.zip\">download WordPress 6.5.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-5-3\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>.</p>\n\n\n\n<p>WordPress 6.5.3 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>,&nbsp;<a href=\"https://profiles.wordpress.org/adrianduffell\">adrianduffell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/alanfuller\">Alan Fuller</a>,&nbsp;<a href=\"https://profiles.wordpress.org/anlino\">Anders Norén</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oandregal\">André</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>,&nbsp;<a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>,&nbsp;<a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>,&nbsp;<a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/dextorlobo\">Arun Sharma</a>,&nbsp;<a href=\"https://profiles.wordpress.org/aslamdoctor\">Aslam Doctor</a>,&nbsp;<a href=\"https://profiles.wordpress.org/benlk\">Ben Keith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/britner\">Ben Ritner – Kadence WP</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>,&nbsp;<a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a>,&nbsp;<a href=\"https://profiles.wordpress.org/CookiesForDevo\">CookiesForDevo</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones\">Damon Cook</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/darerodz\">darerodz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davecpage\">Dave Page</a>,&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>,&nbsp;<a href=\"https://profiles.wordpress.org/justlevine\">David Levine</a>,&nbsp;<a href=\"https://profiles.wordpress.org/DrewAPicture\">Drew Jaynes</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kebbet\">Erik</a>,&nbsp;<a href=\"https://profiles.wordpress.org/evanltd\">evanltd</a>,&nbsp;<a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/grantmkin\">Grant M. Kinney</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>,&nbsp;<a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jason_the_adams\">Jason Adams</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>,&nbsp;<a href=\"https://profiles.wordpress.org/luminuu\">Jessica Lyschik</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jorgefilipecosta\">Jorge Costa</a>,&nbsp;<a href=\"https://profiles.wordpress.org/verygoode\">Joshua Goode</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevinwhoffman\">Kevin Hoffman</a>,&nbsp;<a href=\"https://profiles.wordpress.org/khokansardar\">Khokan Sardar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/luisherranz\">luisherranz</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mmaattiiaass\">Matias Benedetto</a>,&nbsp;<a href=\"https://profiles.wordpress.org/webdevmattcrom\">Matt Cromwell</a>,&nbsp;<a href=\"https://profiles.wordpress.org/devsahadat\">Md Sahadat Husain</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ntsekouras\">Nik Tsekouras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a>,&nbsp;<a href=\"https://profiles.wordpress.org/roytanck\">Roy Tanck</a>,&nbsp;<a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mikachan\">Sarah Norris</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>,&nbsp;<a href=\"https://profiles.wordpress.org/stevejonesdev\">Steve Jones</a>,&nbsp;<a href=\"https://profiles.wordpress.org/tomjcafferkey\">Tom Cafferkey</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nestea29950\">WilliamG</a>,&nbsp;<a href=\"https://profiles.wordpress.org/yguyon\">Yannis Guyon</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;and&nbsp;<a href=\"https://wordpress.slack.com/archives/C06U06K50Q5\">#6-6-release-leads</a>&nbsp;channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/05/07/wordpress-6-5-3-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1752\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"WordPress London Meetup #WPLDN – April 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://en-gb.wordpress.org/2024/04/19/wordpress-london-meetup-wpldn-april-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://en-gb.wordpress.org/2024/04/19/wordpress-london-meetup-wpldn-april-2024/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Apr 2024 09:40:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:6:\"London\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"WP London\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"wpldn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1748\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:415:\"Join the WordPress London Meetup #WPLDN this month, where we&#8217;re presenting two great speakers, one from Amnesty International and the other from a well-established, fast-paced WordPress agency. Join us for an evening of networking, community, and learning. Register today to save your place, as numbers are limited. &#8212; ✍️ &#8211;&#160;Built with humanityFind out about Amnesty&#8217;s (Web [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Dan Maby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2564:\"\n<p>Join the WordPress London Meetup #WPLDN this month, where we&#8217;re presenting two great speakers, one from Amnesty International and the other from a well-established, fast-paced WordPress agency.</p>\n\n\n\n<p>Join us for an evening of networking, community, and learning. Register today to save your place, as numbers are limited.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://www.meetup.com/london-wordpress/events/300347344/\">Register now</a></div>\n</div>\n\n\n\n<p>&#8212;</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/270d.png\" alt=\"✍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Built with humanity</strong><br>Find out about Amnesty&#8217;s (Web Ops at the international secretariat to be specific) journey into WordPress from when we launched our first WordPress site in 2018 to now shipping changes to the 46 + sites that use our open-source theme. Most importantly you can find out how you can get involved and help build humanity!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f5e3.png\" alt=\"🗣\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Presented by Austin</strong><br>Austin works at Amnesty International and the Humanity Open Source WordPress theme and a number of website running the theme.</p>\n\n\n\n<p>&#8212;</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/270d.png\" alt=\"✍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Byte-sized Impact: A greener future for your WordPress website</strong><br>Details will be released soon.</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f5e3.png\" alt=\"🗣\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> &#8211;&nbsp;<strong>Presented by Louise Towler</strong><br>Louise has been building websites for over fifteen years and enjoys helping businesses and organisations make the most of their online web presence and deliver a return on their investment. She started freelancing from her spare room and now runs Indigo Tree with multiple employees. </p>\n\n\n\n<p>&#8212;</p>\n\n\n\n<p>If you&#8217;re interested in featuring as a speaker at an upcoming event, we&#8217;d love to hear from you at&nbsp;<a href=\"https://wpldn.uk/speak\" target=\"_blank\" rel=\"noreferrer noopener\">https://wpldn.uk/speak</a>. Sessions can be delivered both physically in-person and virtually.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://en-gb.wordpress.org/2024/04/19/wordpress-london-meetup-wpldn-april-2024/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1748\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 6.5.2 Maintenance and Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://en-gb.wordpress.org/2024/04/10/wordpress-6-5-2-maintenance-and-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://en-gb.wordpress.org/2024/04/10/wordpress-6-5-2-maintenance-and-security-release/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Apr 2024 11:18:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1743\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"Note: due to an issue with the initial package, WordPress 6.5.1 was not released. 6.5.2 is the first minor release for WordPress 6.5. This security and maintenance release features 2 bug fixes on Core, 12 bug fixes for the Block Editor, and 1 security fix. Because this is a security release, it is recommended that you update [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4681:\"\n<p><strong>Note: due to an issue with the initial package, WordPress 6.5.1 was not released. 6.5.2 is the first minor release for WordPress 6.5.</strong></p>\n\n\n\n<p>This security and maintenance release features <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!60398&amp;milestone=6.5.2&amp;group=status&amp;order=priority\">2 bug fixes on Core</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/60577\">12 bug fixes for the Block Editor</a>, and 1 security fix.</p>\n\n\n\n<p><strong>Because this is a security release, it is recommended that you update your sites immediately.</strong>&nbsp;Backports are also available for other major WordPress releases, 6.1 and later.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.5.2.zip\">download WordPress 6.5.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>WordPress 6.5.2 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-6/\">version 6.6</a>&nbsp;and is currently planned for 16 July 2024.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for responsibly reporting vulnerabilities, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A cross-site scripting (XSS) vulnerability affecting the Avatar block type; reported by <a href=\"https://johnblackbourn.com/\">John Blackbourn</a> of the WordPress security team. Many thanks to <a href=\"https://twitter.com/stealthcopter\">Mat Rollings</a> for assisting with the research.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.5.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance and security fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>,&nbsp;<a href=\"https://profiles.wordpress.org/andraganescu\">Andrei Draganescu</a>,&nbsp;<a href=\"https://profiles.wordpress.org/artemiosans\">Artemio Morales</a>,&nbsp;<a href=\"https://profiles.wordpress.org/iCaleb\">Caleb Burks</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colind\">colind</a>,&nbsp;<a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>,&nbsp;<a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>,&nbsp;<a href=\"https://profiles.wordpress.org/isabel_brison\">Isabel Brison</a>,&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>,&nbsp;<a href=\"https://profiles.wordpress.org/thelovekesh\">Lovekesh Kumar</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mmaattiiaass\">Matias Benedetto</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>,&nbsp;<a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sean212\">Sean Fisher</a>,&nbsp;<a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>,&nbsp;<a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a>&nbsp;channel. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://en-gb.wordpress.org/2024/04/10/wordpress-6-5-2-maintenance-and-security-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.5 “Regina”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://en-gb.wordpress.org/2024/04/02/wordpress-6-5-regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://en-gb.wordpress.org/2024/04/02/wordpress-6-5-regina/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 20:15:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1740\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:394:\"Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist Regina Carter. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&#160; Let the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69504:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Release-Edition-Inline-Image-1024x683.png\" alt=\"WordPress 6.5 &quot;Regina&quot;\" class=\"wp-image-17178\" /></figure>\n\n\n\n<p>Say hello to WordPress 6.5 “Regina,” inspired by the dynamic versatility of renowned jazz violinist <a href=\"https://en.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. An award-winning artist and storied jazz educator known for transcending genre, Regina’s technical foundations in classical music and deep understanding of jazz have earned her the reputation of boldly going beyond what’s possible with the violin.&nbsp;</p>\n\n\n\n<p>Let the stunning twists and subtle turns of <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\" data-type=\"link\" data-id=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">Regina’s genre-bending sound</a> surprise you as you explore everything 6.5 offers.</p>\n\n\n\n<p>This latest version of WordPress puts more power into the details. It offers new and improved ways to fine-tune and enhance your site-building experience, letting you take control in ways that make it your own. You’ll find new ways to manage your site’s typography, more comprehensive revisions available in more places, and a collection of Site Editor updates paired with impressive performance gains to help you get things done smoother and faster.</p>\n\n\n\n<p>&#8220;Regina&#8221; also marks the introduction of some breakthrough developer tools that will start transforming how you use and extend blocks to craft engaging experiences. The Interactivity API opens up a world of creative front-end possibilities, while the Block Bindings API makes dynamic connections between blocks and data seamless. These, among other developer-focused improvements and updates, are ready to help you evolve how you build with WordPress.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/\">Download WordPress 6.5 &#8220;Regina&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s inside 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Add and manage fonts across your site</h3>\n\n\n\n<p>The new Font Library puts you in control of an essential piece of your site’s design – typography – without coding or extra steps. Effortlessly install, remove, and activate local and Google Fonts across your site for any Block theme. The ability to include custom typography collections gives site creators and publishers more options when it comes to styling content.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Font-Manager-2-1024x656.png\" alt=\"\" class=\"wp-image-17167\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Get more from your revisions – including revisions for templates and template parts</h3>\n\n\n\n<p>Work through creative projects with a more comprehensive picture of what’s been done – and what you can fall back on. Get details like time stamps, quick summaries, and a paginated list of all revisions. View revisions from the Style Book to see how changes impact every block. Revisions are also now available for templates and template parts.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Revisions-1-1024x656.png\" alt=\"\" class=\"wp-image-17168\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Play with enhanced background and shadow tools</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Control the size, repeat, and focal point options for background images in Group blocks so you can explore subtle or splashy ways to add visual interest to layouts.&nbsp;</li>\n\n\n\n<li>Set aspect ratios for Cover block images and easily add colour overlays that automatically source colour from your chosen image. </li>\n\n\n\n<li>Add box shadow support to more block types and create layouts with visual depth, or throw a little personality into your design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/design-tools-1-1024x656.png\" alt=\"\" class=\"wp-image-17169\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Discover new Data Views</h3>\n\n\n\n<p>Every piece of your site comes with a library of information and data – now, you can find what you need quickly and organise it however you like. Data views for pages, templates, patterns, and template parts let you see data in a table or grid view, with the option to toggle fields and make bulk changes.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/Data-Views-1-1024x656.png\" alt=\"\" class=\"wp-image-17165\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Smoother drag-and-drop</h3>\n\n\n\n<p>Feel the difference when you move things around, with helpful visual cues like displaced items in List View or frictionless dragging to anywhere in your workspace – from beginning to end.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/drag-and-drop-1-1024x656.png\" alt=\"\" class=\"wp-image-17170\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Improved link controls</h3>\n\n\n\n<p>Create and manage links easily with a more intuitive link-building experience, like a streamlined UI and a shortcut for copying links.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/04/link-controls-1-1024x656.png\" alt=\"\" class=\"wp-image-17171\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s fresh for developers in 6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Bring interactions to blocks with the Interactivity API</h3>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API</a> offers developers a standardised method for building interactive front-end experiences with blocks. It simplifies the process, with fewer dependencies on external tooling, while maintaining optimal performance. Use it to create memorable user experiences, like fetching search results instantly or letting visitors interact with content in real time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connect blocks to custom fields or other dynamic content</h3>\n\n\n\n<p>Link core block attributes to custom fields and use the value of custom fields without creating custom blocks. Powered by the <a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">Block Bindings API</a>, developers can extend this capability further to connect blocks to any dynamic content – even beyond custom fields. If there’s data stored elsewhere, easily point blocks to that new source with only a few lines of code.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Add appearance tools to Classic themes</h3>\n\n\n\n<p>Give designers and creators using Classic themes access to an upgraded design experience. Opt in to support for spacing, border, typography, and colour options, even without using theme.json. Once support is enabled, more tools will be automatically added as they become available.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Explore improvements to the plugin experience</h3>\n\n\n\n<p>There&#8217;s now an <a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">easier way to manage plugin dependencies</a>. Plugin authors can supply a new <code>Requires Plugins</code> header with a comma-separated list of required plugin slugs, presenting users with links to install and activate those plugins first.</p>\n\n\n\n<h3 class=\"wp-block-heading\">From fast to faster: Performance updates</h3>\n\n\n\n<p>This release includes 110+ performance updates, resulting in an impressive increase in speed and efficiency across the Post Editor and Site Editor. Loading is over two times faster than in 6.4, with input processing speed up to five times faster than the previous release.</p>\n\n\n\n<p>&nbsp;Translated sites see up to 25% improvement in load time for this release courtesy of <a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">Performant Translations</a>. Additional performance highlights include <a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">AVIF image support</a> and improvements for <a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">registering block variations with callbacks</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A tradition of inclusion</h3>\n\n\n\n<p>This release includes more than 65 accessibility improvements across the platform, making it more accessible than ever. It contains an important fix that unblocks access to the admin submenus for screen reader users and others who navigate by keyboard. This release also adds fixes to colour contrast in admin focus states, positioning of elements, and cursor focus, among many others, that help improve the WordPress experience for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.5</h2>\n\n\n\n<p>Check out the new <a href=\"https://wordpress.org/download/releases/6-5/\">WordPress 6.5 page</a> to learn more about the numerous enhancements and features of this release – including short demos of some of the highlighted features.</p>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> for quick how-to videos, <a href=\"https://learn.wordpress.org/social-learning/\">online workshops</a>, and other free resources to level up your WordPress knowledge and skills.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">WordPress 6.5 Field Guide</a> for detailed technical information and <a href=\"https://make.wordpress.org/core/tag/dev-notes-6-5/\">developer notes</a> to help you build with WordPress and get the most out of this release. Don’t forget to subscribe to the <a href=\"https://developer.wordpress.org/news/\">Developer Blog</a> for developer updates, feature tutorials, and other helpful WordPress content from a developer perspective.</p>\n\n\n\n<p>For more information about installation, file changes, fixes, and other updates, read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">6.5 release notes</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.5 release squad</h2>\n\n\n\n<p>Every release has many moving parts with its own triumphs and challenges. It takes a dedicated team of enthusiastic contributors to help keep things on track and moving smoothly. 6.5 is made possible by a cross-functional group of contributors, always ready to champion ideas, remove blockers, and resolve issues.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Core Tech Leads: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Editor Tech Leads: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Core Triage Leads: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Editor Triage Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Design Leads: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Marketing and Communication Leads: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Documentation Leads: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a>, <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Performance Leads: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Test Leads: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>, <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Default Themes Leads: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress believes in democratising publishing and the <a href=\"https://opensource.org/osd-annotated\">freedoms that come with open source</a>. Supporting this idea is a global and diverse community of people collaborating to strengthen the software. </p>\n\n\n\n<p>WordPress 6.5 reflects the countless efforts and passion of around 700 contributors in at least 57 countries. This release also welcomed over 150 first-time contributors!</p>\n\n\n\n<p>Their collaboration delivered more than 2,500 enhancements and fixes, ensuring a stable release for all – a testament to the power and capability of the WordPress open source community.</p>\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Nor&#233;n</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">B&#233;ryl de La Grandi&#232;re</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">Christian Dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel K&#228;fer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank J&#228;ger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin (a11n)</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbi&#241;e</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko L&#252;bbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jes&#250;s Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski - Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren W&#252;nsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel R&#252;egger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro L&#243;pez</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Sonia</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kr&#228;ftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Tim Bowen</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn &#8220;Tobi&#8221; Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">Yuta Amakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>Over <a href=\"https://translate.wordpress.org/stats/\">70 locales have translated 90 percent</a> or more of WordPress 6.5 into their language. Community translators are working hard to ensure more translations are on their way. Thank you to everyone who helps make WordPress available in 200 languages.</p>\n\n\n\n<p>Last but not least, thanks to the volunteers who contribute to the <a href=\"https://wordpress.org/support/\">support forums</a> by answering questions from WordPress users worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get involved and contribute</h3>\n\n\n\n<p>Participation in WordPress is not limited to coding. If contributing appeals to you, learning more and getting involved is easy. Discover the teams that come together to <a href=\"https://make.wordpress.org/\">Make WordPress</a>, and use <a href=\"https://make.wordpress.org/contribute/\">this interactive tool</a> to help you decide which is right for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">One more haiku</h2>\n\n\n\n<p>6.5 is here!<br>Play, interact, build better,<br>Stronger and faster.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://en-gb.wordpress.org/2024/04/02/wordpress-6-5-regina/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress London Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://en-gb.wordpress.org/2024/02/19/wordpress-london-meetup/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://en-gb.wordpress.org/2024/02/19/wordpress-london-meetup/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Feb 2024 12:19:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"London\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://en-gb.wordpress.org/?p=1728\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"The WordPress London Meetup is back! You can find all the details at https://www.meetup.com/london-wordpress/events/298932224/.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Mark Robson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"\n<p>The WordPress London Meetup is back! You can find all the details at <a href=\"https://www.meetup.com/london-wordpress/events/298932224/\">https://www.meetup.com/london-wordpress/events/298932224/</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://en-gb.wordpress.org/2024/02/19/wordpress-london-meetup/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:38:\"https://en-gb.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"65529235\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 29 Dec 2024 09:46:08 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 13 Nov 2024 20:19:10 GMT\";s:4:\"link\";s:64:\"<https://en-gb.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1735508768;s:23:\"__cache_expiration_time\";i:1735508768;}", "off");
INSERT INTO `wptr_options` VALUES("145", "_transient_timeout_feed_mod_94d0b45cbbe5640144493b43a9e8f566", "1735508768", "off");
INSERT INTO `wptr_options` VALUES("146", "_transient_feed_mod_94d0b45cbbe5640144493b43a9e8f566", "1735465568", "off");
INSERT INTO `wptr_options` VALUES("147", "can_compress_scripts", "1", "on");
INSERT INTO `wptr_options` VALUES("1651", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1735508769", "off");
INSERT INTO `wptr_options` VALUES("1652", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Gravatar: Advanced Tips for Creating a Successful Online Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2532\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://blog.gravatar.com/2024/12/27/create-online-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24540:\"<p>Building an online community takes dedication, skill, and strategic thinking – but the rewards make it worth every bit of effort. A thriving community can transform your business, whether it&#8217;s your main focus or supplements your existing offerings.</p>\n\n\n\n<p>Starting a community might seem deceptively simple. After all, people naturally want to connect with others who share their interests. And social media makes it easier than ever to gather people in one place.</p>\n\n\n\n<p>But creating a community that genuinely serves its members while meeting your goals? That&#8217;s a different challenge entirely. Most communities struggle with low engagement, unclear purpose, or lack of sustainable growth.</p>\n\n\n\n<p>This guide breaks down advanced strategies for building a community that lasts. You&#8217;ll learn practical approaches to choosing the right platform, creating engaging experiences, and fostering meaningful connections among members. Each section includes specific tactics you can implement right away, backed by examples from successful communities.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Define your reason for creating an online community</strong></h2>\n\n\n\n<p>Starting an online community requires significant time and resources. Before diving in, you need a clear purpose that guides every decision you make.</p>\n\n\n\n<p>The most successful communities serve specific, well-defined goals. A vague aim like &#8220;connecting people&#8221; won&#8217;t provide enough direction. Instead, focus on concrete objectives such as:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Supporting customers through peer-to-peer problem solving.</li>\n\n\n\n<li>Building brand loyalty through exclusive experiences and early access.</li>\n\n\n\n<li>Creating collaborative learning spaces where members share expertise.</li>\n\n\n\n<li>Gathering feedback to improve products or services.</li>\n\n\n\n<li>Providing specialized networking opportunities in niche fields.</li>\n</ul>\n\n\n\n<p>Your community&#8217;s purpose shapes everything from platform choice to content strategy. An educational community focused on live workshops needs different tools than a support community built around troubleshooting forums.</p>\n\n\n\n<p>Ask yourself: <strong>Will this community be central to your business model or support existing offerings?</strong> A course creator might build their entire business around a learning community, while a retailer might use community spaces to enhance customer experience through product discussions and reviews.</p>\n\n\n\n<p>The clearer your purpose, the easier it becomes to make decisions that serve both your members and your goals.</p>\n\n\n\n<h1 class=\"wp-block-heading\"><strong>Define your ideal persona and why community is important for them</strong></h1>\n\n\n\n<p>Success in community building starts with deeply understanding who your members are and what draws them to connect with others. Going beyond basic demographics reveals what truly motivates participation.</p>\n\n\n\n<p>Take these specific examples:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remote tech workers seeking professional growth might join to share career advice, discuss industry trends, and build relationships outside their immediate team.</li>\n\n\n\n<li>Home bakers learning artisan bread techniques want to troubleshoot recipes, showcase their creations, and find motivation from fellow enthusiasts.</li>\n\n\n\n<li>Independent artists could gather to share business tips, critique works in progress, and find potential collaborators.</li>\n</ul>\n\n\n\n<p>Each group has distinct needs that shape how they&#8217;ll engage. Remote workers might value structured networking events and skill-sharing sessions, while bakers might prefer photo-rich discussions and live-streaming demonstrations. Artists might engage most with portfolio showcases and project collaboration tools.</p>\n\n\n\n<p>Study where your ideal members currently gather online. What frustrates them about existing spaces? What makes them stick around? Use these insights to craft experiences that solve real pain points.</p>\n\n\n\n<p>And remember – your community will attract different types of participants. Some will actively create content, others will moderate discussions, while many will simply absorb information. Design your space to support all these interaction styles.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Selecting the right format and channels for your online community</strong></h2>\n\n\n\n<p>Your community&#8217;s format directly impacts how members interact and engage. Each option offers distinct advantages for different community goals:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Forums</strong> excel at organizing in-depth discussions by topic, making it easy for members to find relevant conversations and contribute meaningfully. They&#8217;re particularly effective for technical support or knowledge-sharing communities.</li>\n\n\n\n<li><strong>Live events</strong> build excitement and real-time connection. Whether through video workshops, AMAs, or virtual meetups, synchronous gatherings create shared experiences that strengthen community bonds.</li>\n\n\n\n<li><a href=\"https://blog.gravatar.com/2024/07/11/enable-comments-in-wordpress/\"><strong>Comment sections</strong></a> work well for focused discussions around specific content pieces. They&#8217;re ideal for communities built around blogs, courses, or media content where context matters.</li>\n\n\n\n<li><strong>Activity feeds</strong> keep members updated on community happenings, highlighting recent discussions, achievements, and contributions. They help maintain engagement between deeper interactions.</li>\n</ul>\n\n\n\n<p><a href=\"https://wordpress.org/\">WordPress</a> offers the flexibility to mix these formats without platform restrictions. Unlike social media networks, you control the experience and aren&#8217;t subject to algorithmic changes or paid reach limitations. It also gives you an opportunity to create an engaging community platform with <a href=\"https://blog.gravatar.com/2024/05/09/wordpress-profile-page/\">customized profile pages</a> and personalized recommendations based on user data.&nbsp;</p>\n\n\n\n<p>Whatever the format is,<strong> we recommend starting with free channels to build your initial audience.</strong> For example, many fitness channels offer free training videos on YouTube and then a paid membership option for subscribers who want to join specific programs. Similarly, the <a href=\"https://www.youtube.com/@GoodMythicalMorning/community\">Good Mythical Morning YouTube channel</a> nurtures viewers before inviting them to join their premium <a href=\"https://www.mythicalsociety.com/\">Mythical Society community</a>. This approach lets you demonstrate value and build trust before asking for a deeper commitment.</p>\n\n\n\n<img width=\"660\" height=\"314\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/mythical-society.png?w=660\" alt=\"The Mythical Society\" class=\"wp-image-2535\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Creating member profiles for your community&nbsp;</strong></h2>\n\n\n\n<p>Member profiles form the foundation of community identity and connection. <a href=\"https://gravatar.com/\">Gravatar</a> helps website owners with this crucial element by linking profiles to email addresses, enabling consistent identity across platforms with minimal setup time.</p>\n\n\n\n<p>The &#8220;Update Once, Sync Everywhere&#8221; feature saves valuable time for both administrators and members. Instead of creating new profiles for each community space, Gravatar allows all integrated platforms to pull in and auto-populate profile data.</p>\n\n\n\n<p><a href=\"https://blog.gravatar.com/2024/08/26/gravatar-api-tutorial-for-app-developers/\">Two powerful APIs</a> make implementation straightforward:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The <a href=\"https://docs.gravatar.com/api/avatars/images/\">Avatar API</a> pulls member photos and basic details</li>\n\n\n\n<li>The <a href=\"https://docs.gravatar.com/rest-api/\">Profile API</a> imports comprehensive profile information</li>\n</ul>\n\n\n\n<p>This automation speeds up the <a href=\"https://blog.gravatar.com/2024/09/06/onboarding-user-experience/\">user onboarding</a> significantly. New members arrive with pre-filled profiles, reducing friction and increasing the likelihood they&#8217;ll engage right away. Familiar avatars across different sections of your community help members recognize each other easily, strengthening relationships.</p>\n\n\n\n<p><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" /><em>If you’re looking for some inspiration on how to build beautiful profile pages, check out our article on </em><a href=\"https://blog.gravatar.com/2024/06/05/user-profile-page-examples/\"><em>user profile page examples</em></a><em>.&nbsp;</em></p>\n\n\n\n<p>Privacy remains in members&#8217; control. They choose what information to share and can maintain multiple identities for different community roles – perfect for separating member and moderator profiles.</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Creating community guidelines and moderation strategies</strong></h2>\n\n\n\n<p>Smart moderation strategies keep communities healthy while encouraging authentic interaction. Advanced approaches include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>AI-powered content filtering to catch obvious violations automatically.</li>\n\n\n\n<li>Multi-tier moderation systems where trusted members help maintain community standards.</li>\n\n\n\n<li>Living guidelines that adapt based on community feedback and real situations.</li>\n</ul>\n\n\n\n<p>Gravatar&#8217;s universal profiles enhance these efforts by:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Using verified email addresses to reduce fake accounts and spam.</li>\n\n\n\n<li>Building trust scores based on member history across platforms.</li>\n\n\n\n<li>Speeding up issue resolution through integrated reporting systems.</li>\n</ul>\n\n\n\n<p>Balance strict rules with community self-regulation. The <a href=\"https://stackexchange.com/\">Stack Exchange network</a> demonstrates this well: Experienced members gain moderation privileges through consistent positive contributions, creating a sustainable system where the community largely moderates itself.</p>\n\n\n\n<p>Clear consequences for guideline violations matter, but focus more on rewarding positive behavior. Highlight exemplary members, celebrate constructive contributions, and create paths for members to earn additional privileges through helpful participation.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Strategies for launching and growing your community</strong></h2>\n\n\n\n<p>A successful community launch builds momentum that drives sustained growth. Smart tactics maximize early engagement and set the right foundations.</p>\n\n\n\n<p>Reward early adopters with exclusive perks like special &#8220;founding member&#8221; badges displayed on profiles. Besides the badges, members with this level could also have direct access to community leadership, the right to give input on future features and direction, and even early access to new content or features.</p>\n\n\n\n<p>However, you should nurture all members, not just the early adopters. Create achievement systems that encourage meaningful participation:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Recognition for quality contributions.</li>\n\n\n\n<li>Special roles for consistent, helpful answers.</li>\n\n\n\n<li>Progress tracking tied to learning goals.</li>\n\n\n\n<li>Visible milestones on member profiles.</li>\n</ul>\n\n\n\n<p>You can measure how successful your efforts are by measuring engagement metrics – number of comments, new members, etc. However, it’s best to go beyond the basics and track indicators that show real community health:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Ratio of new discussions to responses.</li>\n\n\n\n<li>Time between member questions and first answers.</li>\n\n\n\n<li>Number of connections made between members.</li>\n\n\n\n<li>Quality and depth of conversations.</li>\n</ul>\n\n\n\n<p>Finally, think of different ways you can scale engagement through time. Partner with micro-influencers who genuinely connect with your community&#8217;s purpose – their authentic enthusiasm will attract members who share your values.</p>\n\n\n\n<p>As your community grows, personalize the experience based on member behavior and interests. Use Gravatar profile data to:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Customize onboarding paths.</li>\n\n\n\n<li>Suggest relevant discussions.</li>\n\n\n\n<li>Connect members with shared interests.</li>\n\n\n\n<li>Highlight content matching expertise levels.</li>\n</ul>\n\n\n\n<p>Keep in mind that small, active communities often provide more value than large, disengaged ones. Focus on fostering quality interactions rather than chasing member numbers.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Fostering engagement and participation in your online community&nbsp;</strong></h2>\n\n\n\n<p>Engaged communities don&#8217;t happen by accident. They need thoughtful content, smart incentives, and active leadership. This section explores advanced strategies that go beyond basic engagement tactics, helping you create an environment where meaningful interaction happens naturally.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Creating compelling community content and discussions&nbsp;</strong></h3>\n\n\n\n<p>Strong content sparks conversations that keep members coming back. Focus on creating material that taps into your community&#8217;s specific interests and motivations:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Frame discussion topics as practical problems to solve rather than digital queries.</li>\n\n\n\n<li>Share behind-the-scenes insights that make members feel like insiders.</li>\n\n\n\n<li>Create content series that build anticipation and regular participation.</li>\n\n\n\n<li>Use polls and surveys to gather opinions on controversial industry topics.</li>\n</ul>\n\n\n\n<p>Mix content formats to suit different learning and interaction styles:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Short-form videos for quick tips and demonstrations.</li>\n\n\n\n<li>Long-form articles for deep dives into complex topics.</li>\n\n\n\n<li>Audio content for on-the-go consumption.</li>\n\n\n\n<li>Interactive workshops for hands-on learning.</li>\n</ul>\n\n\n\n<p>Encourage member-generated content by:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Featuring expert members in community spotlights.</li>\n\n\n\n<li>Running themed challenges that showcase member work.</li>\n\n\n\n<li>Creating dedicated spaces for member success stories.</li>\n\n\n\n<li>Setting up peer mentoring programs.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Implementing gamification and rewards for active members</strong></h3>\n\n\n\n<p>Gamification transforms passive members into active participants when implemented thoughtfully. The <a href=\"https://www.duolingo.com/\">Duolingo</a> language learning community demonstrates this perfectly – their streak system and XP leaderboards turn daily practice into an engaging challenge.</p>\n\n\n\n<img width=\"660\" height=\"290\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/duolingo-daily-quest.png?w=660\" alt=\"Example of Duolingo completed daily quest\" class=\"wp-image-2578\" />\n\n\n\n<p>Achievement paths should reflect genuine community values. A tech support community might award &#8220;Problem Solver&#8221; status to members who consistently provide validated solutions. These members then receive special privileges, like the ability to mark answers as official solutions or mentor newcomers.</p>\n\n\n\n<p>Collaborative challenges build stronger connections between members. Take <a href=\"https://www.strava.com/challenges\">Strava&#8217;s monthly distance challenges</a> – they motivate individual achievement while fostering a sense of shared accomplishment. Your community might organize team projects that combine different skill sets, such as writers partnering with designers to create resources for the community.</p>\n\n\n\n<img width=\"660\" height=\"270\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/strava.png?w=660\" alt=\"Strava’s monthly distance challenges\" class=\"wp-image-2538\" />\n\n\n\n<p><strong>The most effective rewards provide real value. </strong>This could mean exclusive access to industry experts, featured spots in community content, or early access to new features. One gaming community successfully uses a point system where active members earn credits toward premium content and merchandise.</p>\n\n\n\n<p>Track achievements through Gravatar profiles to make recognition visible and persistent. Members can showcase their expertise badges, contribution streaks, and impact metrics across all community spaces, building consistent reputation and authority.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Staying involved and active as a community leader</strong></h3>\n\n\n\n<p>Leadership visibility builds trust and encourages participation. Make your presence felt through:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Regular &#8220;state of the community&#8221; updates.</li>\n\n\n\n<li>Direct responses to member concerns.</li>\n\n\n\n<li>Personal stories that demonstrate vulnerability.</li>\n\n\n\n<li>Clear communication about community decisions.</li>\n</ul>\n\n\n\n<p><strong>Balance hands-on involvement with empowering others.</strong> Train moderators to handle day-to-day management, spotlight emerging community leaders and create opportunities for members to take ownership of initiatives.</p>\n\n\n\n<p>Remember that your consistent presence shows members their participation matters.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Scaling and building your community</strong></h2>\n\n\n\n<p>Growth presents both opportunities and challenges for community builders. A strategic approach helps maintain quality while expanding reach.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Start with a detailed roadmap that outlines growth phases.</strong> Map specific initiatives to member count milestones – what works for 100 members likely won&#8217;t serve 10,000. Include plans for things like expanding moderator teams, adding new content formats, introducing advanced features, and upgrading the technical infrastructure of your platform to accommodate increased traffic.&nbsp;</li>\n\n\n\n<li><strong>Make data-driven decisions</strong> by tracking meaningful metrics:\n<ul class=\"wp-block-list\">\n<li>Member retention rates across different joining cohorts.</li>\n\n\n\n<li>Response times for member questions.</li>\n\n\n\n<li>Active participation percentages.</li>\n\n\n\n<li>Content engagement patterns.</li>\n</ul>\n</li>\n\n\n\n<li><strong>Gather and act on member feedback systematically.</strong> Monthly surveys, feedback threads, and one-on-one conversations with active members reveal pain points before they become major issues.</li>\n\n\n\n<li><strong>Maintain community culture through growth spurts.</strong> The Reddit community r/AskHistorians demonstrates this well &#8211; they&#8217;ve scaled to over a million members while maintaining strict quality standards for historical discussion.</li>\n\n\n\n<li><strong>Be cautious about growing too quickly. </strong>Rapid member influx can overwhelm moderation systems and dilute community culture. Focus on attracting members who align with your community&#8217;s core values rather than chasing pure numbers.</li>\n</ul>\n\n\n\n<p>And remember: <strong>bigger isn&#8217;t always better.</strong> A focused community of 500 engaged members often provides more value than one with 50,000 lurkers. A great example of this is <a href=\"https://join.creatorscience.com/#pricing\">Jay Clouse’s highest-tier community</a>, which has a cap of 200 members. He knows that exclusivity is one of the most important perks, and having fewer subscribers allows him to pay more attention and provide those people with unique benefits.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How to monetize your community strategically</strong></h2>\n\n\n\n<p>Smart monetization enhances member value while creating sustainable revenue. The trick lies in aligning monetary goals with community benefits. Here’s what you can do:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Paid memberships: </strong>Premium memberships work well when they unlock genuine value. <a href=\"https://www.sarahbethyoga.com/\">Sara Beth Yoga</a>, for example, offers basic classes through her YouTube channel while reserving expert-led workshops and specialized support groups for paying members. Members gladly pay because the premium features directly serve their goals.</li>\n\n\n\n<li><strong>Sponsored content: </strong>Brand partnerships succeed through authentic alignment. A photography community might partner with camera manufacturers for exclusive tutorials or early product access. Both the brand and community benefit, while members gain valuable insights.</li>\n\n\n\n<li><strong>Virtual events:</strong> These can include workshops taught by community experts, industry conferences featuring member speakers, mastermind groups for specific topics, and behind-the-scenes tours or demonstrations.</li>\n\n\n\n<li><strong>Digital products</strong>: If members frequently ask similar questions, package those answers into comprehensive guides or courses. Let community input shape product development to ensure relevance.&nbsp;</li>\n\n\n\n<li><strong>Affiliate marketing: </strong>Sign up for affiliate programs to earn commissions on products you’ve personally tried and you believe your audience will find useful or interesting.&nbsp;</li>\n</ul>\n\n\n\n<p>Always maintain transparency about monetization. Explain how revenue supports community growth and improvement. Many successful communities, like <a href=\"http://dev.to\">DEV.to</a>, openly discuss their business model and gather member input on monetization decisions.</p>\n\n\n\n<p>Start small – test ideas with core members before full rollout. Their feedback helps refine offerings that truly serve the community.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Scaling your thriving community: Gravatar&#8217;s role in sustainable expansion</strong></h2>\n\n\n\n<p>Building a thriving online community requires careful planning, consistent effort, and the right tools. Each element covered in this guide is vital in creating spaces where people genuinely want to connect and contribute.</p>\n\n\n\n<p><a href=\"https://blog.gravatar.com/2024/06/03/profiles-as-a-service/\">Gravatar&#8217;s profiles-as-service system</a> removes major technical hurdles from community growth. This frees you to focus on what matters most – fostering meaningful connections between members.</p>\n\n\n\n<p>The platform supports sustainable expansion through several key features:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Streamlined registration</strong> eliminates common friction points. New members arrive with pre-populated profiles, making them more likely to engage immediately. No more abandoned signups due to lengthy forms.</li>\n\n\n\n<li><strong>Multi-platform identity management</strong> helps members maintain consistent presence across community spaces. A member&#8217;s contributions in your forums, comments, and events all link back to their unified profile on <a href=\"https://github.com/\">GitHub</a>, <a href=\"https://slack.com/\">Slack</a>, and other integrated platforms.</li>\n\n\n\n<li><strong>Rich profiles </strong>enable deeper connections. Members can showcase relevant expertise, interests, and achievements. This makes it easier for them to find like-minded peers and contribute meaningfully to discussions.</li>\n\n\n\n<li><strong>Privacy controls</strong> give members confidence in participation. They can manage multiple identities and control exactly what information appears in different community contexts. This flexibility encourages authentic engagement.</li>\n\n\n\n<li><strong>Developer-friendly integration</strong> speeds implementation through well-documented APIs and SDKs. You can focus on building unique community features instead of recreating basic profile functionality.</li>\n</ul>\n\n\n\n<p>Ready to start building your community? <a href=\"https://docs.gravatar.com/\">Explore how Gravatar can help</a> lay the foundation for sustainable growth while creating engaging member experiences.</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Dec 2024 16:11:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WordPress Training Team Launches New Course for Designers: Beginner WordPress Designer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=183334\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/wordpress-training-team-launches-new-course-for-designers-beginner-wordpress-designer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1749:\"<p>The Training Team has launched a new course on Learn WordPress specifically for designers: <a href=\"https://learn.wordpress.org/course/beginner-wordpress-designer/\">Beginner WordPress Designer</a>. This learning pathway is crafted to help designers new to WordPress gain the skills needed to create professional websites.</p>\n\n\n\n<p>The course covers essential topics such as building a style guide, understanding block themes, and adopting a block-first approach to design. It also teaches best practices in web design, theme customization, layout composition, and working with media blocks.</p>\n\n\n\n<p>This learning pathway is free and open to everyone and consists of 24 lessons organized into 6 sections, requiring approximately 4 hours to complete:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Introduction to designing with WordPress</li>\n\n\n\n<li>Getting to know WordPress</li>\n\n\n\n<li>Web design best practices</li>\n\n\n\n<li>Customizing themes and templates</li>\n\n\n\n<li>Layout composition</li>\n\n\n\n<li>Working with media blocks</li>\n</ul>\n\n\n\n<a href=\"https://x.com/dcwhatwhat/status/1870036926087954635\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcsB3IrCP79JgZlCcxR20I-kjT0wy8FAiSG471vrHErMhi3tkleO2KwZ8wwJU-LmAuauVD-D6FwKOe3NdOdEeSzfPhZbETKhQCGAuUuUwoZQs4jySI_OqjSX2UaGOyiZY9GUXZt2g?key=9To1fAJHQrfgfCSDChmn5_yZ\" alt=\"Tweet from WordPress Training Team rep Jamie Madden: \" /></a>\n\n\n\n<p>Lesley Sim, Co-founder of Newsletter Glue <a href=\"https://x.com/lesley_pizza/status/1870045335906832793\">tweeted</a>, “This looks so good and so useful.”</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> is an educational initiative by the Training team aimed at helping users of all levels improve their WordPress skills.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Dec 2024 20:57:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Matt Mullenweg Asks What Drama to Create in 2025, Community Reacts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=183317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/matt-mullenweg-asks-what-drama-to-create-in-2025-community-reacts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9860:\"<p>On Christmas Eve, WordPress co-founder Matt Mullenweg took to <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/what_drama_should_i_create_in_2025/\">Reddit</a>, causing quite a stir by asking what kind of drama he should create in 2025. He posted, “What drama should I create in 2025? I’m very open to suggestions. Should we stop naming releases after jazz musicians and name them after Drake lyrics? Eliminate all dashboard notices? Take over any plugins into core? Change from blue to purple? I think we can brainstorm together and come up with way better things than I could on my own. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/263a.png\" alt=\"☺\" class=\"wp-smiley\" /> Also, Merry Christmas! <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f384.png\" alt=\"🎄\" class=\"wp-smiley\" />”</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"reddit-embed-bq\"><a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/what_drama_should_i_create_in_2025/\">What drama should I create in 2025?</a><br /> by<a href=\"https://www.reddit.com/user/photomatt/\">u/photomatt</a> in<a href=\"https://www.reddit.com/r/WPDrama/\">WPDrama</a></blockquote>\n</div>\n\n\n\n<p>The post quickly amassed over 500 comments. However, the community was far from being amused, and a good portion of the replies urged him to stop posting, step down, seek professional help, or take a break and avoid creating any drama. “For someone in your position, creating extraneous drama for these people is not only disrespectful, it&#8217;s outright psychopathic to the extent that it affects their ability to work and be productive.”, read one <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/comment/m3ovebk/\">comment</a> from Stubby_Shillelagh.</p>\n\n\n\n<p>Redditor WillmanRacing referenced a Sherman Act violation, suggesting sarcastically, “I have a fantastic idea for some drama we can get up to. Why don&#8217;t we create a <a href=\"https://wordpressfoundation.org/\">charitable foundation</a> governing our open source software product, instead of <a href=\"https://automattic.com/\">our for-profit company</a>. Why don&#8217;t we also operate our main website as its <a href=\"https://wordpress.org/\">own separate entity</a>, with employees and volunteers provided by <a href=\"https://audrey.co/\">yet another entity</a>. Then, why dont we have all of these entities take action against one of our competitors and their entire customer base, refusing to do business with any customers until they stop working with our competitor. Why don&#8217;t we ban ALL of those people from our services, and try to compel them to use our service instead?” </p>\n\n\n\n<p>Many expressed frustration and hoped for a return to normalcy. One Redditor <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/comment/m3om7bh/\">shared</a>, “I&#8217;ve been a huge fan of WordPress for the longest time, and I hate to see all this drama happening. Learning WordPress is actually how I landed my first official programming job. I really hope everything will get back to normal soon.”</p>\n\n\n\n<p>Responding to calls for taking a break, Matt quoted Shakespeare’s Macbeth: “Life&#8217;s but a walking shadow, A poor player that struts and frets his hour upon the stage, and then is heard no more: It is a tale told by an idiot, full of sound and fury, signifying nothing.”</p>\n\n\n\n<p>Matt also hinted that some exciting things are on the way. He said, “I&#8217;m really excited for people to experience Phase 3 of Gutenberg, things like real-time co-editing done completely peer-to-peer with WebRTC.”&nbsp;</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXf07lUKH9MXt_vqFieCzYniY92OBQ5zYieFbWFRkWW7EbOBWMx3wBq0OGn14WjHmtgfdAPR9NaJnV3eFmIN7szRoueCIZ-MYVZX10IpkgBG6skYhRTWHbs1KTsa3n6sl6OD7AKt3Q?key=VJAxsFxouUADeL7bmQ2E84-5\" alt=\"\" />\n\n\n\n<p>Another person <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/comment/m3q58tc/\">chimed in</a>, “Matt is doing to WordPress.org what broadcom is doing to VMware. WordPress used to be such a happy place with a rich thriving developer community, but now everyone is scared shitless that Matt will do a rug pull because he feels like it.”</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>It (WordPress) has a very special place in my heart, as well. I think WordPress&#8217; brightest days are ahead of it. </p>\n\n\n\n<p>&#8211; Matt Mullenweg</p>\n</blockquote>\n\n\n\n<p>Matt was also criticized for not grasping the gravity of the situation. One Redditor <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/comment/m3ohcq4/\">said</a>, “How can you write such a post in a time like this? The WordPress community needs stability and a leadership to trust again. It doesn’t matter if you want to be funny, this is not the right time. Do you think people see this post and think, &#8220;yeah, that’s a project I want to contribute to?&#8221; Contributors are leaving, even getting banned. Clients are worried. Users looking for alternatives. A court is involved. But your actions don’t really look like you get the seriousness of this. It’s really sad to watch.”</p>\n\n\n\n<p>Another Redditor too shared this opinion and Matt replied, “I hope you see how much this is unique to WPE and not something that has happened before or since with others. <strong>Silver Lake holds things for 4-6 years and then flips and moves on. Myself and many others are in this for decades. We have seen their type come and go in the past.</strong>”</p>\n\n\n\n<p>When a Redditor asked about choosing Shopify or sticking with WordPress, Matt recommended, “Use WordPress if you value freedom, autonomy, and want to be in complete control of your digital future. Shopify can be expensive but a good proprietary solution if you want to do exactly what they offer and not color outside the lines too much.” Most of Matt’s comments in Reddit were downvoted. </p>\n\n\n\n<p>Some supported Matt’s recent actions. “Thanks for your &#8220;drama&#8221;. Had it been successful, this would have set the best precedent ever for the all the hyper-capitalist leeches leeching off the free work of others. But everyone is selfish, and short-sighted. They should have taken the opportunity to back you, and dealt with you later, but alas. All fools.”, read one <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/comment/m3r7q2u/\">comment</a>.</p>\n\n\n\n<p>Another one <a href=\"https://www.reddit.com/r/WPDrama/comments/1hlp08d/comment/m3rbe7k/\">said</a>, “If you want to make the change you claim you want to see and Matt take a more ethical stance on his business practices, then maybe give WordPress back to the people for free as it was intended. Until then we should appreciate the guy who brought us to the dance. Does not mean we need to like him, more successful people are not liked, something very sad about watching a group of people attack a man who gave 50% of the net to the world for free.”</p>\n\n\n\n<p>The community also offered Matt various suggestions, both serious and playful:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Provide steady leadership.</li>\n\n\n\n<li>Listen to the community.</li>\n\n\n\n<li>Show restraint and consider how his actions affect the rest of the community.</li>\n\n\n\n<li>Publicly promise that no plugins from the Repo will be taken over.</li>\n\n\n\n<li>Endorse a successor to WordPress</li>\n\n\n\n<li>Federate the Repos and take the hosting costs off Automattic.</li>\n\n\n\n<li>Introduce a built-in way to create a simple contact form&nbsp;</li>\n\n\n\n<li>Hand over WordPress.org to a community-run group.</li>\n\n\n\n<li>Make Gutenberg absolutely awesome.</li>\n\n\n\n<li>Offer WordPress with three options right out of the box: Classic only, Gutenberg only, or both.</li>\n\n\n\n<li>Name WordPress releases after meteors/poets/songwriters.</li>\n\n\n\n<li>Charge $.05 per request to anything at WordPress.org</li>\n</ul>\n\n\n\n<p>Regarding the ongoing drama, Matt said, “We&#8217;ll look back on the WPE drama next year as something that seemed like a big deal at the time but isn&#8217;t that notable in the grand arc of history.”</p>\n\n\n\n<p>&nbsp;He signed off, saying, “I really do enjoy talking with people on the internet, even if we don&#8217;t always agree, and I appreciate everyone taking the time to share their perspective. Forums like this is how I got my start as a teenager. If you think Reddit is spicy, you should have seen Usenet and IRC back in the day! I hope you all have an amazing Christmas and very happy new year.”</p>\n\n\n\n<p>The discussion spilled over to Twitter, too. Ryan Duff <a href=\"https://x.com/ryancduff/status/1871708268755869736\">dubbed</a> it “Just another day of very unhealthy and toxic behavior from WordPress co-founder Matt Mullenweg.”</p>\n\n\n\n<p>Takis Bouyouris <a href=\"https://x.com/takisbig/status/1872231107594535031\">tweeted</a>, “Either Matt has crossed some sort of personal Rubicon, or it is hard to imagine how such pettiness could have been the attribute of one who lead the project for so many years. Being lonely at the top, detached from reality and without healthy consult is a sign of a fading ruler. The Autumn of the Patriarch, by Gabriel García Márquez is a great novel on the topic.”&nbsp;</p>\n\n\n\n<p>Duane Storey <a href=\"https://x.com/DuaneStorey/status/1871773196795691345\">tweeted</a>, “Matt looking down at the #WordPress community on Reddit this Christmas eve, wondering why we are all still singing and enjoying ourselves without our WordPress.org toys.”</p>\n\n\n\n<p>Kellie Peterson <a href=\"https://x.com/kellie/status/1871701861369340395\">exclaimed</a>, “What fresh hell? This is what Matt Mullenweg is doing on Christmas Eve. He could be spending it with his alleged many godchildren, his mother, and his sister but instead he&#8217;s sowing chaos.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Dec 2024 20:13:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Gravatar: The Future of Blog UX: 6 Trends and Tools You Need\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://blog.gravatar.com/2024/12/23/blog-ux-best-practices/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20196:\"<p>Even though great content is an important part of any blog, it’s only a small part of <a href=\"https://blog.gravatar.com/2024/08/16/user-experience-personalization/\">creating great user experiences</a>. Everything on your site should be focused on making sure readers can actually find, enjoy, and interact with what you&#8217;ve written.&nbsp;</p>\n\n\n\n<p>A well-designed user experience keeps visitors reading longer, encourages them to explore more posts, and makes them more likely to take a desired action, whether that&#8217;s signing up for your newsletter or checking out your products.</p>\n\n\n\n<p><strong>Search engines care about user experience too. </strong>Google specifically looks at how people interact with your blog, making UX a significant factor in where your content appears in search results. And according to <a href=\"https://lawsofux.com/jakobs-law/\">Jakob&#8217;s Law</a>, which tells us users prefer websites that work similarly to ones they already know, creating a familiar yet modern interface can dramatically increase engagement.</p>\n\n\n\n<p>Ready to make your blog easier to use and more engaging? Let&#8217;s explore some proven practices and tools to help create an outstanding experience for your readers. Plus, discover how <a href=\"https://gravatar.com/\">Gravatar</a> can boost your blog&#8217;s credibility and user interaction.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>1. Ensuring your blog homepage is easy to navigate and well-organized</strong></h2>\n\n\n\n<p>The homepage of your blog sets the tone for the entire reading experience. Getting it right means implementing smart navigation features that help readers find exactly what they want.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Start with an intelligent search system. </strong>Add auto-suggest functionality that predicts what users might search for as they type and weigh the results based on popularity and relevance. Make sure search results can be filtered by date, category, or content type to help readers narrow down their options.</li>\n</ul>\n\n\n\n<img width=\"1647\" height=\"919\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/example-search-system-woo.png\" alt=\"WooCommerce’s search function\" class=\"wp-image-2565\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Structure your content with a clear taxonomy.</strong> Limit your primary categories to 5-7 options – any more can overwhelm readers. Build nested subcategories for more specific topics and use dynamic tag clouds to show popular subjects. This creates clear pathways for readers to explore related content.</li>\n</ul>\n\n\n\n<img width=\"1687\" height=\"771\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-category-overview.png\" alt=\"Gravatar’s category overview\" class=\"wp-image-2566\" />\n\n\n\n<p>How you load content matters, too. For blogs with lots of posts, choose between:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Infinite scroll:</strong> Great for casual browsing and image-heavy content.</li>\n\n\n\n<li><strong>Pagination:</strong> Better for readers who want to track their progress or return to specific pages.</li>\n</ul>\n\n\n\n<p>On mobile devices, focus on these essential elements:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A clean drawer menu that slides in from the side.</li>\n\n\n\n<li>Floating action buttons for quick access to searches or categories.</li>\n\n\n\n<li>Headers that stay visible while scrolling.</li>\n</ul>\n\n\n\n<p>For content previews on your homepage:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Keep excerpts between 120-160 characters.</li>\n\n\n\n<li>Use 16:9 ratio images for consistency.</li>\n\n\n\n<li>Create custom layouts for different types of posts (tutorials, news, reviews).</li>\n</ul>\n\n\n\n<p>Remember to test your navigation with real users. Watch how they browse and search, then adjust based on their behavior. <strong>The best blog homepage design is one that feels natural and helps readers discover more of your content without thinking about it.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>2. Optimizing the visual experience on your blog posts</strong></h2>\n\n\n\n<p>The main goal of great blog design is to make content easy and pleasant to read. Let&#8217;s look at specific techniques that enhance readability and keep readers engaged.</p>\n\n\n\n<p>Typography needs precise measurements to work well:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Set body text between 16-18px for comfortable reading.</li>\n\n\n\n<li>Use a line height of 1.5-1.6 to create breathing room between lines.</li>\n\n\n\n<li>Keep line length to 60-75 characters to prevent eye strain.</li>\n\n\n\n<li>Pick fonts that render crisply on all screen sizes.</li>\n</ul>\n\n\n\n<p>Make long posts easier to navigate with these structural elements:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Add a sticky table of contents that follows as readers scroll.</li>\n\n\n\n<li>Show a progress bar indicating how far through the post they are.</li>\n\n\n\n<li>Create clear visual separation between sections using whitespace.</li>\n\n\n\n<li>Include &#8220;jump to section&#8221; links for quick navigation.</li>\n</ul>\n\n\n\n<p>The first screen readers see (the &#8220;above-fold&#8221; area) should give them immediate context:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Add a clear summary box highlighting the main points.</li>\n\n\n\n<li>Display estimated reading time prominently.</li>\n\n\n\n<li>Keep at least 15-20% of space empty to avoid visual clutter.</li>\n\n\n\n<li>Use subheadings to break up text into scannable chunks.</li>\n</ul>\n\n\n\n<p>For complex or technical posts:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Create expandable sections for detailed explanations.</li>\n\n\n\n<li>Add tooltips to explain specialized terms.</li>\n\n\n\n<li>Use bullet points and numbered lists for step-by-step instructions.</li>\n\n\n\n<li>Include relevant screenshots or diagrams.</li>\n</ul>\n\n\n\n<p><strong>Most importantly, maintain consistency across all posts. </strong>Readers shouldn&#8217;t have to relearn how to navigate each time they visit. This follows Jakob&#8217;s Law – when elements work the same way throughout your blog, readers feel more confident exploring your content.</p>\n\n\n\n<p>Overall, visual design should support your content, not compete with it. Every element should serve a purpose in making the post easier to read and understand.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>3. Performance optimization: Speeding up your blog with dynamic content loading</strong></h2>\n\n\n\n<p>A fast-loading blog keeps readers happy and engaged. Here&#8217;s how to serve content quickly and efficiently using modern loading techniques.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Start with progressive loading to prioritize what matters</strong>, such as text and critical elements. Defer less important elements until after the main content appears and use resource hints to tell browsers what to load next. For example, you can implement the intersection observer API to load images only as readers scroll through them.&nbsp;</li>\n\n\n\n<li><strong>Structure your JavaScript smartly</strong> by splitting code into smaller chunks that load only when needed. Use dynamic imports for features like comment sections or sharing buttons, load third-party scripts (like analytics) after core content, and apply virtual scrolling on index pages to handle large archives efficiently.&nbsp;</li>\n\n\n\n<li><strong>Optimize images for better performance</strong> by compressing them without noticeably reducing quality. We recommend generating WebP versions of all images and creating multiple sizes for different screen widths. You could also use content-aware loading to prioritize visible images.</li>\n\n\n\n<li><strong>Set up technical optimizations</strong>, including browser caching with appropriate cache-control headers, skeleton screens (placeholder content) while posts load, and a CDN that will serve assets from locations close to your readers. Make sure you monitor Core Web Vitals regularly to catch performance issues early.&nbsp;</li>\n\n\n\n<li><strong>Include infinite scroll implementations</strong> like pre-loading the next set of posts before readers reach the bottom, keeping memory usage in check by removing posts far outside the viewport, saving scroll position when readers click through to a post, and showing loading indicators only when new content is actually loading.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>4. Making your blog more authoritative through E-E-A-T best practices</strong></h2>\n\n\n\n<p>Building trust with users means showing them exactly why they should value your content. Experience, expertise, authoritativeness, and trustworthiness (E-E-A-T) help readers – and search engines – understand the credibility behind your posts.</p>\n\n\n\n<p>The best way to do that is by creating <a href=\"https://blog.gravatar.com/2024/10/23/upgrade-author-profiles-with-the-gravatar-block-for-wordpress/\">comprehensive author profiles</a>:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>List relevant credentials and certifications.</li>\n\n\n\n<li>Highlight years of experience in specific topics.</li>\n\n\n\n<li>Link to other published work and research.</li>\n\n\n\n<li>Show professional achievements and awards.</li>\n\n\n\n<li>Connect social media profiles to establish a reliable <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">digital presence</a>.</li>\n</ul>\n\n\n\n<p>Gravatar makes managing author identities simple across multiple platforms. Contributors have to create just one profile, and their information appears on Gravatar-supported websites, including every <a href=\"http://wordpress.com\">WordPress.com</a> blog. There, the integration happens automatically – perfect for blogs with multiple contributors or authors who write across different sites.&nbsp;</p>\n\n\n\n<p>For <a href=\"http://wordpress.org\">WordPress.org</a> sites, the <a href=\"https://wordpress.org/plugins/gravatar-enhanced/\">Gravatar Enhanced plugin</a> adds powerful profile features:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Customizable author profile blocks.</li>\n</ul>\n\n\n\n<img width=\"1548\" height=\"742\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/profile-block-example.png\" alt=\"The Gravatar profile block on WordPress\" class=\"wp-image-2567\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Automatic profile card embedding in posts.&nbsp;</li>\n\n\n\n<li>Social media integration.&nbsp;</li>\n\n\n\n<li>Custom biography sections.</li>\n</ul>\n\n\n\n<img width=\"1542\" height=\"724\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/customizable-author-biography.png\" alt=\"Example of a customizable author biography section \" class=\"wp-image-2568\" />\n\n\n\n<p>You can use these features to build authority with your audience and create dedicated pages showcasing each author&#8217;s expertise. And if your users don’t have a Gravatar profile, you can set up an automated email sequence inviting them to create one.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"198\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-plugin-invitation.png?w=660\" alt=\"Example of an invitation to create a Gravatar profile\" class=\"wp-image-2569\" />\n\n\n\n<p><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" /><em>If you’re not on WordPress (org or com), don’t worry! You can use Gravatar on any platform thanks to its easy-to-implement </em><a href=\"https://blog.gravatar.com/2024/06/03/profiles-as-a-service/\"><em>REST API</em></a><em>.</em></p>\n\n\n\n<p>Now, going beyond author profiles, you can build authority by structuring your archives effectively. For example, you can create Group posts by topic to demonstrate subject knowledge and display engagement metrics like comment counts. When you have someone who’s been contributing for a while, you can feature their most popular or influential posts or add testimonials from industry peers or readers.&nbsp;</p>\n\n\n\n<p>We also recommend that you make expertise visible throughout your content, not just through design:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Add &#8220;About the Author&#8221; sections within posts.</li>\n\n\n\n<li>Include relevant credentials in article introductions.</li>\n\n\n\n<li>Link to author&#8217;s research or cited works.</li>\n\n\n\n<li>Show expertise indicators next to author names.</li>\n\n\n\n<li>Feature author contributions to industry publications.</li>\n</ul>\n\n\n\n<p>The Gravatar API lets you enhance these profiles further:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pull in verified professional achievements.</li>\n\n\n\n<li>Display unified author information across platforms.</li>\n\n\n\n<li>Show real-time updates to author credentials.</li>\n\n\n\n<li>Create custom profile layouts for different content types.</li>\n</ul>\n\n\n\n<p>Whatever your approach is, the best strategy is authenticity. Focus on highlighting genuine expertise and real accomplishments rather than inflating credentials. Readers appreciate honesty and will trust authors who demonstrate their knowledge through quality content backed by verifiable experience.</p>\n\n\n\n<a href=\"https://wordpress.org/plugins/gravatar-enhanced/\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_enhanced_cta.png\" alt=\"\" class=\"wp-image-2634\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>5. Boosting engagement and user interactions on your blog</strong></h2>\n\n\n\n<p>There are several strategies you can implement for a successful and engaging experience.&nbsp;</p>\n\n\n\n<p>First, you must <strong>ensure that your internal linking structure is logical</strong> – you don’t need to link to everything, just the posts that make sense. When you’re smart about it, you can keep readers exploring your content naturally through connections based on topics, skill levels, and reader interests. So, place contextual links within your content where they add value, and use automated related post sections that adapt based on what similar readers have found useful.</p>\n\n\n\n<p>Now, it’s a great thing to guide your readers throughout the blog, but you also need to <strong>motivate them with concrete but meaningful calls to action</strong>. Don’t bombard them with popups; analyze your scroll depth data to understand where readers are most receptive to taking action. Test different CTA positions, designs, and messages with various user segments to find what resonates best.</p>\n\n\n\n<p>Want to create a successful newsletter? <strong>Think beyond basic signup forms.</strong> <a href=\"https://wordpress.com/newsletter/\">WordPress.com&#8217;s native newsletter</a> functionality allows for sophisticated subscriber management. You can segment your audience, deliver automated post notifications, and track which content drives the most engagement. Plus, you can show different content blocks depending on whether someone&#8217;s already subscribed.</p>\n\n\n\n<p>However, perhaps the most powerful way to <strong>build engagement is through an active comment section</strong>. Here&#8217;s where Gravatar&#8217;s universal profile system really shines. When readers comment, their <a href=\"https://blog.gravatar.com/2024/06/05/user-profile-page-examples/\">verified profiles</a> automatically sync across any Gravatar-enabled platform. This builds a sense of community as readers recognize familiar faces and can trust they&#8217;re interacting with real people.</p>\n\n\n\n<img width=\"1784\" height=\"992\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-comment-section.png\" alt=\"Example of a comment section with Gravatar profiles\" class=\"wp-image-2570\" />\n\n\n\n<p>With the <a href=\"https://jetpack.com/\">Jetpack</a> plugin, you can enhance this further by enabling <a href=\"https://support.gravatar.com/profiles/hovercards/\">hovercards</a> – detailed profile previews that appear when readers hover over a commenter&#8217;s name. These cards can display social connections, verified links, and complete user information, encouraging meaningful discussions while reducing spam and low-quality comments. This feature is automatically enabled on WordPress.com websites.&nbsp;</p>\n\n\n\n<img width=\"1036\" height=\"569\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/hovercards-example.png\" alt=\"Example of hovercards\" class=\"wp-image-2571\" />\n\n\n\n<p>Want to set up commenting on your WordPress site? Check out our detailed <a href=\"https://blog.gravatar.com/2024/07/11/enable-comments-in-wordpress/#:~:text=Enable%20comments%20on%20specific%20posts&text=Go%20to%20the%20Discussion%20panel,and%20click%20on%20Allow%20comments\">guide on enabling and managing comments</a> effectively.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>6. Creating multimedia elements that add genuine value to articles</strong></h2>\n\n\n\n<p>Adding images, videos, and interactive elements can enhance understanding – but only if they&#8217;re implemented thoughtfully. Your multimedia content should support your message without slowing down your blog.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Data visualization demands careful attention to detail:</strong> Interactive charts and graphs have to work across screen sizes while maintaining readability. Before adding a visual element, ask whether it makes complex information clearer. And remember to A/B test different visualization styles to see which ones readers engage with most.</li>\n\n\n\n<li><strong>Video integration requires balancing quality with performance: </strong>Implement lazy loading so videos only download when readers scroll near them. This keeps your pages fast while still offering rich content. Match your video player controls to your blog&#8217;s design, and add clear thumbnails that tell readers what they&#8217;ll learn.</li>\n</ul>\n\n\n\n<p>Whatever multimedia elements you choose, optimize them for <a href=\"https://support.google.com/webmasters/answer/9205520?hl=en\">Core Web Vitals</a>:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Compress files without sacrificing quality.</li>\n\n\n\n<li>Set proper width and height attributes to prevent layout shifts.</li>\n\n\n\n<li>Use modern formats like WebP for images and WebM for video.</li>\n\n\n\n<li>Ensure all content works well on mobile devices.</li>\n</ul>\n\n\n\n<p>Most importantly, <strong>make your multimedia content accessible</strong>. Add descriptive alt text for images, provide transcripts for videos, and ensure interactive elements work with keyboard navigation and screen readers.</p>\n\n\n\n<p>Think of multimedia as a powerful tool, not a requirement. Each element should serve a clear purpose in helping readers better understand your content. When used strategically, these additions can transform complex topics into engaging, memorable experiences.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Boost your blog’s UX with Gravatar integration</strong></h2>\n\n\n\n<p>Ready to put these UX improvements into action? Gravatar offers a simple way to enhance your blog&#8217;s user experience through automated profile management.</p>\n\n\n\n<p>The Gravatar Enhanced plugin makes implementation straightforward, with customizable profile blocks that showcase author expertise and build reader trust. Hovercards add depth to your comment sections, displaying detailed user information when readers hover over profile images. This creates a more dynamic, engaging experience that encourages meaningful discussions.</p>\n\n\n\n<p>For developers, the Gravatar API enables custom profile displays tailored to your blog&#8217;s specific needs. Build unique author showcases, create advanced comment systems, or integrate user profiles in creative ways. Plus, built-in privacy controls let users manage exactly what information they share.</p>\n\n\n\n<p>Whether you’re a developer or a passionate blogger, you can use Gravatar to transform your blog into an engaging, professional platform where readers can connect with authors and each other meaningfully. Check out the <a href=\"https://docs.gravatar.com/\">Gravatar REST API</a> or the <a href=\"https://wordpress.org/plugins/gravatar-enhanced/\">Gravatar Enhanced plugin</a> today!</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Dec 2024 19:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Joost de Valk Calls for Breaking the WordPress Status Quo, Community Reacts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=183019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/joost-de-valk-calls-for-breaking-the-wordpress-status-quo-community-reacts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10236:\"<p>Joost de Valk, co-founder of the Yoast SEO plugin has called for <a href=\"https://joost.blog/wordpress-leadership/\">Breaking the Status Quo</a> of the WordPress world. This comes in the wake of Matt Mullenweg’s announcement of a <a href=\"https://wptavern.com/matt-mullenweg-declares-holiday-break-for-wordpress-org-services\">holiday break for WordPress.org</a> and the ongoing Automattic-WP Engine legal dispute.</p>\n\n\n\n<p>de Valk said, “We, the WordPress community, need to decide if we’re ok being led by a single person who controls everything, and might do things we disagree with, or if we want something else. For a project whose tagline is “Democratizing publishing”, we’ve been very low on exactly that: democracy.”</p>\n\n\n\n<p>Referring to Mullenweg as a BDFL (Benevolent Dictator For Life), de Valk argued that Matt is “no longer Benevolent, and because of that, speaking up in public is a risk.” </p>\n\n\n\n<p>de Valk acknowledged that due to Yoast’s contributions to WordPresss, he “did get some say in where WordPress went, though never officially, and never when it went in directions that Matt disagreed with. Over time, that influence became less as Matt tightened his grip on the project. I think that tightening was in part a cramp. Wanting to control more what people were working on, because the project wasn’t progressing fast enough in the direction he wanted it to go in.”</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I think it’s time to let go of the cult and change project leadership. I’ve said it before: we need a “board”. We can’t wait with doing that for the years it will take for Automattic and WP Engine to fight out this lawsuit.</p>\n\n\n\n<p>&#8211; Joost de Valk</p>\n</blockquote>\n\n\n\n<p>He said, “I’m still, to this day, very thankful for what Matt has created. I would love to work with him to fix all this. But it’s clear now, that we can no longer have him be our sole leader, although I’d love it if we could get him to be among the leaders.”</p>\n\n\n\n<p>He put forward 5 steps that must be taken fast:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A WordPress foundation-like entity consisting of a board with people from diverse backgrounds leads the project.</li>\n\n\n\n<li>WordPress.org and key community assets are transferred to the foundation.</li>\n\n\n\n<li>The WordPress trademark is made public domain or managed for free use.</li>\n\n\n\n<li>Companies and individuals can sponsor the foundation, receiving perks like listings on a hosting page.</li>\n\n\n\n<li>Small teams are formed for Architecture, Product, Events, etc., with proper governance.</li>\n</ul>\n\n\n\n<p>He also suggested “Federated and Independent Repositories” to decentralize the official WordPress repository. He said, “Matt might not agree to my first five points above. However, we can still work on the Federated and Independent Repositories without his permission because, frankly, we don’t need it.”</p>\n\n\n\n<p>He revealed that he’s already in talks with other community figures like Karim Marucchi, CEO of <a href=\"https://crowdfavorite.com/\">Crowd Favorite</a>. He is also willing to take up the mantle of the movement if needed.&nbsp;</p>\n\n\n\n<p>He said, “I’m here, and willing to lead through this transition. I do have the time, the energy and the money needed to fund myself doing it. I’ve worked in this industry and this community for close to 20 years and it’s very dear to me. Thanks in large part to the WordPress project, I have the privileged position to be able to drop and/or delegate some of the stuff I’m working on and start working on this.”</p>\n\n\n\n<h2 class=\"wp-block-heading\">Karim Marucchi&#8217;s Vision For a New WordPress Business Roadmap</h2>\n\n\n\n<p>Karim Marucchi of Crowd Favorite <a href=\"https://marucchi.com/wordpress-leadership-continued/\">backed Joost de Valk</a>. He said, “the current situation has jeopardized the very fabric of this ecosystem.”</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>We need to prevent a single entity from doing to WordPress what befell other open-source projects that shrank or died while protecting one party’s market position.</p>\n\n\n\n<p>&#8211; Karim Marucchi</p>\n</blockquote>\n\n\n\n<p>He proposed five essential critical paths to concentrate on:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Securing the supply chain &amp; start modernization </li>\n\n\n\n<li>Convening, defining &amp; creating the Commons </li>\n\n\n\n<li>Defining the roadmap as “the” Open-Web’s Operating System.</li>\n\n\n\n<li>Open Source as a hub for innovation</li>\n\n\n\n<li>Focusing on leading data ownership, privacy, and accessibility</li>\n</ul>\n\n\n\n<p>de Valk and Marucchi will get together with other community leaders in January 2025 to decide the way forward.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Response From Matt</h2>\n\n\n\n<p>Matt commented under de Valk’s blog post: “I think this is a great idea for you to lead and do under a name other than WordPress. There’s really no way to accomplish everything you want without starting with a fresh slate from a trademark, branding, and people point of view.”</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcTpyqNYnNjZg-xV2Rv1R7x3qQXGpoU7AVGZOc8tFo9OOrVkfiL8ChA2lRDim6K7cX0D6yfTdxr8OjEGK-hQHA9_hnfXqMbbQICT9rD3KXX9KrRuxfPPDRt-DaNRfYhaKGxBmGfzQ?key=-I6GkQPHdB1BBSFBEdeFapzU\" alt=\"\" />\n\n\n\n<h2 class=\"wp-block-heading\">Response From the Community </h2>\n\n\n\n<p>Joost de Valk found support from other community leaders too.&nbsp;</p>\n\n\n\n<p>Brian Gardner of WP Engine supported de Valk, <a href=\"https://x.com/bgardner/status/1870160970930094201\">tweeting</a>, “Cosign. (My personal op and b/c I <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f49b.png\" alt=\"💛\" class=\"wp-smiley\" /> WordPress.)”</p>\n\n\n\n<p>WP Engine also came out in <a href=\"https://x.com/wpengine/status/1870242287218790849\">support</a>.&nbsp;</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXdEiJs51Ktl6ff9Sk9qm46CV7Ov8Jz0F57KRKIXNwYrGYQT-T8w1r0MPOJb-7TfTRLPEEtdX8wPepMDPulo20eAC04JCpQmKaMhVAPAalacKcJbWqJaDdGUcUc8Xn4PsZdJkHYL?key=-I6GkQPHdB1BBSFBEdeFapzU\" alt=\"\" />\n\n\n\n<p>Michele Butcher-Jones of Can’t Speak Geek also shared her <a href=\"https://x.com/Michele_Butcher/status/1870153025970389432\">thoughts</a>:</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXdmEzYfuNjqwVmODtiT7PFZTYA2Prtc6p5vlH-U46nbuPrPotPJh3NZj6NHuFSa6FvNJjKzIZYl7Ll2UmoaJbgqo7M03lP2zn_Z5mYm7zddaTZFhtqzyiUlu3Rjen4L4RO-6lWv?key=-I6GkQPHdB1BBSFBEdeFapzU\" alt=\"\" />\n\n\n\n<p>Katie Keith of Barn2Plugins <a href=\"https://x.com/KatieKeithBarn2/status/1870209673300988414\">shared</a>, “Wow, I never expected someone as high profile as&nbsp; @jdevalk to speak out so openly against the current leadership of WordPress. However, I completely agree with his analysis of the situation and his proposed solutions.”</p>\n\n\n\n<p>WordPress Core Committer Tonya Mork <a href=\"https://x.com/hellofromTonya/status/1870185509391348102\">said</a>, “I&#8217;ve been mostly quiet, other than publicly pausing my WordPress Core contributions. That ends today. I stand with&nbsp; @jdevalk and @karimmarucchi for the &#8220;hold this community together&#8221; effort. Publicly sharing my support.”</p>\n\n\n\n<p>Taco Verdo of Emilia Capital had this to <a href=\"https://x.com/TacoVerdo/status/1870227289327161440\">say</a>:</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcS5tGbOrk8z10qVICgWBrl6BrRMHwTxgVgdPShb2cv6cjp7-xfBOyxvdIY48IBP2fvpiHtr0KxbO53aGIbjZZDT9qXGsv-f-NeYQ3I94Rc6D_HhP_2YA0gHk5CUobGxmIf6wta1g?key=-I6GkQPHdB1BBSFBEdeFapzU\" alt=\"\" />\n\n\n\n<p><a href=\"https://x.com/schutzsmith/status/1870241562245960157\">Daniel Schutzsmith</a>, <a href=\"http://on Brown @jb510\">Jon Brown</a>, <a href=\"https://x.com/MeetKarissa/status/1870188249064387046\">Karissa Skirmont</a>, <a href=\"https://x.com/BlakeWhittle7/status/1870184049236464120\">Blake Whittle</a>, <a href=\"https://x.com/DuaneStorey/status/1870144554562986053\">Duane Storey</a>, <a href=\"https://x.com/vovafeldman/status/1870433054533013625\">Vova Feldman</a> and <a href=\"https://x.com/takisbig/status/1870398208985215188\">Takis Bouyouris</a> also came out in support of de Valk.&nbsp;&nbsp;</p>\n\n\n\n<p>Andrei Lupu was, however, against the development. He <a href=\"https://x.com/euthelup/status/1870215581841911837\">said</a>, “Let me nuke my WP career with an honest question: why would we follow a board of people who sold their products when they peaked? No one is perfect and I&#8217;m not sure if switching from one person&#8217;s vision to multiple people fighting for influence of a &#8220;board&#8221; is a good thing.”</p>\n\n\n\n<p>@ViaEth also <a href=\"https://x.com/ViaEth/status/1870485717232882157\">supports</a> Matt. “All of this started after WPE couldn&#8217;t continue to leech off the #WordPress branding. All of these blog posts and whining just proves @photomatt right. Companies want to suck WP dry if this was purely about altruistic reason they would just fork the codebase and fuck off.”</p>\n\n\n\n<p><a href=\"https://x.com/jessuppi/status/1870432050370769222\">Jesse Nickles</a>, an SEO enthusiast, also does not believe in de Valk. He said, “Despite my desire to want to give you another chance as a &#8220;thought leader&#8221; or whatever else, 2 things are seared into my memory&#8230; first, the fact that Yoast SEO was always, and still is, one of the most dishonest and tricky plugins in WordPress history.”</p>\n\n\n\n<p>Morten Rand-Hendriksen published <a href=\"https://www.linkedin.com/pulse/after-wordpress-morten-rand-hendriksen-mkvgc/\">After WordPress</a>. According to him, there are two paths forward for the WordPress community:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Mullenweg releases his iron grip on the project, brings in proper governance, creates a more equitable ecosystem economy, and steps into a role of visionary leader instead of micromanager.&nbsp;</li>\n\n\n\n<li>The community organizes, takes every lesson learned over the past 20+ years, combines with a vision for what the world will need going into the next 10 years, and builds a new platform to stand on.</li>\n</ul>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Dec 2024 19:00:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Gravatar: Customize Your Link in Bio: Top Tools Reviewed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2436\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://blog.gravatar.com/2024/12/20/link-in-bio-tools/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19973:\"<p>Every social media platform has an About section. However, this tends to be very limited in terms of what you can include in it, making it hard to make a memorable first impression and truly tell people what you’re all about. For example, these sections often limit you to a single link in your profile and don’t allow different content formats, just text.&nbsp;</p>\n\n\n\n<p>That&#8217;s why link-in-bio tools have become essential for anyone sharing content online. These tools let you pack multiple destinations into one simple URL, making it easier to guide followers to your content, products, or services.</p>\n\n\n\n<p>This is important for everyone – from an influencer promoting sponsored content to a business owner showcasing products. But with so many tools on the market, it can be hard to choose the right one – some offer basic link collections, while others provide advanced features like analytics and customization options.</p>\n\n\n\n<p>This guide examines popular link-in-bio tools, from dedicated solutions like <a href=\"https://blog.gravatar.com/2024/10/21/linktree-alternatives/\">Linktree</a> to comprehensive profile systems like <a href=\"https://gravatar.com/\">Gravatar</a>. You&#8217;ll learn about essential features, pricing comparisons, and practical tips to help you select the tool that fits your needs.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>What is a link-in-bio tool?</strong></h2>\n\n\n\n<p>A link-in-bio tool creates a single webpage that houses all your important links. Think of it as a mini-website that fits inside your social media profile&#8217;s single link limitation. Instead of choosing between linking to your website, the latest video, or a new product, you can share everything at once.</p>\n\n\n\n<p>These tools typically let you include the following:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Social media profiles</li>\n\n\n\n<li>Website links</li>\n\n\n\n<li>Product pages</li>\n\n\n\n<li>Blog posts</li>\n\n\n\n<li>Contact information</li>\n\n\n\n<li>Latest announcements</li>\n\n\n\n<li>Promotional content</li>\n</ul>\n\n\n\n<p>As you can see, this is a great alternative to X’s (Twitter) one-link or <a href=\"https://blog.gravatar.com/2024/04/12/maximize-your-instagram-bio-the-top-tools-to-consider/\">Instagram’s five-link limit</a>. However, beyond solving the one-link problem, these tools make your profile look more professional.&nbsp;</p>\n\n\n\n<p>Rather than cramming multiple URLs into your bio text, you present a clean, organized hub for your content. This makes it easier for followers to find what they&#8217;re looking for, whether that&#8217;s your latest <a href=\"https://www.youtube.com/\">YouTube</a> video or your online store.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Features to consider in a link-in-bio tool</strong></h2>\n\n\n\n<p>While the features you require will depend on your specific use case, there are some universal good-to-haves that every good link-in-bio tool should provide.&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Flexible presentation options.</strong> Look for platforms that provide various layouts and themes to match your style. For example, a photographer might want a grid layout to showcase their portfolio, while a musician might prefer a list format with embedded music players.</li>\n\n\n\n<li><strong>Design flexibility beyond basic themes.</strong> The best tools let you control colors, fonts, and layouts to match your brand identity. Some even allow custom CSS for complete design control. This means you can make your bio page look like a natural extension of your website or social media presence.</li>\n\n\n\n<li><strong>Link management features. </strong>While basic tools might limit you to 5-10 links, more advanced options offer unlimited links with organizing capabilities. You might want to group your podcast episodes separately from your shop links, or temporarily feature a special promotion without deleting your regular links.</li>\n\n\n\n<li><strong>Additional content features.</strong> Beyond simple URLs, look for tools that support text descriptions, image galleries, video embeds, or newsletter signups. A makeup artist could embed tutorial videos directly in their bio page, while a writer could feature book excerpts alongside purchase links.</li>\n\n\n\n<li><strong>Useful integrations with other platforms.</strong> This might include connecting your eCommerce store to display products, embedding your Spotify playlist, or linking your email marketing service to capture leads. These integrations save time by automatically updating your bio page when you post new content.</li>\n\n\n\n<li><strong>Privacy and user control features.</strong> Some tools let you password-protect certain links, manage multiple profiles from one account, or control who can edit your page. This becomes especially important when working with teams or managing different brands.</li>\n\n\n\n<li><strong>In-depth analytics. </strong>Good tools show you which links get the most clicks, when people visit your page, and where they&#8217;re coming from. This data helps you optimize your page – for instance, you might discover that placing your newsletter signup at the top doubles your conversion rate.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Comparing the top link in bio tools</strong></h2>\n\n\n\n<p>Each link-in-bio tool offers unique advantages. Here&#8217;s a detailed look at seven popular options to help you make an informed choice.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Gravatar</strong></h3>\n\n\n\n<img width=\"660\" height=\"343\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-new-homepage-4.png?w=660\" alt=\"Gravatar homepage\" class=\"wp-image-2444\" />\n\n\n\n<p>At its core, <a href=\"https://gravatar.com/\">Gravatar</a> is a universal profile system that doubles as a link-in-bio tool with a unique <a href=\"https://blog.gravatar.com/2024/02/27/gravatar-manifesto-one-profile-everywhere/\">&#8220;Set once, seen everywhere&#8221;</a> approach to online profiles. When you create a Gravatar profile, thousands of websites can automatically display your profile picture and information – but only with your consent.&nbsp;</p>\n\n\n\n<p>For example, when you comment on a WordPress blog or contribute to a GitHub project, these platforms can pull in your verified profile data. This automatic syncing saves time and ensures consistency across your <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">online presence</a>.</p>\n\n\n\n<img width=\"660\" height=\"103\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/sites-using-gravatar.png?w=660\" alt=\"Logos of sites using Gravatar\" class=\"wp-image-2460\" />\n\n\n\n<p>The platform functions as both a <a href=\"https://blog.gravatar.com/2024/08/28/level-up-your-profile-3-cool-new-features-for-your-link-in-bio/\">link-in-bio tool</a> and a comprehensive profile system. You can add:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Essential links to social media and websites.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"429\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-links-feature-1.png?w=660\" alt=\"Adding website links to a Gravatar profile\" class=\"wp-image-2446\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Verified account connections.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"333\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-profile-links-new-4.png?w=660\" alt=\"Gravatar verified links feature \" class=\"wp-image-2447\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>About Me section.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"510\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-about-section.png?w=660\" alt=\"Editing the About section in Gravatar\" class=\"wp-image-2448\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Payment details.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"336\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-wallet-feature.png?w=660\" alt=\"Adding payment links and wallet addresses to Gravatar\" class=\"wp-image-2450\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Contact information.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"285\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/adding-contact-info-to-gravatar-profile.png?w=660\" alt=\"Adding contact information to Gravatar profile\" class=\"wp-image-2451\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Images and videos.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"238\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-images-section.png?w=660\" alt=\"Adding images to a Gravatar profile\" class=\"wp-image-2452\" />\n\n\n\n<p>Customization options give you full control over your profile&#8217;s appearance. Drag and drop elements to perfect their placement, choose background colors that match your brand, and add custom headers and footers to make the page yours. The layout builder makes it simple to create a professional-looking profile without needing design skills.</p>\n\n\n\n<p>Think of Gravatar as a <a href=\"https://blog.gravatar.com/2024/08/02/organizational-benefits-of-efficient-contact-sharing/\">digital business card</a> that evolves with your online presence. Beyond basic contact details, it showcases your portfolio, connects your social profiles, and highlights your professional achievements – all in one place that updates everywhere automatically.</p>\n\n\n\n<p>Privacy remains in your control. Create multiple profiles for different aspects of your life – perhaps one for professional connections and another for creative projects. Choose exactly what information appears on which websites and manage all your online identities from a single dashboard.</p>\n\n\n\n<p>Unlike most competitors, Gravatar offers <a href=\"https://blog.gravatar.com/2024/06/26/link-your-gravatar-profile-with-a-free-custom-domain/\">free custom domain support</a> (when acquired through <a href=\"http://wordpress.com\">WordPress.com</a>). This means your bio page can live at “yourname.link” instead of a platform-specific URL. And the entire service costs nothing for individual users, making it an accessible option for anyone building their online presence.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Linktree</strong></h3>\n\n\n\n<img width=\"660\" height=\"471\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/linktree-homepage.png?w=660\" alt=\"Linktree homepage\" class=\"wp-image-2453\" />\n\n\n\n<p><a href=\"https://linktr.ee/\">Linktree</a> popularized the link-in-bio concept with its straightforward approach. The platform shines with its user-friendly interface and extensive template collection. You can set up a basic page in minutes, choosing from various button styles and color schemes.</p>\n\n\n\n<p>With their free plan, you get unlimited links, QR codes, and a Shop tab to sell products like merch and affiliates. If you decide to go for one of their paid plans, however, you get:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Advanced design options like custom animations</li>\n\n\n\n<li>Deeper analytics, such as performance for specific links.</li>\n\n\n\n<li>Link scheduling, SEO settings, <a href=\"https://accounts.google.com/signin/v2/identifier?service=analytics&passive=1209600&continue=https%3A%2F%2Fanalytics.google.com%2Fanalytics%2Fweb%2F%23&followup=https%3A%2F%2Fanalytics.google.com%2Fanalytics%2Fweb%2F&flowName=GlifWebSignIn&flowEntry=ServiceLogin\">Google Analytics</a>, and other marketing tools.&nbsp;</li>\n\n\n\n<li>Collecting email addresses and phone numbers.&nbsp;</li>\n\n\n\n<li>Priority support and tailored onboarding with the highest tier.&nbsp;</li>\n</ul>\n\n\n\n<p>Linktree also integrates well with platforms like <a href=\"https://mailchimp.com/\">Mailchimp</a> and <a href=\"https://www.shopify.com/\">Shopify</a>, making it suitable for email marketing and ecommerce.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Later Link in Bio</strong></h3>\n\n\n\n<img width=\"660\" height=\"396\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/later-link-in-bio-homepage.png?w=660\" alt=\"Later link-in-bio tool homepage\" class=\"wp-image-2454\" />\n\n\n\n<p><a href=\"https://later.com/link-in-bio/\">Later&#8217;s tool</a> takes a unique approach by turning your Instagram feed into clickable content. Each post becomes a link destination, making it perfect for visual content creators who frequently reference past Instagram posts.&nbsp;</p>\n\n\n\n<p>There is a free plan, but it’s very hard to find what’s actually included in it. The paid tiers start from $25/month up to $80 for individuals and $200 per month for agencies.&nbsp;</p>\n\n\n\n<p>Features include:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>30 and 150 posts per social profile for the first two paid tiers and unlimited for the rest.&nbsp;</li>\n\n\n\n<li>Easy integration with Later&#8217;s social media scheduling tools for planning posts and corresponding bio links in advance.&nbsp;</li>\n\n\n\n<li>Analytics with up to 1 year of data.</li>\n\n\n\n<li>Credits for AI features.&nbsp;</li>\n\n\n\n<li>Brand collab tools for creators.&nbsp;</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Hopp by Wix</strong></h3>\n\n\n\n<img width=\"660\" height=\"344\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/hopp-by-wix-homepage.png?w=660\" alt=\"Hopp homepage\" class=\"wp-image-2455\" />\n\n\n\n<p>Built on <a href=\"https://www.wix.com/\">Wix&#8217;s</a> website platform, <a href=\"https://www.hopp.co/\">Hopp</a> offers extensive customization options. Users benefit from Wix&#8217;s drag-and-drop interface and design flexibility, making it possible to create highly personalized landing pages.</p>\n\n\n\n<p>Besides that, you also get:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>URL shortening to match the brand name.&nbsp;</li>\n\n\n\n<li>A mobile landing page that you can track.&nbsp;</li>\n\n\n\n<li>Smart promotions that show a pre-roll when a user clicks on a specific URL.&nbsp;</li>\n</ul>\n\n\n\n<p>The platform particularly suits small businesses thanks to its built-in ecommerce capabilities. You can sell products directly through your bio page, complete with inventory management and secure payment processing.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Sprout Social</strong></h3>\n\n\n\n<img width=\"660\" height=\"318\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/sprout-social-link-in-bio-tool.png?w=660\" alt=\"Sprout Social’s link-in-bio tool homepage\" class=\"wp-image-2456\" />\n\n\n\n<p>Aimed at businesses and agencies, <a href=\"https://sproutsocial.com/features/link-in-bio/\">Sprout Social&#8217;s link-in-bio</a> feature comes as part of its comprehensive social media management suite. The tool emphasizes professional features like:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Grid-like design of the links that mirrors an Instagram feed.</li>\n\n\n\n<li>Advanced analytics – group, profile, and post-level reporting.&nbsp;</li>\n\n\n\n<li>Automated link rotation and link scheduling.</li>\n\n\n\n<li>Engagement and customer care services include social inbox, comment moderation, and case management.&nbsp;</li>\n</ul>\n\n\n\n<p>While it&#8217;s one of the pricier options with no free plan, the integrated approach makes sense for teams already using Sprout Social&#8217;s other features. The tiers start from $199/per seat per month up to $399.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Stan</strong></h3>\n\n\n\n<img width=\"660\" height=\"430\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/stan-link-in-bio-tools.png?w=660\" alt=\"Stan homepage\" class=\"wp-image-2457\" />\n\n\n\n<p><a href=\"https://www.stan.store/\">Stan</a> focuses on monetization, functioning as both a link-in-bio tool and an ecommerce platform. It&#8217;s built specifically for creators who want to:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Sell digital products, services, courses, and webinars.&nbsp;</li>\n\n\n\n<li>Offer paid subscriptions.</li>\n\n\n\n<li>Host exclusive content.</li>\n\n\n\n<li>Manage fan relationships.</li>\n</ul>\n\n\n\n<p>The platform includes features for managing customer relationships and tracking sales metrics, though its specialized nature means it might be overkill for users just seeking basic link sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Maximizing impact: Best practices for link in bio optimization</strong></h2>\n\n\n\n<p>Creating a link in bio page marks just the beginning – optimizing it is what drives real results. Here&#8217;s how to make your page more effective.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Start with a clean, organized design that matches your brand.</strong> If you&#8217;re a photographer with a minimalist black-and-white Instagram feed, your bio page should reflect that same aesthetic. This visual consistency helps visitors instantly recognize and trust your page.</li>\n\n\n\n<li><strong>Place your most important content at the top</strong> – that new product launch or latest video needs prime placement. And remember to remove outdated links promptly. Nothing frustrates visitors more than clicking a &#8220;new release&#8221; link from three months ago.</li>\n\n\n\n<li><strong>Write clear, action-focused text for each link.</strong> Instead of &#8220;My YouTube,&#8221; try &#8220;Watch my latest photography tutorials.&#8221; Rather than &#8220;Shop,&#8221; use &#8220;Browse handmade ceramics.&#8221; These specific descriptions tell visitors exactly what to expect, increasing the likelihood they&#8217;ll click.</li>\n\n\n\n<li><strong>Test your page on different devices – mobile, desktop, and tablet. </strong>Are buttons easy to tap? Is text readable without zooming? Does the page load quickly? Most of your visitors will browse on phones, so mobile-first design matters.</li>\n\n\n\n<li><strong>Track your analytics to understand what works.</strong> If your <a href=\"https://www.spotify.com/int/why-not-available/\">Spotify</a> playlist gets more clicks than your online store, maybe your audience prefers content over products. Use these insights to adjust your strategy. Try different link placements, descriptions, or visual elements to see what resonates.</li>\n\n\n\n<li><strong>Think of your bio page as telling your brand&#8217;s story. </strong>Rather than throwing random links together, create sections that guide visitors through your work. A fitness coach might group links into categories like &#8220;Workout Plans,&#8221; &#8220;Nutrition Tips,&#8221; and &#8220;Success Stories.&#8221; This structured approach helps visitors find exactly what interests them.</li>\n\n\n\n<li><strong>Remember to refresh your page regularly. </strong>Add seasonal content, highlight new projects, and remove outdated material. A dynamic page gives followers reasons to return and explore what&#8217;s new.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Create the ultimate link-in-bio with Gravatar</strong></h2>\n\n\n\n<p>Link in bio tools solve common problems, but Gravatar takes a different approach. Rather than just collecting links, it acts as a complete online identity manager. Your Gravatar profile syncs across various integrated platforms, ensuring your online presence stays consistent without extra work.</p>\n\n\n\n<p>What makes Gravatar unique? Privacy controls let you decide exactly what information appears where. You can manage multiple identities from one account. And unlike most link in bio tools, Gravatar offers custom domain support at no cost when using a WordPress.com domain.</p>\n\n\n\n<p>Plus, there&#8217;s no catch – it&#8217;s completely free for individual users. Getting started takes minutes: sign up with your email, add your essential information, and customize your profile. Your unified online presence awaits. </p>\n\n\n\n<p><a href=\"https://gravatar.com/profile\">Create your Gravatar profile for free</a> so that your social media followers can truly make a connection with you.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 20:18:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Gravatar: 7 Transformative Techniques for Website Content Personalization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2226\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://blog.gravatar.com/2024/12/20/website-personalization/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:23688:\"<p>Ever visited a website that seems to know exactly what you&#8217;re looking for? That&#8217;s website personalization in action. It&#8217;s the art of tailoring a site&#8217;s content, layout, and overall experience to each user based on their preferences, behaviors, and demographics.</p>\n\n\n\n<p>Website personalization can be done in different ways. You might encounter:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Content personalization that serves up articles or products you&#8217;re likely to enjoy.</li>\n\n\n\n<li>User interface customization that adjusts the layout based on your browsing habits.</li>\n\n\n\n<li>Product recommendations that feel like they&#8217;re reading your mind.</li>\n\n\n\n<li>Marketing messages that speak directly to your interests.</li>\n</ul>\n\n\n\n<p>Think about how <a href=\"https://www.netflix.com/\">Netflix</a> suggests shows you might like or how <a href=\"https://www.amazon.com/\" rel=\"nofollow\">Amazon</a> recommends products based on your browsing history.&nbsp;</p>\n\n\n\n<p>Similarly, news websites often customize their content feeds to match your reading preferences, while eCommerce sites may greet you with personalized homepages depending on your location and cookie history.</p>\n\n\n\n<p>In this article, we&#8217;ll dive into key techniques for implementing personalization on your website. We&#8217;ll also explore how <a href=\"https://gravatar.com/\">Gravatar</a> can play a very important role in this process, helping you create a more engaging and tailored experience for your users.</p>\n\n\n\n<p>Ready to transform your website into a personalized hub that keeps visitors coming back for more? Let&#8217;s get started!</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Benefits of website personalization</strong></h2>\n\n\n\n<p>Successful online content always caters to the needs and preferences of its visitors, and website personalization is a powerful strategy for improving your site&#8217;s performance and user satisfaction.&nbsp;</p>\n\n\n\n<p>Here&#8217;s how it can help you:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Improved user experience:</strong> When your website speaks directly to each user&#8217;s needs and preferences, it creates a more enjoyable and relevant browsing experience. It&#8217;s like having a store that rearranges itself for each customer – pretty cool, right?</li>\n\n\n\n<li><strong>Increased engagement:</strong> Tailored content is a magnet for user attention. When visitors find what they&#8217;re looking for quickly and easily, they&#8217;re more likely to stick around, explore more pages, and return for future visits.</li>\n\n\n\n<li><strong>Higher conversion rates:</strong> Personalized recommendations and targeted Calls-To-Action (CTAs) are conversion powerhouses. By showing users exactly what they&#8217;re interested in, you&#8217;re essentially laying out a red carpet to the &#8220;Buy Now&#8221; button.</li>\n\n\n\n<li><strong>Enhanced customer loyalty:</strong> When users feel understood and valued, they&#8217;re more likely to form an emotional connection with your brand. This can turn casual browsers into loyal customers who not only keep coming back but also recommend your site to others.</li>\n\n\n\n<li><strong>Better data utilization:</strong> Personalization allows you to put all that user data you&#8217;ve been collecting to good use. Instead of letting insights gather dust, you&#8217;re turning them into actionable strategies that drive real business growth.</li>\n\n\n\n<li><strong>Competitive advantage:</strong> When constantly fighting with competitors (not in real life, hopefully), adding a personalized experience can be your secret weapon. It sets your website apart and gives users a compelling reason to choose you over the generic alternatives.</li>\n</ol>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Challenges of website personalization</strong></h2>\n\n\n\n<p>While website personalization offers numerous benefits, it&#8217;s not without its hurdles. Let&#8217;s take a look at some of the common challenges you might face:</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Collecting data</strong></h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Data collection methods:</strong> Gathering user data can be tricky. You might use behavior tracking, surveys, or third-party sources. However, as people become more conscious about their data, the best strategy is to collect this information directly from your users – it’s the most trustworthy way.&nbsp;</li>\n\n\n\n<li><strong>Data quality and accuracy:</strong> Your personalization is only as good as your data. Poor quality or inaccurate data can lead to off-target personalization, which might frustrate users instead of delighting them.</li>\n\n\n\n<li><strong>Integration challenges:</strong> Integrating data from multiple sources into a unified system can be like solving a complex puzzle. Tools like Gravatar can help simplify this process by providing a centralized profile management system.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Adherence to data regulations</strong></h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Privacy laws and regulations:</strong> Navigating the maze of data privacy laws like the <a href=\"https://gdpr-info.eu/\">General Data Protection Regulation (GDPR)</a> and the <a href=\"https://oag.ca.gov/privacy/ccpa\" rel=\"nofollow\">California Consumer Privacy Act (CCPA)</a> can be daunting. If you don’t comply, you risk legal issues and losing the trust of your users.&nbsp;</li>\n\n\n\n<li><strong>Consent management:</strong> Getting user consent for data collection and personalization efforts is crucial. It&#8217;s a balancing act between being transparent and not overwhelming users with consent requests.</li>\n\n\n\n<li><strong>Data security:</strong> With great data comes great responsibility. Securing user information is paramount to prevent breaches and misuse. Gravatar, for instance, prioritizes data security and gives users <a href=\"https://support.gravatar.com/account/data-privacy/\">control over their personal information</a>.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Other challenges</strong></h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Technical complexity:</strong> Implementing personalization can be technically demanding. Setting up algorithms, managing large datasets, and ensuring real-time data processing are not small tasks.</li>\n\n\n\n<li><strong>Resource constraints:</strong> Personalization efforts can be time-consuming and potentially expensive. You might need to invest in new tools or expertise. Using existing solutions like Gravatar can help streamline processes and reduce the burden on your resources.</li>\n\n\n\n<li><strong>Over-personalization:</strong> There&#8217;s a fine line between helpful personalization and feeling like you&#8217;re being watched. Finding the right balance is key to ensuring personalization feels natural and beneficial, not creepy or intrusive.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Requirements of a personalization engine</strong></h2>\n\n\n\n<p>To effectively personalize your website, you&#8217;ll need a reliable personalization engine. Here are the key components you should look for:</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Unified dataset</strong></h3>\n\n\n\n<p>A unified dataset is like the brain of your personalization efforts. It&#8217;s a centralized repository that brings together data from various sources, giving you a comprehensive view of your users.</p>\n\n\n\n<p><strong>Benefits:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Provides a holistic understanding of user behavior and preferences.</li>\n\n\n\n<li>Enables detailed audience segmentation for targeted engagement.</li>\n\n\n\n<li>Simplifies the process of combining data from different channels.</li>\n</ul>\n\n\n\n<p><strong>Data sources:</strong> Your unified dataset might include information from CRM systems, eCommerce platforms, social media, mobile apps, and even in-store data.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Open architecture</strong></h3>\n\n\n\n<p>An open architecture is all about flexibility. It&#8217;s a system design that plays well with others, allowing easy integration with various third-party tools and technologies.</p>\n\n\n\n<p><strong>Benefits:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Connects with your existing marketing tech stack (CRM, CMS, analytics tools, etc.).</li>\n\n\n\n<li>Allows for easy addition of new features and tools without disrupting existing systems.</li>\n\n\n\n<li>Reduces the need for extensive custom development work.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Decision logic</strong></h3>\n\n\n\n<p>Decision logic is the smart part of your personalization engine. It&#8217;s the set of rules and algorithms that determine what personalized content to serve up based on user data.</p>\n\n\n\n<p><strong>Benefits:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Automates the personalization process, reducing manual effort.</li>\n\n\n\n<li>Enables real-time personalization, delivering tailored content on the fly.</li>\n\n\n\n<li>Uses machine learning to continuously improve personalization strategies based on user interactions.</li>\n</ul>\n\n\n\n<p>Decision logic can power personalized product recommendations, dynamic content delivery, targeted email campaigns, and much more!</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Types of data used for personalization</strong></h2>\n\n\n\n<p>Effective website personalization relies on various types of data. Let&#8217;s explore the key categories:</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Contextual data</strong></h3>\n\n\n\n<p>Contextual data is all about the user&#8217;s current situation and environment, including their device, operating system, browser, screen resolution, and traffic source (direct, paid, referral, search, social media).</p>\n\n\n\n<p>This information helps tailor the user experience based on their current context and specific situation.</p>\n\n\n\n<p><strong>Some examples include:&nbsp;</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Displaying a mobile-optimized version of a website for smartphone users.&nbsp;</li>\n\n\n\n<li>A food app showing restaurant recommendations depending on the user’s location.&nbsp;</li>\n\n\n\n<li>Customizing content based on the user&#8217;s referral source (e.g., different landing pages for social media vs. search engine traffic).&nbsp;</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Behavioral data</strong></h3>\n\n\n\n<p>Behavioral data captures how users interact with your website, for example where they click, what they add to their cart and purchase, and what pages they visit. This data provides you with insights into user preferences and interests, allowing for highly accurate personalization.</p>\n\n\n\n<p><strong>Some examples include:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Recommending products based on previous purchases or browsing history.</li>\n\n\n\n<li>Personalizing content based on frequently visited pages or clicked links.</li>\n\n\n\n<li>Sending notifications and emails about items in their cart.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"435\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/wordpress-abandoned-cart-email.png?w=660\" alt=\"Abandoned cart email by WordPress\" class=\"wp-image-2229\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>CRM data</strong></h3>\n\n\n\n<p>CRM data is information you&#8217;ve collected directly from users, mostly through surveys, registration forms, and other intentional interactions. This is one of the best data types because it’s highly accurate for personalization as it&#8217;s directly provided by the user, reflecting their stated preferences and needs.</p>\n\n\n\n<p><strong>Some examples include:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Customizing email marketing campaigns based on user-provided preferences.</li>\n\n\n\n<li>Personalizing website content for registered users based on their profile information.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Zero-party data</strong></h3>\n\n\n\n<p>Zero-party data is information voluntarily shared by users through surveys, polls, and other interactive tools, including personal details and preferences. It’s considered highly reliable as it&#8217;s willingly shared by the user, offering deep insights into their preferences.</p>\n\n\n\n<p><strong>Some examples include:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Creating personalized content and offers based on user-provided preferences and feedback.&nbsp;</li>\n\n\n\n<li>Enhancing user profiles with detailed information gathered from interactive tools.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Exploring key techniques for website personalization</strong></h2>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>1. Segmenting your site according to personas</strong></h3>\n\n\n\n<p>Create distinct experiences for different user groups:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Define key personas like &#8220;<em>Budget-conscious shoppers</em>,&#8221; &#8220;<em>Luxury buyers</em>,&#8221; or &#8220;<em>Tech enthusiasts</em>&#8221; based on demographics, behavior, and preferences. You can create your personas with a tool like the <a href=\"https://www.hubspot.com/make-my-persona\" rel=\"nofollow\">Hubspot persona creator</a>.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"460\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/hubspot-make-my-persona-.png?w=660\" alt=\"Hubspot’s buyer persona tool\" class=\"wp-image-2230\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use tools like <a href=\"https://marketingplatform.google.com/about/analytics/\" rel=\"nofollow\">Google Analytics</a> to gather data on user segments. Look at metrics like pages visited, time on site, and conversion rates for each segment.</li>\n\n\n\n<li>Develop content variations for each persona. For example, show &#8220;<em>Budget-conscious shoppers</em>&#8221; value-focused messaging and discounts while presenting &#8220;<em>Luxury buyers</em>&#8221; with premium product recommendations.</li>\n</ul>\n\n\n\n<p><strong>Example:</strong> If you’re a sports apparel website, you can show runners products like performance shoes and workout gear. But for people who are more into streetwear, make it all about the latest fashion-forward sneakers and urban apparel.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>2. Utilizing geolocation strategies</strong></h3>\n\n\n\n<p>Tailor content based on a user&#8217;s location:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use IP detection to identify user location and deliver location-specific content, like showing local store information, events, or news based on the user&#8217;s city or region.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"479\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/trip-advisor-homepage.png?w=660\" alt=\"Tripadvisor geo-location based homepage\" class=\"wp-image-2231\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Adjust language, currency, and shipping options based on user location. A visitor from Germany should see prices in Euros and German language content.</li>\n</ul>\n\n\n\n<p>For example, <a href=\"http://booking.com\" rel=\"nofollow\">Booking.com</a> automatically shows the version of the site relevant to the user&#8217;s country and suggests destinations based on previous searches.</p>\n\n\n\n<p>This is the homepage for US visitors:&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"487\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/booking-us-homepage.png?w=660\" alt=\"Booking homepage with the US as a location\" class=\"wp-image-2232\" />\n\n\n\n<p>And this is what’s on the page for Spanish visitors:&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"339\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/booking-spain-homepage.png?w=660\" alt=\"Booking homepage with Spain as a location\" class=\"wp-image-2234\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>3. Optimizing content based on devices used</strong></h3>\n\n\n\n<p>Adapt your site to different devices:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Ensure your website is mobile-friendly and adapts to different screen sizes using responsive design frameworks like <a href=\"https://getbootstrap.com/\">Bootstrap</a> or <a href=\"https://get.foundation/\" rel=\"nofollow\">Foundation</a>.</li>\n\n\n\n<li>Deliver different content formats based on device type. Prioritize concise text and vertical videos for mobile users while offering longer-form articles on desktop.</li>\n\n\n\n<li>Optimize loading times and performance, especially for mobile users. Compress images, minify code, and use browser caching.</li>\n</ul>\n\n\n\n<p><a href=\"https://open.spotify.com/\" rel=\"nofollow\">Spotify</a>&#8216;s mobile app is a master class in device optimization. It&#8217;s streamlined for on-the-go listening, with big buttons and simplified navigation. Switch to the desktop, and suddenly you&#8217;ve got a full-featured music command center.</p>\n\n\n\n<img width=\"660\" height=\"371\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/spotify-app-and-desktop.png?w=660\" alt=\"Spotify on mobile and desktop\" class=\"wp-image-2235\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>4. Personalizing landing pages</strong></h3>\n\n\n\n<p>Create customized entry points:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use visitor data to customize landing page elements in real time. Personalize headlines, images, and CTAs based on user segments.</li>\n\n\n\n<li>Conduct A/B tests with tools like <a href=\"https://www.optimizely.com/\" rel=\"nofollow\">Optimizely</a> or <a href=\"https://www.abtasty.com/\">AB Tasty</a> to determine the most effective personalized elements.</li>\n</ul>\n\n\n\n<p>For example, show a landing page with enterprise-focused messaging and case studies to visitors from large companies while highlighting ease of use for small business visitors.&nbsp;</p>\n\n\n\n<p>HubSpot is the king of personalized landing pages. Visit as a marketer, and you&#8217;ll see content about lead generation and email campaigns. But if you&#8217;re in sales, it&#8217;s all about CRM and pipeline management.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>5. Personalizing recommendations</strong></h3>\n\n\n\n<p>Suggest relevant content or products:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use user behavior data and machine learning to provide personalized product or content recommendations.</li>\n\n\n\n<li><a href=\"https://www.amazon.com/\" rel=\"nofollow\">Amazon</a> is the pioneer in personalized recommendations, suggesting products based on a user&#8217;s browsing and purchase history.</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"371\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/amazon-recommendation.png?w=660\" alt=\"Example of Amazon recommendations\" class=\"wp-image-2236\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>News sites like <a href=\"https://www.nytimes.com/\" rel=\"nofollow\">The New York Times</a> recommend articles based on a reader&#8217;s interests and previously read stories.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>6. Targeted CTAs</strong></h3>\n\n\n\n<p>Create calls-to-action that have an impact:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Design CTAs that cater to specific user segments and behaviors.&nbsp;</li>\n\n\n\n<li>Use dynamic content to adjust CTAs based on user interactions.</li>\n\n\n\n<li>Optimize CTA placement for maximum visibility.&nbsp;</li>\n\n\n\n<li>Use behavioral triggers to display CTAs at the right moment.</li>\n</ul>\n\n\n\n<p>For instance, show a &#8220;<em>Schedule a Demo</em>&#8221; CTA to enterprise visitors who have viewed multiple product pages while offering a &#8220;<em>Try for Free</em>&#8221; CTA to small business visitors.&nbsp;</p>\n\n\n\n<p>7. Personalized checkout pages</p>\n\n\n\n<p>Streamline the purchase process:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use user data to pre-fill forms and reduce checkout friction.&nbsp;</li>\n\n\n\n<li>Offer personalized payment options and shipping methods.</li>\n\n\n\n<li>Provide personalized product recommendations during checkout based on the items in the user&#8217;s cart.</li>\n</ul>\n\n\n\n<p>For example, every time a customer adds a product to their cart on <a href=\"https://fentybeauty.com/\" rel=\"nofollow\">Fenty Beauty</a>’s website, a popup of the checkout shows up with some recommended products.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"394\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/fenty-beauty-checkout-recommendations.png?w=660\" alt=\"Personalized recommendations Fenty Beauty \" class=\"wp-image-2237\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>8. Customizing loyalty programs</strong></h3>\n\n\n\n<p>Reward users in meaningful ways:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Offer rewards based on user preferences and behavior. If you know a customer loves eco-friendly products, offer points bonuses on green items.</li>\n\n\n\n<li>Send personalized emails and notifications to loyalty program members.&nbsp;</li>\n\n\n\n<li>Use segmentation to deliver relevant loyalty program updates.</li>\n\n\n\n<li>​​Use gamification to keep things fun. Progress bars, badges, and tiered rewards can turn shopping into an engaging experience.</li>\n</ul>\n\n\n\n<p><a href=\"https://www.sephora.com/beauty/profile-beautyinsider\" rel=\"nofollow\">Sephora&#8217;s Beauty Insider</a> program offers different rewards and perks based on a member&#8217;s tier and purchase history.</p>\n\n\n\n<img width=\"660\" height=\"394\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/sephora-beauty-insider-loyalty-program.png?w=660\" alt=\"Sephora\'s Beauty Insider program\" class=\"wp-image-2238\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Gravatar: A key player in website personalization</strong></h2>\n\n\n\n<img width=\"660\" height=\"411\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/09/gravatar-profiles-as-a-service.png?w=660\" alt=\"Gravatar Profiles as a Service\" class=\"wp-image-2239\" />\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a> is a powerful tool for web developers who want to improve their website personalization strategies.&nbsp;</p>\n\n\n\n<p>With Gravatar&#8217;s user profile integration, you can <strong>import essential user data, including names, display names, avatars, locations, and verified accounts</strong>. This access to <a href=\"https://blog.gravatar.com/2024/06/05/user-profile-page-examples/\">user profile information</a> means that new visitors don’t have to fill out endless forms just to use your website, improving their experience from the get-go.</p>\n\n\n\n<p>Gravatar&#8217;s ongoing development, particularly the inclusion of user interests, opens up new avenues for developers to <strong>implement more sophisticated personalization techniques</strong>. This feature enables the creation of tailored content recommendations and product suggestions based on user preferences, potentially increasing engagement and conversion rates.</p>\n\n\n\n<p>The platform&#8217;s straightforward integration process, whether for <a href=\"https://wordpress.org/\" rel=\"nofollow\">WordPress</a> sites or custom-built platforms, allows developers to <strong>quickly implement personalization features</strong>. The comprehensive <a href=\"https://docs.gravatar.com/\">Gravatar API documentation</a> will give you all the necessary resources to incorporate these features effectively.</p>\n\n\n\n<p>Finally, Gravatar&#8217;s commitment to user privacy aligns with current data protection standards, allowing developers to <strong>employ personalization strategies that respect user preferences and comply with privacy regulations</strong>.</p>\n\n\n\n<p>Ready to take your website personalization to the next level? <a href=\"https://docs.gravatar.com/\">Head over to Gravatar</a> and start exploring. Your users (and your conversion rates) will love you for it!</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 20:17:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Matt Mullenweg Declares Holiday Break for WordPress.org Services\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182947\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/matt-mullenweg-declares-holiday-break-for-wordpress-org-services\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5872:\"<p>For the first time, Matt Mullenweg has announced a <a href=\"https://wordpress.org/news/2024/12/holiday-break/\">holiday break</a> for WordPress.org services. In his blog post, he said, “In order to give myself and the many tired volunteers around WordPress.org a break for the holidays, we’re going to be pausing a few of the free services currently offered.”</p>\n\n\n\n<p>The paused services include new account registrations on WordPress.org, plugin reviews, and new submissions to the plugin, theme, and photo directories.</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXfPNBwLn0SaNg9Hqo3bpEVo3gyd0rF5yLjZ7KKr89dRkQFElnuZFk5JCJYDpovaH0pacHEGd1tmMfrGKQTVQvFBdcU6WFrlkAeJOsB48X47sd05u9Y7uAFBoDaKYIuAX8LryYXX1Q?key=i0QQsUcgmuemusiuIs5gOcgv\" alt=\"\" />\n\n\n\n<p>During this time, WP Engine will retain full access to WordPress.org. Matt explained, “As you may have heard, I’m legally compelled to provide free labor and services to WP Engine thanks to the success of their expensive lawyers, so in order to avoid bothering the court I will say that none of the above applies to WP Engine, so if they need to bypass any of the above please just have your high-priced attorneys talk to my high-priced attorneys and we’ll arrange access, or just reach out directly to me on Slack and I’ll fix things for you.”</p>\n\n\n\n<p>Matt has not provided a specific date for resuming these services, stating, “<strong>I hope to find the time, energy, and money to reopen all of this sometime in the new yea</strong>r. Right now much of the time I would spend making WordPress better is being taken up defending against WP Engine’s legal attacks. Their attacks are against Automattic, but also me individually as the owner of WordPress.org, which means if they win I can be personally liable for millions of dollars of damages.”</p>\n\n\n\n<p>He concluded the blog post by saying, “If you would like to fund legal attacks against me, I would encourage you to sign up for WP Engine services, they have great plans and pricing starting at $50/mo and scaling all the way up to $2,000/mo. If not, you can use literally any other web host in the world that isn’t suing me and is offering promotions and discounts for switching away from WP Engine.”</p>\n\n\n\n<p>The official WordPress <a href=\"https://x.com/WordPress/status/1869909487932583971\">Twitter</a> account echoed the announcement: “In order to give tired volunteers around WordPress.org a break for the holidays, we’re going to be pausing a few of the free services currently offered…And to be super clear for the court so we&#8217;re not held in contempt, none of this applies to @wpengine.”</p>\n\n\n\n<a href=\"https://x.com/WordPress/status/1869909487932583971\"><img width=\"1780\" height=\"1266\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-15.png\" alt=\"\" class=\"wp-image-182956\" /></a>\n\n\n\n<p>Some have applauded the much-needed break for volunteers, while others expressed concern over the indefinite suspension of services.&nbsp;</p>\n\n\n\n<a href=\"https://x.com/albertalbs/status/1870066631864688977\"><img width=\"2884\" height=\"678\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-10.png\" alt=\"\" class=\"wp-image-182949\" /></a>\n\n\n\n<a href=\"https://x.com/chrisdavidmiles/status/1869924684369895616\"><img width=\"2872\" height=\"1060\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-11.png\" alt=\"\" class=\"wp-image-182950\" /></a>\n\n\n\n<a href=\"https://x.com/YoungbloodJoe/status/1869968488523002274\"><img width=\"2838\" height=\"1150\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-12.png\" alt=\"\" class=\"wp-image-182951\" /></a>\n\n\n\n<a href=\"https://x.com/PeterZaitsev/status/1870159733191258321\"><img width=\"2870\" height=\"1012\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-13.png\" alt=\"\" class=\"wp-image-182952\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress User Registration Reopened to Support WordCamps&nbsp;</h2>\n\n\n\n<p>Since a WordPress.org account is mandatory to buy WordCamp tickets, the temporary suspension of new user registrations had raised concerns, as it restricted new users from buying tickets for upcoming WordCamps, including major events like WordCamp <a href=\"https://europe.wordcamp.org/2025/\">Europe</a>, <a href=\"https://asia.wordcamp.org/2025/\">Asia</a>, <a href=\"https://pune.wordcamp.org/2025/\">Pune</a>, <a href=\"https://kolhapur.wordcamp.org/2025/\">Kolhapur</a>, and <a href=\"https://ahmedabad.wordcamp.org/2025/\">Ahmedabad</a>, where tickets are already on sale.</p>\n\n\n\n<p>Jeff Chandler commented on the issue, saying, “If the requirement is not removed, at the very least, for WordCamp sites with events coming up and they suffer because of it, that&#8217;s going to be such a huge blow to current and future event organizers and to the community itself.”</p>\n\n\n\n<p>Joost de Valk of Emilia Capital raised the issue in <a href=\"https://github.com/WordPress/wordcamp.org/issues/1450\">WordPress GitHub</a> and Dion Hulse reenabled the registration if the referrer is WordCamp. “Login: Enable user account creations when the referer is WordCamp. This allows for WordCamps tickets to continue to be bought. Per Matt.”, reads the <a href=\"https://meta.trac.wordpress.org/changeset/14325\">Trac</a> message.&nbsp;</p>\n\n\n\n<img width=\"3328\" height=\"1246\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-14.png\" alt=\"\" class=\"wp-image-182954\" />\n\n\n\n<p>Dion Hulse then <a href=\"https://meta.trac.wordpress.org/changeset/14326\">enabled</a> user registrations for upcoming &#8216;nextgen events&#8217;. </p>\n\n\n\n<img width=\"2232\" height=\"1050\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-16.png\" alt=\"\" class=\"wp-image-182958\" />\n\n\n\n<p>Discussions are continuing in <a href=\"https://www.reddit.com/r/Wordpress/comments/1hi8880/in_the_spirit_of_the_season_matt_blames_holiday/\">Reddit </a>too.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 19:19:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WPTavern: Lena (Eleni) Stergatou Receives Inaugural WordCamp Europe Kim Parsell Memorial Scholarship \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182933\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/lena-eleni-stergatou-receives-inaugural-wordcamp-europe-kim-parsell-memorial-scholarship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2700:\"<p>Lena (Eleni) Stergatou has been awarded the first-ever WordCamp Europe Kim Parsell Memorial Scholarship. This prestigious scholarship, previously exclusive to WordCamp US, was recently <a href=\"https://wptavern.com/wordcamp-asia-and-wordcamp-europe-added-to-kim-parsell-memorial-scholarship-program\">extended to include WordCamp Asia and Europe</a> following the latest meeting of the WordPress Foundation Board.</p>\n\n\n\n<p>The scholarship honors <a href=\"https://wordpress.org/news/2019/11/people-of-wordpress-kim-parsell/\">Kim Parsell</a>, a beloved member of the WordPress community and regarded as one of the first “women of WordPress.” Affectionately referred to as #wpmom, Kim was a passionate WordPress contributor and advocate for women in technology.</p>\n\n\n\n<p>In their <a href=\"https://wordpressfoundation.org/news/2024/announcing-the-2025-wordcamp-europe-kim-parsell-memorial-scholarship-recipient-eleni-stergatou/\">announcement</a>, the WordPress Foundation stated, “Lena’s dedication to WordPress translations, core, plugins, and more truly embodies the values that Kim held dear.”</p>\n\n\n\n<p>Hailing from Greece, Lena is a devoted WordPress and BuddyPress enthusiast. She has been working as a “Code wrangler”, “Happiness Engineer” and translator (in Greek) with WordPress multisite since 2008 and since 2010 with BuddyPress. She currently develops web services for the Greek educational community at the Computer Technology Institute (CTI Diophantus).</p>\n\n\n\n<p>Her <a href=\"https://profiles.wordpress.org/lenasterg/\">WordPress profile</a> reads, “I&#8217;m familiar with WordPress core and ways to extend it, have an eye for problems on large-scale multisite installation, have fixed numerous outdated themes and edited plugins in order to make them work as they should in multisite WordPress.</p>\n\n\n\n<p>I‘m used to answer questions about WordPress usage, write manuals and FAQs (in Greek language). I love to debug, fix broken things, extend functionalities and share them with others.</p>\n\n\n\n<p>This love led me to participate in the WordPress and BuddyPress community, by contributing with new plugins, “resurrect” broken plugins, bug fixes and contribute to Greek translations as Locale manager in WordPress Greek team.”</p>\n\n\n\n<p>Lena is an active contributor to the WordPress Community, Core, and Polyglots teams.</p>\n\n\n\n<p>The scholarship covers travel to the host city, hotel accommodation for the event duration, and a WordCamp ticket. It does not include airport transfers, meals, or other incidental expenses.</p>\n\n\n\n<p><a href=\"https://europe.wordcamp.org/2025/\">WordCamp Europe 2025</a> will be held from June 5–7 in Basel, Switzerland.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 16:39:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"WordPress Foundation: Announcing the 2025 WordCamp Europe Kim Parsell Memorial Scholarship Recipient: Eleni Stergatou\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpressfoundation.org/?p=1195776\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://wordpressfoundation.org/news/2024/announcing-the-2025-wordcamp-europe-kim-parsell-memorial-scholarship-recipient-eleni-stergatou/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4664:\"<p>In 2015, the WordPress Foundation <a href=\"https://make.wordpress.org/community/2015/01/15/remembering-kim-parsell/\">established an annual memorial scholarship</a> to honor the memory of <a href=\"https://wordpress.org/news/2019/11/people-of-wordpress-kim-parsell/\">Kim Parsell</a>, a beloved and influential contributor to the WordPress community. This scholarship ensures that Kim’s core values continue to inspire and enrich the WordPress community.</p>\n\n\n\n<p>Until 2024, this scholarship was awarded each year to a female WordPress contributor who has never attended WordCamp US and would require financial assistance to do so. <a href=\"http://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">More information on the scholarship, including past recipients, is available here</a>.</p>\n\n\n\n<p>Following the latest WordPress Foundation Board meeting, the Kim Parsell Memorial Scholarship <a href=\"https://wordpressfoundation.org/news/2024/kim-parsell-memorial-scholarship-expands-to-wordcamp-asia-and-wordcamp-europe/\">has been extended</a> to WordCamp Asia and WordCamp Europe, in addition to WordCamp US. This expansion honors Kim’s legacy and her dedication to inclusivity and diversity within the WordPress community, making it possible for more community members to attend these inspiring events.</p>\n\n\n\n<p>We’re happy to announce that this year’s scholarship recipient for WCEU is <a href=\"https://profiles.wordpress.org/lenasterg/\">Eleni Stergatou</a>! Lena&#8217;s dedication to WordPress translations, core, plugins, and more truly embodies the values that Kim held dear.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Meet Lena Stergatou: Advocate for Accessible and Inclusive WordPress Development<br /></h2>\n\n\n<div class=\"wp-block-image\">\n<a href=\"https://i0.wp.com/wordpressfoundation.org/content/uploads/2024/12/lenasterg_removed_background.png?ssl=1\"><img width=\"544\" height=\"572\" src=\"https://i0.wp.com/wordpressfoundation.org/content/uploads/2024/12/lenasterg_removed_background.png?resize=544%2C572&ssl=1\" alt=\"\" class=\"wp-image-1195777\" /></a>Lena&#8217;s close-up picture while smiling at the camera.</div>\n\n\n<p><em>I’m Lena Stergatou, known in the WordPress community as <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a>, and I’ve always enjoyed working with WordPress and BuddyPress. I discovered WordPress back in 2008 while searching for a platform that could support multiple sites within a single installation. That’s when I came across WordPress MU (now known as WordPress Multisite). I immediately loved how flexible and easy it was to extend and customize WordPress to meet specific needs, especially for Multisite environments.</em></p>\n\n\n\n<p><em>I enjoy contributing to the WordPress community by developing new plugins, reviving broken ones, and submitting bug fixes. As a General Translation Editor for the Greek WordPress team, I help make WordPress and its plugins accessible to Greek-speaking users. I believe it’s incredibly important for WordPress, its plugins, and themes to be translated into multiple languages. Translations improve accessibility and foster inclusion by helping more people use the platform comfortably. This realization came from my own experience with my children when they were young, and with my parents, who don’t speak English. Simple prompts like “next” or “read more” were confusing for them, making it clear how crucial it is to provide tools in people’s native languages. This is why I dedicate time to translating — to ensure that everyone, regardless of their language skills, can fully enjoy and benefit from WordPress.</em></p>\n\n\n\n<p><em>I try to live by Ralph Waldo Emerson&#8217;s principle: “To leave the world a bit better, whether by a healthy child, a garden patch, or a redeemed social condition; to know that even one life has breathed easier because you have lived — that is to have succeeded.” So whenever I detect a bug in open-source code, I do my best to fix it, add new features, and share my work with the community.</em></p>\n\n\n\n<p><em>I live in Patras, Greece, with my husband, my teenage daughter, and my teenage son. Professionally, I hold a Master’s in Electrical and Computer Engineering and have worked as an ICT trainer and author. With over 20 years of experience as a web developer, I am currently working with the Computer Technology Institute (CTI Diophantus), where I develop web services for the Greek educational community.</em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Get in touch with Lena on LinkedIn: https://www.linkedin.com/in/lenasterg/ <br /></p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 14:38:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Do The Woo Community: Do the Woo is Proud to be a Media Partner at WordCamp Asia 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87750\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/blog/do-the-woo-is-proud-to-be-a-media-partner-at-wordcamp-asia-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:153:\"We are proud to be media partners for WordCamp Asia in March 2025, engaging with the community and collaborating with fellow media partners at the event.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 09:33:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: WordCamp Asia 2025 with Meher Bala and Dan Tabifranca\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87731\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://dothewoo.io/wordcamp-asia-2025-with-meher-bala-and-dan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"In this chat about WordCamp Asia 2025 in Manila, organizers Meher and Dan share their roles and plans, emphasizing inclusivity, exciting programming, and the vibrant local culture to enhance attendee experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 03:55:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress.org blog: Holiday Break\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18328\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/news/2024/12/holiday-break/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2313:\"<p>In order to give myself and the many tired volunteers around WordPress.org a break for the holidays, we&#8217;re going to be pausing a few of the free services currently offered:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>New account registrations on WordPress.org (clarifying so press doesn&#8217;t confuse this: people can still make their own WordPress installs and accounts)</li>\n\n\n\n<li>New <a href=\"https://wordpress.org/plugins/\">plugin directory</a> submissions</li>\n\n\n\n<li>New plugin reviews</li>\n\n\n\n<li>New <a href=\"https://wordpress.org/themes/\">theme directory</a> submissions</li>\n\n\n\n<li>New <a href=\"https://wordpress.org/photos/\">photo directory</a> submissions</li>\n</ul>\n\n\n\n<p>We&#8217;re going to leave things like localization and the forums open because these don&#8217;t require much moderation.</p>\n\n\n\n<p>As you may have heard, <a href=\"https://www.theverge.com/2024/12/10/24318350/automattic-restore-wp-engine-access-wordpress\">I&#8217;m legally compelled to provide free labor and services to WP Engine thanks to the success of their expensive lawyers</a>, so in order to avoid bothering the court I will say that none of the above applies to WP Engine, so if they need to bypass any of the above please just have your high-priced attorneys talk to my high-priced attorneys and we&#8217;ll arrange access, or just reach out directly to me on Slack and I&#8217;ll fix things for you.</p>\n\n\n\n<p>I hope to find the time, energy, and money to reopen all of this sometime in the new year. Right now much of the time I would spend making WordPress better is being taken up defending against WP Engine&#8217;s legal attacks. Their attacks are against Automattic, but also me individually as the owner of WordPress.org, which means if they win I can be personally liable for millions of dollars of damages.</p>\n\n\n\n<p>If you would like to fund legal attacks against me, I would encourage you to sign up for WP Engine services, <a href=\"https://wpengine.com/plans/\">they have great plans and pricing starting at $50/mo and scaling all the way up to $2,000/mo</a>. If not, you can use <a href=\"https://wordpress.org/news/2024/10/wp-engine-promotions/\">literally any other web host in the world that isn&#8217;t suing me and is offering promotions and discounts for switching away from WP Engine</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 00:36:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: ‘Support Inclusion in Tech’ Expands Grant Program to North and South America\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182872\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/support-inclusion-in-tech-expands-grant-program-to-north-and-south-america\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1559:\"<p>Support Inclusion in Tech (SiNC) has <a href=\"https://supportinclusionintech.com/sinc-expands-grant-program-to-empower-wordpress-contributors-across-north-and-south-america/\">announced </a>the expansion of its grant program to now include applicants from North and South America. SiNC was proposed by Winstina Hughes in 2022 to mitigate the financial stress of underrepresented groups seeking to participate in WordPress events and was first tried in<a href=\"https://wptavern.com/wordcamp-us-trials-new-program-connecting-underrepresented-speakers-with-sponsors-for-travel-and-lodging-costs\"> WordCamp US 2022</a>. </p>\n\n\n\n<p>Originally launched in June 2024 to honor Pride Month, the Grant program offers four grants of <strong>$240 USD</strong> each, to individuals across Europe, Asia, Africa, North America, and South America.</p>\n\n\n\n<p>“We believe that a truly inclusive WordPress community requires a global perspective,” said Winstina Hughes, founder of Support Inclusion in Tech. “By expanding our grant program, we are taking a significant step towards ensuring that everyone, regardless of their geographic location, has the opportunity to contribute and thrive within the WordPress ecosystem.”</p>\n\n\n\n<p>Eligible applicants include those who have contributed to the WordPress community through local meetups, WordCamps, or code contributions. Starting <strong>January 2025</strong>, applicants can choose to be included in a public directory, with grant selections to follow in <strong>March 2025</strong> via a random name picker.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Dec 2024 19:57:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: The WP Community Collective Announces Its Formal Incorporation as a Nonprofit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182859\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/the-wp-community-collective-announces-its-formal-incorporation-as-a-nonprofit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2358:\"<p>The WP Community Collective has <a href=\"https://www.thewpcommunitycollective.com/2024/12/17/the-wp-community-collective-announces-formal-nonprofit-incorporation/\">announced</a> that it has incorporated as a California membership nonprofit for mutual benefit. Sé Reed, President &amp; CEO of WPCC, <a href=\"https://x.com/sereedmedia/status/1869446476725907703\">shared</a>, “A lot is said about (and to) the #WordPress community. But for the most part, the community has been spoken for and not had a voice of its own. That’s why we founded @thewpcc.”&nbsp;</p>\n\n\n\n<p>The organization is also finalizing its designation as a 501(c)(6) nonprofit organization, a federal classification that defines it as an association with a common business interest. This will provide WPCC with greater flexibility in projects and funding. </p>\n\n\n\n<p>WPCC is also planning to create a charitable nonprofit subsidiary. This subsidiary will focus on supporting important projects like the Accessibility Fellowship and efforts to promote diversity, equity, inclusion, and belonging (DEIB) in the WordPress community.&nbsp;</p>\n\n\n\n<p>Membership in WPCC is now open to individuals with a minimum contribution of $5. Members should adhere to the organization’s <a href=\"https://www.thewpcommunitycollective.com/about/code-of-conduct/\">Code of Conduct</a> and <a href=\"https://www.thewpcommunitycollective.com/about/conflict-of-interest-policy/\">Conflict of Interest</a> policy. In addition, WPCC plans to introduce membership tiers for businesses and organizations, along with scholarship memberships, in early 2025. They also launched a dedicated Slack instance for its members.&nbsp;</p>\n\n\n\n<p>Earlier this year, the WPCC faced a challenge when its fiscal host, the Open Collective Foundation (OCF), dissolved unexpectedly. As a result, the WPCC had to move its funds to a temporary host. Unfortunately, those funds cannot be used for the new nonprofit structure, but the organization remains focused on moving forward. They are working on new initiatives and building partnerships to expand opportunities for contributors around the world.</p>\n\n\n\n<p>The WPCC is committed to being transparent with its finances. You can support the organization by making a contribution <a href=\"https://opencollective.com/thewpcommunitycollective#category-CONTRIBUTE\">here</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Dec 2024 19:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Inc Hit Piece\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=132691\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2024/12/inc-hit-piece/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19944:\"<p>When Inc Magazine reached out to have <a href=\"https://freedman.com/\">David H. Freedman</a> (website powered by WordPress) write a feature piece I was excited because though Inc wasn&#8217;t a magazine I have read much since I was a teenager, David seemed like a legit journalist who usually writes for better publications like The Atlantic. I opened up to David with a number of vulnerable stories, and allowed the photo shoot in my home in Houston.</p>\n\n\n\n<p>Whether it was him or his editors, <a href=\"https://www.inc.com/dfreedman/matt-mullenweg-wordpress-wp-engine/90994969\">unfortunately the piece has turned out pretty biased and negative</a>, even to the point of cherry-picking negative photos from the photo shoot they did in my home. It also has a number of basic errors which make me question the fact-checking and editorial integrity of Inc in the first place. Let&#8217;s go through it.</p>\n\n\n\n<p>Although they have dozens of photos of me smiling, it starts with one where I look pretty morose. At least I got some Sonny Rollins and Audrey Hepburn in the background.</p>\n\n\n\n<img width=\"604\" height=\"340\" src=\"https://i0.wp.com/ma.tt/files/2024/12/matt-mullenweg-wordpress-inc-vertical-edited.webp?resize=604%2C340&ssl=1\" alt=\"\" class=\"wp-image-132705\" />\n\n\n\n<p>The article starts with a conversation David had with me while we were both in the bathroom, away from his recorder, where he remarked that the bathroom was really nice. I talked about visiting Google in 2004 when I first came to San Francisco and thinking they had cheap toilet paper, and how given that Automattic&#8217;s offices are barely used there&#8217;s no reason not to spend a few extra bucks on nice soap and toilet paper to give a better experience to employees and visitors. (For those curious, we use <a href=\"https://www.aesop.com/\">Aesop soap</a> and <a href=\"https://us.whogivesacrap.org/\">Who Gives A Crap toilet paper</a>, a brand that donates 50% of profits to charity.) I chose these brands because it&#8217;s what I use in my home, and I want people in our offices to have the same quality. David spins it thusly:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I ask him who at Automattic, the estimated $710-million company of which Mullenweg is CEO, is responsible for toilet paper and soap quality control?</p>\n\n\n\n<p>“Me,” he says, beaming.&nbsp;</p>\n\n\n\n<p>Of course, Mullenweg’s control of Automattic extends well beyond the bathroom walls.</p>\n</blockquote>\n\n\n\n<p>Now you know how the rest of the piece is going to go! <strong>Factual errors mixed with bias.</strong> First, no credible business publication would put Automattic&#8217;s valuation at $710 million, <a href=\"https://ma.tt/2021/08/funding-buyback-hiring/\">our last Series E primary round was at $7.5 billion</a>. That was 2021 and we&#8217;d probably trade closer to $5B now with current multiples, but still the article is an order-of-magnitude off.</p>\n\n\n\n<p>David asked if there was a person responsible for choosing toiletries: of course not! We have better things to work on. The entire thing took probably 30 seconds of my time, from going to the bathroom in our New York office to sending a Slack message, and I haven&#8217;t thought about it since until David commented about our bathrooms being nice, while we were both in the bathroom and I was washing my hands. Okay, back to the article.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>And it all began when Mullenweg got very annoyed, very publicly, at a $400 million company called WP Engine.&nbsp;</p>\n</blockquote>\n\n\n\n<p>Once again, Inc is unable to distinguish between revenue and valuation.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>On September 25, more than 1.5 million websites around the world suddenly lost the ability to make some routine software updates.</p>\n</blockquote>\n\n\n\n<p>First, WP Engine doesn&#8217;t host 1.5 million WordPress sites. <a href=\"https://wordpressenginetracker.com/\">This was easily checked on our website WordPressEngineTracker.com</a>, which as best we can tell from crawling the web, looking at domain registrations and public data from <a href=\"https://builtwith.com/\">BuiltWith</a> and <a href=\"https://w3techs.com/\">W3Techs</a>, they probably had ~745k sites on September 25th, so the second number in the piece is off by 2x. Second, those sites could still do software updates using WP Engine&#8217;s tools or by uploading new versions, it was just the connectivity between WP Engine&#8217;s datacenters and WordPress.org&#8217;s that was impacted for a few days.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>WP Engine had royally pissed off Matt Mullenweg for not contributing enough to the open-source community, in his opinion.&nbsp;Mullenweg claims he had been in negotiations with WP Engine for months to get them to cough up their fair share one way or another, but finally decided the company had dragged its feet for too long, leading him to break off talks and go public with his ire.</p>\n</blockquote>\n\n\n\n<p>No, the negotiations, and what they were doing wrong, was abuse of the WordPress and WooCommerce trademarks. I <em>also</em> think it&#8217;s lame how little they&#8217;re involved in the software their entire business is built on and their ability to serve customers was dependent on free server resources and bandwidth from WordPress.org, but our negotiations were about trademark use.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Mullenweg controls the WordPress Foundation, the non-profit that oversees WordPress’s open-source software, the&nbsp;<a href=\"https://wordpress.org/\">website</a>&nbsp;that serves as the gateway to WordPress resources, and the WordPress trademark.</p>\n</blockquote>\n\n\n\n<p>False, false, false. First, I do not control the WordPress Foundation. I am one of three board members, so by definition am not in control. The other two board members could remove me at any time. Second, the Foundation does not oversee the core software, or the WordPress.org website! This is super clear in WPE&#8217;s legal filings, in the about pages of the respective websites, by talking to anyone who understands this. Really shoddy journalism.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The nearly 1,700 employees—a number that reflects the&nbsp;<a href=\"https://techcrunch.com/2024/10/04/159-employees-are-leaving-automattic-as-ceos-fight-with-wp-engine-escalates\">more than 150 who have left in the past few months</a>—are scattered officeless across 90 countries.</p>\n</blockquote>\n\n\n\n<p><a href=\"https://automattic.com/about/\">As you can see on our about page</a>, Automattic has 1,750 employees, not &#8220;nearly 1,700.&#8221;</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>In person, Mullenweg comes off as surprisingly chill when we meet on October 22, given all the angry online noise and employee turmoil surrounding the WP Engine beef for the past three weeks. He is a young-looking, animated 40 with a near-constant grin, and his neat beard and shawl-collar cardigan sweater contribute to his laid-back air.</p>\n</blockquote>\n\n\n\n<p>I&#8217;m quoting this just to show they would occasionally say something nice before twisting the knife or going back into inaccuracies. A &#8220;near-constant grin&#8221; they couldn&#8217;t capture in photos.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Two days later, a comment popped up under the post from a U.K. coder named Mike Little: Would he like some help?&nbsp;</p>\n\n\n\n<p>Three obsessive days later, Mullenweg released the results and followed a friend’s advice to name it WordPress— only after checking to make sure the domain names WordPress.com and WordPress.org were available. This domain ownership would prove critical.</p>\n</blockquote>\n\n\n\n<p>It&#8217;s true that Mike Little commented a few days <a href=\"https://ma.tt/2003/01/the-blogging-software-dilemma/\">after my blog post</a> in January 2003, but WordPress&#8217; first release wasn&#8217;t until May 27<sup>th</sup>, 2003. Not &#8220;three obsessive days later.&#8221; This fact could have been easily verified by digging deep into obscure sources <a href=\"https://en.wikipedia.org/wiki/WordPress\">like the Wikipedia entry for WordPress</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Though there are different versions of open-source licenses, the general idea is that anyone can freely download and use the software, and anyone can modify it as they see fit, and then release it as their own version. But the original developer of the fork retains the trademark rights. And when it comes to WordPress, the rights belong to Mullenweg.&nbsp;<br /></p>\n</blockquote>\n\n\n\n<p>I&#8217;m not sure where to start&#8230; The WordPress trademark doesn&#8217;t belong to Mullenweg, it belongs to the WordPress Foundation. David has clearly not been able to figure things out at this point. But again, <a href=\"https://tsdr.uspto.gov/#caseNumber=78826734&caseSearchType=US_APPLICATION&caseType=DEFAULT&searchType=statusSearch\">this is easily checked by looking at the WordPress trademark on the USPTO site</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>A&nbsp;<a href=\"https://wpengine.com/resources/value-of-wordpress-worlds-first-study-of-wordpress-economy/\">2020 study commissioned by WP Engine</a>&nbsp;calculated the value of all business driven by WordPress to be $600 billion, and growing rapidly. No one gets a bigger piece of that pie than Automattic.</p>\n</blockquote>\n\n\n\n<p>Okay, now after saying Automattic is worth $710M and WP Engine is worth $400M, you&#8217;re now breathlessly quoting WPE&#8217;s PR slop claiming the WP ecosystem is $600B (it&#8217;s not, probably closer to $10-15B/yr) and then immediately pivot into saying that Automattic gets the biggest piece of that pie, something clearly not true based on our revenue versus everyone else in the ecosystem.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Mullenweg had&nbsp;<a href=\"http://photomatt/\">another complaint</a>: WP Engine was violating Automattic’s trademark rights over the WordPress name, based on the fact that WP Engine freely used the abbreviation “WP,” and that “WordPress” appeared throughout their website.</p>\n</blockquote>\n\n\n\n<p><strong>I&#8217;m quoting this just to point out how bad the quality control is at Inc Magazine</strong>: the link for &#8220;another complaint&#8221; doesn&#8217;t work, it has the code <code>&lt;a href=\"http://@photomatt\"&gt;another complaint&lt;/a&gt;</code>. They can&#8217;t even make sure all the links work in their published articles! I presume this was trying to refer to a tweet of mine, but no one reading the article will be able to know what it was. I would like to know, because our trademark complaint had nothing to do with &#8220;WP&#8221;, it was about the use of &#8220;WordPress&#8221; and &#8220;WooCommerce.&#8221;</p>\n\n\n\n<p>Inc Magazine already runs on WordPress, though they use a needlessly complex and expensive custom front-end instead of just serving the site natively. Maybe in their next re-architecture they can take the money they save by getting rid of their lame headless implementation and put it towards fact-checkers and better editors.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Whenever Mullenweg is accused of being too controlling, he often points out he turned over control of WordPress software to a non-profit called the WordPress Foundation. He created the Foundation in 2010, and did indeed assign it all WordPress rights.</p>\n</blockquote>\n\n\n\n<p>I have never said that, and it&#8217;s not even factually accurate or possible for me to assign all WordPress rights.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>But few people who have looked at the Foundation take its independence seriously. Mullenweg is chairman of its three-person board. Little is known about the other two members, and their names don’t appear anywhere on the Foundation’s website.</p>\n</blockquote>\n\n\n\n<p>The names of the other directors do appear on the Foundation website, <a href=\"https://wordpressfoundation.org/news/2024/meeting-minutes/\">for example in this October 17 blog post</a> that says &#8220;WordPress Foundation Directors: Mark Ghosh, Matt Mullenweg, and Chele Chiavacci Farley.&#8221; </p>\n\n\n\n<img width=\"604\" height=\"906\" src=\"https://i0.wp.com/ma.tt/files/2024/12/inc-matt-mullenweg-wordpress-inline-inc-683x1024.webp?resize=604%2C906&ssl=1\" alt=\"\" class=\"wp-image-132700\" />\n\n\n\n<p>Now the article includes a picture of me at the computer, and out of the hundreds they have with my eyes open, they for some reason chose this one where my eyes were closed.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Like most theme vendors in the early years of that small sub-industry, it sold its themes under a proprietary—that is, non-open-source—license. But in 2008, Mullenweg cleaned house of all theme vendors who refused to switch to an open-source license. Only Thesis held out.</p>\n\n\n\n<p>In response, Mullenweg offered to pay Thesis users to switch. He also reportedly paid $100,000 to acquire the domain name “Thesis.com” from a third party and had the name direct to an Automattic blog about theme design.</p>\n</blockquote>\n\n\n\n<p>Themes in WordPress are linked and integrated in a way that the GPL license applies to the PHP code, so if you publish and distribute a WordPress theme the PHP needs to be GPL. There has only been one person to dispute this, Chris Pearson from Thesis, no lawyer or the thousands of successful themes since then have tried to violate the GPL license. Chris is a clown, and the only source for saying that 100k was paid for the Thesis.com domain, I will say now that the domain was bought for a small fraction of that. Again, no fact checking or citing sources.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Thesis eventually gave in. But many in the WordPress community were put off by what they saw as Mullenweg’s vindictive, bullying behavior, and some eventually even left WordPress for other publishing platforms because of it.&nbsp;</p>\n</blockquote>\n\n\n\n<p>It&#8217;s funny to talk about the last big controversy in WordPress world being in 2010, I think it actually speaks to our stability. Since 2010, when &#8220;some eventually even left WordPress&#8221;, the platform has grown market share from under 10% to 43%. I think in a few years we&#8217;ll look back at WP Engine as inconsequential as Thesis, and Heather Brunner as credible as Chris Pearson.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Some are leaving WordPress entirely. Cernak of Northstar Digital Design has already decided to abandon WordPress (and WP Engine) for a much smaller, rival website-development platform called WebFlow. “I can’t depend on WordPress if Matt is going to make changes based on whatever he happens to want at the time,” he says.</p>\n</blockquote>\n\n\n\n<p>Wow, they found one person leaving WordPress for Webflow. Is that cherry-picked, or a trend? Again, <a href=\"https://w3techs.com/technologies/comparison/cm-webflow,cm-wordpress\">you can go to third parties like W3Techs to see the relative market share</a>, and see that we&#8217;ve gained share since September and Webflow has been flat. <a href=\"https://northstardigital.design/\">Northstar Digital Design</a> &#8220;is a creative agency specializing in digital marketing, blockchain technology, web development &amp; design&#8221; <a href=\"https://x.com/NorthStar_DD\">with 5 followers on X/Twitter</a>. Their website lists no clients or portfolio. It&#8217;s unclear how many sites they are responsible for. But this Cernak character is quoted like he&#8217;s some authority or representative of a trend. Maybe he&#8217;s more credible on blockchain technology.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>When I ask Mullenweg if he is feeling traumatized by the pervasive criticism, he tells me about the time he was playing in a Little League game when his teammates saw, through his thin white pants, that his underwear had cartoon characters on them. “They started laughing. That was traumatic for me. But now it’s a funny story,” he recalls. “Tragedy plus time equals comedy.”&nbsp;</p>\n\n\n\n<p>Whether or not anything about the current crisis ever seems funny to him, he insists it will all end up as a beneficial experience. “The best things come out of adversity and clashes,” he says. “We’re going to come out of it way stronger.”</p>\n</blockquote>\n\n\n\n<p>This is a true story, I was very open and vulnerable with the journalist.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>In a prepared statement emailed to&nbsp;<em>Inc.</em>, a WP Engine spokesperson said that “we are encouraged by and supportive of the ideas we see being shared by leaders within WordPress and adjacent open-source platforms to reimagine how key elements of the WordPress ecosystem are governed and funded….” It is a clear plug for pushing Mullenweg out of his BDFLship.</p>\n</blockquote>\n\n\n\n<p>Oh finally, <a href=\"https://ma.tt/2024/09/missing-spokespeople/\">WP Engine talks to the press after months of avoiding interviews and conferences</a>. This is a great statement given WP Engine can barely fund and govern itself, much less the broader WordPress ecosystem, and I doubt the broader WordPress hosting ecosystem would prefer Silver Lake and WP Engine holding the reins of WordPress.</p>\n\n\n\n<p>There&#8217;s more slop in the article but I&#8217;m not going to go through everything. I know a lot of entrepreneurs follow me and I don&#8217;t want your takeaway to be &#8220;don&#8217;t talk to journalists&#8221; or &#8220;don&#8217;t engage with mainstream media.&#8221; When Inc reached out I thought back to when I was a teenager reading Inc and Fast Company, and how those magazines were inspiring to me, I didn&#8217;t think as much about their decline in editorial quality and relevance. I read David&#8217;s other pieces and thought he had some great insight, but this is a good example of where a decent journalist can&#8217;t overcome a crappy editor and quality control. I probably wouldn&#8217;t be excited to work with Inc Magazine again while <a href=\"https://x.com/mikehofman\">Mike Hofman</a> is in charge as editor-in-chief, he&#8217;s clearly overseeing a declining brand. But I will continue to engage with other media, and blog, and tweet, and tell my story directly.</p>\n\n\n\n<p>If you&#8217;d like to see how much editorial bias can shape a story, I will say that Inc <a href=\"https://www.inc.com/issie-lapowsky/why-stacy-brown-philpot-is-your-favorite-board-members-favorite-board-member/91022175\">just published a great profile, with flattering photos, of my good friend Stacy Brown-Philpot</a>. When an editor wants to make you look good, they can! If they decide they want to drag you, they can too. Everything in my interactions with David and Inc made it seem this would be a positive piece, so be careful. <a href=\"https://ma.tt/2024/12/uh-cover/\">I&#8217;ll also contrast it with the excellent cover article University of Houston published a few days ago</a>.</p>\n\n\n\n<p>We&#8217;ll see if Inc Magazine has any journalistic integrity by their updates to the article.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Dec 2024 17:09:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Do The Woo Community: Do the Woo Host Birgit Olzem Transitions to a Leadership Role at Codeable\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://dothewoo.io/blog/do-the-woo-host-birgit-olzem-transitions-to-a-leadership-role-at-codeable/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:323:\"Birgit Olzem came to our hosting team after my own involvement with the DEIB team on Make.WordPress.org. After getting to know her as both a friend and a staunch proponent of DEIB (Diversity, Equality, Inclusion &#38; Belonging), I knew it was obvious that she need to bring her voice to the Do the Woo Community. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Dec 2024 11:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: The Challenges and Strategies of Running a Woo Agency with Sarkis Salleh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87720\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://dothewoo.io/the-challenges-and-strategies-of-running-a-woo-agency-with-sarkis-salleh/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:217:\"In this episode of Woo AgencyChat, Robbie and Robert interview Sarkis from ITQ Commerce, discussing agency challenges, client maturity, WooCommerce perceptions, AI effects, and the importance of community involvement.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Dec 2024 10:59:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WordPress.org Makes Pineapple Pizza Checkbox Optional\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182783\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/wordpress-org-makes-pineapple-pizza-checkbox-optional\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5119:\"<p>The controversial <a href=\"https://wptavern.com/wordpress-org-login-introduces-mandatory-pineapple-pizza-checkbox\">mandatory pineapple pizza checkbox</a> on WordPress.org&#8217;s login form has been made optional. This decision follows a <a href=\"https://x.com/WordPress/status/1868799979231584473\">Twitter poll</a> conducted by WordPress.org, in which 81.2% of respondents voted against making the checkbox mandatory. Additionally, 58.3% of respondents declared that pineapple on pizza is not delicious.</p>\n\n\n\n<a href=\"https://x.com/WordPress/status/1868799979231584473\"><img width=\"2074\" height=\"1702\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-9.png\" alt=\"\" class=\"wp-image-182788\" /></a>\n\n\n\n<a href=\"https://x.com/WordPress/status/1869044125502439629\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcHSSPEI_Q5tPUHihoPP1Qchr8lE3SVED5h6n6_RvVUAkPxoyLE9GrDw0NGW3MjV_8SJ-T2OdtOCan3VPWs1qcvprHlPr5nCrA6gRaLvamBlJugKaa-6KXtVQbpkZaKvqBRBG-1uA?key=2Uq_dWa0n9KW2FGIfPbr0yj3\" alt=\"\" /></a>\n\n\n\n<p>The checkbox initially replaced one from <a href=\"https://wptavern.com/wordpress-org-login-gets-mandatory-affiliation-checkbox-following-wp-engine-dispute\">October</a>, which required users to confirm, &#8220;I am not affiliated with WP Engine in any way, financially or otherwise,&#8221; before accessing their accounts. This earlier requirement was removed following a <a href=\"https://wptavern.com/automattic-complies-with-court-ruling-wp-org-login-checkbox-and-wp-engine-tracker-csv-file-removed\">court ruling</a>.</p>\n\n\n\n<p>Former WordPress Plugin Review Team representative <a href=\"https://profiles.wordpress.org/ipstenu/\">Mika Epstein</a> advocated for the change by opening a <a href=\"https://meta.trac.wordpress.org/ticket/7863\">Trac ticket</a> to make the &#8220;Pineapple is Delicious&#8221; checkbox optional. The proposal quickly gained traction, with Matt Mullenweg expressing his support, stating, <em>“</em>I&#8217;m supportive of this change.”</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXe5fakK_mk7tt-C7lEYs7BuPy7Lr9DEMSr1dLWlUvHNAVbRBTRRqb_7IYYexvCFhXTCYmCI9Say38xCxzzyASHDZZzSnPdt8LnJ1nNEuPleROphpm6eLEeCZYS8W3xrfWY9TOr0?key=2Uq_dWa0n9KW2FGIfPbr0yj3\" alt=\"\" />\n\n\n\n<p>Earlier, Matt had expressed his willingness to meet with people to discuss specific proposals and changes, responding to calls for reforms in the governance of the open-source project. The Repository had published an <a href=\"https://www.therepository.email/wordpress-contributors-and-community-leaders-call-for-governance-reform-in-rare-open-letter\">open letter</a> written by a group of WordPress professionals urging Matt to work with the community instead of continuing to act unilaterally.</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcxmcydGRej8ImEC6hlrtoHExJ8UdQa9WZoPRTmn3Xm1i4OikHCb1fU1WwBIxQ5CreWOZxHeqqeNE53J1O1S-_o5nzVARjrYZAA13EfVSMRBlruAgazG_1wOrYLdD_2kfG3B9aqqg?key=2Uq_dWa0n9KW2FGIfPbr0yj3\" alt=\"\" />\n\n\n\n<p>In response to the change, Jeff Chandler <a href=\"https://x.com/jeffr0/status/1869485279842914762\">tweeted</a>, “The stupid Pineapple checkbox when logging into WordPress.org is now optional.” CEO of ClikIT Blake Whittle <a href=\"https://x.com/BlakeWhittle7/status/1869489156969427129\">remarked</a>, “Not of any community doing. Only because Matt is supportive of the change on his personal website.” Accessibility Expert Alex Stine <a href=\"https://x.com/alexleestine303/status/1869490838344241204\">added</a>, “Matt said yes, change goes live.”</p>\n\n\n\n<p>One <a href=\"https://www.reddit.com/r/Wordpress/comments/1hhc92y/the_idiotic_pathetic_and_childish_pineapple/\">Reddit</a> user humorously quipped, “The Pineapple is dead! Long live the Pineapple!”</p>\n\n\n\n<p>Earlier, Patricia BT had <a href=\"https://wordpress.slack.com/archives/C037W5S7X/p1734511788881119\">suggested</a> an alternative in the Make WordPress #community-team Slack channel. She said, “Could the .org login box be changed to something a bit more serious? Maybe something like &#8220;I adhere to the <a href=\"https://make.wordpress.org/handbook/community-code-of-conduct/\">Community Code of Conduct</a>&#8221; so everyone is following the code. I understand the pizza joke and I am relieved that the legal implications of the previous one are gone (see my concerns about legal implications <a href=\"https://patriciabt.com/blog/statement-on-legal-involvement/\">on my blog</a>), but the WordPress community must look a bit more serious and not have newcomers scratching their heads&#8230; We are the community and people (meetup attendees, end-users, customers, etc) ask us (who are more involved here) about what is happening and they need trust.”</p>\n\n\n\n<p>Dion Hulse of Automattic also chimed in. He <a href=\"https://wordpress.slack.com/archives/C037W5S7X/p1734567697842339?thread_ts=1734511788.881119&cid=C037W5S7X\">said</a>, “Rather than having a checkbox that must be checked every time without thought, it’s probably better to figure out if the policies are in a format that can be linked to / agreed to, and enable that functionality.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Dec 2024 04:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Falling Snow\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=132584\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2024/12/falling-snow/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:469:\"<p>The talented <a href=\"https://felix-arntz.me/\">Felix Arntz</a> has given an incredible Christmas gift to the WordPress community with his <a href=\"https://wordpress.org/plugins/snow-fall/\">fast, light, and accessible Snow Fall plugin</a>, which is live on this site and you can install on yours. I hope everyone is having a happy holidays! Search for &#8220;snow fall&#8221; in your plugin dashboard and install his version, make your site cozy for the holidays.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 20:25:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Gutenberg 19.9 Introduces Style Book to Classic Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wptavern.com/gutenberg-19-9-introduces-style-book-to-classic-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3304:\"<p>The latest release of <a href=\"https://make.wordpress.org/core/2024/12/18/whats-new-in-gutenberg-19-9-19-december/\">Gutenberg</a>, version 19.9, brings a suite of powerful features, tools, and improvements for WordPress users. From enhancing classic themes with the Style Book to introducing the new Query Total block, here’s everything you need to know about this update.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Style Book Comes to Classic Themes</h3>\n\n\n\n<p>One of the standout features in Gutenberg 19.9 is the introduction of the Style Book for classic themes. Classic themes that support editor styles (via <code>add_theme_support( \'editor-styles\' )</code>) or include a <code>theme.json</code> file now have access to the Style Book under the Appearance > Design > Styles section in the WordPress admin panel.</p>\n\n\n\n<p> For classic themes supporting the Style Book, site patterns have been relocated to Appearance > Design > Patterns, consolidating design-related features previously found under Appearance > Patterns. </p>\n\n\n\n<h3 class=\"wp-block-heading\">New Query Total Block</h3>\n\n\n\n<p>The new Query Total block is designed to enhance the user experience. When used within a Query Loop block, it displays either the total number of results returned by a query or the current range in a set of paginated results.</p>\n\n\n\n<p>This feature is particularly useful for improving navigation and providing context to site visitors, making it easier for them to understand the scope of content on your site.</p>\n\n\n\n<h3 class=\"wp-block-heading\">More Highlights and Enhancements</h3>\n\n\n\n<p>Gutenberg 19.9 also comes with several developer-centric improvements, updates and bug fixes. </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>phpMyAdmin in wp-env:</strong> Developers can now launch phpMyAdmin in wp-env. This connects automatically to the running MySQL database service, allowing you to inspect and manage your WordPress database during development.</li>\n\n\n\n<li><strong>Resolution Controls for Featured Images:</strong> The Cover block now offers resolution controls for featured image backgrounds.</li>\n\n\n\n<li><strong>Inline Reset Button for Colors:</strong> An inline reset button has been added to all color controls, enabling users to reset colors for blocks and global styles with a single click.</li>\n\n\n\n<li><strong>Query Block Design Options:</strong> Query block patterns have moved from a modal interface to a dropdown menu under the block toolbar’s “Change design” option.</li>\n\n\n\n<li><strong>Set Homepage in Site Editor:</strong> Users can now set their homepage directly within the Site Editor. Under the Pages section, select the desired page, open the action menu, and choose “Set as homepage.” </li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\">Bug Fixes </h4>\n\n\n\n<p>Several bug fixes have been addressed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Fixed site editor crashes when adding a front-page template and clicking more options.</li>\n\n\n\n<li>Resolved visual alignment regressions in the navigation menu items within the Site Editor.</li>\n\n\n\n<li>Addressed a critical error in the Style Book when blocks were not registered.</li>\n\n\n\n<li>Corrected the List View not updating when switching editor modes.</li>\n</ul>\n\n\n\n<p>Gutenberg 19.9 is the last release of 2024.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 18:52:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: ‘WP Gives A Hand’ Hits Five Years\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wptavern.com/wp-gives-a-hand-hits-five-years\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1110:\"<p><a href=\"https://wpgivesahand.com/\">WP Gives A Hand</a>, a charitable initiative within the WordPress community, uniting businesses to donate a portion of their revenue to support various nonprofit organizations, has turned five. The businesses choose whichever charity they would like to donate to.</p>\n\n\n\n<p>Over the past five years, 29 companies have collectively raised more than $52,000, benefiting 19 different charitable organizations.</p>\n\n\n\n<p>In 2023, 16 participants contributed $11,200 to nine diverse charities, supporting causes ranging from climate change mitigation to poverty alleviation.</p>\n\n\n\n<p>For the 2024 campaign, participating companies will donate a percentage of their sales between <strong>December 23 and 29</strong> to charity. So far, nine companies have joined the movement.</p>\n\n\n\n<p>This year’s donations will support World Bicycle Relief, SOS Children’s Villages Latvia, ENPA Mira, Associazione Rinascendo, Sonrisas Canarias, and Fundación Favaloro among other charities.</p>\n\n\n\n<p>To get involved, visit <a href=\"http://wpgivesahand.com/\">wpgivesahand.com</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 17:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: #150 – Andrew Palmer on His Challenges and Successes in the WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=182690\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/podcast/150-andrew-palmer-on-his-challenges-and-successes-in-the-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:51019:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast, from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case facing up to the challenges and successes of being in the WordPress community.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Andrew Palmer.</p>\n\n\n\n<p>Andrew&#8217;s journey with WordPress started almost two decades ago, after transitioning from Joomla. He went on to make significant strides in the community, co-founding Elegant Marketplace, and investing in ventures like Atarim and Bertha AI.</p>\n\n\n\n<p>In this episode, we talk about the intricacies of working within the WordPress ecosystem, comparing the free and commercial sides. Andrew shares his thoughts on the challenges of financially compensating event contributors, and the importance of non-financial contributions, such as time.</p>\n\n\n\n<p>He discusses the absence of a structured regulatory body in the web development industry, and how he thinks this can impact trust and credibility.</p>\n\n\n\n<p>We discuss the lack of industry wide accreditation in web development, and the controversial nature of establishing such systems within the ever-evolving WordPress environment.</p>\n\n\n\n<p>We hear about his personal and business achievements, such as guiding clients to grow their recurring income, sharing successes in SEO, and the positive experiences of community events like meetups and WordCamps.</p>\n\n\n\n<p>As we explore his thoughts on contribution expectations, and financial struggles of freelancers, Andrew also touches on the changing nature of the industry with the rise of AI solutions, and the longterm utility of WordPress.</p>\n\n\n\n<p>Andrew&#8217;s reflections on his long career, his plans to pivot towards personal interests, and his intention to remain partially involved in the community, lead to a fun conversation which all seems to boil down to perseverance in a rapidly changing industry.</p>\n\n\n\n<p>If you&#8217;ve ever thought about the complexities and commercial dynamics of the WordPress ecosystem, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Andrew Palmer.</p>\n\n\n\n<p>I am joined on the podcast today by Andrew Palmer. Hello, Andrew.</p>\n\n\n\n<p>[00:03:22] <strong>Andrew Palmer:</strong> Hello, Nathan. How are you?</p>\n\n\n\n<p>[00:03:23] <strong>Nathan Wrigley:</strong> Yeah, good. We tried to do this podcast a week ago, but despite the fact that everything was ready to go, we just talked for about an hour, and so hopefully this time around we&#8217;ve actually hit the record button.</p>\n\n\n\n<p>Andrew Palmer&#8217;s joining us today from the UK, and we&#8217;re going to talk about his life story in WordPress, and the fact that that story in WordPress is going to be coming to an end fairly soon.</p>\n\n\n\n<p>Andrew, anybody that doesn&#8217;t know you, would you just give us your little potted bio. We&#8217;ll explore that in more depth, but just give us the two minute elevator pitch, if you like, of Andrew Palmer&#8217;s life.</p>\n\n\n\n<p>[00:03:55] <strong>Andrew Palmer:</strong> Probably about 30 seconds. Started in WordPress 20 years ago, maybe 18, by accident. Was a Joomla guy. Went into WordPress by a guy called Mark Copeman, who doesn&#8217;t speak to me anymore and I don&#8217;t understand why, maybe it was the 30,000 questions I asked. I just got lucky, I suppose.</p>\n\n\n\n<p>My SEO skillset grew over time. I had a CD printing company and a printing company at the time, we were number one in Google. Which was probably easier 18 years ago, let&#8217;s face it.</p>\n\n\n\n<p>And then I got into products, Elegant Marketplace. Six of us got together, ended up three of us, then two of us, then one of us, for various reasons. Elegant Marketplace sold that to InMotion for silly money, still going. I&#8217;ve got nothing to do with it now. It&#8217;s been five years.</p>\n\n\n\n<p>Spent all that money on investing in different things like Atarim. I&#8217;m an investor in Atarim. Very small shareholder now because big guys like Yoast and some guys from 123 Reg, or ex 123 reg have invested in that as well. Done a few good things there.</p>\n\n\n\n<p>Bertha AI started that with Vito, he had to back off a couple of years ago, so we&#8217;ve been going three years with that. Vito is concentrating on Atarim, which is a collaboration software, which we&#8217;re all very proud of because it was WP Feedback, and now it&#8217;s Atarim and does every website, you know, you can go onto every website, not just WordPress.</p>\n\n\n\n<p>Still got Bertha AI, still got a, well, I&#8217;m closing my agency actually, my web agency, which is part of this story. Getting off social media and just having a rest from the web world and web dev, continuing with my maintenance and that&#8217;s it really. That&#8217;s what I do. I&#8217;m Andrew Palmer.</p>\n\n\n\n<p>[00:05:29] <strong>Nathan Wrigley:</strong> If you don&#8217;t mind me asking, Andrew, and I don&#8217;t want to know your age, but I do want to know, are you at that time of life where closing things down and having a more restful experience is the order of the day, or are you just going to carry on working but in a different arena outside of tech, outside of WordPress?</p>\n\n\n\n<p>[00:05:46] <strong>Andrew Palmer:</strong> Well, I don&#8217;t mind my age because I do pretty well on it really. I&#8217;m 64. 65 in May next year. So missed out on retirement, I&#8217;m getting my pension at 65, by a month because of governments, the way they dilly dally and have different shenanigans around pensions.</p>\n\n\n\n<p>And my pension really is my work, so after having invested a load of money, lost a load of money, invested a load of money again, lost a load of money, and made some money, and all this kind of stuff, it&#8217;s been a bit of a nice roller coaster, gradual roller coaster. Nothing great heights or great depths.</p>\n\n\n\n<p>But the web dev world has changed immensely. So I&#8217;m just going to be doing something else. And whether or not I come back to the web dev world or not is anybody&#8217;s guess. Somebody said, I&#8217;ll never leave it the other day, and same person said, my finger isn&#8217;t on the pulse as much as I think it is. And maybe that&#8217;s true. So maybe I need to go away, think about what I want to do with my life. Do some stuff that I really do want to do, which is catering. I love catering. It&#8217;s in my DNA.</p>\n\n\n\n<p>Had a couple of restaurants, and pizza places, and coffee shops and stuff, and I just enjoy that. I enjoy real customer interfacing, except people that order a particular kind of coffee, it&#8217;s called a dirty espresso or something. It&#8217;s bit of chocolate in it, it&#8217;s horrible. But it&#8217;s hard work to make. You just think, oh, and you got to clean everything down. It&#8217;s just like, really? Just have a coffee.</p>\n\n\n\n<p>[00:07:07] <strong>Nathan Wrigley:</strong> Do you think that working in the technology sector is a young person&#8217;s game? And by that, I&#8217;m looking back on my life and I&#8217;m thinking that it all seemed a lot easier when I was younger. I am in my fifties, and definitely my capacity to learn new things is, it&#8217;s not what it once was.</p>\n\n\n\n<p>My drive and obviously available time, you know, in my case I have a family and that really does consume free time. And a lot of the learning that I did around web dev and technology was done in the evenings when I had free time and all of that. But you said no to that initially, you don&#8217;t think it is. You think that any age is available, and you can be effective, and innovative, and all of that despite your age.</p>\n\n\n\n<p>[00:07:48] <strong>Andrew Palmer:</strong> I really do think, well, with age comes experience, you know, bracket, mistakes. What I try and do, because I&#8217;ve got a little bit of coaching thing on the side. My aim actually is in February I start a counseling course, a proper counseling course for people with bereavement, or partnership issues, or business issues, or the whole personal sort of stuff. But you have to be, in the UK, you have to have some qualifications for that. So I need to go out and get the qualifications.</p>\n\n\n\n<p>I&#8217;ve been coaching for a while actually, and every single one of my coaching clients without exception said, you should really just get into counseling because you are not a business coach in the true sense of the word. Yes, you&#8217;ve helped my business, but you&#8217;ve also helped me emotionally and stuff like that. And walked me off ledges. And encouraged me. And told me my pros, and told me my cons. And without any, because I don&#8217;t hold anything, but actually, no, Nathan, you and I have a private conversations so you know I don&#8217;t hold anything back.</p>\n\n\n\n<p>I think honesty is part of coaching, honesty in business. And I think currently I&#8217;ve got some situations in web dev world where I don&#8217;t think particular people, and or companies, are being particularly honest about the way they, one, promote their products, treat their customers, pricing, price gouging and all this kind of stuff.</p>\n\n\n\n<p>So I&#8217;m a bit sad that the web development world, certainly the WordPress world that I&#8217;m observing is not, or hasn&#8217;t got as much integrity as it did have a few years ago when there were less products out there.</p>\n\n\n\n<p>We&#8217;re overloaded by products. AI products. Forms, I mean, how many forms are out there? And they&#8217;re all trying to compete with each other, and do comparisons, and get involved in Twitter spats and all this kind of stuff. I&#8217;m just not interested in it anymore. I&#8217;m interested in being honest about what we&#8217;re able to give people for a price, and being honest about giving good support.</p>\n\n\n\n<p>[00:09:40] <strong>Nathan Wrigley:</strong> Do you think that the WordPress space during your time in it, you said 18, 20 years, I mean really it&#8217;s the full span of WordPress, more or less. Do you think that it has changed then for the worse? I have not been in it for anything like that length of time. I&#8217;m more like the 10 year mark, the 9, 10 year mark. And when I joined WordPress, commercial products were already, they were the norm. You could go out and buy this, that, and the other thing.</p>\n\n\n\n<p>But my understanding, reading Milestones, the history of WordPress, tells me that it started just like most open source projects do, as a sort of fairly philanthropic endeavor. And then people realised that it was popular and they were able to build their products on top of it, and sell those products and what have you. There always seems to be this tension between the commercial side of WordPress and the contributor side of WordPress, let&#8217;s call it that. So my question very simply is, do you think it&#8217;s got, air quotes, worse?</p>\n\n\n\n<p>[00:10:31] <strong>Andrew Palmer:</strong> Yes. Oh, definitely. And also, from the contributor perspective as well, there&#8217;s been some awesome contributors to the system, and one particular plugin developer that I know very well was giving away all of his plugins. And of course I come along and say, why are you giving them away? And it took me 18 months to get him onto the Elegant Marketplace that I had, and within six months he&#8217;d earn $150,000 from a $10 plugin.</p>\n\n\n\n<p>It&#8217;s easy to get slightly over enthusiastic about it, you know, and it was a lifetime license for $10 and stuff. And then support just got a bit overwhelming, and then the idea of subscriptions came in, because if you want support, you&#8217;ve got to pay for a subscription.</p>\n\n\n\n<p>But certainly on the WordPress repository, there&#8217;s some gamification going on, there&#8217;s SEO shenanigans and lots of products are cross marketing each other. And I don&#8217;t think that was the idea for the repository, really. It was just literally a repository for free plugins. Here&#8217;s a free plugin, this will help make WordPress operate better. You&#8217;ve got a nice form plugin like, for instance, Contact Form 7 has never, you&#8217;ve never had to pay for it. And it&#8217;s got millions upon millions of downloads. But other people have made money out of Contact Form 7 by doing add-ons to them to make it easier to use.</p>\n\n\n\n<p>We know form people very well, Gravity Forms, WS Form. Mark does a great job with WS Form. You&#8217;ve got WP Ninja guys doing forms. There&#8217;s a new form came out last week, so there&#8217;s competition there, which is always good. That&#8217;s the whole point of the world really is, competition should drive prices down. But unfortunately I think it&#8217;s driving quality down, or quality of service, because there&#8217;s a price point that people are willing to pay in WordPress and that&#8217;s being tested, let&#8217;s say.</p>\n\n\n\n<p>There&#8217;s a lot of people out there saying, okay, you can have a lifetime deal. I&#8217;ve got a lifetime deal on Bertha, you know. But some people take it up, some people don&#8217;t. If you&#8217;re selling a plugin for more than $10 a month it&#8217;s kind of, that&#8217;s a lot of money.</p>\n\n\n\n<p>So yeah, the competition and the way that people are marketing things these days within WordPress, and other places, we&#8217;ve got people with the Aldi, Marks and Spencer&#8217;s argument over a cake. You copied my cake, and all that kind of stuff.</p>\n\n\n\n<p>So competition begets resentment as well, and also increases toxicity because, let&#8217;s give an example of say, page builders. If you&#8217;re a Divi user, you love Divi. If you&#8217;re not a Divi user, and you look at another Divi user, you think they&#8217;re an idiot. If you&#8217;re a Bricks user, why would anybody else not want to use Bricks? You&#8217;re an idiot if you don&#8217;t use it. Or if you are a particular plugin user, and another plugin does very similar things, you&#8217;re an idiot if you don&#8217;t use this one. You know, all this kind of stuff. There&#8217;s just a level of toxicity that I can live without.</p>\n\n\n\n<p>[00:13:10] <strong>Nathan Wrigley:</strong> So has this toxicity as you describe it, has that promoted you to leave in advance of when you might have chosen to? In other words, have you become fed up with what&#8217;s going on inside WordPress plugins, themes, community, whatever you want to call it?</p>\n\n\n\n<p>Has it pushed you to make a decision ahead of how you might have done, I don&#8217;t know if, let&#8217;s say for example, five years ago you were thinking you&#8217;d probably go on into your seventies or something, but now you are thinking of retiring, in inverted commas, a little bit earlier?</p>\n\n\n\n<p>[00:13:39] <strong>Andrew Palmer:</strong> I don&#8217;t think so. I think, you know, I&#8217;d always kind of aimed for 65 to retire from the web development work, because it&#8217;s actually not easy developing websites. Especially these days with all the AI solutions, and I&#8217;m guilty of that. You know, we brought out Bertha three years ago. Doesn&#8217;t build websites, but you&#8217;ve got lovely things like ZipWP, you&#8217;ve got Kadence WP, building AI, you&#8217;ve got GoDaddy with their own AI solutions now.</p>\n\n\n\n<p>ZipWP have just announced that there&#8217;s a hosting opportunity, white label. So all hosts, literally all web hosts for WordPress, will have an AI build opportunity built in, and very competitive. If you look at the pricing of ZipWP for host, it&#8217;s crazy competitive.</p>\n\n\n\n<p>So even if you are a reseller, or you are using WHM or whatever to be a host on the back of another host, you can install ZipWP and for 90 bucks a month, you can offer an opportunity for people to build a thousand websites on ZipWP. I think that&#8217;s an incredible opportunity. And it&#8217;s not complete websites. You still have to finish them off and put your own design situations in. But really, for mom and pop shops it&#8217;s a perfect solution. It&#8217;s an unbelievably good solution, just like Kadence WP.</p>\n\n\n\n<p>So it&#8217;s harder to get good web development jobs, or web design jobs, which I&#8217;ve never been a web designer. You know, if you look at some of the web designs that I&#8217;ve done, how&#8217;s he survived? But I&#8217;m more backend really. I&#8217;ve got a team of developers that are unbelievably good at coding, so there&#8217;s never been a situation that they can&#8217;t address really, which is really cool.</p>\n\n\n\n<p>[00:15:07] <strong>Nathan Wrigley:</strong> When you look back at your career then, what have been some of the highlights over that time? And I really am interested in going back the full 18, 20 years because there may very well be bits that weren&#8217;t necessarily all that significant at the time, but with the benefit of hindsight, you think, oh gosh, that really did steer me in a different direction, and change things for me. So let&#8217;s go back and spend a few minutes just thinking of the bits that you&#8217;ve enjoyed the most.</p>\n\n\n\n<p>[00:15:34] <strong>Andrew Palmer:</strong> Oh, it&#8217;s going to sound kind of weird, but helping people. I mean, I&#8217;ve helped a lot of people make a lot of money in WordPress. I&#8217;ve had one guy introduced him to another guy, and he sold his plugin for a hundred grand, and then got 15 grand a month for two years to develop it further.</p>\n\n\n\n<p>I&#8217;ve helped developers earn a lot of money, and grow, and develop lots of plugins. I mean, one guy, probably over the span of four years of being on Elegant Marketplace, probably earned a million bucks in a four year period. I helped WP Feedback massively. Within 31 days, they had a year&#8217;s worth of money to work with.</p>\n\n\n\n<p>But it&#8217;s all persuasion. I mean, you know, to get WP Feedback into Elegant Marketplace, I was literally driving a mini helping this guy move offices, and stealing a couple of screens off him when he was moving offices. I&#8217;m in my little mini convertible and I&#8217;m saying, okay, you want to sell your plugin on your own website, nobody knows where you are. You&#8217;ve got a thousand people in an email address, I&#8217;ve got 63,000 email addresses.</p>\n\n\n\n<p>You either want to sell it on the corner shop or you want to go to the supermarket. And with a supermarket, you are going to lose some of your margin. So what? But at least you&#8217;re going to get out there. And I think we sold 200 grands worth or so in a month. Not bad. So that&#8217;s a proud moment.</p>\n\n\n\n<p>I mean, helping grow Termageddon, we did a marketing campaign with Termageddon, I think we got them a thousand customers in just over two weeks. So that&#8217;s nice to know that, and we got rewarded for it as well. We got paid for that as well, commissions and all kinds of stuff and great friendships were built over that.</p>\n\n\n\n<p>As an individual, I&#8217;ve met a lot of lovely people, you included, amazing, and kept them as friends. People message me all the time saying, how are you doing, and what&#8217;s going on?</p>\n\n\n\n<p>And through Bertha, I just did a thing today, which is what I love doing. You know, there&#8217;s a particular user that&#8217;s really loved Bertha, and used Bertha from day one and carried on with it, and she&#8217;s paid loads of money into it. She paid the first high premium prices, and then she&#8217;s reduced down to the monthly, and then got an annual for whatever, and then she said, oh, do you know what? I&#8217;ve been paying for Bertha for about six months twice, I&#8217;ve been paying for it twice. I said, oh dear, well we&#8217;re beyond our free refund period because it&#8217;s going to cost me money to refund you, but I&#8217;ll tell you what, I&#8217;ll just cancel all payments for the future, and I&#8217;ve gifted you a lifetime of Bertha.</p>\n\n\n\n<p>The email I got back was amazing. It&#8217;s nice to be able to do those kind of things for people that have supported you as well. Speaking at WP London, speaking at Bristol Meetup, my first meetup that I ever spoke at, that was amazing.</p>\n\n\n\n<p>Building websites for businesses, you know, I built a website for a business, he was in Magento, he was turning over 20 grand a month. I persuaded him to move to Shopify of all things, on the golf course, just saying, why don&#8217;t you just move to Shopify? Here&#8217;s the price. He didn&#8217;t like it, but there you go, that&#8217;s him. You know, within a year, he&#8217;d turned over two and a half million quid. So that&#8217;s nice.</p>\n\n\n\n<p>And it sounds as though it&#8217;s all about money, but it means he&#8217;s improved his life, and built up the business and it&#8217;s still continuing to grow. So it&#8217;s basically helping people grow businesses, you know, coaching clients. One person came to me, she was recurring income of about 700 a month and knew exactly what to do, but just couldn&#8217;t get the incentive to do that. Now she&#8217;s on like 10, 15 grand a month recurring income.</p>\n\n\n\n<p>So guiding people through their journeys. Writing references for people so that they, true references as well, saying, yeah, this person&#8217;s good at that, she may not be good at that, or he may not be good at that. Them ending up getting a 200,000 a year job out of it. Hopefully that my reference helped as well. Because it&#8217;s a genuine reference. You know, after coaching people, you kind of know people pretty well.</p>\n\n\n\n<p>One of the greatest things that I did was I had a CD printing company and I learned about SEO. We were number one under CD printing in the UK. One guy got in touch with us and the job was for £365. It was a thousand CDs, and we printed them in our little inkjet printer and everything. His next order was for £365,000. That was quite an achievement. I mean it&#8217;s just, everybody talks about 10 x-ing, not hundred x-ing, or whatever it is.</p>\n\n\n\n<p>And it does sound as though it&#8217;s all about money, but also the nice side about being involved in WordPress is the Meetups, the WordCamps, the traveling, the getting to play golf with Victor Drover for nine holes when I had a bad back, and it was too hot, and I was a bit sweary. All those kind of things.</p>\n\n\n\n<p>You know, meeting Victor Drover from, he&#8217;s got this lovely thing called watchful.net, which is similar to Blog Vault, but hasn&#8217;t got the backups and all that kind of stuff, or ManageWP. And he&#8217;s just a great guy. And he was partners with a guy, Steve Burge, who&#8217;s got PublishPress now, and they&#8217;re just cool guys.</p>\n\n\n\n<p>And they were in the Joomla community first of all, and they&#8217;ve transitioned across to WordPress because it&#8217;s just bigger now. Mike Demo, he was at InMotion, we made friends because he approached me for a coffee in Berlin WordCamp, said, do you want to sell Elegant Marketplace? And it was about three years previously, we&#8217;d been going two years and I said, no, no, no. And then in Berlin, I just thought, you know what, we are near our five year thing, in a year&#8217;s time we&#8217;ll be five years old. These things normally take about a year. And we sold it on the 31st of December that year from a coffee meeting with him and a guy called Tim, who&#8217;s a lovely guy as well. On the 31st of December 2019, so how was that for timing.</p>\n\n\n\n<p>[00:20:47] <strong>Nathan Wrigley:</strong> It sounds like the bit that&#8217;s underlying is the interface of business and community in a way. And although you took pains there to point out that it sounds like it&#8217;s all about the money, in the community, that is a legitimate part of it, right? And I know that for some people, the whole topic of the finance and money and all of that is, it&#8217;s not something they want to engage with. They want to contribute their spare time and the business side of it is of less interest to them.</p>\n\n\n\n<p>Whereas other people like you, it&#8217;s different, right? You have a business, you want to be profitable. Ultimately, that is what the business is for, is to generate revenue, and pay the staff, and increase the product roadmap, and the share of the market that you&#8217;ve got and all of that. And I think that&#8217;s really interesting.</p>\n\n\n\n<p>But it&#8217;s nice that you&#8217;ve also got the community angle thrown around it as well. In that all of the bits and pieces that you&#8217;ve mentioned are not just your own, but other people&#8217;s successes. And I&#8217;ve definitely seen you in person lots and lots of times, and you show up to all those different kind of events as well. So that&#8217;s nice.</p>\n\n\n\n<p>[00:21:42] <strong>Andrew Palmer:</strong> Yeah, I think one of the things that really does annoy me about WordPress is that contributors have to go cap in hand. And I&#8217;m talking about contributors from speakers at WordCamps, to Meetups, to various events that people organise in WordPress. Really talented developers who are contributors for whatever reason to WordPress. It&#8217;s good for them because they get a little badge, they can sell themselves to other people and say, look, I&#8217;m actually a Core contributor to WordPress, so I know more about WordPress and this other person, you should employ me, and also I contribute to WordPress. So kudos to me.</p>\n\n\n\n<p>And that&#8217;s great but then there&#8217;s always a donate button, and there&#8217;s always a, I can&#8217;t make it to WordCamp because I can&#8217;t afford it. Because you can afford the ticket price, because that&#8217;s always been Matt&#8217;s aim to keep it under a hundred bucks or something. I think WordCamp New York was the most expensive, wasn&#8217;t it? A hundred dollars or something? It was the first time it reached a hundred dollars. Mostly it&#8217;s sort of been, I remember when it was 20 bucks. It&#8217;s great. It&#8217;s just a cursory kind of commitment to pay 20 bucks because I want to make sure you come. But it&#8217;s the travel, the hotels, specifically in America, they&#8217;re so expensive, hotels in America.</p>\n\n\n\n<p>So a WordCamp, to make it worth going to a WordCamp, you need to get there two days before to acclimatise to where you are. And there&#8217;s various Meetups, you know, all these hosting companies put on their big events and stuff to try and attract you to them. So you&#8217;re talking a few grand, maybe two or three grand to raise to go to a big WordCamp. One of the four bigs the Asia, I mean, Asia from UK is like 15 hours.</p>\n\n\n\n<p>I would love to get rid of the cap in hand mentality of WordPress. I&#8217;m doing this for free, can you donate? Can you help me contribute more to Core? That shouldn&#8217;t be a thing as far as I&#8217;m concerned. If you are contributing to something that has a commercial end game, which is WordPress, and or Joomla, and or Drupal, because people are using it for commercial purposes, then you shouldn&#8217;t need to go cap in hand.</p>\n\n\n\n<p>You should be paid for your contribution. And you should be paid for your attendance at any kind of Meetups if you are a speaker, because you&#8217;re contributing. That&#8217;s my view, and I know how to do it, and I&#8217;ve told the relevant authorities how to do it. And I think that things have to change to be more appropriate to what the product of WordPress is, because it is a product rather than a project, because loads of people are making loads of money out of it.</p>\n\n\n\n<p>But there&#8217;s also the freelancers out there that are using WordPress to earn a living, and they&#8217;re literally scratching a living. You know, I saw a Tweet the other day from Matt Medeiros saying, anybody willing to tell me how hard it is being a freelancer in WordPress at the moment. You know, are you suffering from not getting paid on time.</p>\n\n\n\n<p>I was in a little group the other day, moaning about the fact that I haven&#8217;t got paid. One guy said, and I&#8217;ll name him because he&#8217;s great, James Bullis said, well, that&#8217;s your fault because you haven&#8217;t set the rules.</p>\n\n\n\n<p>And there&#8217;s no guidance for new freelancers. And he&#8217;s absolutely right. It is my fault. I didn&#8217;t set the rules to my clients, so they take their time in paying me. And so he&#8217;s moved on to GoHighLevel because, doesn&#8217;t want to do WordPress anymore, that type of thing. But he&#8217;s also moved on to being more of a consultant, rather than a web designer, developer. And I think that&#8217;s the way it&#8217;s going.</p>\n\n\n\n<p>Because of AI, people can build their websites in a heartbeat. The way WordPress is going, there&#8217;s more onboarding now. You can actually build something from, especially 6.7 with the new theme there, 6.7 theme, whatever it&#8217;s called, 2025 theme. That&#8217;s much better. And the fact that you can turn off the patterns when you go to every page is just like a complete bonus.</p>\n\n\n\n<p>But WordPress needs to have onboarding and it doesn&#8217;t, and that&#8217;s why it loses out, in inverted commas. I don&#8217;t think WordPress loses out to the Wix&#8217;s of this world, or the Sqarespaces of this world. I think if you&#8217;re going to use WordPress, then it&#8217;s a good decision. Just as it is a good decision to use any other web building software. But you have to be aware that it&#8217;s more long-term work.</p>\n\n\n\n<p>[00:25:37] <strong>Nathan Wrigley:</strong> It&#8217;s such a strange dichotomy, WordPress, because I&#8217;ve got quite a few hobby projects that have got nothing to do with revenue generating. They&#8217;re just personal websites that I&#8217;ve put up to, I don&#8217;t know, house my thoughts for want of a better word. And so that&#8217;s completely free.</p>\n\n\n\n<p>But obviously also inside the WordPress space, there&#8217;s this juggernaut of commercial products, hosting companies, plugin companies, SEO companies, you name it. It&#8217;s all been taken care of. And there&#8217;s millions, billions of dollars sloshing around inside the WordPress space.</p>\n\n\n\n<p>I genuinely find it a really big puzzle trying to work out what the free portion means. And so, you know, when you say that it would be great to pay everybody, I guess that would be a fantastic aspiration, wouldn&#8217;t it? That everybody that attends a WordPress event, and does something there, let&#8217;s say, contributes their time or is a speaker or what you, not an attendee necessarily. But they would be paid for.</p>\n\n\n\n<p>It is interesting how you square that circle, though. You know, where does that money come from? How does that money get corralled? How do you, for want of a better word, compel people to donate money that seems like a fairly decent moral obligation, but isn&#8217;t an actual legal obligation and so on?</p>\n\n\n\n<p>I find that part of the puzzle really difficult. And obviously in more recent times, the last couple of months that is playing itself out, is going to be playing itself out in the courts fairly soon to the time of recording it. And I don&#8217;t know how to solve that problem. I just know that that problem exists.</p>\n\n\n\n<p>In an ideal world where unicorns run free, and there are rainbows everywhere, everybody reaches into their pockets and donates plus 5% of everything that they&#8217;ve got in terms of time and revenue. But we don&#8217;t really live in that world, do we? And some plugin developers are hard up and it&#8217;s difficult enough just to make ends meet. So them donating time might be really difficult, on it goes.</p>\n\n\n\n<p>[00:27:23] <strong>Andrew Palmer:</strong> You are right, it is difficult. But I think the big guys do contribute a little cash wise, but I don&#8217;t think it is all about the cash. It&#8217;s about the time. How do you keep the project going? Especially as so many people have left, you know, the guy that did the Rest API, forgive me, I can&#8217;t remember his name, maybe that&#8217;s because I&#8217;m 64 and it&#8217;s time ago. But he developed something that changed the way WordPress worked. And he is not in the community anymore for various reasons.</p>\n\n\n\n<p>But that&#8217;s not something that can continue, people leaving Core contributions. And to have it all on one company, even though that company is making money, is irresponsible. We&#8217;ve got to find a way for people to contribute, and contribute either financially or with time. With the current situation, that&#8217;s a difficult bridge to cross, and I&#8217;m hoping that the bridge isn&#8217;t burnt. And I don&#8217;t think it is, I think it&#8217;s just severely charred. Might need some repair, you know.</p>\n\n\n\n<p>There&#8217;s things going on in WordPress community that go in on other communities as well. And the difference with WordPress I think, or with web development per se, it&#8217;s not just WordPress. There is no association. Lawyers have the, in the UK they have the Law Society, which they have to adhere to certain rules. With WordPress, it&#8217;s just a free for all. With web, it&#8217;s a free for all. It&#8217;s not just WordPress, it&#8217;s all the web building technologies that you&#8217;ve got. It&#8217;s a complete free for all, and you don&#8217;t know that people are actually qualified to give you the advice that they&#8217;re saying they are self qualified to give.</p>\n\n\n\n<p>And that&#8217;s I think part of the issue with all web development, and it&#8217;s a trust issue. How can I trust you? You hear so many stories, oh, my developers left me. Well okay, yeah, but why? Were you a difficult client? Or did you pay your bills on time? Why did your developer leave you? Because mostly developers will stick around with you. So let&#8217;s figure out why they left you, and if they did leave you for their own reasons and they weren&#8217;t very good at what they did, then that&#8217;s fine. But let&#8217;s make sure that we are at least transparent in what our capabilities are.</p>\n\n\n\n<p>And by being a member of a society like the Law Society or something, we sign up to be good, and honest, and have some integrity, and we charge the right prices, and we don&#8217;t overcharge. Maybe things could get better by that way, who knows?</p>\n\n\n\n<p>[00:29:37] <strong>Nathan Wrigley:</strong> It&#8217;s interesting, isn&#8217;t it? There are initiatives, and off the top of my head, I&#8217;ve forgotten what their names are, but I will try to put in the show notes links to the endeavors to provide some kind of accreditation basically. And you&#8217;re right, certainly in the UK, if a plumber shows up at my house, or an electrician shows up at my house, firstly, I&#8217;m going to assume that they have the necessary qualifications, and if not, I&#8217;m going to ask to see it. And once I&#8217;ve seen that, I am totally happy that they can do the work that&#8217;s required, and that if things are not done to the correct standard, I&#8217;ll be able to go back to some kind of industry body and say, look what happened.</p>\n\n\n\n<p>And in a sense, web development is real wild west, isn&#8217;t it? And you only have to listen to the origin story of more or less everybody that I&#8217;ve interviewed and they say the same thing. And the story kind of goes like this, well, I had a job, I wasn&#8217;t really enjoying it, so I started playing with website building in my spare time. I had a friend or a family member who wanted a website so I did that, and then realised that, oh, actually there&#8217;s something in this. And then pursued it, got better and better. The point being, there is no industry body.</p>\n\n\n\n<p>And I know that this is a real divisive subject actually, because as soon as you introduce this, there are those people who think, yeah, this is a great idea, let&#8217;s get everybody accredited and we&#8217;re off to the races. We can all at least know that if you&#8217;ve got this badge, you can do this set of things, and if you&#8217;ve got this one, you can do this set of things.</p>\n\n\n\n<p>And there are other people who think that that&#8217;s just a terrible idea. You know, I want to be able to learn and not have to go and sit exams and prove what I can do. My history of work will be the judge of what I can do and so on. And I don&#8217;t really know what the answer is, but having that accreditation in other walks of life definitely works. Whether or not it would work in the WordPress space, I&#8217;m not entirely sure, but it&#8217;s an interesting subject.</p>\n\n\n\n<p>[00:31:16] <strong>Andrew Palmer:</strong> We do have it in WordPress in a way with the contributor badges. I&#8217;m a contributor, so I obviously know what I&#8217;m doing because I&#8217;ve got a badge that says I know what I&#8217;m doing. And you can see my profile, and you can see the plugins that I&#8217;ve developed, and all the websites that I&#8217;ve done or my Core contributions.</p>\n\n\n\n<p>But we have it for, as I say, lawyers and accountants, you&#8217;ve got to be a registered chartered accountant. We have it for nurses, to be a member of an accredited association, and to pass exams, and do all the exams. But there&#8217;s things that prove that you can do what you do. And web development is one of those industries that just doesn&#8217;t have that. It&#8217;s literally, take my word for it. Here&#8217;s some stuff that I&#8217;ve done, and here&#8217;s some clients that have been happy. ie testimonials, so bite the bullet and pay the money.</p>\n\n\n\n<p>[00:31:59] <strong>Nathan Wrigley:</strong> It is really difficult, isn&#8217;t it? For example, if you had a WordPress qualification, let&#8217;s say that you were wanting to classify yourself as a WordPress theme builder, developer, plugin developer, whatever. Can you imagine the amount of different accreditations that you&#8217;d have had to have gone through in the last five years? Five years ago you probably could have had one set of qualifications for the previous 15 years. And then it feels like more or less every six months you&#8217;d have to have a new one because it&#8217;s changing so much. And I&#8217;m fairly sure that in the next six months it&#8217;ll have changed beyond all recognition. In fact, I know what&#8217;s coming, as does everybody who follows the project.</p>\n\n\n\n<p>But it&#8217;s going to be really difficult to keep track of, can you build blocks in the correct way now, or in the WordPress way now? Do you have the capacity to do things with full site editing in mind? And so on and so forth? Have you taken account of the new APIs that are coming at the rate of about one a week, it feels at the moment, and so on? So it would be really hard to pin that down.</p>\n\n\n\n<p>And also, it&#8217;s not like we&#8217;ve got a CEO of WordPress, a commercial entity who is, if you like, just telling everybody what to do. It is, to a great extent, a community driven project. And so the direction that it goes can morph a little bit, and so that would make it difficult as well I feel.</p>\n\n\n\n<p>[00:33:11] <strong>Andrew Palmer:</strong> Yeah, because it&#8217;s not, WordPress the project isn&#8217;t a commercial situation. So therefore, I love the phrase of it&#8217;s a Wild West because it is. It is the Wild West. There&#8217;s no doubt about it, is that literally you go on Fiverr, you can get a website developed for $30, 50 bucks, whatever. All the layouts that are out there are the, they&#8217;re bloated and horrible and not accessible and all this kind of stuff.</p>\n\n\n\n<p>Part of the reason I&#8217;m getting out as well from web dev is accessibility. I don&#8217;t want to be held responsible for my client&#8217;s bad decisions, because I have no control. If I say to a client, well, actually to get as accessible as we possibly can, it&#8217;s going to cost you another three or five grand. They go, oh, I don&#8217;t want to do that. I say, well, it could cost you a hundred grand if you don&#8217;t spend that money in advance.</p>\n\n\n\n<p>Web design is becoming more of a commodity as well. Because they&#8217;re saying, okay, well, I can have a website, but there&#8217;s other things. And what I mean, there&#8217;s a commodity, it&#8217;s a product.</p>\n\n\n\n<p>With WordPress, you have an unlimited amount of other products that help it work better to your desire. LMS, forms, API connectors, all this kind of stuff, SaaS systems, whatever. Which all need updating and paying for every single year.</p>\n\n\n\n<p>With a proprietary system, you get what you get. Yes, there are extensions, but there extensions really have to, people are complaining about, oh, got my plugin on wordpress.org kicked out the other day because it hasn&#8217;t got this, this, and this. Try doing a Shopify app and getting it passed. That is really hard. And keeping it there, and also knowing that, once you get to a million dollars a year on Shopify, that you&#8217;ll be having 15% of that revenue taken away from you straight away. Which is fine, I&#8217;ve got no problem with that at all. It&#8217;s just, think outside of WordPress for the moment, and think the difficulties that you&#8217;re going to have in the proprietary systems.</p>\n\n\n\n<p>They&#8217;re going to be similar, not the same, because the proprietary system do the updates. I&#8217;ve had people complaining about 6.7, it&#8217;s broken layouts and things like that. And then you&#8217;ve got another guy who&#8217;s saying, well, it&#8217;s nothing wrong with that, it&#8217;s got to be a plugin conflict. And there&#8217;s no real solution. It&#8217;s just a, yeah, oh, sorry you got a problem, you know, maybe I can help you. Rather than, it can&#8217;t be anything we&#8217;ve done, and all that kind of stuff.</p>\n\n\n\n<p>So you need to have a certain amount of patience to be a web developer in any platform that you are using, because there are going to. I got a quote from a client the other day, finished a massive Shopify site. There&#8217;s just one thing that broke it yesterday, which the client broke it by adding something, and he said, this is why we can&#8217;t have nice things. It just breaks.</p>\n\n\n\n<p>Because it&#8217;s not a Shopify thing that he wanted to add into it, it&#8217;s a mailing system with HTML and the HTML broke. And then now we&#8217;ve got to program it round to fix it, and there&#8217;s another few hours of charges. So, you know, another couple of grand or whatever it may be. So there are problems dealing with proprietary systems as well, let me tell you. It&#8217;s not all roses out there, there&#8217;s some thorns as well.</p>\n\n\n\n<p>[00:36:06] <strong>Nathan Wrigley:</strong> Yeah, it doesn&#8217;t matter which point of WordPress&#8217; history you were to plonk yourself down on if you had a time machine. If you look in one direction, it&#8217;ll be the worst time in WordPress&#8217; history. And you look in another direction, it&#8217;ll be the best time in WordPress&#8217; history. And you could probably say that at any point in time. We&#8217;re just where we are, and we have to figure the way through.</p>\n\n\n\n<p>But you&#8217;ve definitely been there. You&#8217;ve had an extremely long journey. I know that you&#8217;ve had your ups and your downs. And I&#8217;d just like to say, from me, it&#8217;s been a real pleasure getting to know you. Do you think we&#8217;ll see you turning up to events in the near future, or are you literally drawing a line and saying, all media closed, business shut down, nothing to do with the internet anymore. What&#8217;s going to happen?</p>\n\n\n\n<p>[00:36:47] <strong>Andrew Palmer:</strong> The straight answer is no. You&#8217;re not going to see me again ever. You lucky, lucky boy. Your cup runneth over, I&#8217;m sure.</p>\n\n\n\n<p>No, I mean, you know, I&#8217;ll pop in occasionally I would imagine, but I&#8217;m just going to have a rest from this arena. I think Paul, he now does Beaver Builder, Paul Lacey, he left the WordPress community for a while because it was just overwhelming, and he had an agency and he closed it down and did all sorts of stuff.</p>\n\n\n\n<p>And I&#8217;m on a similar path, really. I&#8217;m just going to close my agency down. So web dev is gone. That actually happened on the first of November. I just said, no more web dev. But I&#8217;ve got maintenance clients, I mean, I&#8217;ve got recurring income from that, and that&#8217;s what&#8217;s keeping me. I&#8217;m closing my limited company because the revenue isn&#8217;t enough really to have a limited company with all the associated costs with that, it just costs more for accountancy and costs more for everything. It&#8217;s just horrible.</p>\n\n\n\n<p>So sole trader from first of December, closing the limited company down at the end of December. Not owing any personal person any money, which is great, or any business any money.</p>\n\n\n\n<p>And then from the first of December, trading as Andrew Palmer and doing whatever I do. But the maintenance side, so if somebody wants me to develop a website, I&#8217;ll say no, but these people will develop a website for you. And if someone wants me to build an API, I go, nope, but these people will develop that API, off you go, see you later. The maintenance side I&#8217;ll keep going because it&#8217;s cost effective for me to run and I can do it part-time. It&#8217;s not a big deal.</p>\n\n\n\n<p>I&#8217;ve got one client that&#8217;s very worried that I&#8217;m going to leave her. I look after, I don&#8217;t know, 78 websites for them, so I&#8217;m not going to, yeah. But it&#8217;s not hard to look after them. And occasionally one goes down and I just go in and fix it, and five minutes later it&#8217;s right. So that&#8217;s not going. And the other clients that I&#8217;ve had for 20 years, you know, literally 20 years hosting their websites and they&#8217;re going, well, what are we going to do? I said, well, don&#8217;t worry about it, I&#8217;m keeping that side on.</p>\n\n\n\n<p>I will also get it ready, you know, I nearly sold it last month, and the guy just came back to me at the last minute and said, we&#8217;re not ready and the company&#8217;s not ready. Because when you run your own business, you let a few things go. Not badly but just because you just know. You know what to do on that. So there&#8217;s no notes on it or anything like that. So, you know, I need to be able to make saleable. So within six months, I think I&#8217;ll have completely got out of the business by selling my business and doing what I want to do.</p>\n\n\n\n<p>[00:39:03] <strong>Nathan Wrigley:</strong> It sounds like you&#8217;re going to have a portion of a toe in the water still. Just one toe, but only a little bit of that toe.</p>\n\n\n\n<p>[00:39:09] <strong>Andrew Palmer:</strong> Exactly, yeah. So long as it&#8217;s nice and warm.</p>\n\n\n\n<p>[00:39:12] <strong>Nathan Wrigley:</strong> That sounds nice. Well hopefully, we&#8217;ll get to catch up at some point in the near future, but Andrew Palmer, thank you very much for joining us today and being a part of the community for the length of time that you have. I really appreciate it.</p>\n\n\n\n<p>[00:39:22] <strong>Andrew Palmer:</strong> Thanks very much. It&#8217;s been good fun.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/arniepalmer\">Andrew Palmer</a>.</p>\n\n\n\n<p>Andrew&#8217;s journey with WordPress started almost two decades ago after transitioning from Joomla. He went on to make significant strides in the community, co-founding Elegant Marketplace and investing in ventures like Atarim and Bertha AI.</p>\n\n\n\n<p>In this episode, we talk about the intricacies of working within the WordPress ecosystem, comparing the free and commercial sides. Andrew shares his thoughts on the challenges of financially compensating event contributors and the importance of non-financial contributions, such as time. He discusses the absence of a structured regulatory body in the web development industry, and how he thinks this can impact trust and credibility.</p>\n\n\n\n<p>We discuss the lack of industry-wide accreditation in web development and the controversial nature of establishing such systems within the ever-evolving WordPress environment.</p>\n\n\n\n<p>We hear about his personal and business achievements, such as guiding clients to grow their recurring income, sharing successes in SEO, and the positive experiences of community events like Meetups and WordCamps.</p>\n\n\n\n<p>As we explore his thoughts on contribution expectations and financial struggles of freelancers, Andrew also touches on the changing nature of the industry with the rise of AI solutions and the long-term utility of WordPress.</p>\n\n\n\n<p>Andrew&#8217;s reflections on his long career, his plans to pivot towards personal interests, and his intention to remain partially involved in the community, lead to a fun conversation which all seems to boil down to perseverance in a rapidly changing industry.</p>\n\n\n\n<p>If you&#8217;ve ever thought about the complexities and commercial dynamics of the WordPress ecosystem, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://elegantmarketplace.com/\">Elegant Marketplace</a></p>\n\n\n\n<p><a href=\"https://bertha.ai/\">Bertha AI</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/book/milestones/\">Milestones &#8211; The story of WordPress</a></p>\n\n\n\n<p><a href=\"https://contactform7.com/\">Contact Form 7</a></p>\n\n\n\n<p><a href=\"https://www.gravityforms.com/\">Gravity Forms</a></p>\n\n\n\n<p><a href=\"https://wsform.com/\">WS Form</a></p>\n\n\n\n<p><a href=\"https://ninjaforms.com/\">Ninja Forms</a></p>\n\n\n\n<p><a href=\"https://www.elegantthemes.com/gallery/divi/\">Divi</a></p>\n\n\n\n<p><a href=\"https://bricksbuilder.io/\">Bricks</a></p>\n\n\n\n<p><a href=\"https://zipwp.com/\">ZipWP</a></p>\n\n\n\n<p><a href=\"https://www.kadencewp.com/\">Kadence WP</a></p>\n\n\n\n<p><a href=\"https://www.godaddy.com/en-uk/airo\">GoDaddy Airo</a></p>\n\n\n\n<p><a href=\"https://termageddon.com/\">Termageddon</a></p>\n\n\n\n<p><a href=\"https://www.wpldn.uk/\">WPLDN</a></p>\n\n\n\n<p><a href=\"https://watchful.net/\">Watchful</a></p>\n\n\n\n<p><a href=\"https://publishpress.com/\">PublishPress</a></p>\n\n\n\n<p><a href=\"https://www.inmotionhosting.com/\">InMotion hosting</a></p>\n\n\n\n<p>GoHighLevel</p>\n\n\n\n<p>WP Certify</p>\n\n\n\n<p>Beaver Builder</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Do The Woo Community: LinkedIn for Agencies and Personal Branding with Nicole Osborne\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87681\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://dothewoo.io/linkedin-for-agencies-and-personal-branding-with-nicole-osborne/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:197:\"In this episode, Emma and Adam discuss LinkedIn\'s potential for personal branding and agency growth with trainer Nicole. They share strategies for effective engagement and avoiding common mistakes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 11:50:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Do The Woo Community: Advanced WooCommerce Development, Lessons &amp; Challenges with Chase Gruszewski\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87697\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://dothewoo.io/advanced-woocommerce-development-lessons-challenges-with-chase-gruszewski/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:204:\"In their final episode of the year, hosts Marcel and Mike discuss personal reflections, client management, and WooCommerce insights with developer Chase, focusing on advanced education and AI integration.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 09:32:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"Do The Woo Community: Behind the Scenes on the Do the Woo Site Rebuild with Derek Hanson and Katie McCanna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://dothewoo.io/behind-the-scenes-on-the-do-the-woo-site-rebuild-with-derek-hanson-and-katie-mccanna/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:193:\"In this episode of Do the Woo, hosts Robbie and Bob discuss the website revamp led by Automattic\'s Special Projects team, focusing on improvements, user engagement, and innovative integrations.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Dec 2024 10:23:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Recap of the State of the Word 2024 \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182598\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wptavern.com/recap-of-the-state-of-the-word-2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10549:\"<p>WordPress co-founder Matt Mullenweg delivered his annual State of the Word (SOTW) address today from Tokyo Node Hall in Tokyo, Japan. This marks the second time the event was held outside North America, following last year’s address in Madrid, Spain.</p>\n\n\n\n<p>This year’s event spanned three hours, with a special emphasis on Japanese culture. Matt <a href=\"https://x.com/photomatt/status/1868564167487066543\">explained</a>, “We&#8217;ve gotten so much inspiration over the years from Japanese culture, we wanted to make this event really &#8220;of the space,&#8221; so we&#8217;re doing a few extra things this year. My presentation will include Mary Hubbard and Matías Ventura, but also part of it will be in Japanese and presented by Junko Fukui Nukaga. We&#8217;ll have a piano performance by Aiko Takei. After the presentation and Q&amp;A we&#8217;ll do a panel in Japanese with Mieko Kawakami, Craig Mod, Hajime Ogushi, and Genki Taniguchi.”</p>\n\n\n\n<p>Matt enumerated the WordPress contributions of the Japanese community, mainly <a href=\"https://wptavern.com/community-translation-and-wapuu-how-japan-is-shaping-wordpress-history\">Translation, and Wapuu</a>. Japan was the country that made him realize that WordPress was more than a blogging tool, and Kansei engineering fascinates him.&nbsp;</p>\n\n\n\n<p>A Japanese WordPress site was set up in December 2003, just six months after WordPress was launched.&nbsp; The version originally called “WordPress ME” (WordPress Multilingual Edition) was maintained by a user called Otsukare. <a href=\"https://ja.wordpress.org/about-wp-ja/wapuu/\">Wapuu</a>, the official mascot character of WordPress, was designed by Kazuko Kaneuchi in 2011 and is GPL licensed.</p>\n\n\n\n<p>Matt then shared some statistics:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>WordPress now powers 43.6% of the internet and, according to W3Techs, has a 62.3% CMS market share.</li>\n\n\n\n<li>WordPress powers 58.5% of all the websites in Japan and has an 83% market share, which is 31x Shopify, which is only at 2.7%.</li>\n\n\n\n<li>WordPress has surpassed 500M core downloads.&nbsp;</li>\n\n\n\n<li>English is the most used language (50.8%), followed by Spanish (6.87), German (5.99) and Japanese (5.82%)</li>\n\n\n\n<li>1,700 new themes were uploaded in the last 12 months, an increase over the 1,400 new themes last year. Of those new themes, over 1,000 of them are block themes.</li>\n\n\n\n<li>WordPress is expected to hit 2.35 billion downloads of plugins this year, which is a 20% year-over-year growth.</li>\n\n\n\n<li>Plugin ecosystem is thriving, with the review queue reduced to zero. After launching the Plugin Check tool, 41% fewer issues were reported per approved plugin and enabled the team to approve 138% more plugins each week.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg&nbsp;</h2>\n\n\n\n<p>The event also highlighted the progression of Gutenberg, which is entering its third phase focused on collaboration. &nbsp;<a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, Gutenberg’s lead architect, discussed upcoming features that will enable users to collaborate directly within the editor, including leaving comments and receiving notifications, similar to Google Docs.&nbsp;</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>WordPress is for everyone. So we need to really put our minds together into working out how can it be the best writing tool, the best design tool, the best developer experience. It takes time, it takes effort from the whole community but I think it&#8217;s very rewarding.</p>\n\n\n\n<p>&#8211; Matias Ventura</p>\n</blockquote>\n\n\n\n<p>The team is also working on a ‘Zoom out’ feature. He then talked about Styles, the theme JSON structure, block bindings, query block, the ongoing efforts to address the lack of responsive tools in the editor, and the new Registered Blog Template API, which has simplified the process of registering and managing custom templates.</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcn0kY5hsPRDD6hvnH8QiDQDzLtPziycb0YqdEAMD64qK-z2aHAgSlRW_ZcYQftgbjUSPXe92DLVG0hdUIsjQY6AcX6SI4NzaQp0Ry2PBaHx7_75lTq2xBtWnQhj2HCLllTdHe2?key=XGjteIksmw0i5v-3f2w6QcY9\" alt=\"\" />\n\n\n\n<p>“We have a lot to go through,” Ventura said, “and we want to approach this one through sort of four lenses, and that is Write, Design, Build, and Develop.”</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress Playground</h2>\n\n\n\n<p>WordPress Playground was another exciting feature discussed. This tool allows WordPress to run instantly on any device without hosting, enabling users to experiment without installations. New updates include support for multiple instances within a single window, the integration of Blueprints (JSON files for setting up your WordPress Playground instance), and a Playground block that embeds WordPress instances within WordPress itself. Mullenweg emphasized that these innovations aim to make WordPress more accessible and powerful while preserving its open-source ethos.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>We don’t want to just make things that work. We want to make them beautiful.</p>\n\n\n\n<p>&#8211; Matt Mullenweg</p>\n</blockquote>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress &amp; WP Engine</h2>\n\n\n\n<p>WordPress Executive Director Mary Hubbard said she hopes to resolve the WP Engine issue equitably. She said, “So like Matt, I believe that when you choose WordPress, you should get WordPress. And that should never be anything that somebody is confused about. And that&#8217;s something that I personally believe is worth fighting for and driving my driving force and motivation of taking on this role because we&#8217;ve come too far as an open source platform and we should not stand by as it&#8217;s being exploited or watered down for the short-term gains of a few at the expense of the long-term needs of the many because WordPress belongs to all of us, us and to our community and that&#8217;s what I&#8217;m most passionate about.”</p>\n\n\n\n<p>She also talked about <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> which now features structured learning pathways, and <a href=\"https://openverse.org/\">Openverse</a> which has expanded to include 884 million images and 4.2 million audio files, nearly 4 million page views this month alone and over 21 million API requests.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>WordPress does belong to us all and what we&#8217;re doing is taking care of it for the next generation and the next generation is critical to WordPress&#8217;s ongoing growth as a platform and making it accessible and frictionless as possible has never been more important.</p>\n\n\n\n<p>&#8211; Mary Hubbard</p>\n</blockquote>\n\n\n\n<p>Grassroots programs are flourishing and she mentioned two programmes &#8211; <a href=\"https://wptavern.com/ajmer-in-india-to-host-its-first-wordpress-event-wp-campus-connect\">WP Campus Connect</a> from India and <a href=\"https://wptavern.com/podcast/148-stephen-dumba-on-empowering-uganda-with-wordpress-education-and-community-initiatives\">National ICT Innovation Hub</a> from Uganda.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Local Japanese Community</h2>\n\n\n\n<p>WordPress Community Program Supporter and Team Rep <a href=\"https://profiles.wordpress.org/nukaga/\">Junko Fukui Nukaga</a> shared the updates on Japan and WordPress. Japanese is now the fourth most used language in the world by WordPress. In October 2024, the Japanese WordPress community celebrated DigitalCube’s IPO on the Tokyo PRO Market. Other notable Japanese businesses include Contact Form 7, HAMWORKS, SAKURA Internter, KOMOJU and Xserver.</p>\n\n\n\n<p>Japan is also home to 26 active meetup groups and 11265 community members who hosted 189 local meetups this year. Japan’s contribution to the Core are growing.&nbsp;</p>\n\n\n\n<p>Matt then mentioned the contributions of <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, a Core Committer (made 774 contributions to WordPress core with 338 props for 6.7),and <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, an active Docs Team member. 13 Japanese contributors supported 5.4% of WordPress 6.6 development.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Data Liberation</h2>\n\n\n\n<p>Matt had announced <a href=\"https://wptavern.com/data-liberation-meet-wordpress-orgs-ambitious-plan-for-2024\">Data Liberation</a> at last year&#8217;s State of the Word to be the gold standard of liberation and interoperability. The idea is not just to make WordPress more powerful but to ensure that it’s truly free. It&#8217;s the freedom to move content anywhere, to collaborate without barriers or constraints. WordPress Playground plays a critical role in this vision.</p>\n\n\n\n<p>“Some people might see 2024 as a year of distractions or attacks from bad actors in the community. But it was really a year of growth and focus where we were able to accelerate so many things that we&#8217;re doing. It was also an amazing year of growth in a lot of areas.”, he said. </p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A Session</h2>\n\n\n\n<p>The event also had a short Q&amp;A session where Mullenweg fielded questions about the future of blogging, whether the performance plugin of WordPress will be integrated into core, AI-generated content, digital identity, and democratising publishing.&nbsp;</p>\n\n\n\n<p>Matt also congratulated developer <a href=\"https://x.com/tetsuaki_hamano/status/1858914117987529004\">Aki Hamano</a>. He then talked about Automattic’s missions &#8211; to democratize publishing, democratize commerce (with WooCommerce), and democratize messaging (through <a href=\"https://www.beeper.com/\">Beeper</a>). These three things will keep him busy for life, and he revealed that he’ll work on WordPress for the rest of his life, which he considers to be an honour and privilege.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Panel Discussions</h2>\n\n\n\n<p>The event had two panel discussions moderated by Mary Hubbard. The first panel featuring Mieko Kawakami, Craig Mod and Matt explored ‘Publishing in the Open’ while the second panel of <a href=\"https://x.com/megane9988\">Hajime Ogushi</a>, <a href=\"https://x.com/genkitngch\">Genki Taniguchi</a>, and Matt discussed ‘The Future of WordPress in Japan and Beyond’.&nbsp;</p>\n\n\n\n<p>The event was live-streamed and is available on <a href=\"https://www.youtube.com/watch?v=ySolP8YjODU\">WordPress YouTube channel</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Dec 2024 04:06:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WordPress.org blog: State of the Word 2024: Legacy, Innovation, and Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18205\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2024/12/state-of-the-word-2024-legacy-innovation-and-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:29207:\"<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>On a memorable evening in Tokyo, State of the Word 2024 brought together WordPress enthusiasts from around the world—hundreds in person and millions more online. This event marked the first time State of the Word was hosted in Asia, reflecting the platform&#8217;s growing global reach. The setting couldn’t have been more fitting: a city where tradition and technology coexist in seamless harmony. Tokyo, much like WordPress itself, reflects a powerful blend of legacy and innovation, craftsmanship and technology, and moments of vast scale balanced by serene stillness.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-1 wp-block-group-is-layout-flex\">\n<blockquote><p>Tokyo is a city you feel.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote>\n</div>\n\n\n\n<p>During the event, the concept of <em>kansei</em> engineering emerged as a central theme. This Japanese design philosophy seeks to create experiences that go beyond function and aesthetics, focusing on how something feels. As highlighted during the keynote, this principle has quietly influenced WordPress’s development, shaping its design and user experience in ways that resonate on an instinctive level.</p>\n\n\n\n<p>The evening also celebrated Japan’s deep-rooted connection to WordPress. Nearly 21 years ago, Japan became the first country to localize WordPress, long before a formal translation framework existed. It all started with<a href=\"https://wordpress.org/support/topic/localization-help-needed/\"> a single forum post from a user named Otsukare</a>, launching a translation project that helped WordPress become a truly global platform. Seeing how far the Japanese WordPress community has come—both in market share and cultural influence—was a powerful reminder of what shared purpose can achieve.</p>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"Photo of Matt exhibiting some of the community\'s wapuu creations\" class=\"wp-image-18208\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<p>Wapuu, WordPress’s beloved mascot, was also born in Japan. What began as a simple idea for a fun and friendly representation of WordPress evolved into a global phenomenon. Thanks to Kazuko Kaneuchi’s generous open-source contribution, Wapuu has been reimagined by WordPress communities worldwide, each version infused with local character. This uniquely Japanese creation has helped make WordPress more welcoming, approachable, and fun wherever it appears.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress Growth in 2024</h2>\n\n\n\n<p>WordPress cofounder Matt Mullenweg highlighted significant achievements that underscored WordPress’s growth, resilience, and expanding global presence in 2024. He shared that WordPress now powers 43.6% of all websites globally. In Japan, WordPress’s influence is even more pronounced, powering 58.5% of all websites. This remarkable statistic reinforces the platform’s enduring role as a cornerstone of the open web and accentuates Japan’s deep-rooted commitment to the WordPress ecosystem and its developers’ significant contributions.</p>\n\n\n\n<img width=\"1024\" height=\"260\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=1024%2C260&ssl=1\" alt=\"\" class=\"wp-image-18339\" />\n\n\n\n<p>WordPress sites using languages other than English are expected to surpass English-language sites by 2025. German recently overtook Japanese as the third-most-used language, though Japanese remained close behind. Meanwhile, emerging languages like Farsi experienced rapid adoption, reflecting the platform’s expanding multilingual ecosystem. In Southeast Asia, languages such as Indonesian, Vietnamese, and Thai saw substantial year-over-year growth, signaling broader adoption across diverse regions.</p>\n\n\n\n<p>Core downloads surged to nearly half a billion annually, with the notable releases of WordPress <a href=\"https://wordpress.org/download/releases/6-5/\">6.5</a>, <a href=\"https://wordpress.org/download/releases/6-6/\">6.6</a>, and <a href=\"https://wordpress.org/download/releases/6-7/\">6.7</a>.</p>\n\n\n\n<p>WordPress’s design and development ecosystem flourished as well. Over 1,700 new themes were uploaded in 2024, bringing more than 1,000 block themes to the official repository and reflecting increased interest in modern, flexible site design.</p>\n\n\n\n<p>The plugin ecosystem also saw record-breaking activity this year. Plugin downloads surged toward 2.35 billion, representing a 20% year-over-year increase. Plugin updates exceeded 3 billion and are on track to surpass 3.5 billion by year’s end. Notably, the Plugin Review Team made transformative improvements, drastically reducing the average review wait time. Their efficiency gains were complemented by the launch of the <a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check</a> tool, which reduced submission issues by 41% while enabling the team to approve 138% more plugins each week.</p>\n\n\n\n<p>These accomplishments showcase WordPress’s resilience, adaptability, and ever-expanding influence. As the platform continues to evolve, its global community remains at the heart of its success, driving innovation and ensuring that WordPress thrives as the leading tool for building the open web.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"has-text-align-center\">Help shape the future of WordPress: Join a contributor team today!</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://make.wordpress.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Make WordPress</a></div>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Advancing the Platform</h2>\n\n\n\n<p>WordPress lead architect, Matías Ventura, highlighted WordPress’s evolution through the lenses of writing, design, building, and development, demoing various pieces of new and forthcoming enhancements.</p>\n\n\n\n<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?resize=1024%2C576&ssl=1\" alt=\"Write, Build, Design, Develop\" class=\"wp-image-18219\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<h3 class=\"wp-block-heading\">Writing</h3>\n\n\n\n<p>The writing experience in WordPress saw notable advancements this year, with an improved distraction-free mode that helps users to focus on content creation without interface distractions. Now you can directly select the image itself to drag and drop it where you want, even enabling on-the-fly gallery creation when you drop images next to each other.</p>\n\n\n\n<p>Additionally, the introduction of block-level comments in the editor, currently an experimental feature, promises to reshape collaborative workflows by enabling teams to leave notes directly on blocks.</p>\n\n\n\n<p>These enhancements all work together to make writing, composing, and editing in WordPress feel more fluid, personal, and pleasant than ever.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Design</h3>\n\n\n\n<p>Along with new default theme Twenty Twenty-Five, more than 1,000 block themes offer tailored starting points for different site types, including portfolios, blogs, and business sites. Designers can also utilize the improved Style Book for a comprehensive view of their site’s appearance, ensuring a smooth design process.</p>\n\n\n\n<p>Design work isn’t just about aesthetics—it’s also about creating the right environment and guardrails. It’s important that users can interact with their site, add content, replace media, and choose sections without needing to know the layout details. We’re implementing better default experiences to help you focus exclusively on the content or on the design, depending on your needs at the moment.&nbsp;</p>\n\n\n\n<p>This all works seamlessly with the zoom-out view, where users can compose content using patterns without having to set up every individual block. Having a bird’s-eye view of your site can really help you gain a different perspective.</p>\n\n\n\n<p>These design capabilities scale with you as your WordPress projects grow. WordPress&#8217;s approach to design is systematic: blocks combine to form patterns, patterns form templates, and templates help separate content from presentation.</p>\n\n\n\n<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?resize=1024%2C576&ssl=1\" alt=\"\" class=\"wp-image-18302\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<h3 class=\"wp-block-heading\">Building</h3>\n\n\n\n<p>WordPress’s content management capabilities allow working at scale and across teams. Central to this is the introduction of Block Bindings, which merge the flexibility of blocks with the structured power of meta fields. This feature allows block attributes to be directly linked to data sources like post meta, reducing the need for custom blocks while creating deeper, more dynamic content relationships. The familiar block interface remains intact, making complex data management feel seamless. This connects naturally with our broader work on Data Views for post types and meta fields.&nbsp;</p>\n\n\n\n<p>These updates reinforce WordPress’s role as a powerful content management system by connecting its core primitives—blocks, post types, taxonomies, and meta fields—more intuitively.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Development</h3>\n\n\n\n<p>Lastly, Matías showcased a range of groundbreaking tools that empower WordPress developers and streamline their workflows. One of the highlights was the new Templates API, which has simplified the process of registering and managing custom templates. Future updates to the API will allow users to register and activate templates seamlessly, enabling dynamic site customizations such as scheduling different homepage templates for special events or swapping category archives during campaigns. This flexible approach offers developers greater creative control in a standardized way.&nbsp;</p>\n\n\n\n<p>The session also explored the Interactivity API, designed to deliver fast, seamless website experiences by enabling server-rendered interactivity within WordPress. Unlike JavaScript-heavy frameworks, this technology keeps everything within WordPress’s existing ecosystem, bridging the gap between developers and content creators. Attendees saw live demos showcasing instant search, pagination, and commenting—all without page reloads—while maintaining a perfect performance score of 100 on Lighthouse. In addition, it was announced that responsive controls will receive significant attention, with new features being explored, like block visibility by breakpoint and adding min/max controls to the columns block.</p>\n\n\n\n<p>The WordPress Playground also emerged as a game-changer, allowing users to spin up WordPress sites directly in their browsers, experiment with Blueprints, and manage projects offline. With improved GitHub integration and expanded documentation, WordPress developers now have a more accessible and powerful toolkit than ever before.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An AI Future</h2>\n\n\n\n<p>Returning to the stage, Matt noted that Gutenberg’s evolution is paving the way for AI-powered site building while keeping creative control in users’ hands. A recent speed building challenge on WordPress’s YouTube channel showcased this potential, with <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> using AI-assisted tools and <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> building manually. While the AI-assisted approach won, the key takeaway was that AI isn’t here to replace developers but to enhance creativity and efficiency.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Community Impact and Global Reach</h2>\n\n\n\n<p>When WordPress Executive Director Mary Hubbard took the stage, she emphasized WordPress’s commitment to its open-source mission and the power of its global community. Mary shared her passion for defending WordPress’s principles, reaffirming that when users choose WordPress, they should receive the authentic, community-driven experience that the platform stands for. This commitment to clarity, trust, and open-source integrity is central to ensuring WordPress’s long-term sustainability and success.</p>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"Photo of Mary Hubbard, WordPress Executive Director\" class=\"wp-image-18227\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>Mary Hubbard, WordPress Executive Director\n\n\n\n<p>In 2024, WordPress’s global influence surged through expanded educational programs, developer contributions, and grassroots initiatives. The platform’s social media following grew to 2.3 million, while major events like WordCamps and live-streamed gatherings attracted millions of attendees and viewers, connecting people worldwide.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> introduced Structured Learning Pathways, offering tailored tracks for beginners and developers, fostering a growing network of creators eager to learn and contribute. Grassroots programs flourished, with WP Campus Connect bringing WordPress education to Indian colleges and innovation competitions in Uganda empowering young creators. In Latin America, the Community Reactivation Project reignited meetups across nine cities, fostering a network of over 150 active members and setting the stage for three new WordCamps in 2025.</p>\n\n\n\n<p>WordPress’s efforts also advanced through <a href=\"https://openverse.org/\">Openverse</a>, which expanded its free content library to 884 million images and 4.2 million audio files, serving millions of creators worldwide and supporting WordPress’s broader mission of democratizing publishing.</p>\n\n\n\n<p>Whether through educational platforms, developer-driven innovation, or community-led projects, WordPress’s ecosystem continues to nurture shared learning, creativity, and collaboration, ensuring its growth and relevance for future generations.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Japanese Community Highlights</h2>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/nukaga/\">Junko Fukui Nukaga</a>—Community Team rep, program manager, and WordCamp organizer—noted that WordPress&#8217;s prominence in Japan contributes to an economy now estimated to exceed 100 billion yen.</p>\n\n\n\n<p>In October of 2024, the Japanese WordPress community celebrated DigitalCube’s IPO on the Tokyo PRO Market, marking a milestone for the local WordPress ecosystem. Major contributors like Takayuki Miyoshi’s <a href=\"https://wordpress.org/plugins/contact-form-7/\">Contact Form 7</a> plugin surpassed 10 million active users, while companies like Sakura Internet and XServer built specialized WordPress infrastructure.</p>\n\n\n\n<p>Community events in Japan have also flourished, with 189 local meetups held throughout the year, fueled by dedicated volunteers and organizers. Translation Night gatherings have ensured WordPress remains accessible to Japanese users, reflecting a thriving collaborative spirit.</p>\n\n\n\n<p>Matt gave special recognition to Japan’s standout contributor, <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, a Core Committer whose exceptional efforts elevated WordPress development over the past year. Hamano-san made an impressive 774 contributions to WordPress core, earning 162 props for WordPress 6.5, rising to 274 props for 6.6 as the second-highest contributor, and securing the top spot with 338 props for 6.7.Other notable Japanese contributors included <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, an active Docs Team member, and Nukaga, recognized for her exceptional community organizing efforts. Additionally, 13 Japanese contributors supported 5.4% of WordPress 6.6 development, showcasing the country’s growing influence in the WordPress ecosystem.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Data Liberation</h2>\n\n\n\n<p>Reflecting on the progress since the initiative&#8217;s launch last year, the focus remained on ensuring that WordPress not only becomes more powerful but also embodies freedom in its deepest sense—the freedom to move content anywhere, collaborate without limits, and create without constraints. This vision extends beyond individual sites to a broader web where content flows seamlessly across platforms, enabling unrestricted creativity and innovation.</p>\n\n\n\n<p>One compelling example demonstrated how easily ePub files could be imported into a WordPress site, integrating seamlessly with existing designs. This represents the initiative’s broader goal: making content migration and integration effortless. WordPress Playground plays a critical role in this vision by enabling easy site migration through a simple browser extension. With Playground as a staging area, migrating and adapting sites becomes intuitive and accessible.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A</h2>\n\n\n\n<p>The floor was opened to questions in both Japanese and English.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>Questions from the audience, including <a href=\"https://en.wikipedia.org/wiki/Tokyo_Vice\"><em>Tokyo Vice</em></a> author Jake Adelstein, covered the future of blogging, WordPress performance, the impact of AI search, and what democratizing publishing means today. Matt shared his excitement for more open platforms such as Mastodon and Bluesky, as well as his recommendations for optimizing your site for both humans and AI. A common thread throughout was that a personal website is an important part of your digital identity, and WordPress allows you to<a href=\"https://playground.wordpress.net/?plugin=piano-block&blueprint-url=https%3A%2F%2Fwordpress.org%2Fplugins%2Fwp-json%2Fplugins%2Fv1%2Fplugin%2Fpiano-block%2Fblueprint.json%3Frev%3D3166994%26lang%3D\"> express yourself in fun and unique ways</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Panels</h2>\n\n\n\n<p>After attendees enjoyed a special performance by the pianist, Takai-san, industry leaders, creators, and innovators took the stage for panel discussions about the present and future of WordPress, moderated by Mary Hubbard.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Publishing in the Open</h3>\n\n\n\n<p>Featuring:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Mieko Kawakami, Japanese Author and Poet&nbsp;</li>\n\n\n\n<li>Craig Mod, Author of Things Become Other Things&nbsp;</li>\n\n\n\n<li>Matt Mullenweg, WordPress Cofounder and Automattic CEO</li>\n</ul>\n\n\n\n<p>This first panel explored the transformative power of open-source publishing. Panelists shared insights into how open publishing has influenced their creative journeys, expanded audience engagement, and shaped storytelling across cultural boundaries.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Publishing in the open has defined what I’ve done. All the best connections I’ve made in live have been the result of publishing in the open. &#8211; Craig Mod</p>\n</blockquote>\n\n\n\n<p>Publishing in the open, like WordPress, is about building community, mutual connections, and putting power back into the hands of creators.</p>\n\n\n\n<h3 class=\"wp-block-heading\">The Future of WordPress in Japan and Beyond</h3>\n\n\n\n<p>Featuring:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Hajime Ogushi, mgn CEO</li>\n\n\n\n<li>Genki Taniguchi, SAKURA internet Inc. Senior Director</li>\n\n\n\n<li>Matt Mullenweg, WordPress Cofounder and Automattic CEO</li>\n</ul>\n\n\n\n<p>The second discussion highlighted WordPress&#8217;s remarkable growth in Japan and its broader global impact. The discussion covered the drivers behind Japan&#8217;s adoption of WordPress, its thriving ecosystem of WordPress-based businesses, and emerging trends in web development.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Compared to other CMSs the WordPress Japanese is much easier to use. &#8211; Hajime Ogushi</p>\n</blockquote>\n\n\n\n<p>The group discussed plugins such as <a href=\"https://wordpress.org/plugins/contact-form-7/\">Contact Form 7</a>, the affordability of hosting WordPress, and local meetups and events</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>Thank you to all the guests who joined us on stage, those who ventured to Tokyo, and everyone who tuned in from around the world. Today’s event showcased how a free and infinitely flexible platform, an active global community, open innovation, and a commitment to a fully democratized web make us better at being who we are.</p>\n\n\n\n<p>From Tokyo, Arigatou Gozaimashita!</p>\n\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18249\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18262\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18274\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18252\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18258\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18240\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18260\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18251\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"683\" height=\"1024\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?resize=683%2C1024&ssl=1\" alt=\"\" class=\"wp-image-18229\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18230\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18233\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18236\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"683\" height=\"1024\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?resize=683%2C1024&ssl=1\" alt=\"\" class=\"wp-image-18231\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18228\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18272\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18305\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18269\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18257\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18271\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18279\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18275\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18265\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18282\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18280\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18268\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18266\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18281\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n\n<p>For those interested in exploring past State of the Word keynotes, WordPress has curated a comprehensive YouTube playlist featuring keynotes from previous years. Watch them all here:<a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU\" target=\"_blank\" rel=\"noreferrer noopener\"> State of the Word YouTube Playlist</a>. Be sure to mark your calendars for major WordPress events in 2025: <a href=\"https://asia.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Asia</a> (Manila, Philippines), <a href=\"https://europe.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Europe</a> (Basel, Switzerland), and <a href=\"https://us.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp US</a> (Portland, Oregon, USA).</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 21:28:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: WordPress.org Login Introduces Mandatory Pineapple Pizza Checkbox\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/wordpress-org-login-introduces-mandatory-pineapple-pizza-checkbox\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4362:\"<p>Does pineapple belong on pizza?</p>\n\n\n\n<p>The answer may vary from person to person. But WordPress users were in for a surprise when they tried to login to the WordPress.org website.</p>\n\n\n\n<p>A new mandatory checkbox require users to confirm that “Pineapple is delicious on pizza” before accessing their accounts. </p>\n\n\n\n<img width=\"1186\" height=\"1830\" src=\"https://wptavern.com/wp-content/uploads/2024/12/WP.org-login.png\" alt=\"\" class=\"wp-image-182548\" />\n\n\n\n<p>Following the dispute with WP Engine, WordPress.org had introduced a <a href=\"https://wptavern.com/wordpress-org-login-gets-mandatory-affiliation-checkbox-following-wp-engine-dispute\">mandatory check box</a> in October that allowed users to access their accounts only after confirming “I am not affiliated with WP Engine in any way, financially or otherwise.” It was later removed following the <a href=\"https://wptavern.com/automattic-complies-with-court-ruling-wp-org-login-checkbox-and-wp-engine-tracker-csv-file-removed\">court instructions</a>.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Reactions From the Community</h2>\n\n\n\n<p>Francesca Marano of Patchstack <a href=\"https://x.com/FrancescaMarano/status/1868636332572180761\">tweeted</a>, “Seeing the level of immaturity and unprofessional behaviour in the WP industry is disheartening. Pizza checkbox? Not fun. A website calling Matt the worst person in tech, also not fun.”</p>\n\n\n\n<p>Gergely Orosz of The Pragmatic Engineer has opened a <a href=\"https://x.com/GergelyOrosz/status/1868583246080225672\">poll</a> on X and more than 1500 people have voted.&nbsp;</p>\n\n\n\n<a href=\"https://x.com/GergelyOrosz/status/1868583246080225672\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXd6AeMaSXa6obVl8ePq8gSI9BuvFx09-vGONhsQdZVjqHQZUwKkcpNzt5B8VAeTt2XFJHAJW-BO-Qp-b0CLxDRrITeiA8iD85iQkJi8-JZUGNkIcxI-F6l631EewGQ1Gm0kf-hXTw?key=dGtlaTRp7JtOAVktXwlVhu2x\" alt=\"\" /></a>\n\n\n\n<p>He also <a href=\"https://x.com/GergelyOrosz/status/1868593104674042243\">tweeted</a>, “This checkbox is a good example how the public feud of two billion-dollar companies (Automattic that raised $985M in VC funding and WP Engine that raised $250M in private equity funding) keep impacting WordPress developers &#8211; even if its in cryptic forms like this.”</p>\n\n\n\n<p>Web and eCommerce specialist Nick Weisser <a href=\"https://x.com/nickweisser/status/1868637845008834717\">joked</a>. “Pineapple is delicious on #pizza? So now you have to break Italian law to access @WordPress.org.”</p>\n\n\n\n<p>Maarten Belmans, founder of Studio Wombat, shared his <a href=\"https://x.com/PoeHaH/status/1868560451422044579\">concerns</a>, “My only worry is WP has already caused trust issues with enterprise (hijacking a plugin is no small issue, so&nbsp; I heard). Adding another checkbox, even as a light joke, might show enterprise WP just isn&#8217;t the serious platform they need it to be? Idk!”</p>\n\n\n\n<p>Bozz Media was critical, and <a href=\"https://x.com/bozzmedia/status/1868600076949766317\">tweeted</a>, “Gross. It’s sad that the unprofessional and unbecoming behavior from WP leadership continues, tarnishing the entire reputation of the platform.”</p>\n\n\n\n<p>Brett Atkin, Founder and Digital Strategist at Pixel Jocks, <a href=\"https://x.com/brettatkin/status/1868629331179921709\">tweeted</a>, &#8220;Thought it was a joke until I started seeing multiple posts about it. Sad, embarrassing and unprofessional, especially given the circumstances and recent court rulings. Feels like he is mocking the court, the judge and the entire community.&#8221; He is not alone as several users initially thought it to be a joke or a meme. </p>\n\n\n\n<p>WPTavern founder Jeff Chandler also shared his <a href=\"https://x.com/jeffr0/status/1868557854636192247\">thoughts</a>, “That checkbox didn’t exist during WCUS so technically, it’s not restored back to the status quo. It’s stupid.”</p>\n\n\n\n<p>Simon Harper of SRH Design <a href=\"https://x.com/SRHDesign/status/1868565101978251331\">tweeted</a>, “This should not have been added and I&#8217;m not sure what&#8217;s worse, the checkbox and text alignment or the attempt at humour.” The alignment issue was later fixed.&nbsp;</p>\n\n\n\n<p>The pineapple debate has sparked conversations on <a href=\"https://www.reddit.com/r/Wordpress/comments/1hf98pj/this_is_getting_out_hand/\">Reddit</a> too.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 16:58:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: Gutenberg, Contributing and Community with Birgit Pauli Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://dothewoo.io/gutenberg-contributing-and-community-with-birgit-pauli-haack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"Birgit Pauli-Haack discusses her journey in WordPress, emphasizing the evolution of the block editor and strategies for engaging younger contributors in the community and future developments.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 10:09:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WordPress.org blog: Write Books With the Block Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/12/write-books-with-the-block-editor/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3861:\"<p>If you need a little push to start writing this winter, in the comfort of your familiar editor, here it is! You can now use the Block Editor to create electronic books and other documents—all completely offline. What a full circle moment for Gutenberg!</p>\n\n\n\n<img width=\"1024\" height=\"711\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=1024%2C711&ssl=1\" alt=\"\" class=\"wp-image-18179\" />\n\n\n\n<p>The Block Editor contains so many features I miss when writing in other editors. It produces clean, semantic markup. You can paste in content from anywhere and the editor will clean it up for you, or paste a link onto selected text to auto-link. The List View and Outline panels allow you to easily navigate and inspect the content. And we’re constantly iterating on the Block Editor: more features and improvements are on the way, such as refined drag and drop interactions coming in early 2025.</p>\n\n\n\n<p>All this inspired me to wrap our editor in an app that can read and write local files—just as other document editors do. It turns out that EPUB is the best file format to store the content, because EPUB is an open standard for e-books that is essentially a ZIP file containing HTML and media—HTML like your WordPress posts!</p>\n\n\n\n<img width=\"1024\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=1024%2C560&ssl=1\" alt=\"\" class=\"wp-image-18180\" />\n\n\n\n<p>And just like that, the WordPress Block Editor can also be used to write books! The cool thing about EPUB files is that any e-book app, such as Kindle and Apple Books, can open it. So even if someone doesn’t have this editor, they can still easily read the content, which makes the files it produces portable.</p>\n\n\n\n<p>The editor allows you to create a cover, so you can easily distinguish between the books or documents you write. It will also treat each heading as a chapter so you can easily navigate content when opened in an e-book reader.</p>\n\n\n\n<div class=\"wp-block-columns alignfull is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"1024\" height=\"793\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=1024%2C793&ssl=1\" alt=\"\" class=\"wp-image-18181\" />\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"768\" height=\"1024\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/screenshot_2024_12_11T12_00_190100.png?resize=768%2C1024&ssl=1\" alt=\"\" class=\"wp-image-18178\" />\n</div>\n</div>\n\n\n\n<p>The term “book” should be taken broadly. While the file that the Block Editor produces is primarily used for e-books, you can create any document with it. It’s possible to export your document to a DOCX file in case you need it, though the more complex blocks are not supported yet.</p>\n\n\n\n<p>It is still very much a nascent project. There’s many features left to be added, such as revisions and the ability to open any externally created EPUB files, or even DOCX files, so keep an eye out for these in the coming weeks and months! If you’re interested in this editor, it’s all <a href=\"https://github.com/block-editors/blockdocs\">open source</a>, and I welcome any kind of help.</p>\n\n\n\n<p>For now, the <a href=\"https://block-editors.github.io/blockdocs/\">demo editor</a> is installable as a Progressive Web App (PWA) in Chrome. While it’s totally usable without installation, it does give you some nice benefits such as allowing you to open the EPUB files directly from your OS. In the future we might wrap it in proper native apps. Your feedback is welcome on <a href=\"https://github.com/block-editors/blockdocs\">GitHub</a>!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 08:36:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Ella\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: State of the Word Tokyo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=132238\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://ma.tt/2024/12/state-of-the-word-tokyo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2659:\"<p>It&#8217;s a dream come true being here in Tokyo for <a href=\"https://wordpress.org/state-of-the-word/\">State of the Word 2024</a>. We&#8217;re going to be in an amazing venue that looks over the city. Most of WordPress and Automattic&#8217;s senior leadership is here, and we&#8217;ll also have several hundred folks from the local community and press. </p>\n\n\n\n<p>(Update: If you&#8217;d like a <a href=\"https://wordpress.org/news/2024/12/state-of-the-word-2024-legacy-innovation-and-community/\">fantastic recap of how the event went, check out this post on .org</a>.)</p>\n\n\n\n<img width=\"604\" height=\"340\" src=\"https://i0.wp.com/ma.tt/files/2024/12/sotw-tokyo-2024-1024x576.jpg?resize=604%2C340&ssl=1\" alt=\"\" class=\"wp-image-132251\" />\n\n\n\n<p>We&#8217;ve gotten so much inspiration over the years from Japanese culture, we wanted to make this event really &#8220;of the space&#8221; so we&#8217;re doing a few extra things this year. My presentation will include <a href=\"https://profiles.wordpress.org/4thhubbard/\" target=\"_blank\" rel=\"noreferrer noopener\">Mary Hubbard</a> and <a href=\"https://profiles.wordpress.org/matveb/\" target=\"_blank\" rel=\"noreferrer noopener\">Matías Ventura</a>, but also part of it will be in Japanese and presented by <a href=\"https://profiles.wordpress.org/nukaga/\" target=\"_blank\" rel=\"noreferrer noopener\">Junko Fukui Nukaga</a>. We&#8217;ll have piano performances by <a href=\"https://www.instagram.com/aichina02/\" target=\"_blank\" rel=\"noreferrer noopener\">Aiko Takei</a>. After the presentation and Q&amp;A we&#8217;ll do a panel in Japanese with <a href=\"https://www.mieko.jp/mieko-kawakami\" target=\"_blank\" rel=\"noreferrer noopener\">Mieko Kawakami</a> (one of the top novelists in Japan, on par with <a href=\"https://en.wikipedia.org/wiki/Haruki_Murakami\">Haruki Murakami</a>), <a href=\"https://craigmod.com/about/\" target=\"_blank\" rel=\"noreferrer noopener\">Craig Mod</a>, <a href=\"https://profiles.wordpress.org/megane9988/\" target=\"_blank\" rel=\"noreferrer noopener\">Hajime Ogushi</a>, and <a href=\"https://profiles.wordpress.org/gtaniguchi/\" target=\"_blank\" rel=\"noreferrer noopener\">Genki Taniguchi</a>.</p>\n\n\n\n<p>For those who can attend in person, we&#8217;ll have a reception afterward with some unique gifts including posters from a local Kanji artist and nice sweater to keep everyone warm this winter.</p>\n\n\n\n<img width=\"604\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2024/12/sotw-tokyo-2024-posters-1024x768.jpeg?resize=604%2C453&ssl=1\" alt=\"\" class=\"wp-image-132255\" />\n\n\n\n<p>If you&#8217;d like to livestream at home, you can do so on Youtube here:</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 07:46:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Matt: UH Magazine, Revisiting My Alma Mater\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=131738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2024/12/uh-cover/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1203:\"<p>My father attended University of Houston, and it&#8217;s where I went to college to study political science, I started WordPress when there, and then dropped out after two years to move to San Francisco. It was fun seeing&nbsp;<a href=\"https://stories.uh.edu/magazine/magazine/fall-2024/the-mind-of-matt-mullenweg/index.html\" target=\"_blank\" rel=\"noreferrer noopener\">UH Magazine feature an article</a>&nbsp;about my journey from a University of Houston student to co-founding WordPress and leading Automattic. I was surprised they put me on the cover of the physical edition! I wish my Dad were still around to see it.</p>\n\n\n\n<p>The piece explores my commitment to open-source, my vision for democratizing online publishing, and the values of creativity and adaptability that have shaped my path. It’s an honor to reflect on these experiences with my alma mater.</p>\n\n\n\n<a href=\"https://stories.uh.edu/magazine/magazine/fall-2024/the-mind-of-matt-mullenweg/index.html\" target=\"_blank\" rel=\" noreferrer noopener\"><img width=\"604\" height=\"678\" src=\"https://i0.wp.com/ma.tt/files/2024/12/24-uh-02-online-cover-02-3529x3961-1-912x1024.webp?resize=604%2C678&ssl=1\" alt=\"\" class=\"wp-image-131739\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 15 Dec 2024 19:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: 25% Off Annual Plans at WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182389\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wptavern.com/25-off-annual-plans-at-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:593:\"<p>WordPress.com is now offering new annual plans at 25% off as part of their <a href=\"https://wordpress.com/blog/2024/12/12/end-of-the-year-sale-2025/\">year-end promotion</a>. The offer includes a free domain for the first year.</p>\n\n\n\n<p>This exclusive deal ends on <strong>December 31st</strong>, 2024.</p>\n\n\n\n<p>To claim the <a href=\"https://wordpress.com/end-of-year-savings/\">offer</a>, use the coupon code <strong>DREAM25</strong> at checkout.</p>\n\n\n\n<p>Please note this offer is only for new annual plan purchases and does not apply to renewals or upgrades for existing paid plans.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Dec 2024 18:14:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WP Engine Regains WordPress.org Access and ACF Plugin Control Following Court Ruling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182376\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/wp-engine-regains-wordpress-org-access-and-acf-plugin-control-following-court-ruling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4483:\"<p>After removing the mandatory WordPress.org login checkbox and the WP Engine Tracker CSV file, Automattic has reinstated WP Engine&#8217;s WordPress.org repository access and control over the <a href=\"https://wordpress.org/plugins/advanced-custom-fields/\">Advanced Custom Fields</a> (ACF) plugin repository. This follows a <a href=\"https://wptavern.com/court-grants-wp-engine-preliminary-injunction-against-automattic\">court ruling</a> that required Automattic to restore these rights within 72 hours.</p>\n\n\n\n<p>In October, WordPress co-founder Matt Mullenweg announced the <a href=\"https://wptavern.com/acf-plugin-forked-to-secure-custom-fields-plugin\">forking of the Advanced Custom Fields </a>(ACF) plugin into the new plugin Secure Custom Fields. He took over the plugin citing security issues and invoked <a href=\"https://github.com/wordpress/wporg-plugin-guidelines/blob/trunk/guideline-18.md\">point 18 of the plugin directory guidelines</a>. </p>\n\n\n\n<p>In a <a href=\"https://x.com/wp_acf/status/1867761686389604368\">tweet</a>, Advanced Custom Fields confirmed: “53 minutes ago, we initiated publishing the genuine ACF on .org and are now awaiting .org to complete the review process to make it available.”</p>\n\n\n\n<img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXfelrooYD9odmbysi_LIPFRvB5wW5St33bCZEpFRP1QW_cXHwwJV2379QFUVO3VDpsrqCt6xfPPAZoUq0d4Yb4vzuJaj9858GgU7oDCIPaM7mcuGjMBPeiOiegISNfAWbDBPI97_Q?key=NOtArAI7AMvE2QyfskVfI3jW\" alt=\"\" />\n\n\n\n<p>They later <a href=\"https://x.com/wp_acf/status/1867764818272244109\">added</a>: “We&#8217;re pleased to share that our team has had account access restored on WordPress dot org along with control of the ACF plugin repo. This means all ACF users can rest assured that the ACF team you trust is once again maintaining the plugin. There’s no action required if you have installed ACF directly from the ACF website or you are an ACF PRO user.”</p>\n\n\n\n<p>The Repository now lists WP Engine as the author of the plugin instead of WordPress.org.&nbsp;</p>\n\n\n\n<img width=\"2946\" height=\"1364\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-8.png\" alt=\"\" class=\"wp-image-182381\" />\n\n\n\n<p>While many in the community are relieved to see ACF restored, some have expressed concerns about the negative reviews ACF received following the controversial takeover and the future of the <a href=\"https://wptavern.com/wordpress-org-releases-new-secure-custom-fields-plugin-with-acf-pro-features\">SCF Pro version</a>.  Secure Custom Fields plugin still has WordPress.org as the author in the Repository.</p>\n\n\n\n<img width=\"2944\" height=\"1302\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image-7.png\" alt=\"\" class=\"wp-image-182379\" />\n\n\n\n<p>WP Engine’s Brian Gardner <a href=\"https://x.com/bgardner/status/1867762185080066373\">tweeted</a>, “Welcome home, ACF.” while entrepreneur Duane Storey <a href=\"https://x.com/DuaneStorey/status/1867835621752156284\">commented</a>: “This should never have been done in the first place. Let’s not forget, this was returned due to a court order, not a change of heart. I still consider the dot org repositories to no longer be trustworthy. I seriously think people with plugins there should be migrating away.”</p>\n\n\n\n<p>Matt Mullenweg <a href=\"https://x.com/photomatt/status/1867759730992586756\">responded</a> on this with, “I’m disgusted and sickened by being legally forced to provide free labor and services to @wpengine, a dangerous precedent that should chill every open source maintainer. While I disagree with the court’s decision, I&#8217;ve fully complied with its order. You can see most changes on the site. They have access to ACF slug but haven’t changed it… must not have been the emergency they claimed.”</p>\n\n\n\n<p>As usual, the community remains divided with some supporting his stance while others opposed it.&nbsp;</p>\n\n\n\n<a href=\"https://x.com/Perpetualmaniac/status/1867822838054629596\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXfzh-cTMQSewPWV8vlnMN0cdaaxhwgsbcg0Kfr8nuj4owxLvPRlZRFdQDi2Qs69IIRLwbXDhVpaapRbRs8VccPfK1f5wfSq2QjYf3DSsFPMGzoJpeDFggt0_RbTCaKJfHApMCsORg?key=NOtArAI7AMvE2QyfskVfI3jW\" alt=\"\" /></a>\n\n\n\n<a href=\"https://x.com/hackteck/status/1867872602393633206\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXcoxIrrLWnokIkXfdkK6RYvFaNNqLR1u4orcYPNr6IFJcac7YA9_YC95DX1b89Uic7nORJ0T08_vswH3b_rx8xKmH7piOHyKLzaM5XkIB7A6Td4-D9Ahc1ddegRpe_APkxVTePn?key=NOtArAI7AMvE2QyfskVfI3jW\" alt=\"\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Dec 2024 16:34:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"Gutenberg Times: Playground for agencies, Block theme for millions, What’s next for Gutenberg and WooCommerce — Weekend Edition #314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=31217\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://gutenbergtimes.com/playground-for-agencies-block-theme-for-millions-whats-next-for-gutenberg-and-woocommerce-weekend-edition-314/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20074:\"<p>Hi,&nbsp;🎄🎁🎆</p>\n\n\n\n<p>I wish you a contemplative, peaceful and restful Holiday Season and a happy, healthy and prosperous New Year! 2025! </p>\n\n\n\n<p>This newsletter and I will take a break, and we will be back on January 11, 2025. Be well, </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<p><em>PS: <a href=\"https://thewpweekly.com/awards/\"><strong>Voting in The WP Awards</strong> </a>has been extended to December 20. If you haven&#8217;t yet, please consider voting for <strong>Gutenberg Times</strong> in the Blog category. Also, vote for the <strong>Gutenberg Changelog</strong> in the Podcast category. And for your favorite WordPress products at the same time</em>. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-block-theme-for-millions-whats-next-for-gutenberg-and-woocommerce-weekend-edition-314/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-block-theme-for-millions-whats-next-for-gutenberg-and-woocommerce-weekend-edition-314/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-block-theme-for-millions-whats-next-for-gutenberg-and-woocommerce-weekend-edition-314/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-block-theme-for-millions-whats-next-for-gutenberg-and-woocommerce-weekend-edition-314/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-block-theme-for-millions-whats-next-for-gutenberg-and-woocommerce-weekend-edition-314/#this-week-in-playground\">This week in Playground</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Catch up on what’s coming next for Core, Gutenberg, and WordPress Playground in the last edition of <a href=\"https://developer.wordpress.org/news/2024/12/10/whats-new-for-developers-december-2024/\"><strong>What’s New for Developers?</strong></a> for 2024. <strong>Ryan Welcher </strong>summarized developer-related changes in WordPress for December 2024. Key updates include style book improvements in the Site Editor, new filters for block editor rendering mode, and enhancements to WordPress Playground. The post highlights updates to core blocks, bug fixes, and new features like setting featured images directly from Image blocks. It also mentions the release of WordPress 6.7, planning for version 6.8, and resources like Developer Hours sessions, YouTube content, and new tutorials on the Developer Blog. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>The WordPress Meta and Design teams have been incredibly busy. They updated the Make WordPress Sites with all the team&#8217;s sites, the Rosetta sites, and the Photo Directory. This visual refresh is part of the continued effort to build a consistent design language across WordPress.org.</p>\n\n\n\n<p>Read more about the effort and the before and after views in <a href=\"https://make.wordpress.org/meta/2024/12/10/the-photos-directory-gets-a-refresh-and-is-now-powered-by-blocks/\"></a><a href=\"https://make.wordpress.org/meta/2024/12/12/make-wordpress-gets-a-refresh/\"><strong>Make WordPress gets a refresh</strong></a> by <strong>Nick Diego</strong>. &#8220;The Make section of WordPress.org is vast, covering 32 contributor teams and 114 local teams, each with its own blog, handbooks, and component pages.&#8221; he wrote. After many years, the sites are now converted to a block first layout. It&#8217;s a newfound pleasure to publish on the Make Blogs again!  The handbooks follow the developer documentation sites and it&#8217;s reading pleasure. </p>\n\n\n\n<a href=\"https://make.wordpress.org/meta/2024/12/12/make-wordpress-gets-a-refresh/\"><img width=\"652\" height=\"350\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/new-core.webp?resize=652%2C350&ssl=1\" alt=\"\" class=\"wp-image-31274\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In <a href=\"https://make.wordpress.org/meta/2024/12/10/the-photos-directory-gets-a-refresh-and-is-now-powered-by-blocks/\">The Photos Directory gets a refresh and is now powered by blocks</a>, <strong>Nick Diego</strong> also shares details on the revamp for the popular picture site. Besides the reorganized homepage that now shows many more photos at first glance, I am quite intrigued by the new search filter by format: landscape, portrait or square. </p>\n\n\n\n<a href=\"https://make.wordpress.org/meta/2024/12/10/the-photos-directory-gets-a-refresh-and-is-now-powered-by-blocks/\"><img width=\"652\" height=\"372\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/search-results-detail.webp?resize=652%2C372&ssl=1\" alt=\"\" class=\"wp-image-31275\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>📣 Don&#8217;t miss it! <strong><a href=\"https://wordpress.org/state-of-the-word/\">The annual State of the Word</a></strong> is Matt Mullenweg&#8217;s keynote presentation of the year. It will take place on <strong>December 16, 2024</strong>, in Tokyo, Japan. The&nbsp;<a href=\"https://www.youtube.com/@WordPress/streams\">livestream</a>&nbsp;will start at<strong>&nbsp;9 am UTC</strong>&nbsp;on WordPress YouTube channel.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p> WordPress developer <strong>Riad Benguella</strong> recently <a href=\"https://bsky.app/profile/riad.blog/post/3lcfs43ucms2u\">sparked a lively community discussion </a>on improving the Gutenberg block editor, on Bluesky. Developers provided several suggestions, many linked to existing GitHub issues. They focused on practical enhancements like border radius presets, link CSS classes, and table block improvements. The conversation highlighted the community&#8217;s wish for more granular design controls and better pattern organization. Some suggestions led to immediate action with pull requests in progress. Others need further exploration due to technical complexities or the need to balance functionality with user-friendliness. <a href=\"https://x.com/Martinko\"><strong>Martin Dubovic</strong></a> posted a recap of the conversation with links and opinions.  <a href=\"https://wpshout.com/wordpress-community-improvement-suggestions/\"><strong>What’s Next for Gutenberg? A Community Chat With WordPress Developer Riad Benguella</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v19.9.0-rc.1\"><strong>Gutenberg 19.9 RC1</strong></a> is ready for testing. It includes a style book for classic themes. There are improvements to the experimental feature of inline commenting.  Additionally, there is a new block for post counts and other updates to existing blocks. The changelog should be your guide until the final release on December 18, 2024. It will be the last release of 2024. The next Gutenberg Changelog episode will be recorded on January 10th, and we will cover not only 19.9 but also Gutenberg 20.0 &#8211; the 200th release of the project. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-112-gutenberg-19-8-create-block-theme-plugin/\">Gutenberg Changelog #112 Gutenberg 19.8, Create Block Theme Plugin</a> with Sarah Norris</p>\n\n\n\n<img width=\"652\" height=\"183\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-07-at-12.04.50.png?resize=652%2C183&ssl=1\" alt=\"\" class=\"wp-image-31178\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>Explore the insights of <a href=\"https://developer.woocommerce.com/2024/12/12/woocommerce-in-2025/\"><strong>WooCommerce in 2025</strong></a>. It&#8217;s about building a platform for the future. This is presented by <strong>Beau Lebens</strong>, the Head of Engineering at WooCommerce. In 2025, the organization will concentrate on three significant objectives. They will enhance performance. They will improve the online shopping experience. They will deploy essential tools that meet the actual needs of merchants. The strategy streamlines operations for merchants. It integrates an increased number of features directly into the core platform. This integration reduces complications linked with extensions. The overarching goal is to develop a robust, flexible platform that effectively addresses the requirements of contemporary online merchants.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In Remkus de Vries newsletter, <a href=\"https://remkusdevries.com/newsletter/woo-test-orders-5-thought-pieces-jonos-predictions/\">Within WordPress</a>,  I learned about <a href=\"https://wordpress.org/plugins/dynamic-template-parts/\">​Dynamic Template Parts​</a>  by <strong>Matt Watson</strong>. It allows you to replace headers, footers, and other template parts dynamically based on the content you’re editing. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Brian Coords</strong> new Webmaster podcast latest episode is: <a href=\"https://webmasters.fm/building-a-block-theme-for-1-million-users-ft-jessica-lyschik/\"><strong>Building a Block Theme for 1 Million Users</strong></a>. In this conversation, <strong>Jessica Lyschik</strong> shares her journey as a WordPress developer and core contributor. She discusses her experiences in the WordPress community. She also talks about the evolution of WordPress themes and the unique features of the Greyd Suite. She emphasizes the importance of full site editing, the challenges of the block editor, and the future of Gutenberg. The discussion also touches on the impact of social media on blogging and concludes with where to find Jessica online.</p>\n\n\n\n<a href=\"https://webmasters.fm/building-a-block-theme-for-1-million-users-ft-jessica-lyschik/\"><img width=\"652\" height=\"366\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-13-at-18.28.28.png?resize=652%2C366&ssl=1\" alt=\"\" class=\"wp-image-31286\" /></a>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest video, <strong>Elliot Richmond</strong> walks you through how he <strong><a href=\"https://www.youtube.com/watch?v=kLhmEIL0RqA\">created  a sticky nav bar with Block Variations</a>,</strong> CSS, and JavaScript. &#8220;This WordPress block theme technique will enhance your visitors’ browsing experience by adding a creative sliding navigation bar that appears as they scroll down the page.&#8221; Richmond wrote. </p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his latest newsletter, <strong>Remkus de Vries</strong> alert me to a little script by <strong>Luc Princen</strong> that turns Block patterns into loadable template files, so they can then easily be added to Git. This could save you from having to go through a lot of database hassle. <a href=\"https://gist.github.com/lucprincen/02ff162a582ffd649992cfdc8785d9a8\">The script is available in a Gist</a>. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In his blog post, <strong><a href=\"https://developer.wordpress.org/news/snippets/how-to-lock-wordpress-blocks-and-prevent-unlocking/\">Snippet: How to lock WordPress blocks and prevent unlocking</a>,</strong> <strong>Nick Diego</strong> explains the Block Locking API. He also discusses how to use it. It also details how to prevent unlocking blocks as well as disabling the Code Editor. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Did you miss the Man vs Machine Speed Build Challenge? The recording is available on YouTube: <a href=\"https://www.youtube.com/watch?v=vjw6KWahFlk\"><strong>AI Takes On HUMAN in WordPress Speed Build Showdown</strong></a>.  &#8220;In this thrilling face-off, two WordPress powerhouses go head-to-head in an epic coding battle with a twist. <strong>Nick Diego</strong> and <strong>Ryan Welcher</strong>, both seasoned WordPress developers, are pitted against each other in a race against time. But there&#8217;s a catch – one developer has the advantage of AI assistance, while the other relies solely on traditional coding methods.&#8221; Jamie Marsland wrote.  After watching the show, I wasn&#8217;t the only one wh  checked out the <a href=\"https://www.cursor.com/\">Cursor AI</a> and played around with it. </p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<h2 class=\"wp-block-heading\" id=\"this-week-in-playground\">This week in Playground</h2>\n\n\n\n<p>If you missed last week&#8217;s Hallway Hangout, <strong><a href=\"https://x.com/adamzielin\">Adam Zieliński</a></strong> has the recording. He also has a summary and the transcript for you: <a href=\"https://make.wordpress.org/playground/2024/12/13/recap-of-hallway-hangout-playground-for-agencies-and-product-demos/\"><strong>Recap of Hallway Hangout: Playground for Agencies and Product Demos</strong></a>. As an agency, you can use WordPress Playground to streamline your workflows. You can test your products and share interactive demos. You can show and do so much more. In this recent Hallway Hangout sparked by <a href=\"https://x.com/karmatosed\"><strong>Tammie Lister</strong></a>, attendees from various agencies and product teams shared their experiences. They also expressed curiosity about applying WordPress Playground in their work.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Uros Tasic</strong>, co-lead organizer of WordCamp Europe, talked about <strong><a href=\"https://wordpress.tv/2024/12/13/code-test-repeat-accelerating-development-with-wordpress-playground/\">Code, Test, Repeat: Accelerating Development with WordPress Playground</a></strong> at WordCamp Larissa last month. The recording is now available on WordPress TV. Tasic discussed how Playground can enhance your development cycle, enabling quicker iterations without the need for complex setups.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>📣 Upcoming <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304881623/\"><strong>Developer Hours: Everything you need to know about WordPress Playground</strong></a> will take place on <strong>December 17th at 16:00 UTC. </strong> &#8220;Beyond spinning up WordPress sites, Playground offers powerful capabilities, from testing plugins and themes to running demos and even supporting app development. No matter how you engage with WordPress, Playground has something valuable to offer.&#8221; reads the description. </p>\n\n\n\n<img wid